//htmTools.h    0.1.1   09/2010     G.P.L.

#ifndef htm_tools
#define htm_tools

#include <wx/wx.h>
#include <wx/splitter.h>
#include <wx/treectrl.h>
#include <wx/notebook.h>
#include <wx/grid.h>
#include <wx/dir.h>
#include <wx/filename.h>
#include <wx/textfile.h>
#include <wx/xml/xml.h>
#include <wx/dnd.h>


//---------------- main app ----------------
class MainApp: public wxApp
{
    virtual bool OnInit();
    int OnExit();

};

class toolDlg;
class xTool;
class chTxt;
class dndFile;


//---------------- main frame ----------------
class MainFrame: public wxFrame
{
 public:

	MainFrame(const wxString& title);
    virtual ~MainFrame();

    void CreateGUIControls();
	    
    DECLARE_EVENT_TABLE()

 private:
    
    void OnInfo(wxCommandEvent&);
    void OnToolSet(wxCommandEvent&);
    void OnQuit(wxCommandEvent&);
    void OnTreeChanged(wxTreeEvent&);
    void OnNotebookPage(wxNotebookEvent&);
    
    wxSplitterWindow *MainSplitter;
    wxTreeCtrl *MainTree;
    wxNotebook *MainBook;
    
    wxArrayString pages, comments;
    wxArrayString items;
    wxTreeItemId rootId;    
   	
    enum
    {
        ID_QUIT = wxID_HIGHEST,
        ID_SET,
        ID_INFO,
        ID_TREE,
        ID_BOOK,
    };
		
};


//---------------- tool settings dialog ----------------
class toolDlg: public wxDialog
{
 public:

    toolDlg(wxFrame*, wxWindowID, const wxString&, wxString);
    wxArrayString GetItems();

    DECLARE_EVENT_TABLE()

 private:

    void OnClose(wxCommandEvent&);
    void OnBtOpen(wxCommandEvent&);
    void OnBtIns(wxCommandEvent&);
    void OnBtDel(wxCommandEvent&);

    void OnGrid(wxGridEvent&);

    void ReadXmlFile(wxString, wxArrayString&, wxArrayString&);
    void WriteXmlFile();
    wxString ChkXML(wxString);
    void CreateDefaultFile(wxString);
    
    bool IsInArray(wxString , wxArrayString);

    wxGrid *grid;
    wxBitmapButton *BtOpen;

    wxString xmLoc;

    enum
    {
        ID_BT_OK = wxID_HIGHEST,
        ID_BT_ESC,
        ID_BT_OPEN,
        ID_BT_INS,
        ID_BT_DEL,
        ID_GRID,
    };
};


//---------------- xTool - run external command line tool ----------------
class xTool : public wxPanel
{
 public:

    virtual void CreateControls();
    void SetPattern(wxString pt, bool sub) { Pattern=pt; chkSub=sub; }
    void SetTool(wxString tl, wxString i_op, wxString o_op) { Tool=tl; iOpts=i_op; oOpts=o_op; }
    void SetOutFile(wxString o_pt, wxString o_sub ) { oPatt=o_pt; oSub=o_sub; }
    void SetOutOpts(bool p_sz, bool p_ext ) { chkSze=p_sz; chkExt=p_ext; }

    DECLARE_EVENT_TABLE()
    
    wxTextCtrl *TcFile, *TcPatt, *TcRes;
    wxCheckBox *ChkSub;

    dndFile *DragContent;

    wxArrayString files;
    wxString Pattern;
    bool chkSub;
    
    enum
    {
        ID_TC_FILE = wxID_HIGHEST,
        ID_TC_PATT,
        ID_CHK_SUB,
        ID_BT_OPEN,
        ID_BT_GO,
    };

 private:
    
    void OnOpenDir(wxCommandEvent&);
    void OnTcChanged(wxCommandEvent&);
    void SelectFiles(wxString);
    virtual void OnAction(wxCommandEvent&);
    wxString CreateCommand(wxFileName&);

    wxString Tool, iOpts, oOpts, oPatt, oSub;
    bool chkTool, chkSze, chkExt;
    
};


//---------------- chTxt - change text in multiple files ----------------
class chTxt : public xTool
{
 public:

    void CreateControls();

 private:
        
    void OnAction(wxCommandEvent&);

    wxTextCtrl *TcSrch, *TcRepl;
    wxCheckBox *ChkTst;
    wxPanel *PanelSR;

};


//---------------- drag n drop ----------------
class dndFile : public wxFileDropTarget
{
 public:

    dndFile(wxTextCtrl *DragWindow) { TargetWindow = DragWindow; }
    virtual bool OnDropFiles(wxCoord x, wxCoord y, const wxArrayString& filenames);

 private:

    wxTextCtrl *TargetWindow;

};


#endif


//bitmaps

/* XPM */
static char * tools_xpm[] = {
"16 16 28 1",
" 	c None",
".	c #2D3335",
"+	c #2E3436",
"@	c #2F3537",
"#	c #353B3D",
"$	c #373D3F",
"%	c #515656",
"&	c #575C5E",
"*	c #3465A4",
"=	c #5A5F60",
"-	c #3566A3",
";	c #3A69A6",
">	c #416BA1",
",	c #7C868B",
"'	c #858986",
")	c #878986",
"!	c #888A85",
"~	c #828B92",
"{	c #8DA7C4",
"]	c #B1B6B3",
"^	c #C4C8C2",
"/	c #D1D3D0",
"(	c #DADDD7",
"_	c #DCDED9",
":	c #DBDFD8",
"<	c #DCDFD9",
"[	c #E7E9E5",
"}	c #E9EAE6",

"        ++      ",
"        ++      ",
"   !!     .+    ",
"    !!    +.+   ",
" !  !!    =#++  ",
" !!!!!   </%++@ ",
"  !!!!! _[:  +$&",
"     ),]}(    @ ",
"      >{^       ",
"     **;~!      ",
"   ****-'!!     ",
"  *****  !!!    ",
" *****    !!!   ",
" ***       !!!  ",
" ***        ! ! ",
"                "};


/* XPM */
static char *open_xpm[] = {
"16 15 36 1",
", c #AAC1E8",
"1 c #9AEA53",
"q c #DCE6F6",
". c #295193",
"; c #A9D066",
"r c #C6D6F0",
"$ c #4A7CCE",
"9 c #779DDB",
"8 c #EAF0FA",
"O c #6E96D8",
"X c #214279",
"e c #BED0EE",
"6 c #85A7DF",
"5 c #F0F5FC",
"t c #ADC4E9",
": c #3161B1",
"  c None",
"u c #274D8B",
"& c #BFDC9B",
"> c #9FB9E5",
"y c #5584D1",
"w c #3569BF",
"% c #3A70CA",
"+ c #305FAC",
"3 c #5D89D3",
"0 c #D2DFF4",
"@ c #CAE2AA",
"= c #B2D58C",
"2 c #FAFCFE",
"# c #638ED5",
"* c #CEDCF2",
"4 c #90AFE2",
"< c #B3C8EB",
"7 c #E5EDF9",
"- c #A2BCE6",
"o c #DFF0D0",

"                ",
"     ....       ",
"XXXXX .oo.      ",
"XOOOO+ .@o.     ",
"XOOOO#$%.&*XXX  ",
"XOOOOOOO.=*X-X  ",
"XOXXXX...;*XXXX:",
"XOX>,<.11111*X2:",
"X3X4>,<.111*X5-:",
"XX#64>,,.1*X78: ",
"XXO964>,,.X0q7: ",
"Xw3O964>,,er0t: ",
"X%y3O964>,<er:  ",
"uXXXXXXXXXXXX:  ",
"                "};



