// ISDemoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ISDemo.h"
#include "ISDemoDlg.h"
#include <math.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define PI_OVER_TWO ((3.141596254) * .5)
static void BestFit(UINT srcX, UINT srcY, UINT maxX, UINT maxY, UINT &outX, UINT &outY);


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

	// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CStatic	m_vers;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

	// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


BOOL CAboutDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	char v[20];
	_is6_GetImgSourceVersion(v);
	CString t = "ImgSource version : ";
	t+= v;
	m_vers.SetWindowText(t);

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Control(pDX, IDC_ISOURCEVERS, m_vers);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CALLBACK callBackFn(const UINT32 uCurRow, 
						 const UINT32 uTotalRows,
						 const IS_CALLBACK_DATA uUserData)
{
	if ((uCurRow % 10) == 0)
	{
		TRACE("Callback : (data = %d) %4.2f complete\n", uUserData, ((double)uCurRow / (double)uTotalRows) * 100.0);
	}

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CISDemoDlg dialog

CISDemoDlg::CISDemoDlg(CWnd* pParent /*=NULL*/)
: CDialog(CISDemoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CISDemoDlg)
	m_bBlur = FALSE;
	m_uBlurLevel = 50;
	m_bFlipV = FALSE;
	m_bGrayscale = FALSE;
	m_bHistEQ = FALSE;
	m_bFlipH = FALSE;
	m_bLUTBlue = TRUE;
	m_bLUTGreen = TRUE;
	m_bLUTRed = TRUE;
	m_bLUT = FALSE;
	m_bMedianFilter = FALSE;
	m_uQuantColors = 16;
	m_bQuantize = FALSE;
	m_bRGBBGR = FALSE;
	m_bSharpen = FALSE;
	m_uSharpenLevel = 20;
	m_bDespeckle = FALSE;
	m_bUnsharpMask = FALSE;
	m_bGamma = FALSE;
	m_fGamma = 1.5;
	m_bEmboss = FALSE;
	m_bPolyWarp = FALSE;
	m_bMosaic = FALSE;
	m_bIncreaseSaturation = FALSE;
	m_uQuantErrorMax = 20;
	m_bQuantFS = FALSE;
	m_bHistStretch = FALSE;

	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	// LUT
	for (int lb=0;lb<256;lb++)
	{
		m_InvLUT[lb]=255 - (BYTE)lb;
		m_StepLUT[lb]=((BYTE)lb / 32) * 32;
		m_VLUT[lb] = (lb < 128 ? 255 - lb * 2 : (lb - 128) * 2);
		m_highBrightLUT[lb] = min((int)lb + 64, 255);
		m_lowerBrightLUT[lb] = max((int)lb - 64, 0);
	}

	m_LUTArray[0] =  m_StepLUT;
	m_LUTArray[1] =  m_InvLUT;
	m_LUTArray[2] =  m_VLUT;
	m_LUTArray[3] =  m_highBrightLUT;
	m_LUTArray[4] =  m_lowerBrightLUT;

	// global image
	m_rgbBuf=NULL;
	m_width=0;
	m_height=0;

	m_dEmbossAngle = 0.0;

	m_EQGraphMask = 0;	// lum
	for (int i=0; i<256; i++) m_EQHisto[i]=0;

	MakePalette();

	// this is required (even without a valid key!), to initialize the ImgSource thread pool
   const char * pKey = TESTKEY;
	_is6_Initialize(pKey);
}

CISDemoDlg::~CISDemoDlg()
{
	CleanUp();
	m_pal.DeleteObject();

	// _is6_Exit is required to release memory and resources used by ImgSource. 
	// failing to call this could also lead to crashes on application exit.
	_is6_Exit();
}

void CISDemoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CISDemoDlg)
	DDX_Control(pDX, IDC_HISTOCOMBO, m_histoCombo);
	DDX_Control(pDX, IDC_LUT_COMBO, m_lutCombo);
	DDX_Control(pDX, IDC_COLOR_TEXT, m_colorTextWnd);
	DDX_Control(pDX, IDC_IMGRECT_BEFORE, m_imgRectBefore);
	DDX_Control(pDX, IDC_IMGRECT, m_imgRectAfter);
	DDX_Control(pDX, IDC_HISTO_FRAME, m_histoFrame);
	DDX_Check(pDX, IDC_BLUR_CHECK, m_bBlur);
	DDX_Text(pDX, IDC_BLUR_LEVEL, m_uBlurLevel);
	DDX_Check(pDX, IDC_FLIP, m_bFlipV);
	DDX_Check(pDX, IDC_GRAYSCALE, m_bGrayscale);
	DDX_Check(pDX, IDC_HISTCHECK, m_bHistEQ);
	DDX_Check(pDX, IDC_HORIZFLIP, m_bFlipH);
	DDX_Check(pDX, IDC_LUT_BLUE, m_bLUTBlue);
	DDX_Check(pDX, IDC_LUT_GREEN, m_bLUTGreen);
	DDX_Check(pDX, IDC_LUT_RED, m_bLUTRed);
	DDX_Check(pDX, IDC_LUTCHECK, m_bLUT);
	DDX_Check(pDX, IDC_MEDIAN_FILTER, m_bMedianFilter);
	DDX_Text(pDX, IDC_QUANT_COLORS, m_uQuantColors);
	DDX_Check(pDX, IDC_QUANTIZE_CHECK, m_bQuantize);
	DDX_Check(pDX, IDC_RGBBGR, m_bRGBBGR);
	DDX_Check(pDX, IDC_SHARPEN_CHECK, m_bSharpen);
	DDX_Text(pDX, IDC_SHARPEN_LEVEL, m_uSharpenLevel);
	DDX_Check(pDX, IDC_DESPECKLE, m_bDespeckle);
	DDX_Check(pDX, IDC_UNSHARPMASK, m_bUnsharpMask);
	DDX_Check(pDX, IDC_APPLYGAMMA, m_bGamma);
	DDX_Text(pDX, IDC_GAMMALEVEL, m_fGamma);
	DDX_Check(pDX, IDC_EMBOSS, m_bEmboss);
	DDX_Check(pDX, IDC_POLYWARP, m_bPolyWarp);
	DDX_Check(pDX, IDC_MOSAIC, m_bMosaic);
	DDX_Check(pDX, IDC_SMEAR, m_bSmear);
	DDX_Check(pDX, IDC_INCSAT, m_bIncreaseSaturation);
	DDX_Text(pDX, IDC_QUANT_ERRMAX, m_uQuantErrorMax);
	DDX_Check(pDX, IDC_QUANT_FS, m_bQuantFS);
	DDX_Check(pDX, IDC_HISTOSTRETCH, m_bHistStretch);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CISDemoDlg, CDialog)
	//{{AFX_MSG_MAP(CISDemoDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_ABOUT, OnAbout)
	ON_BN_CLICKED(IDC_SAVE, OnSave)
	ON_BN_CLICKED(IDC_OPEN, OnOpen)
	ON_BN_CLICKED(IDC_BLUR_CHECK, UpdateInvalidate)
	ON_EN_CHANGE(IDC_BLUR_LEVEL, UpdateInvalidate)
	ON_BN_CLICKED(IDC_EQ_BLUE, UpdateInvalidate)
	ON_BN_CLICKED(IDC_EQ_GREEN, UpdateInvalidate)
	ON_BN_CLICKED(IDC_EQ_LUM, UpdateInvalidate)
	ON_BN_CLICKED(IDC_EQ_RED, UpdateInvalidate)
	ON_BN_CLICKED(IDC_FLIP, UpdateInvalidate)
	ON_BN_CLICKED(IDC_GRAYSCALE, UpdateInvalidate)
	ON_BN_CLICKED(IDC_HISTOSTRETCH, UpdateInvalidate)
	ON_BN_CLICKED(IDC_HISTCHECK, UpdateInvalidate)
	ON_BN_CLICKED(IDC_HORIZFLIP, UpdateInvalidate)
	ON_BN_CLICKED(IDC_INVLUT, UpdateInvalidate)
	ON_BN_CLICKED(IDC_LINLUT, UpdateInvalidate)
	ON_BN_CLICKED(IDC_LUT_BLUE, UpdateInvalidate)
	ON_BN_CLICKED(IDC_LUT_GREEN, UpdateInvalidate)
	ON_BN_CLICKED(IDC_LUT_RED, UpdateInvalidate)
	ON_BN_CLICKED(IDC_LUTCHECK, UpdateInvalidate)
	ON_BN_CLICKED(IDC_MEDIAN_CUT, UpdateInvalidate)
	ON_EN_CHANGE(IDC_QUANT_COLORS, UpdateInvalidate)
	ON_BN_CLICKED(IDC_QUANTIZE_CHECK, UpdateInvalidate)
	ON_BN_CLICKED(IDC_RGBBGR, UpdateInvalidate)
	ON_BN_CLICKED(IDC_SHARPEN_CHECK, UpdateInvalidate)
	ON_EN_CHANGE(IDC_SHARPEN_LEVEL, UpdateInvalidate)
	ON_BN_CLICKED(IDC_DESPECKLE, UpdateInvalidate)
	ON_BN_CLICKED(IDC_AUTOBRIGHT, UpdateInvalidate)
	ON_BN_CLICKED(IDC_UNSHARPMASK, UpdateInvalidate)
	ON_EN_CHANGE(IDC_GAMMALEVEL, UpdateInvalidate)
	ON_EN_CHANGE(IDC_QUANT_ERRMAX, UpdateInvalidate)
	ON_BN_CLICKED(IDC_APPLYGAMMA, UpdateInvalidate)
	ON_BN_CLICKED(IDC_EMBOSS, UpdateInvalidate)
	ON_BN_CLICKED(IDC_MOSAIC, UpdateInvalidate)
	ON_BN_CLICKED(IDC_POLYWARP, UpdateInvalidate)
	ON_BN_CLICKED(IDC_SMEAR, UpdateInvalidate)
	ON_BN_CLICKED(IDC_INCSAT, UpdateInvalidate)
	ON_BN_CLICKED(IDC_QUANT_FS, UpdateInvalidate)
	ON_CBN_SELCHANGE(IDC_HISTOCOMBO, UpdateInvalidate)
	ON_CBN_SELCHANGE(IDC_LUT_COMBO, UpdateInvalidate)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CISDemoDlg message handlers

BOOL CISDemoDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	//SetIcon(m_hIcon, FALSE);		// Set small icon

	// load the sample image
	LoadDefaultImage();

	int idx = m_histoCombo.AddString("Brightness");
	m_histoCombo.SetItemData(idx, 0);
	idx = m_histoCombo.AddString("Red");
	m_histoCombo.SetItemData(idx, 1);
	idx = m_histoCombo.AddString("Green");
	m_histoCombo.SetItemData(idx, 2);
	idx = m_histoCombo.AddString("Blue");
	m_histoCombo.SetItemData(idx, 3);

	m_histoCombo.SetCurSel(0);

	idx = m_lutCombo.AddString("32 Steps");
	m_lutCombo.SetItemData(idx, 0);
	idx = m_lutCombo.AddString("Inverse");
	m_lutCombo.SetItemData(idx, 1);
	idx = m_lutCombo.AddString("V-shaped");
	m_lutCombo.SetItemData(idx, 2);
	idx = m_lutCombo.AddString("Raise Brightness");
	m_lutCombo.SetItemData(idx, 3);
	idx = m_lutCombo.AddString("Lower Brightness");
	m_lutCombo.SetItemData(idx, 4);

	m_lutCombo.SetCurSel(0);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CISDemoDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CISDemoDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CPaintDC dc(this); // device context for painting

		CPalette * op = dc.SelectPalette(&m_pal,FALSE);
		dc.RealizePalette();

		// where to draw to
		CRect afterRect;
		m_imgRectAfter.GetWindowRect(afterRect);
		ScreenToClient(afterRect);
		afterRect.InflateRect(-2,-2);
		dc.FillRect(afterRect, &CBrush(::GetSysColor(COLOR_3DFACE)));

		// where to draw to
		CRect beforeRect;
		m_imgRectBefore.GetWindowRect(beforeRect);
		ScreenToClient(beforeRect);
		beforeRect.InflateRect(-2,-2);
		dc.FillRect(beforeRect, &CBrush(::GetSysColor(COLOR_3DFACE)));

		// draw the before image

		// this call wraps a call to _is6_RGBToHBITMAP as well as all the
		// usual CreateCompatibleDC, SelectObject, BitBlt stuff
		if (m_rgbBuf!=NULL) 
		{
			_is6_DrawRGB(dc.m_hDC,
				m_rgbBuf, 
				m_width, m_height, 
				m_width * 3, 
				beforeRect.left,
				beforeRect.top,
				(HPALETTE)m_pal.GetSafeHandle());	//optional
		}


		// apply the changes to generate the "after" image
		BYTE *outputImage = RenderImage();

		// draw the After image
		if (outputImage!=NULL) 
		{
			_is6_DrawRGB(dc.m_hDC,
				outputImage, 
				m_width, m_height, 
				m_width * 3,
				afterRect.left,
				afterRect.top,
				(HPALETTE)m_pal.GetSafeHandle()); //optional

			delete [] outputImage;
		}

		// draw histo graph

		// where to draw to
		CRect graphRect;
		m_histoFrame.GetWindowRect(graphRect);
		ScreenToClient(graphRect);
		graphRect.DeflateRect(4,2);
		dc.FillRect(graphRect, CBrush::FromHandle((HBRUSH)::GetStockObject(WHITE_BRUSH)));

		// fit this in our space
		UINT32 maxval = 0;
		for (int z = 0; z<256; z++)
		{
			if (maxval < m_EQHisto[z])
			{
				maxval = m_EQHisto[z];
			}
		}

		if (maxval > 0) 
		{
			double xscale = (double)(graphRect.Width() - 4) / 256;
			double yscale = (double)(graphRect.Height()) / maxval;

			// draw it
			for (int i=0; i<256; i++) 
			{
				double xpos = xscale * i + graphRect.left + 2;
				double ypos = graphRect.bottom - (yscale * m_EQHisto[i] + 1);

				dc.MoveTo((int)xpos, (int)ypos);
				dc.LineTo((int)xpos, (graphRect.bottom - 1));
			}
		}

		dc.SelectPalette(op, FALSE);

		CDialog::OnPaint();
	}

}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CISDemoDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CISDemoDlg::UpdateInvalidate()
{
	BOOL bCurSmear = m_bSmear;
	BOOL bCurWarp = m_bPolyWarp;
	BOOL bCurEmboss = m_bEmboss;

	UpdateData(TRUE);

	// now we'll pick some random values for things, if the user has selected them
	if (m_bEmboss && !bCurEmboss)
	{
		// pick an angle between 0 and 2*pi
		m_dEmbossAngle = ((rand() % 31415) * 2) / 1000.0;
	}

	if (m_bSmear && !bCurSmear)
	{
		// pick two points, each in the middle 1/2 of the image
		UINT32 x1 = (rand() % m_width / 2) + (m_width / 4);
		UINT32 x2 = (rand() % m_width / 2) + (m_width / 4);
		UINT32 y1 = (rand() % m_height / 2) + (m_height / 4);
		UINT32 y2 = (rand() % m_height / 2) + (m_height / 4);
		m_smear1 = CPoint(x1, y1);
		m_smear2 = CPoint(x2, y2);
	}

	if (m_bPolyWarp && !bCurWarp)
	{
		UINT32 x1 = (rand() % m_width / 4);
		UINT32 y1 = (rand() % m_height / 4);

		UINT32 x2 = (rand() % m_width / 4) + (3 * m_width / 4);
		UINT32 y2 = (rand() % m_height / 4);

		UINT32 x3 = (rand() % m_width / 4) + (3 * m_width / 4);
		UINT32 y3 = (rand() % m_height / 4) + (3 * m_height / 4);

		UINT32 x4 = (rand() % m_width / 4);
		UINT32 y4 = (rand() % m_height / 4) + (3 * m_height / 4);

		m_warp00 = CPoint(x1, y1);
		m_warp10 = CPoint(x2, y2);
		m_warp11 = CPoint(x3, y3);
		m_warp01 = CPoint(x4, y4);
	}

	InvalidateAfter();
}

void CISDemoDlg::OnAbout() 
{
	CAboutDlg t;
	t.DoModal();

}

void CISDemoDlg::OnSave() 
{
	CString fileName;
	CString filt="JPG File (*.JPG)|*.JPG|24-Bit PNG File (*.PNG)|*.PNG|8-bit PNG File (*.PNG)|*.PNG|8-bit GIF File (*.GIF)|*.GIF|24-bit BMP (*.BMP)|*.BMP|8-bit BMP (*.BMP)|*.BMP|4-bit BMP (*.BMP)|*.BMP||";

	// OPENFILENAME - so i can get to its Help page easily
	CFileDialog fileDlg(FALSE,"*.JPG","*.JPG",NULL,filt,this);

	fileDlg.m_ofn.Flags|=OFN_FILEMUSTEXIST;
	fileDlg.m_ofn.lpstrTitle="File to save as";

	CWaitCursor bob;

	if (fileDlg.DoModal()==IDOK) 
	{
		fileName=fileDlg.GetPathName();

		HISDEST hDest = _is6_OpenFileDest(fileName, FALSE);
		if (hDest==NULL)
		{
			AfxMessageBox("Cannot open file for writing");
			return;
		}


		CString ext=fileName.Right(4);

		// draw the output image
		BYTE *tmp = RenderImage();

		DWORD imgByteSize = (m_width * m_height * 3);

		switch (fileDlg.m_ofn.nFilterIndex) 
		{
		default:
		case 1: //JPG
			{
				if (!_is6_WriteJPG(hDest, tmp, m_width, m_height, 24, m_width * 3, 75, NULL, 0)) 
				{
					AfxMessageBox(StringFromErrorNum(_is6_GetLastError()));
				}
			}
			break;
		case 2:	// PNG-24
			{
				if (!_is6_WritePNG(hDest, tmp, m_width, m_height, m_width * 3, 8, 1<<24, NULL, 2, 0.0, NULL, 0)) 
				{
					AfxMessageBox(StringFromErrorNum(_is6_GetLastError()));
				}
			}
			break;
		case 3:	//	PNG-8
			{
				int colors = (fileDlg.m_ofn.nFilterIndex == 5 ? 16 : 256);

				// make a buffer for the quantized version
				BYTE *qImg;
				try 
				{
					qImg = (BYTE *) new BYTE[imgByteSize];
				} 
				catch (CMemoryException *e) 
				{
					e->ReportError();
					e->Delete();
					AfxMessageBox(StringFromErrorNum(IS_ERR_MEM));
					_is6_CloseDest(hDest);
					return ;
				}

				// quantize it
				RGBQUAD pal[256];
				if (!_is6_QuantizeRGBTo8Bit(tmp,
					m_width,
					m_height,
					m_width * 3, // number of bytes in an RGB pixel row
					qImg,
					m_width,  // number of bytes in an 8-bit pixel row
					colors,
					pal,
					0,
					20,
					0)) 
				{
					AfxMessageBox(StringFromErrorNum(_is6_GetLastError()));
					_is6_CloseDest(hDest);
					return;
				}

				// save it
				if (!_is6_WritePNG(hDest, qImg, m_width, m_height, m_width, 8, 256, pal, 3, 0.0, NULL, 0)) 
				{
					AfxMessageBox(StringFromErrorNum(_is6_GetLastError()));
				}
				delete [] qImg;
			}
			break;

		case 4:	//	GIF-8
			{
				int colors = 256;

				// make a buffer for the quantized version
				BYTE *qImg;
				try 
				{
					qImg = (BYTE *) new BYTE[imgByteSize];
				} 
				catch (CMemoryException *e) 
				{
					e->ReportError();
					e->Delete();
					AfxMessageBox(StringFromErrorNum(IS_ERR_MEM));
					_is6_CloseDest(hDest);
					return ;
				}

				// quantize it
				RGBQUAD pal[256];
				if (!_is6_QuantizeRGBTo8Bit(tmp,
					m_width,
					m_height,
					m_width * 3, // number of bytes in an RGB pixel row
					qImg,
					m_width,  // number of bytes in an 8-bit pixel row
					colors,
					pal,
					0,
					20,
					0)) 
				{
					AfxMessageBox(StringFromErrorNum(_is6_GetLastError()));
					_is6_CloseDest(hDest);
					return;
				}

				// save it
				if (!_is6_WriteGIF(hDest, qImg, m_width, m_height, m_width, 0, -1, 8, pal, 0)) 
				{
					AfxMessageBox(StringFromErrorNum(_is6_GetLastError()));
				}
				delete [] qImg;
			}
			break;

		case 5: //24 bit BMP
			if (!_is6_WriteBMP(hDest, tmp, m_width, m_height, 24, m_width * 3, 1 << 24, NULL, NULL, 0)) 
			{
				AfxMessageBox(StringFromErrorNum(_is6_GetLastError()));
			}

			break;

		case 6 : // 8-bit BMP, 4-bit BMP
		case 7:
			{
				int colors = (fileDlg.m_ofn.nFilterIndex == 6 ? 16 : 256);
				int bits = (fileDlg.m_ofn.nFilterIndex == 6 ? 4 : 8);

				// make a buffer for the quantized version
				BYTE *qImg;
				try 
				{
					qImg = (BYTE *) new BYTE[imgByteSize];
				} 
				catch (CMemoryException *e) 
				{
					e->ReportError();
					e->Delete();
					AfxMessageBox(StringFromErrorNum(IS_ERR_MEM));
					_is6_CloseDest(hDest);
					return ;
				}

				// quantize it
				RGBQUAD pal[256];
				if (!_is6_QuantizeRGBTo8Bit(tmp, m_width, m_height, m_width * 3, qImg, m_width, colors, pal, 0, 20, 0)) 
				{
					AfxMessageBox(StringFromErrorNum(_is6_GetLastError()));
					_is6_CloseDest(hDest);
					return;
				}

				if (fileDlg.m_ofn.nFilterIndex==6)
				{
					// need to pack this into 4bpp rows
					BYTE *pPacked = new BYTE [((m_width + 1) /2) * m_height];

					// this says "pack the low 4 bits of each 8 bit pixel 
					// into rows ((m_width + 1) /2) bytes wide". that's what the BMP
					// writer wants, when writing 4bpp BMP.
					_is6_Pack8BitBuffer(qImg, m_width, m_height, m_width, pPacked, 4, TRUE, ((m_width + 1) /2), 0);

					// save it
					if (!_is6_WriteBMP(hDest, pPacked, m_width, m_height, bits, ((m_width + 1) /2), colors, pal, NULL, 0)) 
					{
						AfxMessageBox(StringFromErrorNum(_is6_GetLastError()));
					}

					delete [] pPacked;
				}
				else
				{
					// save it
					if (!_is6_WriteBMP(hDest, qImg, m_width, m_height, bits, m_width, colors, pal, NULL, 0)) 
					{
						AfxMessageBox(StringFromErrorNum(_is6_GetLastError()));
					}
				}
				delete [] qImg;
			}

			break;
		}

		delete [] tmp;							  

		_is6_CloseDest(hDest);

	}

}

void CISDemoDlg::OnOpen() 
{
	CString fileName;
	CString filt="JPG Files (*.JPG)|*.JPG| \
				 GIF Files (*.GIF)|*.GIF| \
				 PNG Files (*.PNG)|*.PNG| \
				 TIFF Files (*.TIF)|*.TIF| \
				 BMP Files (*.BMP)|*.BMP| \
				 Photoshop Files (*.PSD)|*.PSD| \
				 ZSoft PCX Files (*.PCX)|*.PCX| \
				 Targa Files (*.TGA)|*.TGA| \
				 Windows Metafiles (*.WMF)|*.WMF| \
				 All files (*.*)|*.*||";

	// OPENFILENAME - so i can get to its Help page easily

	CString defFilt = "*.PSD;*.GIF;*.BMP;*.JPG;*.PCX;*.PNG;*.TGA;*.TIF;*.WMF";
	CFileDialog fileDlg(TRUE,defFilt, defFilt, NULL,filt,this);

	fileDlg.m_ofn.Flags|=OFN_FILEMUSTEXIST;
	fileDlg.m_ofn.lpstrTitle="File to load";

	if (fileDlg.DoModal()==IDOK) 
	{

		CWaitCursor bob;

		fileName=fileDlg.GetPathName();

		UINT32 w,h;

		// tell the DLL to call the function "callBackFn" on every scan line processed.
		// the second parameter is a 32-bit user data value. we'll just set it to 15 here.
		// ImgSource will pass this value to the callback function.
		_is6_SetCallback(callBackFn, 15);

		// open the file
		HISSRC hSource = _is6_OpenFileSource(fileName);
		if (hSource==NULL)
		{
			AfxMessageBox(StringFromErrorNum(_is6_GetLastError()));
			return;
		}

		/* 
		read new image. this is the simplest way to read an image to RGB pixels.
		each format has its own reading function (_is6_ReadBMP, _is6_ReadJPG, etc),
		and if you want to take advantage of a specific feature offered by a format
		those are the way to go. but if you just need RGB pixels and don't care 
		about the actual format they're encoded in, this function is ideal.

		it can also read to RGBA and DIB.
		*/
		HGLOBAL hImg = _is6_ReadImage(hSource, &w, &h, 0, 0);

		UINT err = _is6_GetLastError();

		// close
		_is6_CloseSource(hSource);

		// turn off the callback. most image processing functions will call the
		// callback function. if we leave this on, we'll be flooded with TRACEs
		_is6_SetCallback(NULL, 0);

		if (hImg!=NULL) 
		{
			BYTE *tmp = (BYTE *)hImg;
			if (tmp!=NULL) 
			{
				CleanUp();

				// resize the input to fit our available space
				CRect afterRect;
				m_imgRectAfter.GetWindowRect(afterRect);
				ScreenToClient(afterRect);
				afterRect.InflateRect(-2,-2);

				// determine the best size. scale without changing proportions
				UINT newW = 0;
				UINT newH = 0;
				BestFit(w, h, afterRect.Width(), afterRect.Height(), newW, newH);

				DWORD imgSize = newW * newH * 3;

				m_rgbBuf = (BYTE *) new BYTE[imgSize];
				if (m_rgbBuf==NULL)
				{
					m_width = 0;
					m_height = 0;

					GlobalFree(hImg);
					AfxMessageBox("Can't allocate image memory!");
					return;
				}

				// resize. 
				_is6_ResizeImage(tmp, w, h, w * 3, m_rgbBuf, newW, newH, newW * 3, 3, 
					is6_RESIZE_MODE_BICUBIC, // BiCubic resampling is a good default - fast and the quality is decent.
					0);

				m_width = newW;
				m_height = newH;

				// clean up
				GlobalFree(hImg);

				// redraw
				InvalidateBefore();
				InvalidateAfter();
			}
		} 
		else 
		{
			AfxMessageBox(StringFromErrorNum(err));
		}
	}            
}

///////////////////////////////////////////////

void BestFit(UINT srcX, UINT srcY, UINT maxX, UINT maxY, UINT &outX, UINT &outY) 
{
	double ratx = (double)srcX / (double)maxX;
	double raty = (double)srcY / (double)maxY;
	if (ratx > raty) 
	{
		outX = maxX;
		outY = (UINT)((double)srcY / ratx);
	} 
	else if (ratx < raty)
	{
		outX = (UINT)((double)srcX / raty);
		outY = maxY;
	} 
	else 
	{
		outX = maxX;
		outY = maxY;
	}
}

///////////////////////////////////////////////

void CISDemoDlg::InvalidateAfter()
{
	// where to draw to
	CRect outRect;
	m_imgRectAfter.GetWindowRect(outRect);
	ScreenToClient(outRect);

	// if our after image changed, so did our histogram
	InvalidateHistogram();

	InvalidateRect(outRect, FALSE);
}

void CISDemoDlg::InvalidateBefore()
{
	// where to draw to
	CRect outRect;
	m_imgRectBefore.GetWindowRect(outRect);
	ScreenToClient(outRect);

	// if our after image changed, so did our histogram
	InvalidateHistogram();

	InvalidateRect(outRect, FALSE);
}

// call this when we want to redraw the histogram image
void CISDemoDlg::InvalidateHistogram()
{
	// where to draw to
	CRect graphRect;
	m_histoFrame.GetWindowRect(graphRect);
	ScreenToClient(graphRect);

	InvalidateRect(graphRect, FALSE);

}


// creates a spread of colors - no real method, just a semi-even spread
// this is all you really need to get better than Windows standard...
void CISDemoDlg::MakePalette()
{ 
	LPLOGPALETTE     lpPal;
	BYTE *           pLogPal;
	HPALETTE         hPal = NULL;
	int              i;

	try 
	{
		pLogPal = new BYTE [sizeof (LOGPALETTE) + (sizeof (PALETTEENTRY) * (256))];
	} 
	catch (CMemoryException *e) 
	{
		e->ReportError();
		e->Delete();
		pLogPal=NULL;
		return;
	}

	lpPal = (LPLOGPALETTE) pLogPal;
	lpPal->palVersion = 0x300;
	lpPal->palNumEntries = 256;

	int r,g,b;
	r=b=g=0;
	for (i=0;i<256;i++) 
	{
		lpPal->palPalEntry[i].peRed   = (BYTE)r % 256;
		lpPal->palPalEntry[i].peGreen = (BYTE)g % 256;
		lpPal->palPalEntry[i].peBlue  = (BYTE)b % 256;
		lpPal->palPalEntry[i].peFlags = 0;

		r+=16;
		g+=4;
		b++;
	}

	BOOL ok = m_pal.CreatePalette (lpPal);

	delete [] pLogPal;
}


void CISDemoDlg::LoadDefaultImage()
{
	CleanUp();

	// we'll need our palette to render the bitmap on < 16 bit displays
	HPALETTE hPal = (HPALETTE)m_pal.GetSafeHandle();


	//	use _is6_LoadResourceBitmap, instead of CBitmap::LoadBitmap!
	//
	//	on 8-bit displays, LoadBitmap maps the bitmap to the 16-colors
	//	of the standard Windows palette - this is no good. you don't even
	//	get a chance to use a palette on the image because LoadBitmap mangles
	//	the color info!! yuck!!
	//
	//	if you use this function, with a palette that represents a
	// spread of colors from the image, or even just a nice spread of
	//	colors all across the spectrum, you'll get much better results.
	//	
	//	if you use a NULL palette, this function will use a 
	//	set of colors from the system palette, which will give slightly
	//	better results than LoadBitmap.
	//
	//	CBitmap tmpBmp; tmpBmp.LoadBitmap(IDB_SAMPLE_IMAGE);
	//	HBITMAP hTmpBmp = tmpBmp.GetSafeHandle();
	//

	// pick one of our images at random
	srand(GetTickCount());
	LPSTR resId[6] = 
	{
		(LPSTR)IDB_SAMPLE_ELVIS, 
		(LPSTR)IDB_SAMPLE_LOVE, 
		(LPSTR)IDB_SAMPLE_FLOWER,
		(LPSTR)IDB_SAMPLE_SPRINKLER,
		(LPSTR)IDB_SAMPLE_BUTTERFLY,
		(LPSTR)IDB_SAMPLE_LIGHTNING
	};


	HBITMAP hTmpBmp = _is6_LoadResourceBitmap(AfxGetInstanceHandle(), resId[rand() % 6], hPal);

	if (hTmpBmp==NULL) 
	{
		AfxMessageBox(StringFromErrorNum(_is6_GetLastError()));
		return;
	}

	// get an RGB buffer from our HBITMAP, use the palette to render the bitmap
	UINT32 w,h;
	_is6_GetHBITMAPDimensions(hTmpBmp, &w, &h);

	BYTE * pImg = new BYTE[w * h * 3];

	CDC *pDC = GetDC();

	_is6_HBITMAPToRGB(hTmpBmp, pDC->m_hDC, (HPALETTE)m_pal.GetSafeHandle(),pImg);

	ReleaseDC(pDC);

	// clean up - we have the RGB buffer, we don't need the HBITMAP anymore
	::DeleteObject(hTmpBmp);

	if (pImg!=NULL) 
	{
		m_width = w;
		m_height = h;

		// copy it to our buffer
		DWORD imgByteSize = (m_width * m_height * 3);

		// alloc our buffer
		try 
		{
			m_rgbBuf = (BYTE *) new BYTE[imgByteSize];
		} 
		catch (CMemoryException *e) 
		{
			e->ReportError();
			e->Delete();
			CleanUp();
		}

		// copy
		memcpy(m_rgbBuf, pImg, imgByteSize);

		InvalidateBefore();
		InvalidateAfter();

		delete [] pImg;
	} 
	else 
	{
		AfxMessageBox(StringFromErrorNum(_is6_GetLastError()));
		return;
	}
}

/////////////////////////////////////////

void CISDemoDlg::CleanUp()
{
	if (m_rgbBuf!=NULL) 
	{
		delete [] m_rgbBuf;
		m_rgbBuf=NULL;
		m_width=m_height=0;
	}
}

CString CISDemoDlg::StringFromErrorNum(int err)
{
	CString out = "";
	switch (err) 
	{
		// obviously there are a lot more error codes than we've handled
		// here. but, you get the idea...
	default 			         :			out.Format("Error #%d", err);
		break;
	case IS_ERR_OK				:		out="No error"; 
		break;
	case IS_ERR_CALLBACKCANCEL :		out="Operation cancelled by callback";
		break;
	case IS_ERR_PNGCREATE	:		out="Internal PNG creation error - possibly bad params";
		break;	
	case IS_ERR_INTERNAL		:		out="Internal _IS3ource error";
		break;
	case IS_ERR_FONT			:		out="Font creation error";
		break;
	case IS_ERR_MEM			:		out="Error : out of memory";
		break;
	case IS_ERR_FILEOPEN		:		out="Error on file open";
		break;
	case IS_ERR_FILEREAD		:		out="Error on file read";
		break;
	case IS_ERR_FILEWRITE	:		out="Error on file write";
		break;
	case IS_ERR_BADPARAM		:		out="Bad user param";
		break;
	case IS_ERR_INVALIDBMP	:		out="Bad BMP file";
		break;
	case IS_ERR_BMPRLE		:		out="We don't do RLE BMP files";
		break;
	case IS_ERR_INVALIDTIFF	:		out="Bad TIF file";
		break;
	case IS_ERR_INVALIDJPG	:		out="Bad jpg file";
		break;
	case IS_ERR_TRIALVERSION	:		out = "DLL unlocked to Trial level functionality only";
		break;
	case IS_ERR_DC				:		out = "Device error";
		break;
	case IS_ERR_DIB			:		out = "GetDIBits error";
		break;
	case IS_ERR_NORESOURCE	:		out = "Resource Not Found";
		break;
	}

	return out;
}

////////////////////////////////////////////////////////////////////////
//	this is where we apply the mod's
//
// we just apply each effect in the order it's listed on the main dialog.
//
// it's not the prettiest way to do things, but it does show the basic idea.
//

BYTE * CISDemoDlg::RenderImage()
{
	CWaitCursor bob;

	// turn this off. we don't need to see all of the updates
	_is6_SetCallback(NULL, 0);

	// we'll use a temp buffer a few places here. this is how big it will be.
	// width * height pixels, three bytes each pixel.
	DWORD imgByteSize = (m_width * m_height * 3);

	// alloc our buffer
	BYTE * outBuf = (BYTE *) new BYTE[imgByteSize];
	if (outBuf==NULL)
	{
		return NULL;
	}

	// copy input to the output image
	memcpy(outBuf, m_rgbBuf, imgByteSize);

	// grayscale
	if (m_bGrayscale) 
	{
		// change to grayscaled RGB, in place
		if (!_is6_ImageToGrayScale(outBuf, m_width, m_height, 3, m_width * 3, 0)) 
		{
			return outBuf;
		}
	}

	// flip
	if (m_bFlipV) 
	{
		// vertically flips an image
		if (!_is6_VerticalFlipImage(outBuf, m_width * 3, m_height)) 
		{
			return outBuf;
		}
	}

	// RGB => BGR
	if (m_bRGBBGR) 
	{
		// swap reb and blue
		if (!_is6_RGBToBGR(outBuf, m_width, m_height, m_width * 3, 0)) 
		{
			return outBuf;
		}
	}

	// horiz flip
	if (m_bFlipH) 
	{
		if (!_is6_HorizontalFlipImage(outBuf, m_width, m_height, 3, m_width * 3, 0)) 
		{
			return outBuf;
		}
	}

	// LUT = LookUp Table
	if (m_bLUT) 
	{
		// an array of one LUT for each channel in the image
		BYTE *pLuts[3];

		// start out NULL. NULL = don't modify the channel
		pLuts[0] = pLuts[1] = pLuts[2] = NULL;

		int iCurSel = m_lutCombo.GetCurSel();
		int iLut = (int)m_lutCombo.GetItemData(iCurSel);

		// if red was selected, set the LUT to the red channel..
		if (m_bLUTRed)
		{
			pLuts[0] = m_LUTArray[m_lutCombo.GetItemData(m_lutCombo.GetCurSel())];
		}

		if (m_bLUTGreen)
		{
			pLuts[1] = m_LUTArray[m_lutCombo.GetItemData(m_lutCombo.GetCurSel())];
		}

		if (m_bLUTBlue)
		{
			pLuts[2] = m_LUTArray[m_lutCombo.GetItemData(m_lutCombo.GetCurSel())];
		}

		// apply the LUT to the channels that were selected
		if (!_is6_ApplyLUTsToImage(outBuf, m_width, m_height, 3, m_width * 3, (const void ** )pLuts, 0))
		{
			return outBuf;
		}
	}

	// quantize
	if (m_bQuantize) 
	{
		// do this into a temp 8-bit buffer,
		// then convert that back to RGB
		BYTE *tmp = (BYTE *) new BYTE[imgByteSize];

		// quantize it

		RGBQUAD pal[256];
		if (!_is6_QuantizeRGBTo8Bit(outBuf,
			m_width,
			m_height,
			m_width * 3,
			tmp,
			m_width,
			m_uQuantColors,
			pal,
			m_bQuantFS ? 1 : 0,
			m_uQuantErrorMax,0)) 
		{
			return outBuf;
		} 

		// we really want a 24-bit image for display, so create a 24-bit image,
		// using the palette and the 8-bit image

		if (!_is6_8BitToRGB(tmp, m_width, m_height, m_width,
			outBuf, m_width * 3, 
			m_uQuantColors, pal, 0)) 
		{
			return outBuf;
		}

		delete [] tmp;
	}


	// histogram EQ
	if (m_bHistEQ) 
	{
		if (!_is6_BrightnessHistogramEqualizeImage(outBuf, m_width, m_height, 3, m_width * 3, 5, 250, 0)) 
		{
			return outBuf;
		}
	}

	if (m_bHistStretch)
	{
		if (!_is6_BrightnessHistogramStretchImage(outBuf, m_width, m_height, 3, m_width * 3, 2.5, 2.5, 0, 0))
		{
			return outBuf;
		}
	}


	// despeckle
	if (m_bDespeckle) 
	{
		if (!_is6_DespeckleImage(outBuf, m_width, m_height, 3, m_width * 3, 1 | 2 | 4))
		{
			return outBuf;
		}
	}

	// adjust the image gamma 
	if (m_bGamma) 
	{
		_is6_AdjustGamma(outBuf, m_width, m_height, 3, m_width * 3, m_fGamma, 0);
	}

	// median filter
	if (m_bMedianFilter) 
	{
		// have to do this to a temp buffer
		BYTE *tmp = (BYTE *) new BYTE[imgByteSize];

		// the "1 | 2 | 4" is the channel selector . most filter operations use this method.
		if (!_is6_MedianFilterImage(outBuf, m_width, m_height, 3, m_width * 3, tmp, m_width * 3, 3, 1.0, 1 | 2 | 4)) 
		{
			return outBuf;
		}
		memcpy(outBuf, tmp, imgByteSize);
		delete [] tmp;
	}

	// unsharp mask
	if (m_bUnsharpMask)
	{
		BYTE *tmp = (BYTE *) new BYTE[imgByteSize];

		// just some generic parameters here. the user should really control these...
		_is6_UnsharpMaskImage(outBuf, m_width, m_height, 3, m_width * 3, tmp, m_width * 3, 10, 0.75, 1.5, 1 | 2 | 4);

		memcpy(outBuf, tmp, imgByteSize);
		delete [] tmp;
	}

	// emboss
	if (m_bEmboss)
	{
		// need an 8-bit grayscale to use as a 'bump map'
		// 8-bit buffers are one byte per pixel
		BYTE *tmp = (BYTE *) new BYTE[m_width * m_height];
		_is6_ImageToGrayScaleSingle(outBuf, m_width, m_height, 3, m_width * 3, tmp, m_width, 0);

		_is6_EmbossRGB(tmp, m_width, m_height, m_width, 
			m_dEmbossAngle, 1.0, 5, 
			NULL, 0, 
			outBuf, m_width * 3, 
			NULL, 0, 0);

		delete [] tmp;
	}


	if (m_bPolyWarp)
	{
		// have to do this to a temp buffer
		BYTE *tmp = new BYTE[imgByteSize];				 

		// make a black background
		_is6_FillSolidRect(tmp, m_width, m_height, 3, m_width * 3, CRect(0, 0, m_width - 1, m_height - 1), RGB(0,0,0), 0);

		// warping from this quadrilateral (the image's actual rectangle, in this case)
		ISQuadrilateral qFrom;
		qFrom.topLeft = CPoint(0, 0);
		qFrom.bottomLeft = CPoint(0, m_height - 1);
		qFrom.topRight = CPoint(m_width - 1, 0);
		qFrom.bottomRight = CPoint(m_width - 1, m_height - 1);

		// warp to this rectangle
		ISQuadrilateral qTo;
		qTo.topLeft = m_warp00;
		qTo.bottomLeft = m_warp01;
		qTo.topRight = m_warp10;
		qTo.bottomRight = m_warp11;

		_is6_PolygonWarpImage(outBuf, m_width, m_height, m_width *3,
			tmp, m_width, m_height, m_width * 3,
			// warp from this quad
			&qFrom,
			// warp to this quad
			&qTo,
			24, NULL, 0, 
			2, // mode 2 = bicubic interpolation (better quality)
			0);

		memcpy(outBuf, tmp, imgByteSize);

		delete [] tmp;
	}

	if (m_bSmear)
	{
		// have to do this to a temp buffer
		BYTE *tmp = (BYTE *) new BYTE[imgByteSize];

		_is6_PushImage(outBuf, m_width, m_height, 3, m_width * 3, tmp, NULL, 0, &m_smear1, &m_smear2, 0);

		memcpy(outBuf, tmp, imgByteSize);

		delete [] tmp;
	}

	if (m_bMosaic)
	{
		// size of output squares, adjust to taste
		UINT32  uBlockSizeX = 7, uBlockSizeY = 7;

		// how many blocks will we need?
		UINT32 uTW = m_width / uBlockSizeX;
		UINT32 uTH = m_height / uBlockSizeY;

		// allocate a temporary image
		BYTE *pTemp = new BYTE[uTW * uTH * 3];

		// find the averages
		_is6_ResizeImage(outBuf, m_width, m_height, m_width * 3, pTemp, uTW, uTH, uTW * 3, 3, is6_RESIZE_MODE_AREAAVG_FAST, 0);

		// expand that back to the source buffer
		_is6_ResizeImage(pTemp, uTW, uTH, uTW * 3, outBuf, m_width, m_height, m_width * 3, 3, is6_RESIZE_MODE_NEAREST_NEIGHBOR, 0);

		// done
		delete [] pTemp;

	}


	// blur
	if (m_bBlur) 
	{
		// have to do this to a temp buffer
		BYTE *tmp = (BYTE *) new BYTE[imgByteSize];

		if (!_is6_BlurImage(outBuf, m_width, m_height, 3, m_width * 3, tmp, m_width * 3, 3, (double)m_uBlurLevel / 100.0, 1 | 2 | 4)) 
		{
			return outBuf;
		}

		memcpy(outBuf, tmp, imgByteSize);

		delete [] tmp;
	}

	// sharpen
	if (m_bSharpen) 
	{
		// have to do this to a temp buffer
		BYTE *tmp = (BYTE *) new BYTE[imgByteSize];

		if (!_is6_SharpenImage(outBuf, m_width, m_height, 3, m_width * 3, tmp, m_width * 3, 3, (double)m_uSharpenLevel / 100., 1 | 2 | 4)) 
		{
			return outBuf;
		}
		memcpy(outBuf, tmp, imgByteSize);
		delete [] tmp;
	}


	// here's a simple one
	if (m_bIncreaseSaturation)
	{
		_is6_ModifyImageSaturation(outBuf, m_width, m_height, 3, m_width * 3, 1.7);
	}



	///////////////////////////////////////////////////////////////////////////////
	// all done rendering. now let's count the colors and generate the histograms

	// count the colors
	UINT32 cols = _is6_CountImageColors(outBuf, m_width, m_height, 3, m_width * 3, 0);
	CString t;
	t.Format("%u colors", cols);
	m_colorTextWnd.SetWindowText(t);

	int iCurSel = m_histoCombo.GetCurSel();
	int iHistoSel = (int)m_histoCombo.GetItemData(iCurSel);

	if (iHistoSel==0) 
	{

		if (!_is6_GetBrightnessHistogram(outBuf,
			m_width,
			m_height,
			3,
			m_width * 3,
			m_EQHisto,
			0)) 
		{
			TRACE("Something bad happened\n");
		}
	} 
	else 
	{
		// need an array of arrays.
		// we'll give NULLs for the channels we don't want
		UINT32 *histos[3];

		histos[0] = histos[1] = histos[2] = NULL;
		switch (iHistoSel)
		{
		case 1:
			histos[0] = m_EQHisto; 
			break;
		case 2:
			histos[1] = m_EQHisto; 
			break;
		case 3:
			histos[2] = m_EQHisto; 
			break;
		}

		if (!_is6_GetImageChannelHistograms(outBuf,
			m_width,
			m_height,
			3,
			m_width * 3,
			histos, 0)) 
		{
			ASSERT(0);
		}
	}


	return outBuf;
}
