// ISDemoDlg.h : header file
//

#if !defined(AFX_ISDEMODLG_H__67F8BF49_F364_11D2_815A_444553540000__INCLUDED_)
#define AFX_ISDEMODLG_H__67F8BF49_F364_11D2_815A_444553540000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

/////////////////////////////////////////////////////////////////////////////
// CISDemoDlg dialog

// since we're going to use the ImgSource DLL, we need to #define this symbol:
#define IS60_USING_DLL
#include "ISource.h"

class CISDemoDlg : public CDialog
{
// Construction
public:
	CISDemoDlg(CWnd* pParent = NULL);	// standard constructor

	~CISDemoDlg();

// Dialog Data
	//{{AFX_DATA(CISDemoDlg)
	enum { IDD = IDD_ISDEMO_DIALOG };
	CComboBox	m_histoCombo;
	CComboBox	m_lutCombo;
	CStatic	m_colorTextWnd;
	CStatic	m_imgRectBefore;
	CStatic	m_imgRectAfter;
	CStatic	m_histoFrame;
	BOOL	m_bBlur;
	UINT	m_uBlurLevel;
	BOOL	m_bFlipV;
	BOOL	m_bGrayscale;
	BOOL	m_bHistEQ;
	BOOL	m_bFlipH;
	BOOL	m_bLUTBlue;
	BOOL	m_bLUTGreen;
	BOOL	m_bLUTRed;
	BOOL	m_bLUT;
	BOOL	m_bMedianFilter;
	UINT	m_uQuantColors;
	BOOL	m_bQuantize;
	BOOL	m_bRGBBGR;
	int		m_iRotateSel;
	BOOL	m_bSharpen;
	UINT	m_uSharpenLevel;
	BOOL	m_bDespeckle;
	BOOL	m_bUnsharpMask;
   BOOL  m_bGamma;
   double m_fGamma;
	BOOL	m_bEmboss;
	BOOL	m_bPolyWarp;
	BOOL	m_bMosaic;
   BOOL  m_bSmear;
	BOOL	m_bIncreaseSaturation;
	UINT	m_uQuantErrorMax;
	BOOL	m_bQuantFS;
	BOOL	m_bHistStretch;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CISDemoDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
   CPoint m_warp00, m_warp01, m_warp10, m_warp11;
   CPoint m_smear1, m_smear2;
   double m_dEmbossAngle;

	HICON m_hIcon;

	CPalette m_pal;

	UINT32 m_height, m_width;
	BYTE * m_rgbBuf;

	BYTE	m_InvLUT[256];
	BYTE	m_StepLUT[256];
   BYTE	m_VLUT[256];
   BYTE	m_highBrightLUT[256];
   BYTE	m_lowerBrightLUT[256];
   BYTE *m_LUTArray[5];
	
	BYTE	m_LUTChannelMask;

	// eq graph
	BYTE		m_EQGraphMask;
	UINT32	m_EQHisto[256];

	void InvalidateAfter();
	void InvalidateBefore();
	void InvalidateHistogram();


	void MakePalette();
	void CleanUp();
	void LoadDefaultImage();
	CString StringFromErrorNum(int err);


	BYTE * RenderImage();

	// Generated message map functions
	//{{AFX_MSG(CISDemoDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnAbout();
	afx_msg void OnSave();
	afx_msg void OnOpen();
	//}}AFX_MSG
	afx_msg void UpdateInvalidate();
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_ISDEMODLG_H__67F8BF49_F364_11D2_815A_444553540000__INCLUDED_)
