/*---------------------------------------------------------
   ISMotionBlur.h : part of the ImgSource library.
   
   Image processing functions

   This code copyright (c) 2000-2014, Smaller Animals Software, Inc..

   No portion of this code may be copied or distributed without 
   permission of Smaller Animals Software, Inc..
   http://www.smalleranimals.com

---------------------------------------------------------*/
#ifndef ISMOTIONBLURH
#define ISMOTIONBLURH

#if !defined is5_SOURCEH && !defined is5_INTERNAL
#error Do not include this file directly. Include ISource.h
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*---------------------------------------------------------
   is5_MotionBlur

   Purpose : 
   Apply a motion blur effect to an image

   Notes:
      *  pIn != pOut.
      *  Output is allocated by the caller.

   Param             Use
   ------------------------------------
   pIn               source image
   uWidth            width in pixels
   uHeight           height
   uInRowStride      bytes per input pixel row
   pOut              output image
   uOutRowStride     bytes per output pixel row
   uBpp              number of bytes per pixel
   fAngle            angle of motion, for linear blur
   fDistance         distance between original image and final blur step
   length            number of blur steps
   eStyle            0 : linear. image is blurred in a line (traditional motion blur)
                     1 : radial. image is blurred in a circle around the center point
                     2 : zoom. image is blurred as if zooming in

   Uses callback : Yes

   Return
   ------
   FALSE on failure
---------------------------------------------------------*/
_ISDeclSpec BOOL _ISCConv _ISFn( is5_MotionBlur )(const BYTE *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pOut, UINT32 uOutRowStride, UINT32 uBpp, double fAngle, double fDistance, int length, int eStyle);

#ifdef __cplusplus
}
#endif

#endif