/*---------------------------------------------------------

   ISRevision.h : part of the ImgSource library.

   ImgSource revision history

   This code copyright (c) 2000-2014, Smaller Animals Software, Inc..

   No portion of this code may be copied or distributed without 
   permission of Smaller Animals Software, Inc..
   http://www.smalleranimals.com

---------------------------------------------------------*/
/*

  
   1.0.0.0
   first beta

   1.0.0.1
   second beta

   1.0.0.2     4/23/99
   first release

   1.0.1.0     4/27/99
   metafile functions

   1.0.1.1     4/28/99
   RGB->HBITMAP fixup (non-realizied palette)

   1.0.2.0     5/3/99
   SplitRGB and CombineRGB

   1.0.3.0     5/6/99
   RLE-DIB support
   draw DIB 

   1.0.3.1     5/10/99
   IS_ERR_SELECTOBJ
   more flexible Drawing (allow !RC_BITMAP64)

   1.0.4.0     5/12/99
   granularity improvements in ISLib

   1.1         5/13/99
   IS* i/o functions added

   1.2         5/14/99
   JPEG_APPx added

   1.2.0.1     5/19/99
   name change to ImgSource

   1.2.0.1     5/20/99
   GIF dimensions fix
   CopyBuffer fix

   1.2.1.0     6/2/99
   GIF read fix

   1.2.1.1     6/7/99
   TGA and PNG callback fixup

   1.2.1.2     6/8/99
   PNG write callback
   Improved error checking on read/write ops

   1.2.1.3     6/11/99
   single line BMP alignment fix

   1.2.1.4     6/16/99
   typedef clarification in PCX code
   delete the right thing in WMF writing

   1.2.1.5     6/17/99
   memory read fix

   1.2.2.0     6/28/99
   TIFF compression call

   1.2.3.0     7/15/99
   memory seek fixup (fixes TIFF memory write)

   1.3.0.0     7/19/99
   multi-page TIFF

   1.3.0.1     7/26/99
   JPG DPI fix

   1.3.1.0     7/29/99
   DIB Draw fix (24 bpp)
   added crossover LUT
   file size fix (fflush)

   1.4         8/2/99
   no GIF

   1.4.0.1     8/16/99
   PNG DPI read from dims fix
   moved reg info to non-thread-safe area

   1.4.0.2     8/18/99
   PNG DPI to dots per meter

   1.4.1.0     8/23/99
   PNG to RGBA
   PNG 8-bit + alpha
   RGBA -> RGB + A

   1.4.1.1     8/27/99
   bail on invalid TIFF read

   1.4.2.0     9/21/99
   HBITMAP <-> DIB fns
   RGBQUAD -> HPALETTE fns
   fix on return from ISStretchDrawDIB
   stronger GIF lockout

   1.4.2.1     11/6/99 
   VC6 touch ups
   reduced granularity of JPG functions
   reduced granularity of file dim
   fixed JPG output marker bug

   1.4.3       11/8/99
   BMP RLE fixup
   ResizeImage
   CropImage

   1.4.3.1     11/10/99
   removed ASSERT in UnpackDIB

   1.4.3.2     11/16/99
   speedups in BMP and TGA output

   1.4.3.4     
   TIFF - LZW read check
   manager validity test

   1.4.3.5
   DIB palette fix

   1.4.3.6
   RLE tolerance increase

   1.4.4.0     12/14/99
   gamma function

   1.4.5.0     12/21/99
   pack buffer function

   1.4.5.1     12/29/99
   changed CISImgUtil::_BGRToRGB to non-inline (VC 5 is broken???)

   1.4.6.0     1/19/00
   DIBParts

   1.4.7.0     1/20/00
   ISSetHBITMAPCreateMethod
   ISDecimateRGB speedup

   1.4.7.1     1/24/00
   JPG GetDims Depth fix
   added RGB->lum conversion for 8-bit JPG Read

   1.4.7.2     1/24/00
   JPG CMYK fix

   1.4.7.3     2/9/00
   PCX monochrome read fixup
   more GIF removal

   1.4.8.0     2/11/00
   shear x,y
   ImgSource::is_min, ImgSource::is_max
   ISGetLibVersion

   1.4.9.0      3/9/00
   new TIFF page fns

   1.4.9.1      3/9/00
   JPG YCbCrk == CMYK...

   1.4.10.0      3/12/00
   BMP-RLE in (word align)
   BMP-RLE 8 output

   1.5.0.0         3/16/00
   16-bit grayscale TIFF input
   g3/g4 TIFF output
   g3/g4 TIFF input
   removed old multi-page TIFF calls

   1.5.0.1         3/17/00
   rearranged some internals

   1.5.1.0         3/28/00
   more histogram fns
   catch no read fn on user write
   pack last byte fix
   unpack
   1,4 bit to DIB


   1.5.1.1         4/3/00
   8-bit to DIB biSizeImage fix

   1.5.1.2         4/3/00
   8-bit TIFF output fix

   1.5.1.3         4/25/00
   TIFF input optimization (remove extra alloc)

   1.5.2.0         4/27/00
   sa_ptr
   ISDitherRGB
   dither choice


   1.5.3.0         4/29/00
   Flood fill
   Polygon fill


   1.5.4.0         5/5/00
   ISArray
   overlay speedups
   auto brightness
   despeckle


   1.5.4.1         5/10/00
   metafile output to SetDIBitsToDevice

   1.6.0.0   
   PAX
   restructure of the DLL (config)

   1.6.0.1         5/18/00
   PNG gamma switch

   1.6.0.2         5/23/00
   BI_BITFIELDS in BMP and DIB
   Allocators
   flood fill tolerance

   1.6.0.3         6/4/00
   fixed PNG output for < 8bpp
   recompile for PAX

   1.6.0.4         6/4/00
   PAX in GuessFileType
   PNG bKGD conditions   

   1.6.0.5         6/5/00
   BMP 16 read fix

   1.6.1.0         6/8/00
   Overlay trans tolerance
   color replace tolerance
   ISGetTextLineSize added to DLL
   smooth text output

   1.6.1.1         6/16/00
   alpha overlay speedups
   ok to pass empty string to drawtext
   getpngdims2

   1.6.1         6/27
   ISCombineRGBAndAToRGBA
   ISQuickRotateImage


   1.6.1.2         6/28
   fixed memory leak in 8-bit TIFF FAX read
   quick rotate images
   hflip image

   1.6.1.3         6/29
   simple resample rgb, image

   1.6.1.4         7/4
   drop shadow div/0

   1.7         7/9/00
   Photoshop RGB/8-bit in/out

   1.7.0.1      7/9
   PSD compressed file channel vs. input channel fix

   1.7.0.2      7/9
   metatfile handle to RGB

   1.7.0.3      7/13
   PCX write fix (quit on write error)
   DLL fix for PSD read

   1.7.0.4      7/16
   TIFF bail on LZW fix again

   1.7.0.5      7/17
   TIFF DPI for FAX reads

   1.7.0.6      7/20
   TIFF memory using C-stdlib not Global*
   fixed mem IO to better handle seeks and reads during write
   returning outsize from BMP-RLE and TIFF-RGB writes

   1.7.0.7      7/20
   yet another PSD tweak

   1.7.0.8      7/20
   ISGetPAXID

--------------------------------------------------------------------------

   2.0.0.0   b      8/2/00
   extreme function changes:
   consolidated reading and writing functions
   removed many after-thought functions
   move DPI into dim's

   ISAlphaBlendRGBA
   relative seeks on RLE write
   ISIsTIFFFax
   ISReadTIFFFaxPageTo1Bit
   TLA
   Rotate8
   Resize8
   Shear8
   SolidRect8
   HorizFlip 1 bit
   resize 1 bit
   1 bit to DIB
   1 and 8 bit overlays
   resize speedups

   2.0.0.1   b
   BMP read write change
   DPI structs
   dib->colormapped

   2.0.0.2   b
   DPI fixes

   2.0.0.3   b
   PNG pal switching on colors

   2.0.0.4 b
   - multi TIFF fax fn

   2.0.0.5 b
   fix for .h (overlay tol)

   2.0.0.6
   released

   2.0.1.0   
   ISDrawLineOnImage
   overlay cleanup
   overlay 8 to 24
   overlay 8 alpha
   overlay 8 alpha to 24
   ellipse
   polygon fill image
   polygon fill touchup
   TLA read 8 fix

   2.0.1.1
   crop fix

   2.0.1.2
   zoom fix

   2.0.1.3
   multi-page fax out fix

   2.0.1.4
   mutli-page tiff output

   2.0.1.5
   read PNG < 8 to 8 bpp

   2.0.1.6
   better poly & line range checking
   _ISResizeRGBBiCubic

   2.0.1.7
   bi-cubic touch up

   2.0.1.8
   imgx ts flags

   2.0.1.9
   callback to bicub

   2.0.2.0
   crop back to width/height

   2.0.2.1
   bk color fix for crop

   2.0.2.2
   optimization rebuild

   2.0.2.3
   ISGetFirstNColorsInRGB

   2.0.2.4
   pack buffer check fix

   2.0.3.0   
   get pal functions
   PNG grayscale palette touch up
   TIFF frame count param check

   2.0.3.1
   JPG marker doc. touch up

   2.0.3.2
   rem'd msgbox in JPG error code

   2.0.4.0
   lossless JPG transforms

   2.0.4.1   
   init DPI values

   2.0.4.2
   added _ISJPGTransform to .def

   2.0.4.3
   PNG 16bit gray input fix

   2.0.5.0
   WBMP support

   2.0.5.1
   _ISGetWBMPDims

   2.0.5.2
   WBMP to guessft

   2.0.5.3
   memcpy crit to process safe

   2.0.5.4
   PSD resource fix

   2.0.5.5
   HBITMAP->RGBA

   2.0.6.0
   ISExit
   ISGetTIFFTag

   2.0.6.1
   WBMP output fix

   2.0.6.2
   critical section init stuff

   2.0.7.0
   ISResizeFilter

   2.0.7.1
   resize filter callback and optimizations

   2.0.7.2, 3
   resize filt return value touchups

    ** 2.0.7.4 hybrid of 2.0.7.0 + filterResize from 2.1.2.1

   2.1.0.0   b 11/24/00
   color matching speedups
   new trial input / output limitations
   new key
   single line not for trial
   poly fill re-do
   NULL pwd for TLA ok

   + ISReadImageToDIB
   + ISPushRGB
   + ISQuickRotate1Bit
   - ISRotateRGB
   - ISRotate8Bit
   + ISRotateImage
   - ISPolygonFillRGB
   - ISPolygonFill8Bit
   - ISPolygonFillRGBOverlay
   - ISResizeRGB
   - ISResizeRGBBiCubic
   + ISResizeImageBicubic
   - ISQuickRotateRGB
   - ISCropRGB

   2.1.0.1   b 11/24/00
   callback userdata set fix

   2.1.0.2 b 11/25/00
   generic read fix for PSD, metafiles

   2.1.0.3 11/25/00
   DIB dim fns

   2.1.1.0   11/30/00
   1-bit text
   8-bit text
   JPG smoothing
   JPG downsample

   2.1.1.2   12/3/00
   fixed single line key check

   2.1.1.3 12/9/00
   fixed drawtext w clr = white
   (fixes smoothtext)

   2.1.1.4 12/16/00
   check for no TLS
   per-file optimization pragmas
   TIFF tile dims tags

   2.1.2.0 12/31/00
   ISApplyRedEyeFilter
   libtiff 3.5.5

   2.1.2.1   12/3/00
   prevent trial error from overriding other errors
   BMP read bit depth fix
   BMP read NULL pal fix
   trial punish test for NULL palette
   updated copyright notices

   2.1.3.0
   EXIF reading
   callback in filterresize

   2.1.3.1
   write error checking for metafiles

   2.1.3.2     2/3/01
   ISSetDitherErrorMax

   2.1.3.3    2/4/01
   JPG DCT scaling

   2.1.3.4   2/9/01
   JPG / PNG write error on EOF
   EXIF string len

   2.1.3.5   2/13/01
   tag memory fix

   2.1.3.6   2/15/01
   fixed leak in tag memory array
   rotate RGBA

   2.1.3.7   2/18/01
   fixed rotate

   2.1.3.8   2/28/01
   EXIF u16 read fix for motorola

   2.1.4.0   3/3/01
   IPTC reading
   another EXIF u16 read fix for motorola

   2.1.5.0   3/xx/01
   ISGetPSDDims2
   IS8BitToRGBA
   various PNG read changes (x/0, alpha read 8-bit, etc)

   2.1.5.1   3/19/01
   get PNG background color

   2.1.6.0   4/4/01
   1-bit fills


   2.1.6.1   
   init handles to null on exif and iptc reads
   16-bit BMP output
   RGB24->16

   2.1.6.2 5/6/01
   _ISApply3LUTsToRGB
   _ISShiftRGBChannels

   2.1.6.3   5/9/01
   look in ifd0 for makernote

   2.1.6.4   5/21/01
   exif section parse reworking

   2.1.7.0   5/26/01
   PNG single line reading

   2.1.7.1   6/30/01
   recompile with size optimizations

   2.1.7.2   7/1/01
   shear image

   2.1.7.3 7/7/01
   fixed callback test

   2.1.8.0  7/24/01
   _ISGaussianBlurImage
   _ISUnsharpMaskImage
   _ISApplyConvolutionFilterToImage      

   2.1.8.1   8/6/01
   ISPush 8bit fix

   2.1.8.2  8/7/01
   callback on gaussian blur and unsharp mask

   2.1.8.3  8/10/01
   _ISOverlay1BitTrans

   2.1.8.4  8/11/01
   TGA grayscale read fix

   2.1.8.5  8/12/01
   read TIFF to 8bit

   2.1.8.6  8/14/01
   ISMeta*2
   exif id tag tweak

   2.1.8.7  8/16/01
   exif fix

   2.1.8.8  8/18/01
   no, really. exif fix.

   2.1.8.9  8/19/01
   mono pcx read

   2.1.9.0  8/20
   isoverlayimage
   ISCreate8BitMaskFromColor
   ISFillSolidRect

   2.1.9.1  8/21/01
   typedef tweaks

   2.1.9.2  8/27/01
   _ISApplyLUTsToImage

   2.1.9.3  
   poly fill RGBA      

   2.1.9.4
   ISMeta read fix

   2.1.9.5
   _ISAlphaBlendSolidColor

   2.1.9.6
   allowing other compression types in ISISTIFFFAX

   2.1.9.7
   _ISFindColorsUsedIn8BitImage2
   update isdemo

   2.1.9.8
   set low bits from 16bit DIBs to 0 (not 0x07)

   2.1.9.9
   fix TIFF/JPG output 

   2.1.9.10

   2.1.10.0 11/13/01
   callbacks in TIFF read

   2.1.11.0 11/16/01
   Get fill mask
   fix to flood fill (queue issue??)

   2.1.11.1 11/26/01
   callback change from inline to macro

   2.1.12.0 11/30/01
   warp image (disabled)

   2.1.12.1
   warp image (disabled)
   fix to single plane PCX read
   speedup in ISGetFirstNColorsInRGB

   2.1.12.2
   ISBicubic test ranges on signed values 

   2.1.12.3
   another pcx read fix

   2.1.12.4
   yet another pcx read fix

   2.1.13.0
   exposed poly warp in DLL

   2.1.14.0 1/22/02
   _ISWriteMultiTIFFEx

   2.1.15.0
   _ISGetTIFFDimsEx


   2.1.15.2
   fix to generic read with grayscale JPGs

   2.1.16.0
   read TGA as RGBA
   ISDrawRGBA

   2.1.16.1
   write RGBA TIFF

   2.1.16.2
   LineReader stuff

   2.1.17.0
   ISRGBAToDIB
   ReadToDIB handles 32 bit images

   2.1.17.1
   check for TIFFs missing bitdepth tags in GetDims

   2.2 a
   BMP 32 out
   libPng 1.2.1 (was 1.0.3)
   PNG_INFO_tRNS (allow single color alpha)
   user file out allocators
   WBMP file read callback
   return whatever was read, for file reads
   return bytes written, not 0, on file write err
   new key
   FFT
   RGB<->HSV
   emboss


   removed redundant functions:
   - ISSimpleResampleRGB
   - ISApplyLUTsToRGB
   - ISApply3LUTsToRGB
   - ISWrite1BitToTIFFFax
   - ISWriteMultiTIFFEx
   - ISReadMetafileToRGB2
   - ISReadMetafileHandleToRGB2
   - ISGetPSDDims2
   - IS8BitToDIB2

   2.2.0.1 a
   added DPI to BMP output
   morpho filters

   2.2.0.3 b
   comments and morpho touchups

   2.2.0.5 b
   G4 cleanup
   final beta

   2.2.0.6
   released

   2.2.1.0
   ISReadImageToRGB

   2.2.2.0
   make copy of input in RGBAQuant (modifies input!)
   _ISCombineImageChannels
   _ISSplitImage

   2.2.3.0
   _ISFindNormalizedDifference
   _ISReorderChannels
   _ISAlphaBlend8BitGray

   2.2.3.1
   fix to _ISAlphaBlend8BitGray

   2.2.4.0
   _ISGetImageChannelHistograms

   2.2.4.1
   ISSimpleResizeImage speedup
   ISResizeImage speedup
   JPEG marker read fix

   2.2.4.2
   fixed ISResizeImage

   2.2.5.0
   new modes for ISOverlayImage
   _ISApplyBrightnessContrastToImage
   allow 16-bit (gray+alpha) input for PNG 

   2.2.5.1
   fixed bug in ISOverlayImage in abs diff mode
   fixed alpha channel test in _ISApplyBrightnessContrastToImage

   2.2.6.0
   ISJPGTransformCrop
   AddOffset & SubOffset overlay modes


   2.2.7.0
   _ISDoubleArrayOffset
   bi-cubic in polywarp

   2.2.7.1
   fix TIFF-FAX out (separate to contig planar. fixes WinXP reader issues)
   added CCITT modified Huffman RLE for 1-bit TIFF output

   2.2.7.2
   tightened up bounds checking in EXIF parsing

   2.2.7.3
   fix to 4-bit BMP/RLE decoding

   2.2.8.0
   read and write TIFF/CMYK
   TIFFTAG_INKSET

   2.2.8.1
   fixed bytes written return of ISWriteMultiTIFF
   EXIF: search SubIFD for MakerNote 

   2.2.8.2
   PNG gamma read tweak, defaulting to 1/2.2 as file gamma.
   added sRGB support for PNG read
   improved comments for PNG output gamma

   2.2.9.0
   _ISDrawTextCharsetMode
   get mono palette in ISGetPCXPalette
   read PNG to 1 bit
   fix to mem source seek from end (was seeking one too far back)

   2.2.10.0
   allow none, deflate, packbits, etc comp mode for 1-bit TIFF write
   fix TIFF dpi output
   ISCreateColorMatcher
   ISDestroyColorMatcher
   ISFindClosestColor
   ISColorCompare
   ISWriteTiffMultiViaCB

   2.2.10.1
   GPS EXIF
   fixed count RGB colors

   2.2.11.0
   ISCopyJPGInputMetadataToOutputMetadata
   ISCopyPNGInputMetadataToOutputMetadata

   2.2.12.0
   ISQuantizeRGBATo8BitEx
   ISOverlayRGBOnRGBA
   ISAlphaBlendRGBAToRGBA
   ISSwapPaletteEntriesIn8Bit
   ISResizeImageEx
   32-bit TGA out
   clearing palettes to 0's first, on file reads

   2.2.13.0
   ISSimpleResampleImageEx
   ISResizeFilterImageEx
   ISResize8BitEx
   ISResize1BitEx

   fix ISStretchDrawDIB for 16 bpp DIBs with BI_BITFIELDS
   fix ISRGBAToDIB
   fix to JPG transform (uninit'd variable)
   return max colors if biClrUsed = 0 in ISGetBMPPalette

   2.2.14.0
   PCD image read
   PCD id in ISGuessFileType
   fix to 8bit TIFF FAX Read (checking photometric to invert on min is white)

   2.2.15.0
   modified DLL_THREAD_DETACH and DLL_PROCESS_DETACH in DllMain, to reduce accumulation of TLS data.
   fixed 16-bit BMP output
   finished PCD index reading
   added get PCD index count

   2.2.15.1
   more aggressive thread clean up
   converted TSL to use std::list
   ISThreadExit

   2.2.15.2
   removed all setjmp/longjmp in favor of C++ exceptions

   2.2.16.0
   ISResizeFilterImageExOneTo8Gray
   ISResizeOneTo8Gray
   ISResizeImageBicubicEx

   2.2.16.1
   optimized gaussian blur and unsharp mask

   2.2.16.2
   optionally using user's input rect in *DrawTextEx2* when DT_CENTER or DT_RIGHT
   added 8-bit + alpha to tiff reading
   fixed return codes in ISResizeFilter*

   2.2.17.0
   _ISResizeFilterImageEx8To24

   2,2,18.0
   _ISResizeImageEx8To24

   2.2.18.1
   fix to ResizeFilter for extreme reductions

   2.2.18.2
   allowing PCX 1 bit input
   ISResizeFilterImageExOneTo8Gray: fix crash on large images, fix palette swap

   2.2.19.0
   ISOpenUserDestEx
   ISOpenFileDestReadWrite
   ISAppendTIFF
   ISAppendMultiTIFF
   TIFF append 
   1-bit TIFF output in ISWriteTIFF

   2.2.19.1
   fix to ISDrawTrans* (too agressive on the cleanup)

   2.2.19.3
   fix to JPG error handling (crashed)

   2.2.19.4
   fix to text output

   2.2.19.5
   stronger error checking in PCX reader

   2.2.19.6
   stronger default alpha on read TGA to 32-bit

   2.2.19.7
   allowing 8-bit JPG-in-TIFF output

   2.2.20.0
   ISIPTCWriteInit
   ISIPTCWriteAddString
   ISIPTCExport
   ISIPTCWriteDestroy
   ISCopyJPGWithNewMarkers

   2.2.20.1
   fix to 1-bit TIFF with LZW
   fix to PNG DPI read

   2.2.20.2
   fix to ISRotateImage

--------------------------------------------------------------------------

   3.0 started 10/20/02
   - ISQuickRotateRGB
   - ISApplyConvolutionFilterToRGB
   - ISZoomRGB
   - ISApplyBrightnessContrastToRGB
   - ISOverlayRGB
   - ISMakeDropShadowOnRGB
   - ISDrawTextOn1Bit2
   - ISReadTIFFFaxPageTo8Bit
   - ISReadTIFFFaxPageTo1Bit
   - ISIsTIFFFAX
   - ISReadMetafileToRGB
   - ISReadMetafileHandleToRGB
   - ISEXIFDestroy
   - ISEXIFGetMakerNote
   - ISEXIFInit
   - ISFillRGBSolidRect
   - ISFill8BitSolidRect
   - ISDrawSolidRectOn1Bit
   - ISPolygonFill1BitEx
   - ISApplyGammaToRGB
   - ISGetRGBBrightnessHistogram
   - ISGetRGBChannelHistogram
   - ISHistogramEqualizeRGB
   - ISRGBToGrayScale24
   - ISRGBToGrayScale8Bit    
   - ISSetDitherErrorMax
   - ISResizeImageEx
   - ISResizeImageBicubicEx
   - ISResizeFilterImageEx
   - ISResize8BitEx
   - ISResize1BitEx       
   - ISSimpleResampleImageEx
   - ISResizeFilterImageExOneTo8Gray
   - ISResizeImageEx8To24
   - ISResizeFilterImageEx8To24
   - ISFindColorsUsedIn8BitImage2
   - ISColorReplaceRGB
   - ISSplitRGBChannels
   - ISCombineRGBChannels
   - ISSetAlphaChannelInRGBA
   - ISMakeDropShadowOnRGB
   - ISQuantizeRGBATo8BitEx
   - ISMakeRectFadeMask
   - ISOverlayRGBEdgeFaded
   - ISOverlayRGB
   - ISApply3LUTsToRGB
   - ISDespeckleRGB
   - ISDespeckleGrayscale
   - ISSetTIFFWrite32BitAsCMYK
   - IS3SetTIFFNoConvertCMYK
   - IS3Overlay8BitTrans
   - IS3Overlay1BitTrans
   - ISVertFlipBuf
   - ISFlipHorizontalImage
   - ISShearRGBX
   - ISShearRGBY
   - ISShear8BitX
   - ISShear8BitY
   - ISIPTCInit


   + ISGetRotatedBufSize
   + ISGetRotatedPixelSize
   + ISApplyBrightnessContrastToImage
   + ISIsOneBitTIFF
   + ISReadMetafile
   + ISReadMetafileHandle
   + ISEXIFInitialize
   + ISEXIFRelease
   + ISFillSolidRect1Bit
   + ISApplyGammaToImage
   + ISRGBAToBGRA         
   + ISImageToGrayScale
   + ISImageToGrayScale8Bit
   + ISGetBrightnessHistogram
   + ISHistogramEqualizeImage
   + ISRGBToHSL
   + ISHSLToRGB
   + ISResizeFilterImageOneTo8Gray
   + ISResizeImage8To24
   + ISResizeFilterImage8To24
   + ISColorReplaceImage
   + ISDespeckleImage
   + ISVerticalFlipImage
   + ISHorizontalFlipImage
   + ISQuickRotateImageInPlace
   + ISDraw1Bit
   + ISStretchDraw1Bit
   + ISIPTCInitialize
   + ISOpenHandleSource
   + ISOpenHandleDest
   + IS3GetJPGInputMarkerInfo
   + ISGetICCProfile
   + IS3QuadrilateralIsConvex
   + IS3IsValidManager

   * ISReadBMP
   * ISReadJPG
   * ISReadPAX
   * ISInitReadPAXLines
   * ISReadPCD
   * ISReadPCDIndex
   * ISReadPCX
   * ISReadPNG
   * ISReadPSD
   * ISReadTLA
   * ISReadWBMP
   * ISEXIFGetString
   * ISEXIFGetTagList
   * ISDrawEllipseOnImage
   * ISDrawEllipseOn1Bit
   * ISDrawLineOnImage
   * ISDrawLineOn1Bit
   * ISFillSolidRect
   * ISPolygonFillImage
   * ISPolygonFill1BitEx
   * ISRotateImage
   * ISQuantizeRGBTo8Bit
   * ISRGBTo8BitDithered
   * ISQuickRotate1Bit
   * ISQuickRotateImage
   * ISUnsharpMaskImage
   * ISGaussianBlurImage
   * ISApplyConvolutionFilterToImage
   * ISFlipHorizontal1Bit
   * ISFlipHorizontalImageEx
   * ISApplyLUTsToImageEx
   * ISOverlayImage
   * ISRGBToBGR
   * IS8BitToRGB
   * IS8BitToRGBA
   * ISRGBToRGBA
   * ISGetImageChannelHistograms
   * ISAutoBrightnessRGB
   * ISHistogramStretchGrayscale
   * ISHistogramStretchRGB
   * ISRGBToHSV
   * ISHSVToRGB
   * ISModifyImageSaturation
   * ISGetColorMatchMaskFromRGB
   * ISFloodFillRGB
   * ISMorphoDilationGray
   * ISMorphoErosionGray
   * ISGet8BitPaletteFromRGB
   * ISResizeImage
   * ISResizeImageBicubic
   * ISResizeFilterImage
   * ISResize8Bit
   * ISResize1Bit
   * ISSimpleResampleImage
   * ISFindColorsUsedIn8BitImage
   * ISCountRGBColors
   * ISPushImage
   * ISSplitImage
   * ISCombineImageChannels
   * ISRGBTo8BitBestFit
   * ISSplitRGBAToRGBPlusA
   * ISReorderChannels
   * ISAlphaBlendSolidColor
   * ISCombineRGBAndAToRGBA
   * ISCropImage
   * ISCrop1Bit
   * ISQuantizeRGBATo8Bit
   * ISOverlayRGBTrans
   * ISOverlayImage
   * ISOverlayRGBOnRGBA
   * ISAlphaBlendRGB
   * ISAlphaBlendRGBA
   * ISAlphaBlendRGBAToRGBA
   * ISOverlay1Bit
   * ISOverlay1BitTrans
   * ISOverlay8Bit
   * ISOverlay8BitTrans
   * ISOverlay8BitToRGB
   * ISOverlayImage8BitAlphaOnRGB
   * ISOverlayImage8BitAlpha
   * ISOverlayImageDouble
   * ISAlphaBlend8BitGray
   * ISPolygonWarpImage
   * ISPack8BitBuffer
   * ISShiftRGBChannels
   * ISInitWriteTIFFLines
   * ISShearImageX
   * ISShearImageY
   * ISOpenUserDest
   * ISOpenMemoryDest
   * ISOpenFileDest
   * ISSeek

   3.0.0.1 a      11/16/02
   alpha 

   - IS3PNGSetAllowAlphaPalette
   - IS3AllowPNGGammaCorrectInput
   - IS3DrawTextCharsetMode

   * IS3InitReadPNGLines

   3.0.0.2 a      11/19/02
   first alpha release

   3.0.0.3 a
   * _IS3GetSize
   * _IS3GetPos
   size and pos manager callbacks changed
   using HANDLE for file Source/Dest
   fixed -1 error val on BMP read
   fixed TIFF write crash
   fixed PNG to DIB read BGR issue
   change to ISRotateImage (no back fill, bi-cubic, etc)
   + ISRotateImage1Bit

   3.0.0.4 a
   changed all RECT and POINT params on exported functions to RECT*, POINT*, to please the gods of VB

   3.0.0.5 a
   fixed 8-bit text draw color problem
   fixed bound rect on text draw fn's

   - IS3BlurRGB
   - IS3SharpenRGB
   - IS3MedianCutRGB
   - ISApplyBrightnessContrastToImage
   - ISApplyGammaToImage

   + IS3BlurImage
   + IS3SharpenImage
   + IS3MedianCutImage
   + ISAdjustBrightnessContrast
   + ISAdjustGamma

   - IS3AutoBrightnessRGB

   + IS3FillTransparentRectOnImage
   + IS3AlphaBlendSolidColor
   + IS3BrightnessHistogramEqualizeImage
   + IS3BrightnessHistogramStretchImage

   3.0.0.6 a
   + IS3Decimate8Bit
   + IS3Decimate8BitTo24

   * IS3DecimateImage

   moved the following to ISEffects
   - IS3AllocFFTGrid
   - IS3DoFFT
   - IS3FilterFFT
   - IS3DoFFTInverse
   - IS3MakeGrayscaleFromFFT
   - IS3NextPowerOfTwo

   3.0.0.7 a
   * IS3EmbossRGB

   3.0.0.8 a
   + IS3SetOutputICCProfile

   3.0.0.9 a
   - IS3FloodFillRGB
   - IS3GetColorMatchMaskFromRGB
   - IS3ApplyMatrixToRGB

   + IS3FloodFillImage
   + IS3GetColorMatchMaskFromImage
   + IS3ApplyMatrixToImage

   * IS3ApplyConvolutionFilterToImage
   * IS3ShiftImageChannels

   - IS3HistogramStretchGrayscale
   - IS3HistogramEqualizeGrayscale

   * IS3HistogramStretchImage
   * IS3HistogramEqualizeImage

   3.0.0.10 a
   - IS3CountRGBColors
   + IS3CountImageColors

   * ISGetFirstNColorsInRGB

   3.0.0.11 beta 12/2/02
   change to luminance calc (affects many functions)

   3.0.0.12 beta 12/2/02
   bicubic resize optimizations + fix

   3.0.0.13 b
   + IS3PolygonIsConvex
   added 8-bit gray output for TIFF 
   fixed headers for TIFF output (bad uFlags bits in some)

   3.0.0.14 b
   + IS3GetConvexHull
   IS3InitWriteTIFFLines documentation fix

   3.0.0.15 b
   fix to 8-bit despeckle

   3.0.0.16 b
   * IS3DespeckleImage
   * IS3GaussianBlurImage
   * IS3UnsharpMaskImage

   3.0.0.17 b
   fix to IS3EXIFGetThumbnail (bad return value)
   * IS3RotateImage docs
   * IS3RotateOneBitImage docs
   + IS3DrawTextOnRGBA
   + IS3DrawTextOnRGBA2

   3.0.0.18 b
   fix to IS3ColorReplaceRGB

   3.0.0.19 b
   fixed header file guard for _ISIOManagers.h

   3.0.0.20 b
   re-enabled JPEG-in-TIFF (old and new) support

   3.0.0.20 b
   re-enabled JPEG-in-TIFF (old and new) support

   3.0.0.21 b
   fix to v2.2 conversion header

   3.0.0.22 b
   fix to count 8-bit colors

   3.0.0.23 b
   returning NULL when file not found on file source/dest open
   tweaked test for TGA in guess file type

   3.0.0.24
   first release

   3.0.0.25
   changed IS3DrawRGBCrop to draw images that are smaller than the crop rect
   modified IS22To30 header for cropimage
   changed GetLastError handling in CISIO

   3.0.1.0
   + IS3GetJPGMCUSize
   removed IS22To30.h from ISource.h header
   fixed  _IS3ApplyConvolutionFilterToImage call in DLL header

   3.0.1.1
   fix to TGA RLE read
   curve options in IS3AdjustBrightnessContrast

   3.0.1.2
   back to C streams for file I/O because the Win32 API fn's are too slow (12x!)

   3.0.2.0
   some filter resize optimizations
   + IS3GetExtHook

   3.0.3.0
   deinterlace
   more filter resize optimizations
   made it an error to attempt to allocate zero bytes for image output
   j2k file type test fix

   3.0.3.1
   fix to IS3HSVToRGB

   3.0.4.0
   IS3DIBToRGBA

   3.0.4.1
   one bit speed ups ( ">> 3" vs. "/ 8" , "& 0x07" vs. "% 8") = 30% faster
   TGA DIB read fix
   IS3MedianCut rename

   3.0.4.2
   IS3DIBToRGBA alpha channel fix

   3.0.4.3
   BMP DIB read fix (BMFH offset issue)
   smooth text opacity fix

   3.0.5.0
   added _IS3GetPCDIndexImageCount (mistakenly left out of the DLL)
   fixed comments for IS3ReadBMP (DIB read flag is bit "1" not "0")

   3.0.6.0
   ISDeinterlaceCollapse
   fix to ISDeinterlace/merge

   3.0.6.1
   added 1-bit to IS3GetBorder
   reversed sense of Retain Odd in deinterlace functions

   3.0.6.2
   removed 3 byte-per-pixel restriciton in deinterlace fn's

   3.0.6.3
   WBMP read fix when not initialized

   3.0.6.4
   re-reversed sense of Retain Odd in deinterlace functions
   added new mode to IS3CopyJPGWithNewHeaders

   3.0.6.5
   error value fix in text drawing functions (should never happen anyway, just plugging holes)

   3.0.7.0
   + IS3SetTIFFOutputStripSize
   fixed return code from IS3GetICCProfile with TIFFs (returned a false FALSE)

   3.0.8.0
   + _IS3Decimate1BitImage
   + _IS3GetOneBitHistogram

   3.0.8.1
   fixed PSD palette issue when reading 1-bit images (force 255,0)
   added flag to TIFF output to switch to MINISBLACK

   3.0.8.2
   fix to BMP->DIB reading

   3.0.8.3
   fix to BMP-> DIB reading when biClrUsed = 0
   fix to RLE-DIB translation
   added 1 on 1, 8 on 8 and <8 on 8 support to IS3OverlayDIBOnDIB
   using LibPNG v1.2.5 (fixes reported buffer overflow)

   3.0.8.4
   fix to PNG->DIB read with 1-bit images
   fix to horizontal flip when rowStride != width * bpp

   3.0.8.5
   maker note parsing

   3.0.8.6
   another BMP->DIB tweak

   3.0.8.7
   rebuild (for vc7)

   3.0.8.8
   fix to IS3DrawLine when not smooth

   3.0.8.9   3/13/03
   fixes to PCX->DIB reading
   fix to DIB->RGB with RLE
   set caller's w,h on PSD->DIB read

   3.0.8.10  3/15/03
   tweak to PNG->DIB reading

   3.0.8.11  3/25/03
   fix to EXIF from TIFF parsing

   3.0.8.12  3/29/03
   tweak to bi-lin resizing to offset source pixels on reduction. helps edges
   fixed BMP 16 read

   3.0.8.13  4/5/03
   fix EXIF maker note single tag read

   3.0.8.14  4/20/03
   added FlashPix to GuessFileType
   officially added JPEG 2000 to GuessFileType

   3.0.8.15
   fixed realloc issue (draw text, TIFF read, etc.)

   3.0.8.16
   added 8-bit grayscale support to IS3GetColorMatchMaskFromImage

   3.0.9.0
   + IS3GetJPGDimsEx

   3.0.9.1
   gif pal read fix

   3.0.10.0
   BMP DPI in dots / meter
   gif bitdepth read fix
   + IS3GetJPGDimsEx2

   3.0.10.1  5/8/03
   enabled 4-bit PNG ->DIB read
   fixed un-init'ed var in TIFF orientation

   3.0.10.2
   allowed in-place modification for IS3ReorderChannels
   GIF dim tweak

   3.0.10.3
   16-bit PNG -> DIB read tweak
   RGBA quant tweak for DIBs

   3.0.10.4
   JPG ICC writing fix for profiles > 64K

   3.0.10.5
   BMP->DIB read fix (total rewrite)... again
   fix to flood fill, mode 0 with BGR order (infinite loop)

   3.0.10.6
   another BMP -> DIB read fix
   IS3StretchDraw1Bit fix
   WBMP -> DIB fix
   shift channels fix

   3.0.10.7  5/23/03
   added support for 1-bit uncompressed PSD
   fixed NAN issue in poly warp

   3.0.11.0
   optimized simple resize
   + IS3Overlay1BitMasked
   fix to rotate (incorrect clip on right, bottom edges)
   enabled 16-bit gray to 8-bit gray TIFF reads
   enabled uncompressed 16-bit gray to 8-bit gray PSD reads

   3.0.12.0  6/4/03
   + IS3FindDeskewAngleOneBit
   callback optimization
   fix to fast shears with non-standard rowstride

   3.0.13.0
   tweak to BGR color handling for 8-bit images in IS3ColorReplaceImage 
   disabled memory callbacks for IS3ReadImageToRGB
   + IS3ReadImageToRGBA
   tweak to IS3GetTIFFTag for text strings

   3.0.14.0
   TIFF tag write tweak (VarInit)
   Hough transform optimizations
   + IS3ClearTIFFOutputTags

   3.0.14.1
   GIF changes

   3.0.15.0
   + IS3SetTIFFOutputIPTCDataBlock

   3.0.15.1
   fix for reading PCD sub-image 5

   3.0.15.2
   new deinterlace mode

   3.0.15.3
   fix to 8-bit TGA output

   3.0.16.0
   + _IS3EmbossRGBEx

   3.0.16.1
   tiff predictor enabled

   3.0.16.2
   skip app1, app13 in copy jpg with new...

   3.0.17.0  8/10/03
   optimized quick-rotate 1-bit
   + IS3Decimate1BitTo8Gray

   3.0.17.1
   fix for IPTC with zero length strings

   3.0.18.0
   + IS3AutoBrightness

   3.0.18.1
   IPTC read mod, to handle APP13 with non-IPTC data at the start

   3.0.18.2
   fix to rotate 1-bit in cleared mode for 180,270 deg

   3.0.19.0
   + IS3Get8BitPaletteFromRGBEx

   3.0.19.1
   fix to single bit TIFF read orientation correction issue

   3.0.19.2
   fix to IS3Create8BitMaskFromColor

   3.0.19.3 9/19/03
   tweak to IPTC parsing

   3.0.20.0
   + IS3SetTIFFJPGQuality
   + IS3ExportAndReplaceIPTCData
   + IS3ExaminePhotoshopResources
   EXIF : nikon maker note v3 parsing (attempt - no documentation)

   3.0.20.1
   more error checking in IPTC code

   3.0.21.0
   read PSD IPTC
   + IS3SetPSDOutputIPTCDataBlock
   + IS3IPTCCopyTagsFromInputToOutput

   3.0.21.1
   more IPTC end of buffer checks

   3.0.21.2
   disabled predictor for 1-bit TIFF output

   3.0.21.3
   removed TIFF debug strings in release builds
   IS3Decimate* speedups

   3.0.21.4
   fp rounding error fix in Decimate* fns

   3.0.21.5
   fp rounding error fix in Decimate* fns

   3.0.21.6
   optimized certain modes in IS3OverlayImage
   optimized IS3ApplyConvolutionFilterToImage

   3.0.21.7
   added check to validate reasonable dimensions in WBMP read

   3.0.22.0
   + IS3SetTIFFOrientation
   added flag for TIFF predictor
   fixed TIFF predictor modification of source data
   24-bit TIFF read to DIB optimization
   added TIFF compression modes 8 (Deflate, Adobe), 32771 (CCITT RLE/W), 32909 (Pixar 11 / ZIP)

   3.0.23.0
   + _IS3GetPNGDimsEx
   + _IS3PNGSetTransparencyIndex
   resize filter dimension small limits (prevents crash on small dimensions: < 4)

   3.0.23.1
   fix to IS3ReadPNGDims (broke in last build)
   defensive bounds checking in EXIF parsing - to deal with busted offsets created by EXIF editors

   3.0.23.2
   re-did DLL configuration setup
   corrected PNG transparency index comments and code

   3.0.23.3 1/3/04
   read gray PNG as 8-bit DIB 
   added flag to read and write JPG as YUV/YCbCr

   3.0.23.4 1/9/04
   PNG->DIB alpha fix

   3.0.23.5
   change to HSL -> RGB calc for monochromes, affects :
      IS3HSLToRGB
      IS3AdjustBrightnessContrast (undocumented modes)
      IS3BrightnessHistogramStretchImageInHSL

   3.0.23.6
   fix for IS3Draw8BitCrop

   3.0.23.7
   increased precision in EXIF RAT/SRAT type tags when read from tiff

   3.0.24.0
   + IS3SetTIFFReadUnknown4thChannelAsAlpha

   3.0.24.1
   tweaks around IS3SetTIFFReadUnknown4thChannelAsAlpha

   3.0.24.2
   new mode in IS3DrawTextOnRGBA
   fixed _IS3DrawTextOnRGBA
   fixed problem with ellipse drawing code with large ellipses (overflow)

   3.0.24.3
   fix possible buffer overrun in PSD read

   3.0.25.0
   + _IS3ZDeflateBuffer
    + _IS3ZInflateBuffer

   3.0.25.1
   compression options for _IS3ZDeflateBuffer
   more 16-bit PSD read support

   3.0.25.2
   fix for PSD 16-bit CMYK to DIB reading

   3.0.25.3
   change to PNG output (incorrect setting of RGB(0,0,0) as trans color)
   tighter paramter checking in IS3AdjustBrightnessContrast

   3.0.25.4
   rotate optimization

   3.0.26.0
   TIFF annotations

   3.0.27.0
   option to read raw EXIF UserComment info

   3.0.28.0 4/11/04
   + IS3GetTIFFBinaryTag
   + IS3SetTIFFBinaryTag
   no fail if last ITPC string exceeds buffer size
   experimental 8-bit tiled TIFF reading code

   3.0.28.1
   override TIFF strip size for JPEG
   omit JPEG tables in JPEG-in-TIFF

   3.0.28.3
   IPTC read mem leak fix

   3.0.28.4
   IPTC read mem leak fix

   3.0.28.5
   IS3Decimate1BitTo8Gray optimizations for 1/32, 1/16, etc.
   fix to IS3RotateImage with bi-cubic mode - was clipping left and bottom
   fix to IS3OverlayRGBOnRGBA

   3.0.28.6
   polywarp clipping fix
   bi-lin rotate clipping fix
   fix to IS3GetTIFFBinaryTag 
   started mmx work

   3.0.28.7
   added alpha support to IS3DrawEllipseOnImage

   3.0.29.0
   enabled GIF:
      + IS3ReadGIFTo8Bit
      + IS3ReadMultiFrameGIFTo8BitEx
      + IS3ClearGIFFrames
      + IS3GetGIFFrameCount
      + IS3GetGIFFrameEx
      + IS3Write8BitToGIF
      + IS3InitWriteMultiframedGIF
      + IS3AddGIFFrame
      + IS3DestroyMultiGIF

   PCD -> DIB read fix for alloc CBs
   added support for reading 1-bit tiled TIFFs
   1-bit overlay speedup


   3.0.30.0
   added IS3GetISDIBSize, IS3ClearTIFFOutputTags to DLL export
       + _IS3SimpleResampleImage16
       + _IS3ResizeImage16
       + _IS3ResizeImageBicubic16
       + _IS3DecimateImage16
       + _IS3OverlayImage16
       + _IS3HistogramEqualizeImage16
       + _IS3HistogramStretchImage16
       + _IS3GetBrightnessHistogram16
       + _IS3GetImageChannelHistograms16
       + _IS3SwapByteOrderIn16bpcImage
       + _IS3Convert8bpcTo16bpc
       + _IS3Convert16bpcTo8bpc
       + _IS3ApplyConvolutionFilterToImage16

   3.0.30.1
      fix to GIF frame delay reading
      fix to 1-bit tiled TIFF -> DIB reading
      added callbacks in tiled TIFF and 1-bit TIFF reading

   3.0.30.2
      flag on decimate 1->8 to allow for photo-negative images
      upgrade to LibPNG 1.2.5

   3.0.31.0
      optimizations to alpha overlay functions
      IS3SetDebugMessageLevel

   3.0.31.1
      flag to IS3GetColorMatchMaskFromImage to use 0,255 instead of 0,1
      changed IS3OpenFileDest to create the file if it doesn't already exist, when opening with append=TRUE

   3.0.32.0
      added PNG 16-bit gray reading
      read PSD-CMYK to CMYK
      + _IS3GetGIFDimsEx
      + _IS3GetGIFFrameEx2


    3.0.33.0
      + _IS3RGBToBGR16
      + _IS3RGBAToBGRA16
      + _IS3CombineRGBAndAToRGBA16
      + _IS3ApplyLUTsToImage16
      + _IS3SplitImage16
      + _IS3CombineImageChannels16
      + _IS3SplitRGBAToRGBPlusA16
      + _IS3ImageToGrayScale16
      fix to IS3DrawRGBCrop (incorrect behavior when one dim exceeded source size)

   3.0.34.0
      + _IS3Overlay1BitEx
      added flag in JPG output to skip JFIF header
      write 4-bit TIFF

   3.0.35.0
      + _IS3ResizeDIB
      fix to TGB->DIB reading for RGB16
      generic PNG reading fix for 2 bit PNG

  3.0.36.0
      + _IS3UnsharpMaskImage16
      + _IS3GaussianBlurImage16
      get TIFFTAG_EXTRASAMPLES
      PSD reading tweaks (1->8 fix)

   3.0.36.1

      JPG rewind after read flag
      JPG BGR + DWORD-aligned flag

   3.0.36.2
      TIFF EXIF crash fix

   3.0.37.0
      IS3AdjustBrightnessContrast tweak - to change low-range behavior for brightness      
      + IS3GetPSDThumbnail

   3.0.37.1   
      libtiff 3.6.1
      fixed IS3OpenHandleDest
      fixed crash bug in IS3GetPSDThumbnail

   3.0.38.0
      relaxed LibTiff's error handling
      IS3SaturationHistogramStretchImage
      added test for out-of-buffer in raw EXIF parsing
      lossless JPG xform callbacks

   3.0.39.0
   relaxed EXIF parsing failure tolerance
   fixed JPEG-in-TIFF reading (broken in libtiff 3.6.1)
   fixed TIFF binary tag len problem
   + IS3HistogramStretchImageEx
   + IS3HistogramStretchImage16Ex
   + IS3BrightnessHistogramStretchImageEx
   + IS3SaturationHistogramStretchImageEx
   + IS3BrightnessHistogramStretchImageInHSLEx


   3.0.40.0

   obsoleted IS3SetPSDOutputIPTCDataBlock
   obsoleted IS3SetTIFFOutputIPTCDataBlock
   obsoleted IS3IPTCExport
   obsoleted IS3ExportAndReplaceIPTCData

   + IS3IPTCExportEx
   + IS3IPTCInitializeFromByteArray
   + IS3SetPSDOutputResourceBlock

   + IS3InitializePSDResourceManager
   + IS3DestroyPSDResourceManager
   + IS3FillPSDResourceManagerFromSource
   + IS3FillPSDResourceManagerFromByteArray
   + IS3GetPSDResourceList
   + IS3GetPSDResource
   + IS3RemovePSDResource
   + IS3AddPSDResource
   + IS3CopyPSDResourceManager
   + IS3ExportPSDResourceBlock
   
   3.0.40.1
   fix to IS3IPTCInitialize

   3.0.41.0
   using tif_fax3.c from 3.7.0
   use "Unknown" for unknown IPTC tags when translating
   + IS3OpenNullDest
   + IS3CopyPSDWithNewResources
   + IS3SharpenImage16
   + IS3BlurImage16
   + IS3MedianFilterImage16

   3.0.42.0
   + IS3FillSolidRectSingleChannel
   fixed _IS3ApplyConvolutionFilterToImage16 bug (was clipping values > 255)
   fix to paletted TIFF reading

   3.0.42.1
   fixed zlibDeflate headers

   3.0.43.0
   + IS3WriteTIFFEx
   + IS3SetTIFFOutputTileSize
   + IS3ReadTIFFTileOrStrip
   + IS3Resize8BitMasked
   fixed threading problem when reading multiple TIFFs 

   using LibTiff pre-3.7.1 CVS

   3.0.44.0
   more tolerance for TIFF read errors
   fix to IS3WriteTiffMultiViaCB, when appending to existing file
   added updated TIFF-OJPEG reading code
   fixed IS3IPTCInitializeFromByteArray header comments
   fixed IS3WriteTiffMultiViaCB header comments
   new mode in IS3CopyJPGWithNewMarkers

   + IS3EXIFInitializeFromByteArray
   + IS3EXIFGetTagPos
   + IS3GetJPGOutputMarkerCount
   + IS3SetJPGOutputMarker
   + IS3GetJPGOutputMarker
   + IS3SwapLong
   + IS3SwapShort

   3.0.44.1
   more tolerance for TIFF read errors

   3.0.44.2
   fixed non-working callback cancel in 1 and 8-bit tiff reads
   fixed headers for IS3TIFFWrite (swapped bits 6 and 7 in uFlags)

   3.0.45.0
   _IS3QuickRotateImageInPlace16
   _IS3QuickRotateImage16
   _IS3HorizontalFlipImage16

   16-bit gray TIFF I/O
   removed TIFFTAG_XMP_DATA from custom tag list. LibTiff handles this one now.

   3.0.46.0
   + IS3CreateTIFFTileStripReader
   + IS3TIFFReadTileOrStripWithReader
   + IS3DestroyTIFFTileReader
   fix 1-bit tiff reading vertical flip
   1-bit tiff orientation ignore fix
   read 16-bit TIFF tiles/strips
   vflip + DWORD align for 16-bit TIFF reads
   IPTC fix when first string is not in section 2
   GIF read fix for small interlaced images
   fixed image overlay fill - was starting on second overlay line

   3.0.46.1
   added color inverse for 1-bit tiff tile/strip
   made EXIF maker note parse non-fatal
   relaxed error checking in tiff tile/strip reading
   fixed RGB/RGBA strip reading - was erroring on any but first strip

   3.0.46.2
   fixed 1-bit TIFF tile/strip bug when photometric=1
   tightened TIFF tile coordinate validation code
   fixed GIF disposal method documentation
   copy JPEG_APP0 option in IS3CopyJPGWithNewMarkers
   LibPNG 1.2.8

   3.0.46.3
   fixed RGB/RGBA strip reading - was only reading first strip
   using lrint/round in resizing/rotating code. correct ugly results based on floating point errors
   fixed HSL->RGB. output images were incorrect

   3.0.46.4
   fixed buffer overrun in IS3ResizeImage

   3.0.47.0
   added support for "core bitmap" BMPs
   using trial version system

   3.0.48.0
   fix to IS3FillTransparentRectOnImage for bpp=4
   fix to IS3ResizeFilterImage - far better results
   fix to IS3InitReadJPGLines for bpp=8
   planar YCC TIFF handling
   + IS3SetTIFF4thChannelAlphaHandlingMode

  3.0.48.1
  Duff for overlay
  use monochrome DC for 1-bit HBITMAP creation (to force 1-bit HBITMAP)

  3.0.49.0
  _IS3GetGIFDimsEx2
  1-bit overlay optimizations

  3.0.50.0
  + _IS3IsMMXSupported
  + _IS3RGBToHSVSingle
  + _IS3HSVToRGBSingle
  + _IS3RGBToHSLSingle
  + _IS3HSLToRGBSingle

  div by zero check in RGB->HSL conversion
  change to R,G,B in 0..1 range for internal RGB<->HSL usage
  16-bit PSD read fix
  fixed mem leak in IS3ReadImageToRGBA for formats that don't support RGBA reading natively
  MMX Overlay modes

  3.0.50.1
  added flag to suppress PNG timestamp
  corrected IS3DrawEllipseOnImage - was defaulting to BGR
  incorrect dimension checking in IS3Decimate1BitTo8Gray. would fail for certain reductions

  3.0.50.2
  fixed incorrect dims from IS3ReadImageToRGBA for formats that don't support RGBA reading natively

  3.0.51.0
  + IS3RGBTo1Bit
  optimized IS3Pack8BitBuffer and IS3UnpackBufferTo8Bit for 1bpp. this affects many internal operations.

   3.0.52.0    6/14/05        
   + _IS3FinishIconWrite
   + _IS3AddIcon
   + _IS3ReadIconFrames
   + _IS3GetIconFrame
   + _IS3ClearIcons
  
   3.0.53.0  7/23/05

   + _IS3CreateTIFFReader_TR
   + _IS3DestroyTIFFReader_TR
   + _IS3ReadTIFF_TR
   + _IS3ReadTIFFTileOrStrip_TR
   + _IS3GetTIFFPageCount_TR
   + _IS3GetTIFFTag_TR
   + _IS3SetTIFFPage_TR
   + _IS3SetTIFFTag_TW
   + _IS3WriteDirectory_TW
   + _IS3CreateTIFFWriter_TW
   + _IS3InitializeTIFFWriter_TW
   + _IS3WriteTIFF_TW
   + _IS3DestroyTIFFWriter_TW
   + _IS3ResizeImageMasked
   + _IS3ImageToGrayScaleWeighted
   + _IS3ImageToGrayScaleWeighted16
   + _IS3ImageToGrayScale8BitWeighted

   optimized 1-bit crop for byte-aligned crops
   obsoleted IS3ResizeRGBMasked
   read TIFFTAG_RICHTIFFIPTC as either UNDEFINED or LONG
   fixed write TIFFTAG_RICHTIFFIPTC bug (wasn't writing it)
   fixed TIFF 24/32-bit tile read problem for bottom tiles when image data is flipped - was blanking rows it shouldn't
   fixed possible PNG comment text problem when writing PNG
   new zLib

   3.0.54.0
   TIFF read fix for 8-bit, tiled, read to DIB
   1-bit rotate optimizations
   + IS3ShearOneBitX
   + IS3ShearOneBitY
   + IS3FindDeskewAngleOneBitSparse

   3.0.55.0
   1-bit crop fix
   + IS3WritePCXEx
   + IS3GetPCXDimsEx

   3.0.56.0    8/28/05
   + _IS3DrawSmoothTextOnRGBA
   + _IS3DrawSmoothTextOnRGBA2
   IS3FindDeskewAngleOneBitSparse fix

   3.0.57.0
   + IS3IPTCWriteAddTagData

   3.0.58.0
   + IS3SetDefaultMetafileInfo
   fixed bad behavior for boundary percentages in IS3HistogramStretchImage 

--------------------------------------------------------------------------

   start 4.0.0.0      10/5/05
   build DLL and static lib diretly from same source (no wrapper DLL)
   consolidation of many functions to eliminate redundancy (*Ex/*Ex2, merging of 8/16bpc functions, etc)
   consolidation of resizing functions
   rowstride/vflip/bgr to image writing
   rowstrides to drawing functions (to allow instant crop+draw)
   removal of drawCropped functions
   EXIF writing
   14 new overlay modes + opacity on all modes
   GIF animation rendering
   progressive JPEG callback reading
   floating point DPI values
   PNM i/o
   moved JPG marker and PNG text reading to separate functions (no longer automatic on file read)
   error history
   advanced gray to mono thresholding
   get polygon fill scanlines
   1-bit histogram optimization
   morpho optimization
   gaussian blur optimization
   blendSolidColor
   LibTiff 3.7.4
   16-bit DIB creation
   PCX 4-bit to DIB read fix
   fix to JPG writing App0 skip

   4.0.0.1 b  12/20/05
   _IS40_EXIFGetTagData
   1-bit quick rotation optimization

   4.0.0.2 b  1/5/06
   GeoTIFF tag reading

   4.0.0.3 b   1/14/06
   deskew foregroun/background inverse flag

   4.0.0.4
   release     1/21/06

   4.0.0.5
   fix to BMP->DIB read - give real value for biSizeImage if DIB from file has a zero
   make EXIF parser tolerant of broken IFDs
   filter resize optimizations
   disabled beta keys

   4.0.0.6
   copy EXIF thumbnail in IS40_EXIFCopyTagsToWriter

   4.0.0.7
   fix to out-of-bounds check in EXIF writing. was throwing exceptions in valid situations

   4.0.0.8 
   VS05 changes

   4.0.0.9
   Gaussian Blur fix

   4.0.1.0
   + IS40_GetPSDDimsEx

   fix to Gaussian Blur when kernel > image. possible crash bug
   fixed bug in colormapped to DIB conversion for inputs where input rowstride != widthPix
   fixed bug in 1bit to DIB conversion for inputs where input rowstride != RS1BIT(widthPix)
   fixed IS40_WriteTIFF_TW - was ignoring uFlags and returning incorrect # bytes written
   fix to FillRect - was incorrectly filling full rowStride bytes instead of (w * bpp) bytes when r=g=b
   fix to BMP writing with BGR output - was writing incorrect data.
   fix to IS40_PolygonIsConvex - was returning negated result
   16-bit options in IS40_ImageToGrayScale8Bit and IS40_ImageToGrayScale8BitWeighted
   added flags to read TIFF, GIF, TGA, PCX, TLA, WBMP, PNG as BGR & DWORD-aligned
   fixed some image processing function description that spec'd rowStride as 'bytes per row' when it should've been 'components per row'
   fixed some file writing function descriptions that had swapped the BGR and vflip flags

  4.0.1.1      2/5/06
  optimization to global error recording (in response to report of slow SARAW reading - was related to repeated calls to IS40_read, which calls setGlobalError, etc)
  added flag to read BMP as BGR & DWORD-aligned

  4.0.1.2
  fix headers for IS40_SetLastError, IS40_AddGIFFrame - missing params
  fixed DIB->RGB conversion (was swapping R/B, due to changes in 4.0.1.0) - affects many different functions including DCtoRGB, DIBToRGB, RGBA drawing, etc

  4.0.1.3
  added TGA extension and footer to TGA writes, attempting to satisfy the GIMP's reading of ImgSource's RGBA TGAs

  4.0.1.4
  added DWORD-rowstrided support for 1 and 8-bit BMP reading

  4.0.1.5
  PSD resource reader was failing
  tweak to TGA rowStride writing

  4.0.1.6
  fix to tiled TIFF writing via IS40_CreateTIFFWriter_TW

  4.0.1.7
  fix to polygonFill/Scan in VS05 when image is too short to contain any scanlines. vector.reserve(<0) fails
  in VS05, but not in all the other versions.
  fix to Big Red X drawing for 8-bit images
  fix to EXIF reading when order = motorola & type = SHORT and data is in the offset space.

  4.0.1.8
  added flag for tag data type in IS40_EXIFGetTagList
  fix to PBM writing
  fix to IS40_WritePNM header

  4.0.2.0
  1-bit bi-in resize speedup
  packbuffer speedup for 1-bit
  use MMX/SSE always, if the processor supports it
  + IS40_DisableMMXFunctions

  4.0.2.1
  1-bit bi-lin resize speedup enabled
  change to generic file read, to support CMYK PSDs

  4.0.3.0
  IS40_SetColorFrom1BitMask
  IS40_Create1BitMaskFromColor

   4.0.4.0

  more BMP reading tolerance, for bad pixoff calculations
  fix to IS40_ColorReplaceImage with bit 2 (mod alpha) - exception
  added new mode to IS40_ColorReplaceImage
  + IS40_ColorReplaceImageRangeSpecified

  4.0.5.0
  fixed bug in GetGIFDims where incorrect palette would be returned when the file has no global color map
  + _IS40_HSVToRGB_u8s
  + _IS40_RGBToHSV_Bytes

  4.0.5.1
  PNM I/O fix

  4.0.6.0
  + IS40_FindFirstUnusedRGBColor
  overlay 1-bit trans fix

  4.0.7.0 
  fixed issue with DLL build error
  + IS40_StretchDrawDIBCropped
  fixed bug in GetGIFDims where incorrect palette would be returned when a GIF87a file has no global color map

  4.0.8.0
  + _IS40_ReplaceJPGOutputMarker

  4.0.8.1
  optimized IS40_SharpenImage and IS40_BlurImage

  4.0.8.2
  fix to IS40_DrawTextOnRGB*, when rowStride != w * 3

  --

  4.0.8.3
  fix to gaussian blur / unsharp. crash in x64 related to signed/unsigned multiplication in kernel element lookup
  other x64-related changes

  4.0.8.4
  flag in IS40_GetGIFDims to choose screen/local dimensions

  4.0.8.5 10/24/06
  fix to IS40_GetGIFDims . was tripping over local/global palette test when checking dims

   4.0.8.6 11/2/06
   shipping with x64 project configs for vs05
   fix to ICC profile writing with JPG - signed/unsigned confusion in chunk size

   4.0.8.7
   fix to IS40_ResizeImage1To8Gray, incorrect use of special-case optimizations

   4.0.8.8
   fix to IS40_ResizeImage* modes 0-13 . potential array overflow for certain resize ratios

   4.0.8.9
   fix to 8-bit TIFF-to-DIB reading - incorrect rowStride handling

   4.0.9.0
   +IS40_AlphaBlendRGBAToRGBA2
   +IS40_AlphaBlendRGBA2
   +IS40_AlphaBlendRGB2

   4.0.9.1
   fixed possible crash bug in 1-bit crop, for byte-aligned case

   4.0.9.2
     minor header tweaking, to make it easier for C/C++ users to select between DLL
   and static lib symbols.

   updated copyright notices

   4.0.9.3
   fix to unpack 1 to 8-bit. possible read overrun on final byte of the buffer

   4.0.9.4
   fix to EXIF write Rational/Signed Rational - corrupt data with more than one value

   4.0.9.5
   made the EXIF parser recognize MakerNote as a normal tag. now you can get it with IS40_EXIFGetTagData.
   this also allows MN data to copy over to the output when using IS40_EXIFCopyTagsToWriter
   added code to truncate long tag data strings in IS40_EXIFGetTagList
   added support for Casio MakerNote when make is "CASIO COMPUTER CO.,LTD "
   added more MakerNote tag descriptions for all supported cameras
   zero-padded tag IDs in IS40_EXIFGetTagList
   reworked storage of generic IS40_EXIFTYPE_UNDEFINED tags (wasn't storing them properly, before)

   4.0.9.6
   removed IFD1 requirement for EXIF writing
   fixed error code setting from IS40_EXIFWriteTags (was setting to IS_ERR_OK, always)

   4.0.9.7
   fixed return value code from IS40_EXIFWriteTags (was always true, even on error)

    4.0.9.8

   4.0.9.9
   fix to TIFF EXIF reading of rational tags. VC optimizations were wrecking the demoninators
   rework of I/O system to boost performance for hooked add-in libraries

    4.0.9.10
    fix to JPG EXIF reading, User Comment when len <= 4 - possible crash

  4.0.9.11
  improved handling for Olympus and Nikon EXIF maker note - more robust handling.
  fix to ASCII Usernote EXIF reading - dropping the tag in some cases.
  fix to 1-to-8-bit TIFF strip reading. was only showing first 1/8th of the input image.

  4.0.9.12
  fixed return code on IS40_EXIFGet* - was returning TRUE in some failure cases

  4.0.9.13
  fix in EXIF maker note tag fetching, to handle cases where datalen <= 4

  4.0.9.14
  minor changes to accomodate x64 compilation

  4.0.9.15
  added write check in IsValidManager
  added C friendly definitions for 'extern "C"' in ISTypes.h, to keep C happy.
  fixed a bug (which we caused) in libTiff's RGBA interface, when reading images with palettes

  4.0.9.16
  fix in GIF reading: possible crash when there's not enough memory to allocate the output image

  4.0.10.0 9/21/07
    + IS40_EXIFGetTagListData

  4.0.11.0
   + IS40_GetStretchedHistogramLUT
    + IS40_GetGrayscaleTo1BitThreshold
    fix possible crash bug in IS40_GrayscaleTo1Bit

  4.0.11.1
  fixed error in multi-frame GIF writing

  4.0.11.2
  fixed error in logical operation overlays where src and dest start on DWORD boundaries and the number of bytes >=4 and <= 7

    4.0.12.0
    libPng 1.2.22
    new modes in IS40_GrayscaleTo1Bit, IS40_GetGrayscaleTo1BitThreshold
    + IS40_PNGSetCompressionOptions
    + IS40_DeletePNGText

  4.0.13.0
  changes to text output to prevent clipping of over/underhang when drawing italic text
  added _IS40_EXIFSetThumbnailInWriter, _IS40_OverlayImageColor, _IS40_SetJPGProgressiveReadCallback to DLL export

  4.0.14.0
  +IS40_ShiftImageSubPixel
  new anti-aliased text modes in IS40_DrawTextOnRGBA, IS40_DrawTextOnRGB
  optimizations in text rendering

  4.0.15.0
  + IS40_ReorderChannels16
  fixed text rendering horizontal alignment issues

  4.0.15.1        12/15/07
  fixed smooth text (non-)clipping issues

  4.0.15.2        12/22/07
  fix to ReorderChannels16 - mismatch between function definition and declaration resulting in unresolved externals on linking

  4.0.15.3        1/6/08
  reset error code in EXIF writer object, to prevent an error on one call from persisting through subsequent calls

  4.0.15.4
  added new clipping mode to DrawSmoothText functions
  fixed return value in IS40_EXIFGetTagData - was returning FALSE all the time

  4.0.15.5        1/27/08
  minor changes for VS08 builds

  4.0.15.6        2/6/08
  fix for DT_WORD_ELLIPSES in smoothtext new clipping mode

  4.0.15.7        2/25/08
  change to overlay modes (soft dodge, soft burn, PS overlay, hard light) to use 128 as 255/2 instead of 127. this gives better results.
  skipped DumpTagVector on EXIF read if debug level not set to Verbose. for performance reasons...

  4.0.15.8        2/27/08
    fix to IS40_EXIFGetTagPos - was returning TRUE when it could not find the tag
    fixed uFlags notes for IS40_InitializeTIFFWriter_TW.

  4.0.15.9        4/8/08
  fixed bug with mode 1 + BGR in FloodFill

  4.0.15.10        4/28/08
  fixed bug with WriteMultiTIFFViaCallback - was failing to set strip v tile on the tiff writer

  4.0.16.0        5/17/08
  + IS40_PolygonFillImage_16

  4.0.17.0        5/19/08
    grayscale and anti-aliased mode in IS40_PolygonFillImage

  4.0.17.1        7.2.08
  added better error handling in TIFF-EXIF reading. was crashing on certain malformed TIFFs

  4.0.18.0        7.16.8
  + IS40_ResizeDouble

  4.0.19.0
  added 16bpc in IS40_ApplyMatrixToImage
    + _IS40_RotateImageDouble
    + _IS40_QuickRotateImageDouble
    + _IS40_QuickRotateImageInPlaceDouble
    + _IS40_GetImageChannelHistogramsDouble
    + _IS40_ApplyMatrixToImageDouble

  4.0.20.0
   + _IS40_OverlayImageDoubleEx

  4.0.20.1
  added more bounds checking in JPG-EXIF reading. possible crash with invalid tag offsets (esp Maker Notes)

    4.0.20.2
    reading IS40_EXIFTYPE_UNDEFINED to byte array for tags that don't have specific rules (ComponentsConfiguration (0x9101), for example)

  4.0.21.0
    + _IS40_OpenFileSourceW
    + _IS40_OpenFileDestW
    change in IS40_OpenFileWrite in "append" mode - open output file for writing, after creating. was opening the file for _reading_. (?)

  4.0.21.1
  change to EXIF reading to prevent modification of EXIF data buffers

  4.0.22.0
  + IS40_AdjustBrightnessContrast2
  change to IS40_ResizeImageMasked to behave more like the old version. also, fixed a bug in the handling of alpha

  4.0.22.1
  fix to TIFF reading 8-bit grayscale + alpha -> RGBA was crashing in LibTiff

  4.0.22.2
  fix to memory dest writing - would fail when trying to write the last byte of the buffer

  4.0.23.0                    4/5/09
  + IS40_MergeRGBA

  4.0.23.1
  fix to IS40_ResizeImage8

  4.0.23.2              4/22/09
  added support for reading PSD/CMYKA to CMYK
  added support for reading ICC profile from PSD

  4.0.23.3                    4/23/09
  added support for PSD/CMYK + unlmited alpha channels (discarding the alphas)

  4.0.23.4                    5/7/09
  change to histogram stretch operations, to fix bug when hist[0] % > high %    . was setting all to 0

  4.0.23.5
  now able to read PNG icons

  4.0.24.0
  many fixes to ICO writing
  added PNG .ICO writing
  + IS40_OpenDynamicMemoryDest
  + IS40_AddIconEx

  4.0.24.1
  fix to BMP reading - to correctly position pixel start according to bmfh.bfPixOff

  4.0.24.2
  fix to IS40_GetPNGDims. docs spec'd that caller should pass NULL for puTransIndex. but the code would return 
  a bad param error if it saw a NULL there. 

  4.0.24.3
  fix to IS40_OpenFileDestW in append mode - was truncating the output file instead of appending.

  4.0.24.4
  IS40_OverlayRGBTrans can now accept RGBA images (ignores alpha)
  check in IS40_SharpenImage and IS40_BlurImage to bail if W or H < 3
  new modes in IS40_MergeRGBA and IS40_AlphaBlendColor

  4.0.24.5            9.15.09
  libTiff 2.9.1

  4.0.25.0
  flag to set alpha directly in IS40_FillTransparentRectOnImage
  removed broken scheme to read TIFF IPTC data when saved with the incorrect TIFF_UNDEFINED tag
  new flag on IS40_OverlayRGBOnRGBA (no mod alpha)
  new flag on IS40_AlphaBlendColor (set alpha to mask value. set RGB to mask color, not blended)
  IIR Gaussian
  libPng 1.2.40

  4.0.25.1
  16-bpc TIFF output

  4.0.25.2
  forbid Pixar compression on 48/64 bpp TIFF 
  read 48, 64bpp TIFFs

  4.0.26.0
  +IS40_ImageToHBITMAP
  +IS40_ReadCALS
  +IS40_GetCALSDims

  4.0.26.1
  fix to possible crash in IS40_GaussianBlur (IIR method). affects everything that uses a Gaussian blur (unsharp, ISE's shadow, glows, gauzy, scribble, fingerprint, watercolor, contrast mask)  

--------------------------------------------------------------------------

  5.0 started 1/20/10
  new flag on is6_EmbossRGB to allow for edge pixel processing
  new flag on is6_AlphaBlendColor to allow composited alpha blending method for RGBA.
  fix to is6_AlphaBlendColor. when blending onto RGBA without setting a blend mode flag, would generate bad output
  DIBSection speed-up of DrawText when using Windows smoothing
  templated rewrite of core functions, filters, resizers
  fixed incorrect methods selection in DIB resize
  new modes in is6_GetHSVColorMatchMaskFromImage
  added rowstrides to RGB/HSL conversion functions
  back to libPng 1.2.22 (1.2.40 was just not working out)
  fixed bug in PSD 1-bit => 24-bit reading

  + is6_SetWorkerThreadCount
  + is6_SetWorkerThreadCallbackFrequency
  + is6_SetWorkerThreadTimeout
  + is6_SetWorkerThreadPoolSize
  + is6_ShuffleChannels
  + is6_SetImageChannel
  + is6_MotionBlur
  + is6_RadialBlur
  + is6_ZoomBlur
  + all ISEffects functions

  all-new zoom, radial and motion blur filters

  multithreading in:
      rotate (all non-'quick' variants)
      polygon warp
      bi-cubic, area averaging, and 'filter' resizing methods (RGB, 8->24)
      1-bit bi-lin
      1-bit, 8-bit morpho dilation/erosion
      transforms
      sobel
      bilateral
      RGB/A -> grayscale single
      image overlay (is6_OverlayImage)
      alpha blend RGB/RGBA
      overlay 1-bit on RGB/RGBA (used in text output)
      motion, zoom, radial blur

   5.0.0.1 A2  2/9/10
   fixed missing exports in DLL build

   5.0.0.3 A3   2/13/10
   fixed is6_AlphaBlendRGBA mode 4 - bad output
   use threading if rows/cols to process < WorkerThreads * 5
   re-org #includes for PCH to speed-up build times.
    removed PCH for VC6 - was creating unreliable code (crash on start up - STL problems)
   removed global warning #pragmas and cleaned-up the resulting warnings
   fixed broken TIFF line writer
    added quick bail in overlay when intersect rect is empty

   5.0.0.4 A4  2/14/10
   more compiler warning cleanups
    better smooth line algorithm
    speedup in new is6_GetHSVColorMatchMaskFromImage modes
    
    5.0.0.5 A5 2/18/10
    moved threadpool clean up to is6_Exit. auto-cleanup in DllMain was causing crashes. this means is6_Exit is now required.
    moved threadpool init to is6_Initialize

    5.0.0.6    2/20/10
    first beta

    5.0.0.7    2/24/10
    first release

    5.0.0.8    2/25/10
    fix to 1-bit morpho erosion - incorrect results
    rebuild with dependent libs included

    5.0.0.9    2/26/10
    fix to is6_MorphoHitOrMiss1Bit. missing const on parameter. caused undef'd symbol.
    added CALS and ICO to GuessFileType
   fixes in is6_GrayscaleTo1Bit. fixed modes 4, 7, 11, 12. added 1 to the calculated threshhold for all, to avoid thresh=0 yielding black images
   read to 1-bit in is6_ReadImage
   added flag to auto-reduce fractions when fetching EXIF tag data

   5.0.0.10 3/15/10
   tweaks to metafile reading
   fix to radial blur - infinite loop with very small blur radius
   allow RGBA in is6_PushImage. added multi-threading.

   5.0.0.11 3/18/10
   changed optimizations in gradient fill
   fixed bug in moeds 4,5 of is6_GetHSVColorMatchMaskFromImage. added flag for HSL input.

   5.0.1.0
   increased precision in EXIF reduced fractions
   added (std::nothrow) to all C++ 'new' allocations, to help prevent out of memory exceptions. ImgSource prefers a NULL return from new.
   + is6_SetErrorCallback

   5.0.1.1
   fixed return value in non-threaded filter resize. was mixing IS_ERR* and BOOL
   added guard in is6_Initialize to prevent problem with multiple initializations of the thread pool
   
   5.0.1.2
   cleaned-up the non-MMX code paths

   5.0.1.3
   VS2010 builds

   5.0.1.4
   added min dim check in gaussian blur. would crash doing IIR when dim < 4

   5.0.2.0
   redefinied OutputDebugString as SAODS (a.k.a. OutputDebugStringA), to please Unicode builds
   + is6_RGB24ToRGB16Ex

   5.0.2.1
   fix to "Big Red X" drawing code - was crashing on 48bpp images

   5.0.2.2  7/15/10
   fix to generic read of PSD. was failing.
   added vertical flip support for BMP-RLE writing
   added RGBA support in GetBorder
   added CALS ID in GuessType (though it only guesses by file extension)
   added GIF 87a support for multi-frame GIF
   TIFF write doc changes, re: rowStride
   BMP write doc changes: BGR & vertical flip flags were reversed

   5.0.2.3  7/16/10
   fix multi-frame GIF read. was zeroing 89a fields.
   fix to MMX build in ISImgGaussian.cpp

   5.0.2.4  7/18/10
   removed debugging info from VS10 builds

   5.0.2.5  8/25/10
   added a fudge to try to account for floating point inaccuracy during bicubic calculations

   5.0.2.6  8/30/10
   fix to EXIF tag writing. was incorrectly swapping byte order when outputting to Motorola-ordered EXIF

   5.0.2.7  9/20/10
   MMX/SSE functions for x64
   moved inline _asm to external MASM/ML64 files
   modified EXIF writing to account for NULL char on user-added ASCII tags

   5.0.2.8  10/3/10
    added TIFF reading for 48 & 64bpp via is6_ReadTIFF_TR
    LibPNG 1.4.4
    fixed handle leak in threadpool (one event per thread)

    5.0.3.0
    fixed swapped parameters in is6_BilateralFilterImage (input rowstride and components per pixel were reversed on internal call)
    fixed bad error code setting in is6_BilateralFilterImage
    + _is6_RGBToXYZ
    + _is6_XYZToRGB
    + _is6_XYZToLab
    + _is6_LabToXYZ
    + _is6_XYZToLuv
    + _is6_LuvToXYZ
    + _is6_SimpleWhitePointCorrection


    5.0.4.0
    fixed bug in median filter - bad output values
    added double support in:
        is6_ThresholdFilter
        is6_MidpointFilter
        is6_MaximumFilter
        is6_MinimumFilter
        is6_MedianFilterImage
        is6_DustAndScratches
        is6_HorizontalFlipImage
        is6_ApplyConvolutionFilterToImage

    + is6_DoubleToInteger
    + is6_IntegerToDouble


    5.0.4.1
    fixed bug in gaussian blur. access violation.

    5.0.4.2
    changed IO seek code to use unsigned values for absolute seeks (allows files up to 2^32 bytes)
    fix to read "core" BMP files to 32 bpp (crash)
    fixed crash bug when reading certain YCbCr TIFFs

    5.0.5.0
    + is6_InitializeEx

    5.0.5.1
    removed debug info from VS10 release build - caused by SP1 bug

    5.0.5.2
    added double-check in GuessFileType for ICO, so as to lessen confusion with TGA
    changed ellipse drawing to use 64-bit ints, to avoid int overflow on large ellipses

    5.0.5.3
    anti-aliased ellipses

    5.0.5.4 9/28/11
    fix to animated gif rendering. was incorrectly handling background replacement.

    5.0.5.5 9/28/11
    "  " 

    5.0.5.6 9/29/11
    "  " 

    5.0.6.0 11/13/11
    + is6_InpaintImage
    + is6_InpaintImageDouble
    new mode on grayscale morpho functions

    5.0.6.1
    fixed black border on top,left of inpaint output

    5.0.6.2 1/8/12
    rebuild for new cert

    5.0.6.3 1/20/12
    fix to is6_OverlayImage8BitAlphaOnRGB. internally, bpp and rowStride were swapped.
    added some null pallete checks on 8-bit overlay fns

    5.0.6.4 2/16/12
    fix to is6_DrawTextOnRGB/is6_DrawTextOnRGB2. was not drawing text

    5.0.6.5  3/17/12
    added more out-of-memory checks, lib-wide
    EOF check on single-byte read. prevents possible infinite loop on GIF read.

    5.0.6.6 3/18/12
    better EOF check than 5.0.6.5

    5.0.6.7 3/28/12
    export is6_ZoomBlur

    5.0.6.8 6/15/12
    using libPng 1.5.11
    fixed broken trans index result in is6_GetPNGDims

    5.0.6.9 7/25/12
    VS12 RC test build

    5.0.6.10    8/20/12
    added tag names for XP* EXIF tags (0x9C9B-0x9C9F)
    improved OilPaint performance

    5.0.6.11
    9/28/12
    is6_Posterize - significant performance improvement
    is6_Scribble - fix to mode 2, possible crash bug

    5.0.6.12
    fix to EXIF writing. was missing the 'next IFD' offsets at the ends of IFDs.

    5.0.7.0 3/13/13
    fix to is6_XYZToLab, is6_XYZToLuv, is6_LabToXYZ, is6_LuvToXYZ: would return error if image height was smaller than maxThreads * 5
    change to RGB <-> XYZ and XYZ <-> Lab calculations. previous versions were incorrect.
    changed RGB <-> XYZ default colorspace from Abode RGB to sRGB.

    + is6_RGBToXYZ_2
    + is6_XYZToRGB_2

    5.0.8.0 3/31/13
    code fixups per VS2012 static code analysis
    fixed clipping issue in is6_BrightnessHistogramStretchImage 
    allow bilinear and bicubic rotations for 8-bit grayscale images in is6_RotateImage, with no palette slowdown
    option to allow auto-scale output in is6_DoubleToInteger
    + is6_DetermineImageTranslation
    + is6_ResizeImageFractional
    + is6_TransformProcessDouble
    + is6_GaussianBlurImageEx
    + is6_ApplyWindow
    
    5.0.8.1 4/11/13
    fix to IPTC export

    5.0.8.2 4/11/13
    fixes to IPTC import/export

    5.0.8.3 5/3/13
    read and write 16-bpc in PSD (RGB and CMYK)

    5.0.9.0 7/4/13
    + is6_DrawThickLineOnImage
    crash fix in anti-alias mode of is6_PolygonFillImage
    improved positioning in is6_PolygonFillImage (AA-mode)

    5.0.9.1 7/13/13
    changes to arrowhead rendering in is6_DrawThickLineOnImage

    5.0.10.0    9/17/13
    + is6_Convert16bpcTo8bpcEx
    fix to is6_Convert16bpcTo8bpc documentation
    fixes to CISImage

    5.0.10.1    11/15/13
    fix to guassian blur. bad results when image roswstride != pixels * channels

    5.0.10.2    11/17/13
    fix to guassian blur. possible crash due to fix in 5.0.10.1

    5.0.10.3    11/21/13
    fix to line smooth line drawing on single channel images. was tripling the line, also potential crash bug.
    fix to guassian blur. possible crash

    5.0.10.4    11/23/13
    removed single-precision modes from Gaussian blur - was experiencing accuracy errors with large sigma

    5.0.10.5
    VS13 builds

    5.0.10.6 1/9/14
    fix to possible crash when using the MMX modes of is6_OverlayImage. 
    this also affects is6_DropShadow, is6_OuterGlowRGBA, is6_InpaintImage, is6_TophatGray and is6_GauzyImage.

    5.0.10.7
    is6_ReadRGBA can now read trans GIFs to RGBA
    fixed custom allocator issues in generic read

    5.0.11.0
    complete rework of color space transformations
    fixed accuracy issues in XYZ<->LUV
    fixed rowstride issues in XYZ<->Lab, XYZ<->LUV
    multithreaded all color conversions

    +_is6_CompareColorsDeltaE
    +_is6_RGBToYCC
    +_is6_YCCToRGB
    +_is6_LabToLCH
    +_is6_LCHToLab
    +_is6_LCHToLuv
    +_is6_LuvToLCH
    +_is6_RGBToLab 
    +_is6_LabToRGB 
    +_is6_RGBToLuv 
    +_is6_LuvToRGB 
    +_is6_RGBToLCH 
    +_is6_LCHToRGB 


   added more depth options in is6_SplitImage, is6_CombineImageChannels, is6_ShuffleImageChannels, is6_HorizontalFlipImage

   fixed bugs in is6_WatercolorTintRGB and is6_GauzyImage

   5.0.11.1
   fix to RGB-48 to XYZ

   5.0.12.0
   fix to GIF reading (would fail to read certain images)
   + is6_MultiscaleHatDenoise
   + is6_MultiscaleHatDecompose
   + is6_MultiscaleHatRecompose

   5.0.12.1
   added minimum size check on is6_MultiscaleHatDenoise & is6_MultiscaleHatDecompose


    5.0.12.2
    new overlay modes (32-38)
    is6_MotionBlur parameter list was incorrect (uBpp and uInRowStride were swapped on the declaration)
    fix to polygon fill - was not drawing anti-aliased polys when image was 1bpp (affects is6_DrawThickLine, also)
    added anti-aliased ellipse filling

    5.0.13.0
    is6_HistogramSpecification
    fix to overlay subtract mode in MMX
    added overlay mode subtract (bottom = top - bottom)
    added 'black' top hat variation for is6_TophatGray


    5.0.14.0
    fix to intersect, XOR and union buffers. affects HitOrMiss, Thinning, BoundaryExtraction
    fix to intersectRow1Bit. affects HitOrMiss 
    deprecated is6_MorphoThinning1Bit. API was unusable.
    + is6_MorphoThinning1BitEx (to fix is6_MorphoThinning1Bit)
    major expansion of CISImageEx and demo apps

    5.0.14.1
    Hough performance improvements

	5.0.15.0	5/18/14
	+ is6_GetSIMDSupport
	deprecated is6_IsMMXSupported
	added SSE support for RGBToBGR, simple blend overlay, RGBAOnRGB, logical blends, solid color+alpha mask blend. VS10+ only
    removed MMX support in VS10+
	reworked MMX support for VC6-VS08
	now building DLL and demos with VS13


   5.0.15.1 5/31/14
   added 'improved' Perlin noise
   speedups to bilin rotate and warp
   SSE bi-cubic calc in rotate, warp, resize
   EWA interpolation in warp

   6.0.0.0A  started 6/22/2014
    */

#define IS_VERSIONSTRING "IS 6.0.0.0"

// x.xx.xxx.xx
#define IS_VERSION_NUMERIC 60000000