/*

	This is a very simple image viewer demo for the ImgSource library.

	It basically demonstrates two functions:

		is6_LoadImage - the high-level image reading function. in this example, we read directly to DIB.

		is6_StretchDrawDIB - having read a DIB, we draw it to the screen.

	The techniques used here for drawing and moving the image can be 
	used in other applications, however.

*/
// ISSimpleViewerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ISSimpleViewer.h"
#include "ISSimpleViewerDlg.h"



#include <math.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CString StringFromErrorNum(int err);

/////////////////////////////////////////////////////////////////////////////
// CISSimpleViewerDlg dialog

CISSimpleViewerDlg::CISSimpleViewerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CISSimpleViewerDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CISSimpleViewerDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

   m_bBtnDown =
   m_bMouseInImage = 
   m_bNeedGrabber = false;
   m_ptLast = CPoint(0,0);
   m_ptCurOffset = CPoint(0,0);

   m_hDIB = NULL;
}

void CISSimpleViewerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CISSimpleViewerDlg)
	DDX_Control(pDX, IDC_INFO, m_infoWnd);
	DDX_Control(pDX, IDC_FRAME, m_frameWnd);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CISSimpleViewerDlg, CDialog)
	//{{AFX_MSG_MAP(CISSimpleViewerDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_LOADNEW, OnLoadnew)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_SETCURSOR()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CISSimpleViewerDlg message handlers

BOOL CISSimpleViewerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

/////////////////////////////////////////////////////////////////////////////

void CISSimpleViewerDlg::OnPaint() 
{
   CPaintDC dc(this); // device context for painting

	if (IsIconic())
	{
		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
      CDialog::OnPaint();
      
      // where does the image go?
      CRect frameRect = GetFrameRect();

      if (m_hDIB!=NULL)
      {
         // draw to a memory DC
         CDC memDC;
         if (memDC.CreateCompatibleDC(&dc))
         {
            CBitmap bmp;
            if (bmp.CreateCompatibleBitmap(&dc, frameRect.Width(), frameRect.Height()))
            {
               CBitmap *ob = memDC.SelectObject(&bmp);
               if (ob)
               {
                  // dark red background
                  memDC.FillSolidRect(CRect(0,0,frameRect.Width(), frameRect.Height()), RGB(64,0,0));

						// stretchDrawDIB is typically the fastest way to draw an image from ImgSource.
                  BOOL ok = _is6_StretchDrawDIB(memDC.m_hDC, (BITMAPINFOHEADER *)m_hDIB, m_ptCurOffset.x, m_ptCurOffset.y,  m_uDIBW, m_uDIBH);

                  if (!ok)
                  {
                     memDC.SetBkMode(TRANSPARENT);
                     memDC.SetTextColor(RGB(255,255,255));
                     memDC.TextOut(frameRect.left, frameRect.top,"Can't draw image: " + StringFromErrorNum(_is6_GetLastError()));
                  }

                  // copy this to the window
                  dc.BitBlt(frameRect.left, frameRect.top, frameRect.Width(), frameRect.Height(), &memDC, 0,0, SRCCOPY);

                  memDC.SelectObject(ob);
               }
            }
         }
      }
      else
      {
         dc.SetBkMode(TRANSPARENT);
         dc.SetTextColor(RGB(255,255,255));
         dc.TextOut(frameRect.left + 5, frameRect.top + 5,"No image");
      }
   }
}
                   
/////////////////////////////////////////////////////////////////////////////

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CISSimpleViewerDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

/////////////////////////////////////////////////////////////////////////////

CString StringFromErrorNum(int err)
{
	CString out = "";
	switch (err) 
	{
		default 			         :		out.Format("Error #%d", err);
			break;
		case IS_ERR_OK				:		out="No error"; 
			break;
		case IS_ERR_MEM			:		out="Error : out of memory";
			break;
		case IS_ERR_FILEOPEN		:		out="Error on file open";
			break;
		case IS_ERR_FILEREAD		:		out="Error on file read";
			break;
		case IS_ERR_FILEWRITE	:		out="Error on file write";
			break;
		case IS_ERR_BADPARAM		:		out="Bad user param";
			break;
		case IS_ERR_INVALIDBMP	:		out="Bad BMP file";
			break;
		case IS_ERR_INVALIDTIFF	:		out="Bad TIF file";
			break;
		case IS_ERR_INVALIDJPG	:		out="Bad JPG file";
			break;
		case IS_ERR_INVALIDPCX	:		out="Bad PCX file";
			break;
		case IS_ERR_INVALIDGIF	:		out="Bad GIF file";
			break;
		case IS_ERR_INVALIDPSD	:		out="Bad PSD file";
			break;
		case IS_ERR_INVALIDPCD	:		out="Bad PCD file";
			break;
      case IS_ERR_PCDINDEX    :     out="This program isn't set up to read PCD index files";
         // ImgSource can read these, but this program doesn't.
         break;
	}

	return out;
}

/////////////////////////////////////////////////////////////////////////////

void CISSimpleViewerDlg::OnLoadnew() 
{
	CString fileName;
	CString filt=
"JPG Files (*.JPG)|*.JPG| \
PNG Files (*.PNG)|*.PNG| \
GIF Files (*.GIF)|*.GIF| \
TIFF Files (*.TIF)|*.TIF| \
BMP Files (*.BMP)|*.BMP| \
PhotoCD Files (*.PCD)|*.PCD| \
Photoshop Files (*.PSD)|*.PSD| \
ZSoft PCX Files (*.PCX)|*.PCX| \
Targa Files (*.TGA)|*.TGA| \
Wireless Bitmap Files (*.WBMP)|*.WBMP| \
Windows Metafiles (*.WMF)|*.WMF| \
All files (*.*)|*.*||";

	CString defFilt = "*.PSD;*.BMP;*.GIF;*.JPG;*.PCX;*.PCD;*.PNG;*.TGA;*.TIF;*.WBMP;*.WMF";
	CFileDialog fileDlg(TRUE,defFilt, defFilt, NULL,filt,this);

	fileDlg.m_ofn.Flags|=OFN_FILEMUSTEXIST;
	fileDlg.m_ofn.lpstrTitle="File to load";

	if (fileDlg.DoModal()==IDOK) 
	{
      if (m_hDIB)
      {
         GlobalFree(m_hDIB);
         m_hDIB = NULL;
      }

		CWaitCursor bob;

		fileName=fileDlg.GetPathName();

      // open the file
      HISSRC hSrc = _is6_OpenFileSource(fileName);
      if (hSrc)
      {
         // read it
         UINT32 w,h;
         m_hDIB = _is6_ReadImage(hSrc, &w, &h, 2, 0);	 // the "2" = load directly to DIB, in the lowest bit depth possible.
         if (m_hDIB)
         {
            // get the dimensions
            _is6_DIBWidth((BITMAPINFOHEADER *)m_hDIB, &m_uDIBW);
            _is6_DIBHeight((BITMAPINFOHEADER *)m_hDIB, &m_uDIBH);

            UINT32 bc;
            _is6_DIBBitCount((BITMAPINFOHEADER *)m_hDIB, &bc);
            CString csInfo;

            csInfo.Format("%s: (%d x %d) %d bpp.", fileDlg.GetFileName(), m_uDIBW, m_uDIBH, bc);

            m_infoWnd.SetWindowText(csInfo);

            // will we need to be able to drag this image?
            CRect fr = GetFrameRect();
            m_bNeedGrabber = ((int)m_uDIBW > fr.Width() || m_uDIBH > fr.Height());
            
            m_bBtnDown = m_bMouseInImage = false;
            m_ptLast = CPoint(0,0);
            m_ptCurOffset = CPoint(0,0);

            // these need to be cleared so we don't re-use them on the next read (if the next file is not a JPG)
            _is6_ClearJPGInputMarkers();

            // draw it
            Invalidate(TRUE);
         }
         else
         {
            AfxMessageBox("Can't read that image\n"+ StringFromErrorNum(_is6_GetLastError()));
         }

         _is6_CloseSource(hSrc);
      }
      else
      {
         AfxMessageBox("Can't open that image\n"+ StringFromErrorNum(_is6_GetLastError()));
      }
   }	
}

/////////////////////////////////////////////////////////////////////////////

CRect CISSimpleViewerDlg::GetFrameRect()
{
   CRect rect;

   if (::IsWindow(m_frameWnd))
   {
      m_frameWnd.GetWindowRect(rect);
      ScreenToClient(rect);
      rect.DeflateRect(1,1);
   }

   return rect;
}

/////////////////////////////////////////////////////////////////////////////

void CISSimpleViewerDlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
   if (m_bBtnDown)
   {
      ASSERT(0);
   }

   if (m_hDIB!=NULL)
   {
      m_bBtnDown = true;
      m_ptLast = point;

      // set the cursor for this click. 
      // we need to handle the moving cursor in OnSetCursor
      if (m_bNeedGrabber)
      {
         if (m_bMouseInImage)
         {
            SetCursor(AfxGetApp()->LoadCursor(IDC_CLOSEDHAND));
         }
      }
   }

	CDialog::OnLButtonDown(nFlags, point);
}

/////////////////////////////////////////////////////////////////////////////

void CISSimpleViewerDlg::OnLButtonUp(UINT nFlags, CPoint point) 
{
   // all done
   m_bBtnDown = false;
   
   ReleaseCapture();
   
   CRect imgRect(0, 0, m_uDIBW, m_uDIBH);
   imgRect = GetFrameRect();

   CPoint imgPoint = point;
   
   // is the mouse over the image?
   if (imgRect.PtInRect(point))
   {
      m_bMouseInImage = true;
      SetCursor(AfxGetApp()->LoadCursor(IDC_OPENHAND));
   }
   else
   {
      m_bMouseInImage = false;
      SetCursor(AfxGetApp()->LoadCursor(IDC_ARROW));
   }


   CDialog::OnLButtonUp(nFlags, point);
}

/////////////////////////////////////////////////////////////////////////////

void CISSimpleViewerDlg::OnMouseMove(UINT nFlags, CPoint point) 
{
   if (m_hDIB!=NULL)
   {
      CRect imgRect(0, 0, m_uDIBW, m_uDIBH);
      imgRect = GetFrameRect();

      CPoint imgPoint = point;
      
      // is the mouse over the image?
      if (imgRect.PtInRect(point))
      {
         m_bMouseInImage = true;
      }
      else
      {
         m_bMouseInImage = false;
      }
      
      // is the button down?
      if (m_bBtnDown)
      {
         SetCapture();
         
         m_ptCurOffset += point - m_ptLast;
         
         CRect rect = GetFrameRect();
         
         // slide the image around
         if ((int)m_uDIBW > rect.Width())
         {
            m_ptCurOffset.x = min(0, max(m_ptCurOffset.x, rect.Width() - (int)m_uDIBW));
         }
         else
         {
            m_ptCurOffset.x = 0;
         }
         
         if (m_uDIBH > rect.Height())
         {
            m_ptCurOffset.y = min(0, max(m_ptCurOffset.y, rect.Height() - m_uDIBH));
         }
         else
         {
            m_ptCurOffset.y = 0;
         }
         
         m_ptLast = point;
         
         Invalidate(FALSE);
      }
   }
   else
   {
	   CDialog::OnMouseMove(nFlags, point);
   }
}

/////////////////////////////////////////////////////////////////////////////

BOOL CISSimpleViewerDlg::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
	if (pWnd==(CWnd *)this) 
	{
		if (nHitTest==HTCLIENT) 
		{
			if ((message==WM_MOUSEMOVE) || (message==WM_LBUTTONDOWN) || (message==WM_LBUTTONUP)) 
			{
            if (m_bNeedGrabber)
            {
               if (m_hDIB!=NULL)
               {
                  if (m_bMouseInImage)
                  {
                     if (m_bBtnDown)
                     {
                        // dragging the image
                        SetCursor(AfxGetApp()->LoadCursor(IDC_CLOSEDHAND));
                     }                                                 
                     else
                     {
                        // just moving over the image
                        SetCursor(AfxGetApp()->LoadCursor(IDC_OPENHAND));
                     }
                     return TRUE;
                  }
               }
            }
         }
      }
   }


	return CDialog::OnSetCursor(pWnd, nHitTest, message);
}

