/*---------------------------------------------------------
   ISErrorCodes.h : part of the ImgSource library.
 
   ImgSource error codes, as returned by is5_GetLastError

   This code copyright (c) 2000-2014, Smaller Animals Software, Inc..
   No portion of this code may be copied or distributed without 
   permission of Smaller Animals Software, Inc..
   
   http://www.smalleranimals.com
---------------------------------------------------------*/

#ifndef IS_ERRORCODESH
#define IS_ERRORCODESH

////////////////////////////////////////////////////////
// ImgSource Error values
#ifndef IS_ERROR_VALUES
#define IS_ERROR_VALUES

// is5_GetLastError will return one of these enum values
enum {
   IS_ERR_TRIALVERSION = -1,     // LIB was not initialized with a registered key
   IS_ERR_OK = 0,                // no err                                                                        
   IS_ERR_MEM = 1,               // out of memory                                                                 
   IS_ERR_FILEOPEN,              // error on file open                                                            
   IS_ERR_FILEREAD,              // error on file read                                                            
   IS_ERR_FILEWRITE,             // error on file write                                                           
   IS_ERR_BADPARAM = 5,          // bad user param                                                                
   IS_ERR_INVALIDBMP,            // bad BMP file                                                                  
   IS_ERR_BMPRLE,                // some RLE variations are not supported                                         
   IS_ERR_INVALIDGIFVERSION,     // bad GIF version number
   IS_ERR_INVALIDJPG,            // invalid JPG file, or error during JPG processing
   IS_ERR_DC = 10,               // error with device context                                                     
   IS_ERR_DIB,                   // problem with a GetDIBits call                                                 
   IS_ERR_INVALIDGIF,            // bad GIF file
   IS_ERR_NORESOURCE,            // resource not found                                                            
   IS_ERR_CALLBACKCANCEL,        // callback returned FALSE - operation aborted                                   
   IS_ERR_INVALIDPNG = 15,       // invalid PNG file, or error during PNG processing
   IS_ERR_PNGCREATE,             // internal PNG lib behavior - contact smaller animals s.w.                      
   IS_ERR_INTERNAL,              // misc unexpected behavior error - contact smaller animals s.w.                 
   IS_ERR_FONT,                  // trouble creating a font object                                                
   IS_ERR_INTTIFF,               // misc internal TIFF error                                                      
   IS_ERR_INVALIDTIFF = 20,      // invalid TIFF file, or error during TIFF processing
   IS_ERR_NOTIFFLZW,             // this will not read TIFF-LZW images (note, unused error message)
   IS_ERR_INVALIDPCX,            // invalid PCX image                                                             
   IS_ERR_CREATEBMP,             // a call to the fn CreateCompatibleBitmap failed                                
   IS_ERR_NOLINES,               // end of an image while using single-line de/compression                        
   IS_ERR_GETDIB = 25,           // error during a call to GetDIBits                                              
   IS_ERR_NODEVOP,               // device does not support an operation required by this function                
   IS_ERR_INVALIDWMF,            // invalid windows metafile                                                      
   IS_ERR_DEPTHMISMATCH,         // the file was not of the requested bit-depth                                   
   IS_ERR_BITBLT,                // a call to BitBlt failed.                                                      
   IS_ERR_BUFTOOSMALL = 30,      // output buffer is too small for this operation                                 
   IS_ERR_TOOMANYCOLORS,         // not enough room in the output palette to store the colors from this image 
   IS_ERR_INVALIDTGA,            // Invalid TGA File                                                              
   IS_ERR_NOTGATHUMBNAIL,        // No TGA Thumbnail in the file                                                  
   IS_ERR_RESERVED3,             // reserved value
   IS_ERR_CREATEDIB = 35,        // a call to the fn CreateDIBitmap failed                                        
   IS_ERR_NOLZW,                 // LZW de/compression is not permitted
   IS_ERR_SELECTOBJ,             // a call to SelectObject has failed (DC does not support this operation?)
   IS_ERR_BADMANAGER,            // the HISSRC or HISDEST object passed into the function does appear to be valid
   IS_ERR_OBSOLETE,              // the function is obsolete
   IS_ERR_CREATEDIBSECTION=40,   // a call to CreateDIBSection failed
   IS_ERR_SETWINMETAFILEBITS,    // a call to SetWinMetaFileBits failed (95/98 only)
   IS_ERR_GETWINMETAFILEBITS,    // a call to GetEnhMetaFileBits   or GetWinMetaFileBits failed
   IS_ERR_PAXPWD,                // apparently invalid PAX password
   IS_ERR_INVALIDPAX,            // invalid PAX file
   IS_ERR_NOSUPPORT = 45,        // this function is not supported in this build (see DLL build options)
   IS_ERR_INVALIDPSD,            // invalid PSD (Photoshop) file
   IS_ERR_PSDNOTSUPPORTED,       // this Photoshop sub-format is not supported
   IS_ERR_DECRYPT,               // decryption error - possible bad password for encrypted files
   IS_ERR_ENCRYPT,               // encryption failed
   IS_ERR_COMPRESSION = 50,      // compression failed
   IS_ERR_DECOMPRESSION,         // decompression error - possible bad password for encrypted files
   IS_ERR_INVALIDTLA,            // invalid TLA file. may indicate incorrect password
   IS_ERR_INVALIDWBMP,           // invalid or unsupported WBMP (Wireless Bitmap) image.
   IS_ERR_NOTIFFTAG,             // ImgSource does not support reading or writing this TIFF tag
   IS_ERR_NOLOCALSTORAGE = 55,   // ImgSource was not able to allocate thread-local storage. this is a severe low-memory condition.
   IS_ERR_INVALIDEXIF,           // invalid EXIF format
   IS_ERR_NOEXIFTAG,             // no EXIF tag was found with the given ID
   IS_ERR_INVALIDIPTC,           // invalid IPTC format
   IS_ERR_NOIPTCTAG,             // no IPTC tag was found with the given ID
   IS_ERR_PNGINTERLACED = 60,    // can't read interlaced PNGs one line at a time
   IS_ERR_NONCONVEXPOLY,         // can't warp to or from a non-convex polygon
   IS_ERR_NOXFORMMAP,            // unable to determine polygon transformation matrix
   IS_ERR_INVALIDPCD,            // invalid PhotoCD image
   IS_ERR_PCDINDEX,              // image is a PhotoCD index file, not a single image
   IS_ERR_NOEXIFTHUMBNAIL = 65,  // EXIF data does not contain a thumbnail
   IS_ERR_NOPNGCHUNK,            // the requested data is not in the PNG file
   IS_ERR_INVALIDPSRESOURCE,     // unable to parse the Photoshop resource
   IS_ERR_IMAGETOOSMALLFORFILTER,// output image was too small for the requested filter type
   IS_ERR_ZLIBINIT,              // error initializing zLib for de/compression
   IS_ERR_ZLIBCOMP = 70,         // error in zLib de/compression
   IS_ERR_NOPROCSUPPORT,         // processor does not support the requested operation
   IS_ERR_NOPSDRESOURCE,         // Phtotoshop resource not found
   IS_ERR_TIFFTILESTRIPMISMATCH, // attempted to read tiled TIFF as strips, or vice versa
   IS_ERR_TIFFPLANARMISMATCH,    // the function can't read TIFFs with separated color planes
   IS_ERR_NOTILESTRIP = 75,      // there is no tile pos or strip index in the file (out of range, or bad tile position)
   IS_ERR_BADMARKERTYPE,         // invalid JPEG marker type for the operation
   IS_ERR_INVALIDICO,            // invalid ICO (Windows ICON) file
   IS_ERR_INVALIDPNM,            // invalid PPM, PBM or PGM file, or error during processing
   IS_ERR_ENDOFANIMATION,        // end of (GIF) animation
   IS_ERR_MISSINGEXIFTAGS = 80,  // one or more tags required for valid EXIF data was not set
   IS_ERR_INVALIDGEOTIFF,        // unable to intialize GeoTiff reader
   IS_ERR_NOGEOTIFFTAG,          // no GeoTIFF tag was found with the given ID
   IS_ERR_NOEXIFUSERNOTE,        // EXIF data does not contain a usernote
   IS_ERR_THREADTIMEOUT,         // timeout while waiting for a thread to start or finish.
	IS_ERR_BADCALS = 85,				// invalid CALS file
	IS_ERR_CALS_NOTSUPPORTED,		// ImgSource cannot read this CALS type
   IS_ERR_THREADCREATION,        // an error occurred while starting a thread

   // extension error codes start here
   IS_ERR_EXTBASE       = 1000,
   /*
   SAJSK errors are in the range 1000 to 1010
   SAFPX errors are in the range 1020 to 1030
   
   If you are writing your own extension library, and wish to reserve a block of error codes,
   please contact Smaller Animals Software
   */
};
#endif

#endif