// ISImageDemo.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "ISImageDemo.h"

#include "MainFrm.h"
#include "ChildFrm.h"
#include "ISImageDemoDoc.h"
#include "ISImageDemoView.h"
#include "ISImageDemoAniGIFDoc.h"
#include "ISImageDemoAniGIFView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CISImageDemoApp

BEGIN_MESSAGE_MAP(CISImageDemoApp, CWinApp)
	//{{AFX_MSG_MAP(CISImageDemoApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_UPDATE_COMMAND_UI(ID_FILE_OPEN, OnUpdateFileOpen)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
    ON_COMMAND(ID_FILE_OPENANIMATE, OnFileOpenAnimatedGIF)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CISImageDemoApp construction

CISImageDemoApp::CISImageDemoApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
  }

/////////////////////////////////////////////////////////////////////////////
// The one and only CISImageDemoApp object

CISImageDemoApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CISImageDemoApp initialization

BOOL CISImageDemoApp::InitInstance()
{  
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
//	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// Change the registry key under which our settings are stored.
	// You should modify this string to be something appropriate
	// such as the name of your company or organization.
	SetRegistryKey(_T("Local AppWizard-Generated Applications"));

	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// ImgSource initialization. this is required.
	// we'll call is6_Exit in our ExitInstance
   const char * pKey = TESTKEY;
	_ISFn(is6_Initialize)(pKey);
	

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.


	m_pStaticDocTemplate = new CMultiDocTemplate(
		IDR_ISIMAGTYPE,
		RUNTIME_CLASS(CISImageDemoDoc),
		RUNTIME_CLASS(CChildFrame), // custom MDI child frame
		RUNTIME_CLASS(CISImageDemoView));
	AddDocTemplate(m_pStaticDocTemplate);

	m_pAniGIFTemplate = new CMultiDocTemplate(
		IDR_GIFDOCTYPE,
		RUNTIME_CLASS(CISImagedemoAniGIFDoc),
		RUNTIME_CLASS(CChildFrame), // custom MDI child frame
		RUNTIME_CLASS(CISImageDemoAniGIFView));
	AddDocTemplate(m_pAniGIFTemplate);


	// create main MDI Frame window
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;
	m_pMainWnd = pMainFrame;

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

   // suppress empty doc on startup
    if (cmdInfo.m_nShellCommand == CCommandLineInfo::FileNew) 
      cmdInfo.m_nShellCommand = CCommandLineInfo::FileNothing; 

	// Dispatch commands specified on the command line
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// The main window has been initialized, so show and update it.
	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CISImageDemoApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CISImageDemoApp commands

int CISImageDemoApp::ExitInstance() 
{
	// perform ImgSource shutdown. this is required!
	_ISFn(is6_Exit)();
	
	return CWinApp::ExitInstance();
}

void CISImageDemoApp::OnFileOpen()
{
	// big, scary input filter
	CString filt= _T("Image Files |*.BMP;*.GIF;*.JPG;*.PCX;*.PNG;*.TGA;*.TIF;*.PSD;*.WBMP|\
Windows BMP Files (*.BMP)|*.BMP|\
GIF Files (*.GIF)|*.GIF|\
JPEG Files (*.JPG)|*.JPG|\
ZSoft PCX Files (*.PCX)|*.PCX|\
Adobe Photoshop Files (*.PSD)|*.PSD|\
Kodak PhotoCD Files (*.PCD)|*.PCD|\
PNG Files (*.PNG)|*.PNG|\
Targa TGA Files (*.TGA)|*.TGA|\
Wireless Bitmap Files (*.WBMP)|*.WBMP|\
TIFF Files (*.TIF)|*.TIF|\
All files (*.*)|*.*||");

	CString defFilt = _T("Image Files|*.Bmp;*.Jpg;*.Pcx;*.Pcd;*.Png;*.Tga;*.Psd;*.wbmp;*.Tif;*.Gif");

	CFileDialog fileDlg(TRUE, defFilt, _T(""), NULL, filt, NULL);

	fileDlg.m_ofn.Flags|=OFN_FILEMUSTEXIST;
	fileDlg.m_ofn.lpstrTitle = _T("Open image file");

	if (fileDlg.DoModal()==IDOK)
	{
		CString csFQSrcFile = fileDlg.GetPathName();

      m_pStaticDocTemplate->OpenDocumentFile(csFQSrcFile);
   }
}

void CISImageDemoApp::OnUpdateFileOpen(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable();	
}

void CISImageDemoApp::OnFileOpenAnimatedGIF()
{
   // big, scary input filter
   CString filt= _T("GIF Files (*.GIF)|*.GIF|\
                    All files (*.*)|*.*||");

   CString defFilt = _T("GIF Files|*.gif");

   CFileDialog fileDlg(TRUE, defFilt, _T(""), NULL, filt, NULL);

   fileDlg.m_ofn.Flags|=OFN_FILEMUSTEXIST;
   fileDlg.m_ofn.lpstrTitle = _T("Open GIF file");

   if (fileDlg.DoModal()==IDOK)
   {
      CString csFQSrcFile = fileDlg.GetPathName();

      m_pAniGIFTemplate->OpenDocumentFile(csFQSrcFile);
      
   }
}


void CISImageDemoApp::getImageDocs(std::vector<CISImageDemoDoc*> &listDocs, CISImageDemoDoc*excl)
{
   // clear the list
   listDocs.clear();

   // loop through application's document templates
   POSITION posDocTemplate = GetFirstDocTemplatePosition();
   while(NULL != posDocTemplate)
   {
      CDocTemplate* pDocTemplate = GetNextDocTemplate(posDocTemplate);
 
      // get each document open in given document template
      POSITION posDoc = pDocTemplate->GetFirstDocPosition();
      while (NULL != posDoc)
      {
         CDocument* pDoc = pDocTemplate->GetNextDoc(posDoc);

         CISImageDemoDoc *pDD = dynamic_cast<CISImageDemoDoc*>(pDoc);
         if (pDD && pDD != excl)
         {
            listDocs.push_back(pDD);
         }
      }
   }
}