// ISImageDemoAniGIFView.cpp : implementation file
//

#include "stdafx.h"
#include "ISImageDemo.h"
#include "ISImageDemoAniGIFDoc.h"
#include "ISImageDemoAniGIFView.h"


#define ANITICKTIMER 1000

// CISImageDemoAniGIFView

IMPLEMENT_DYNCREATE(CISImageDemoAniGIFView, CScrollView)

CISImageDemoAniGIFView::CISImageDemoAniGIFView()
{

}

CISImageDemoAniGIFView::~CISImageDemoAniGIFView()
{
}

CISImagedemoAniGIFDoc* CISImageDemoAniGIFView::GetDocument() // non-debug version is inline
{
   ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CISImagedemoAniGIFDoc)));
   return (CISImagedemoAniGIFDoc*)m_pDocument;
}

BEGIN_MESSAGE_MAP(CISImageDemoAniGIFView, CScrollView)
   //{{AFX_MSG_MAP(CISImageDemoView)
   //}}AFX_MSG_MAP
   // Standard printing commands
   ON_COMMAND(ID_FILE_PRINT, CScrollView::OnFilePrint)
   ON_COMMAND(ID_FILE_PRINT_DIRECT, CScrollView::OnFilePrint)
   ON_COMMAND(ID_FILE_PRINT_PREVIEW, CScrollView::OnFilePrintPreview)
   ON_WM_ERASEBKGND()
   ON_WM_TIMER()
END_MESSAGE_MAP()



// CISImageDemoAniGIFView drawing

void CISImageDemoAniGIFView::OnInitialUpdate()
{
   CScrollView::OnInitialUpdate();

   CSize sizeTotal;
   // TODO: calculate the total size of this view
   sizeTotal.cx = sizeTotal.cy = 100;
   SetScrollSizes(MM_TEXT, sizeTotal);


   OnNewImage();
}

void CISImageDemoAniGIFView::OnDraw(CDC* pDC)
{
   CISImagedemoAniGIFDoc* pDoc = GetDocument();
   ASSERT_VALID(pDoc);

   CSize imgSize = pDoc->GetImageSize();
   CRect imgRect = CRect(0, 0, imgSize.cx, imgSize.cy);

   CRect updateRect = ((CPaintDC*)pDC)->m_ps.rcPaint;

   // draw to a memory DC
   CDC memDC;
   if (memDC.CreateCompatibleDC(pDC))
   {
      CBitmap bmp;
      if (bmp.CreateCompatibleBitmap(pDC, updateRect.Width(), updateRect.Height()))
      {
         CBitmap *ob = memDC.SelectObject(&bmp);
         if (ob)
         {
            CISImageEx &image = pDoc->GetImage();
            if (image.ISValid())
            {
               image.Draw(&memDC, CPoint(0,0), NULL);
            }
            // copy this to the window
            pDC->BitBlt(0,0, imgRect.Width(), imgRect.Height(), &memDC, 0,0, SRCCOPY);

            memDC.SelectObject(ob);
         }
      }
   }
}

void CISImageDemoAniGIFView::OnTimer(UINT_PTR nIDEvent) 
{
   if (nIDEvent==ANITICKTIMER)
   {
      KillTimer(ANITICKTIMER);

      CISImagedemoAniGIFDoc* pDoc = GetDocument();
      ASSERT_VALID(pDoc);

      // tell the doc to get us the next frame. we'll grab it in OnDraw.
      // set the timer to go off after the frame's time has elapsed.
      UINT32 ticks;
      pDoc->PrepareNextFrame(ticks);

      InvalidateImageRect();

      SetTimer(ANITICKTIMER, ticks * 10, NULL);
   }
}

void CISImageDemoAniGIFView::InvalidateImageRect()
{
   CISImagedemoAniGIFDoc* pDoc = GetDocument();
   ASSERT_VALID(pDoc);

   CSize sz = pDoc->GetImageSize();
   CRect cr ;
   cr.top = 0;
   cr.left = 0;
   cr.right = sz.cx;
   cr.bottom = sz.cy;

   InvalidateRect(&cr, 0);
}

// CISImageDemoAniGIFView diagnostics

#ifdef _DEBUG
void CISImageDemoAniGIFView::AssertValid() const
{
   CScrollView::AssertValid();
}

#ifndef _WIN32_WCE
void CISImageDemoAniGIFView::Dump(CDumpContext& dc) const
{
   CScrollView::Dump(dc);
}
#endif
#endif //_DEBUG

/*
time to update something...
*/
void CISImageDemoAniGIFView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
   switch (lHint)
   {
   case eHintNewImage:
      OnNewImage();
      break;
   }
}

/*
Set our scroll sizes to fit the image. This doesn't
change the window size, only the size that the scroll bars
use.
*/
void CISImageDemoAniGIFView::OnNewImage()
{
   CISImagedemoAniGIFDoc* pDoc = GetDocument();
   CSize imgSize = pDoc->GetImageSize();

   CSize setSize = imgSize;

   UINT_PTR r = SetTimer(ANITICKTIMER, 1, NULL);

   SetScrollSizes(MM_TEXT, setSize);
   ResizeParentToFit(TRUE);

   CRect cr;
   GetClientRect(cr);
   if (imgSize.cx > cr.Width())
   {
      SetScrollPos(SB_HORZ, imgSize.cx / 3);
   }

   if (imgSize.cy > cr.Height())
   {
      SetScrollPos(SB_VERT, imgSize.cy / 3);
   }

   Invalidate(TRUE);
}


BOOL CISImageDemoAniGIFView::OnEraseBkgnd(CDC* pDC)
{

   return CScrollView::OnEraseBkgnd(pDC);
   //return TRUE;
}

