/*
This handles the image display and printing
*/

// ISImageDemoView.cpp : implementation of the CISImageDemoView class
//

#include "stdafx.h"
#include "ISImageDemo.h"

#include "ISImageDemoDoc.h"
#include "ISImageDemoView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CISImageDemoView

IMPLEMENT_DYNCREATE(CISImageDemoView, CScrollView)

BEGIN_MESSAGE_MAP(CISImageDemoView, CScrollView)
   //{{AFX_MSG_MAP(CISImageDemoView)
   ON_WM_LBUTTONDBLCLK()
   //}}AFX_MSG_MAP
   // Standard printing commands
   ON_COMMAND(ID_FILE_PRINT, CScrollView::OnFilePrint)
   ON_COMMAND(ID_FILE_PRINT_DIRECT, CScrollView::OnFilePrint)
   ON_COMMAND(ID_FILE_PRINT_PREVIEW, CScrollView::OnFilePrintPreview)
   ON_WM_ERASEBKGND()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CISImageDemoView construction/destruction

CISImageDemoView::CISImageDemoView()
{
   // TODO: add construction code here

}

CISImageDemoView::~CISImageDemoView()
{
}

BOOL CISImageDemoView::PreCreateWindow(CREATESTRUCT& cs)
{
   // TODO: Modify the Window class or styles here by modifying
   //  the CREATESTRUCT cs

   return CScrollView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CISImageDemoView drawing

void CISImageDemoView::OnDraw(CDC* pDC)
{
   CISImageDemoDoc* pDoc = GetDocument();
   ASSERT_VALID(pDoc);

   if (pDC->IsPrinting())
   {
      PrintImage(pDC);
      return;
   }

   CSize imgSize = pDoc->GetImageSize();
   CRect imgRect = CRect(0, 0, imgSize.cx, imgSize.cy);

   CRect updateRect = ((CPaintDC*)pDC)->m_ps.rcPaint;

   if (imgSize.cx * imgSize.cy > 10000000)
      AfxGetApp()->DoWaitCursor(1);

   pDoc->Draw(pDC, CRect(0,0,imgSize.cx, imgSize.cy));

   AfxGetApp()->DoWaitCursor(-1);
}

/*
set scroll sizes
*/
void CISImageDemoView::OnInitialUpdate()
{
   CScrollView::OnInitialUpdate();

   OnNewImage();
}

/////////////////////////////////////////////////////////////////////////////
// CISImageDemoView printing

BOOL CISImageDemoView::OnPreparePrinting(CPrintInfo* pInfo)
{
   // default preparation
   return DoPreparePrinting(pInfo);
}

void CISImageDemoView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
   // TODO: add extra initialization before printing
}

void CISImageDemoView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
   // TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CISImageDemoView diagnostics

#ifdef _DEBUG
void CISImageDemoView::AssertValid() const
{
   CScrollView::AssertValid();
}

void CISImageDemoView::Dump(CDumpContext& dc) const
{
   CScrollView::Dump(dc);
}

CISImageDemoDoc* CISImageDemoView::GetDocument() // non-debug version is inline
{
   ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CISImageDemoDoc)));
   return (CISImageDemoDoc*)m_pDocument;
}
#endif //_DEBUG


/*
time to update something...
*/
void CISImageDemoView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
   switch (lHint)
   {
   case eHintNewImage:
      OnNewImage();
      break;
   }
}

/*
Set our scroll sizes to fit the image. This doesn't
change the window size, only the size that the scroll bars
use.
*/
void CISImageDemoView::OnNewImage()
{
   CISImageDemoDoc* pDoc = GetDocument();
   CSize imgSize = pDoc->GetImageSize();
   //imgSize+=CSize(2, 2);

   CSize setSize = imgSize;

   SetScrollSizes(MM_TEXT, setSize);
   ResizeParentToFit(TRUE);

   CRect cr;
   GetClientRect(cr);
   if (imgSize.cx > cr.Width())
   {
      SetScrollPos(SB_HORZ, imgSize.cx / 3);
   }

   if (imgSize.cy > cr.Height())
   {
      SetScrollPos(SB_VERT, imgSize.cy / 3);
   }
   Invalidate(TRUE);
}

/*
First, try to using ISDrawHBITMAP to BitBlt the doc's CBitmap to the 
printer. If that fails, we'll try to StretchDraw it.
*/
void CISImageDemoView::PrintImage(CDC *pDC)
{
   CISImageDemoDoc* pDoc = GetDocument();
   ASSERT_VALID(pDoc);

   // how big is this image?
   CSize imgSize = pDoc->GetImageSize();
   if ((imgSize.cx <= 0) || (imgSize.cy <= 0))
   {
      return;
   }

   CRect imgRect = CRect(0, 0, imgSize.cx, imgSize.cy);

   // get the CBitmap image
   CBitmap *pImage = pDoc->GetImageCBitmap();
   if (pImage->GetSafeHandle()==NULL)
      return;

   imgRect.NormalizeRect();

   // set DPI for accurate drawing
   CSize imgDpi = pDoc->GetImageDPI();


   if ((imgDpi.cx <= 0) || (imgDpi.cy <= 0))
   {
      imgDpi = CSize(72, 72);
   }

   // adjust our DC's extents to fit the DPI
   pDC->SetMapMode(MM_ISOTROPIC); 
   pDC->SetWindowExt(imgDpi); 
   pDC->SetViewportExt(pDC->GetDeviceCaps(LOGPIXELSX), pDC->GetDeviceCaps(LOGPIXELSY)); 

   // find out what this printer can do
   int iCaps = pDC->GetDeviceCaps(RASTERCAPS);

   // if we can use bitblt, use it
   if (((iCaps & RC_BITBLT) == RC_BITBLT) && ((iCaps & RC_BITMAP64) == RC_BITMAP64))
   {
      TRACE(_T("PrintImage : GetDeviceCaps says RC_BITBLT && RC_BITMAP64 OK. Trying ISDrawHBITMAP\n"));

      if (!pDoc->Draw(pDC, CRect(0,0,imgSize.cx, imgSize.cy)))
      {
         // try this instead
         TRACE(_T("PrintImage : ISDrawHBITMAP Failed\n"));
         StretchPrint(pDC, imgRect);
      }
   }
   else
   {
      StretchPrint(pDC, imgRect);
   }
}

/////////////////////////////////////////////////////////////////////////////

void CISImageDemoView::StretchPrint(CDC *pDC, CRect imgRect)
{
   // find out what this printer can do
   int iCaps = pDC->GetDeviceCaps(RASTERCAPS);
   if ((iCaps & RC_STRETCHDIB) == RC_STRETCHDIB)
   {
      TRACE( _T("StretchPrint : GetDeviceCaps says RC_STRETCHDIB ok. Trying StretchDraw\n") );
      CISImageDemoDoc* pDoc = GetDocument();

      // internally, this is StretchDIBits
      VERIFY(pDoc->StretchDraw(pDC, imgRect)==IS_ERR_OK);
   }
   else
   {
      TRACE( _T("StretchPrint : GetDeviceCaps says no RC_STRETCHDIB\n") );
   }
}

/////////////////////////////////////////////////////////////////////////////

void CISImageDemoView::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
   CScrollView::OnLButtonDblClk(nFlags, point);
}

BOOL CISImageDemoView::OnEraseBkgnd(CDC* pDC)
{
   CISImageDemoDoc* pDoc = GetDocument();

   // Set brush to desired background color
   CBrush backBrush(pDoc->GetBackgroundColor());

   // Save old brush
   CBrush* pOldBrush = pDC->SelectObject(&backBrush);

   CRect rect;
   pDC->GetClipBox(&rect);     // Erase the area needed

   pDC->PatBlt(rect.left, rect.top, rect.Width(), rect.Height(),
      PATCOPY);
   pDC->SelectObject(pOldBrush);
   return TRUE;
}
