// ISImagedemoAniGIFDoc.cpp : implementation file
//

#include "stdafx.h"
#include "ISImageDemo.h"
#include "ISImagedemoAniGIFDoc.h"


// CISImagedemoAniGIFDoc

IMPLEMENT_DYNCREATE(CISImagedemoAniGIFDoc, CDocument)

CISImagedemoAniGIFDoc::CISImagedemoAniGIFDoc()
{
   m_GIFANI = NULL;
}

BOOL CISImagedemoAniGIFDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;
	return TRUE;
}

CISImagedemoAniGIFDoc::~CISImagedemoAniGIFDoc()
{
   if (m_GIFANI)
   {
      _ISFn(is6_DestroyAnimatedGIFRender)(m_GIFANI);
   }
}


BEGIN_MESSAGE_MAP(CISImagedemoAniGIFDoc, CDocument)
END_MESSAGE_MAP()


// CISImagedemoAniGIFDoc diagnostics

#ifdef _DEBUG
void CISImagedemoAniGIFDoc::AssertValid() const
{
	CDocument::AssertValid();
}

#ifndef _WIN32_WCE
void CISImagedemoAniGIFDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif
#endif //_DEBUG

#ifndef _WIN32_WCE
// CISImagedemoAniGIFDoc serialization

void CISImagedemoAniGIFDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}
#endif


BOOL CISImagedemoAniGIFDoc::OnOpenDocument(LPCTSTR pFilename) 
{
    CWaitCursor waitHere;

    UINT res;

    HISSRC hSrc = _ISFn(is6_OpenFileSource)(pFilename);
    if (hSrc==NULL)
    {
       res = _ISFn(is6_GetLastError)();

       AfxMessageBox(CISImageEx::ErrorString(res));
       return FALSE;
    }

    UINT32 w, h;
    m_GIFANI = _ISFn(is6_AnimatedGIFRenderInit)(hSrc, &w, &h, 0);

    if (m_GIFANI==NULL)
    {
       res = _ISFn(is6_GetLastError)();

       _ISFn(is6_CloseSource)(hSrc);

       AfxMessageBox(CISImageEx::ErrorString(res));
       return FALSE;
    }
    _ISFn(is6_CloseSource)(hSrc);

    m_GIFSize.cx = w;
    m_GIFSize.cy = h;

    UpdateImage();

    SetTitle(pFilename);

    return TRUE;
}

///////////////////////////////////////////////////

void CISImagedemoAniGIFDoc::UpdateImage()
{
    // force a redraw and a scroll bar recalc
    UpdateAllViews(NULL, eHintNewImage, NULL);
}

///////////////////////////////////////////////////

BOOL  CISImagedemoAniGIFDoc::PrepareNextFrame(UINT32 &ticksForNext)  
{
   if (!m_image.ISValid() || m_image.Size() != m_GIFSize)
   {
      m_image.AllocBlank(m_GIFSize, 32);
   }

   BOOL ok = _ISFn(is6_AnimatedGIFRenderNextFrame)(m_GIFANI, m_image.ImageData(), &ticksForNext, 0);

   return ok;
}