#pragma once

#include "ISImageEx.h"

// CISImagedemoAniGIFDoc document

class CISImagedemoAniGIFDoc : public CDocument
{
	DECLARE_DYNCREATE(CISImagedemoAniGIFDoc)

public:
	CISImagedemoAniGIFDoc();
	virtual ~CISImagedemoAniGIFDoc();
#ifndef _WIN32_WCE
	virtual void Serialize(CArchive& ar);   // overridden for document i/o
#endif
#ifdef _DEBUG
	virtual void AssertValid() const;
#ifndef _WIN32_WCE
	virtual void Dump(CDumpContext& dc) const;
#endif
#endif

   CSize			GetImageSize()			{return m_GIFSize;}
   CISImageEx&	GetImage()			   {return m_image;}
   void        GetImagePalette(CPalette &p)    {m_image.MakeImagePalette(p);}

   // draw our CBitmap into a rect on a DC using m_image's palette
   // we just assume that the palette and the CBitmap were based on the
   // same image                     
   BOOL        PrepareNextFrame(UINT32 &ticksForNext);

   BOOL        StretchDraw(CDC *pDC, const CRect & outRect);

   void UpdateImage();

protected:
   CSize         m_GIFSize;
   HISGIFANI     m_GIFANI;

   CISImageEx    m_image;
   
   CPalette    m_pal;

	virtual BOOL OnNewDocument();
   BOOL OnOpenDocument(LPCTSTR pFilename) ;

	DECLARE_MESSAGE_MAP()
};
