/*---------------------------------------------------------
   ISZLibComp.h : part of the ImgSource library.

   Generic data de/compression functions.

   This code copyright (c) 2000-2014, Smaller Animals Software, Inc..

   No portion of this code may be copied or distributed without 
   permission of Smaller Animals Software, Inc..
   http://www.smalleranimals.com

---------------------------------------------------------*/

#ifndef is6_ZLIBDEFLATEOH
#define is6_ZLIBDEFLATEOH

#if !defined is6_SOURCEH && !defined is6_INTERNAL
#error Need to include ISource.h before this file.
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*---------------------------------------------------------
   is6_ZDeflateBuffer / _is6_ZDeflateBuffer

   Purpose : 
   Compress a buffer of data using zLib's deflate method.

   Output buffer is allocated by the caller and should be
   at least 140% the size of uInLen. 

   Param             Use
   ------------------------------------
   pIn               data to be compressed
   uInLen            length of data to be compressed
   pOut              output buffer (allocated by caller)
   uOutLen           size of output buffer

   uLevel            0 = default
                     1 = no compression
                     2 = low compression
                     ...
                     9 = highest compression

                     higher compression takes longer.

   uFlags            bits     use
                     ----     ---

                     8-9      compression strategy.

                              00 - default
                              01 - assumes input has been filtered with a predictor.
                                    more Huffman coding, less string matching.
                              10 - Huffman encoding only
                              11 - Z_RLE (Run Length Encoding)
   Return
   ------
   size of compressed data
---------------------------------------------------------*/
   _ISDeclSpec UINT32        _ISCConv _ISFn(is6_ZDeflateBuffer)(const BYTE *pIn, UINT32 uInLen, BYTE *pOut, UINT32 uOutLen, UINT32 uLevel, UINT32 uFlags);

/*---------------------------------------------------------
   is6_ZInflateBuffer / _is6_ZInflateBuffer

   Purpose : 
   Decompress a buffer of data using zLib's inflate method.

   The buffer must have been compressed using zLib's deflate 
   method (preferrably via is6_ZDeflateBuffer - buffers compressed
   by any other means may not work here). 

   Output buffer is allocated by the caller and should be
   large enough to handle the decompressed data. It's up to the
   caller to know the size of the decompressed data.

   Param             Use
   ------------------------------------
   pIn               data to be decompressed
   uInLen            length of data to be decompressed
   pOut              output buffer (allocated by caller)
   uOutLen           size of output buffer
   uFlags            unused

   Return
   ------
   size of decompressed data
---------------------------------------------------------*/
   _ISDeclSpec UINT32        _ISCConv _ISFn(is6_ZInflateBuffer)(const BYTE *pIn, UINT32 uInLen, BYTE *pOut, UINT32 uOutLen, UINT32 uFlags);

#ifdef __cplusplus
}
#endif

#endif