// OverlayPickerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ISImageDemo.h"
#include "OverlayPickerDlg.h"
#include "afxdialogex.h"
#include "isimagedemodoc.h"


// COverlayPickerDlg dialog

IMPLEMENT_DYNAMIC(COverlayPickerDlg, CDialogEx)

COverlayPickerDlg::COverlayPickerDlg(std::vector< CISImageDemoDoc* > & listDocs, CWnd* pParent /*=NULL*/)
: CDialogEx(COverlayPickerDlg::IDD, pParent),
m_listDocs(listDocs)
, m_docIdx(0)
{

}

COverlayPickerDlg::~COverlayPickerDlg()
{
}

void COverlayPickerDlg::DoDataExchange(CDataExchange* pDX)
{
   CDialogEx::DoDataExchange(pDX);
   DDX_Control(pDX, IDC_DOC_LIST, m_docList);
   DDX_Control(pDX, IDC_MODE_LIST, m_modeList);
   DDX_LBIndex(pDX, IDC_DOC_LIST, m_docIdx);
}


BEGIN_MESSAGE_MAP(COverlayPickerDlg, CDialogEx)
END_MESSAGE_MAP()


// COverlayPickerDlg message handlers

static void AddModeString(CComboBox & cb, const char *p, CISImageEx::overlayMode i)
{
   int idx = cb.AddString(p);
   cb.SetItemData(idx, (int)i);
}

BOOL COverlayPickerDlg::OnInitDialog()
{
   CDialogEx::OnInitDialog();

   AddModeString(m_modeList, "Solid", CISImageEx::overlayMode::eSolid); 
   AddModeString(m_modeList, "50% Blend", CISImageEx::overlayMode::eBlendFast);
   AddModeString(m_modeList, "Max", CISImageEx::overlayMode::eMax);
   AddModeString(m_modeList, "Min", CISImageEx::overlayMode::eMin);
   AddModeString(m_modeList, "Add", CISImageEx::overlayMode::eAdd);
   AddModeString(m_modeList, "Sub", CISImageEx::overlayMode::eSubBottomMinusTop);

   AddModeString(m_modeList, "Hard Light", CISImageEx::overlayMode::eHardLight);
   AddModeString(m_modeList, "Color Dodge", CISImageEx::overlayMode::eColorDodge);
   AddModeString(m_modeList, "Color Burn", CISImageEx::overlayMode::eColorBurn);
   AddModeString(m_modeList, "Screen", CISImageEx::overlayMode::eScreen);
   AddModeString(m_modeList, "Vivid LIght", CISImageEx::overlayMode::eVividLight);

   AddModeString(m_modeList, "AND", CISImageEx::overlayMode::eAnd);
   AddModeString(m_modeList, "OR", CISImageEx::overlayMode::eOr);
   AddModeString(m_modeList, "XOR", CISImageEx::overlayMode::eXor);

   m_modeList.SetCurSel(1);

   for (std::vector< CISImageDemoDoc* >::iterator it = m_listDocs.begin();
      it != m_listDocs.end();
      it++)
   {
      CString str;
      str = (*it)->GetTitle();
      m_docList.AddString(str);
   }
   m_docList.SetCurSel(0);

   return TRUE;  // return TRUE unless you set the focus to a control
   // EXCEPTION: OCX Property Pages should return FALSE
}


void COverlayPickerDlg::OnOK()
{
   UpdateData(1);

   int idx = m_modeList.GetCurSel();

   m_mode = (CISImageEx::overlayMode)m_modeList.GetItemData(idx);

   CDialogEx::OnOK();
}
