// ISImageDemoDoc.h : interface of the CISImageDemoDoc class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_ISIMAGEDEMODOC_H__988D2F6E_FD70_11D2_A086_00500402F30B__INCLUDED_)
#define AFX_ISIMAGEDEMODOC_H__988D2F6E_FD70_11D2_A086_00500402F30B__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "ISImageEx.h"

class CISImageDemoDoc : public CDocument
{
protected: // create from serialization only
	CISImageDemoDoc();
	DECLARE_DYNCREATE(CISImageDemoDoc)

// Attributes
public:

// Operations
public:
	CSize			GetImageSize()			{return m_image.Size();}
	CSize			GetImageDPI()			{return m_image.GetDPIInches();}
	CBitmap *	GetImageCBitmap()		{return &m_cBmp;}
   void        GetImagePalette(CPalette &p)    {m_image.MakeImagePalette(p);}
   COLORREF    GetBackgroundColor();


   COLORREF    GuessImageBackgroundColor();

   // draw our CBitmap into a rect on a DC using m_image's palette
   // we just assume that the palette and the CBitmap were based on the
   // same image                     
   BOOL        Draw(const CDC *pDC, const CRect & outRect);

   BOOL        StretchDraw(CDC *pDC, const CRect & outRect);


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CISImageDemoDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	//}}AFX_VIRTUAL

   BOOL OnOpenDocument(LPCTSTR pFilename) ;

// Implementation
public:
	virtual ~CISImageDemoDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

   CISImageEx    m_image;

protected:
   
   CBitmap     m_cBmp;
   CPalette    m_pal;

// Generated message map functions
protected:
	//{{AFX_MSG(CISImageDemoDoc)
	afx_msg void OnFileSaveAs();
	afx_msg void OnEditResize();
	afx_msg void OnEditHorizontalflip();
	afx_msg void OnEditVerticalflip();
	afx_msg void OnSharpen();
	afx_msg void OnBlur();
	afx_msg void OnExif();
	afx_msg void OnIptc();
	afx_msg void OnRotate();
	afx_msg void OnAutocrop();
	afx_msg void OnCentersharp();
	afx_msg void OnEditPaste();
	afx_msg void OnColors();
	afx_msg void OnDeskew();
	afx_msg void OnFileSave();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()


   void  UpdateImage();
public:
   afx_msg void OnUpdate_Valid(CCmdUI* pCmdUI);
   afx_msg void OnUpdate_32_24_8G(CCmdUI* pCmdUI);
   afx_msg void OnUpdate_32_24(CCmdUI* pCmdUI);
   afx_msg void OnUpdate_24(CCmdUI* pCmdUI);
   afx_msg void OnUpdate_8G_1(CCmdUI* pCmdUI);
   afx_msg void OnUpdate_8G(CCmdUI* pCmdUI);
   afx_msg void OnUpdate_1(CCmdUI* pCmdUI);
   afx_msg void OnUpdate_MultiDocs(CCmdUI* pCmdUI);
   
   afx_msg void OnMoreimagestuffWaveletdenoise();
   afx_msg void OnGaussianblurSmall();
   afx_msg void OnGaussianblurMedium();
   afx_msg void OnGaussianblurHuge();
   afx_msg void OnBlursRadialblur();
   afx_msg void OnBlursZoomblur();
   afx_msg void OnBlursMotionblur();

   afx_msg void OnFiltersUnsharpMask();
   afx_msg void OnFiltersMedian();
   afx_msg void OnFiltersMin();
   afx_msg void OnFiltersMax();
   afx_msg void OnFiltersBilateral();
   afx_msg void OnFiltersMidpoint();
   afx_msg void OnFiltersArithmeticmean();

   afx_msg void OnFiltersSobel();
   afx_msg void OnMakesomenoiseGaussian();
   afx_msg void OnMakesomenoiseRayleigh();
   afx_msg void OnMakesomenoisePerlin();
   afx_msg void OnPrettycolorsDoutone();
   afx_msg void OnPrettycolorsPosterize();
   afx_msg void OnPrettycolorsMosaic();
   afx_msg void OnPrettycolorsGauzy();
   afx_msg void OnPrettycolorsCrackle();


   afx_msg void OnMorphologicalErosion();
   afx_msg void OnMorphologicalDilation();
   afx_msg void OnMorphologicalOpen();
   afx_msg void OnMorphologicalClose();
   afx_msg void OnMorphologicalTophat();
   afx_msg void OnMorphologicalGradient();
   afx_msg void OnMorphologicalThinning();
   afx_msg void OnMorphologicalBoundaryextraction();
   afx_msg void OnMorphologicalHitormiss();
   afx_msg void OnPrettycolorsInvert();
   afx_msg void OnGeometryLine();
   afx_msg void OnGeometryThickline();
   afx_msg void OnGeometryEllipse();
   afx_msg void OnGeometryPolygon();
   afx_msg void OnMoreimagestuffSeamcarve();
   afx_msg void OnPrettycolorsRetinex();
   afx_msg void OnSaturationMore();
   afx_msg void OnSaturationLess();
   afx_msg void OnVibranceMore();
   afx_msg void OnVibranceLess();
   afx_msg void OnMoreimagestuffOverlay();
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_ISIMAGEDEMODOC_H__988D2F6E_FD70_11D2_A086_00500402F30B__INCLUDED_)
