﻿/*
C# Function declarations for ImgSource.

Built at ImgSource version 6.0.4.3

Copyrith 2016, Smaller Animals Software Inc.
*/
using System;
using System.Runtime.InteropServices;

// everything in here is static
class IS6
{
    // standard Windows structures
    [StructLayout(LayoutKind.Sequential)]
    public struct RECT
    {
        public Int32 x1;
        public Int32 y1;
        public Int32 x2;
        public Int32 y2;
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct RGBQUAD
    {
        public byte rgbRed;
        public byte rgbGreen;
        public byte rgbBlue;
        public byte rgbReserved;
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct BITMAPINFOHEADER
    {
        public UInt32 biSize;
        public Int32 biWidth;
        public Int32 biHeight;
        public UInt16 biPlanes;
        public UInt16 biBitCount;
        public UInt32 biCompression;
        public UInt32 biSizeImage;
        public Int32 biXPelsPerMeter;
        public Int32 biYPelsPerMeter;
        public UInt32 biClrUsed;
        public UInt32 biClrImportant;
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct POINT
    {
        public Int32 x;
        public Int32 y;
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct LOGFONT
    {
        public Int32 lfHeight;
        public Int32 lfWidth;
        public Int32 lfEscapement;
        public Int32 lfOrientation;
        public Int32 lfWeight;
        public Byte lfItalic;
        public Byte lfUnderline;
        public Byte lfStrikeOut;
        public Byte lfCharSet;
        public Byte lfOutPrecision;
        public Byte lfClipPrecision;
        public Byte lfQuality;
        public Byte lfPitchAndFamily;
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
        public string lfFaceName;
    }

    // ImgSource structures
    [StructLayout(LayoutKind.Sequential)]
    public struct XYdouble
    {
        public double x;
        public double y;
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct ISQuadrilateral
    {
        public POINT topLeft;
        public POINT bottomLeft;
        public POINT topRight;
        public POINT bottomRight;
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct IS4DPIStruct
    {
        public double fDPIX;
        public double fDPIY;
        public UInt32 uDPIUnits;
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct ISDPIStruct
    {
        public UInt32 uDPIX;
        public UInt32 uDPIY;
        public UInt32 uDPIUnits;
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct ISPSDThumbnailInfo
    {
        public Int32 colorOrder;
        public Int32 format;
        public Int32 width;
        public Int32 height;
        public Int32 widthbytes;
        public Int32 size;
        public Int32 csize;
        public short bitspixel;
        public short planes;
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct ISGGStruct
    {
        public UInt32 imageCount;
        public UInt32 width;
        public UInt32 height;
        public UInt32 loopCount;
        public UInt32 backGround;
        public Int32 trans;
        public RGBQUAD[] palette;
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct ISGFStruct
    {
        public UInt32 index;
        public UInt32 imageType;
        public IntPtr hImage;
        public UInt32 width;
        public UInt32 height;
        public UInt32 xpos;
        public UInt32 ypos;
        public UInt32 ticks;
        public UInt32 disposalMethod;
        public UInt32 inputFlag;
        public UInt32 palType;
        public UInt32 clrTransIndex;
        public RGBQUAD[] palette;
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct ISGFStructEx
    {
        public UInt32 index;
        public UInt32 imageType;
        public IntPtr hImage;
        public UInt32 width;
        public UInt32 height;
        public UInt32 xpos;
        public UInt32 ypos;
        public UInt32 ticks;
        public UInt32 disposalMethod;
        public UInt32 inputFlag;
        public UInt32 palType;
        public Int32 clrTransIndex;
        public bool bIsInterlaced;
        public RGBQUAD[] palette;
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct ISIconStruct
    {
        public UInt32 index;
        public IntPtr hDIBXOR;
        public IntPtr hDIBAND;
        public UInt32 width;
        public UInt32 height;
        public UInt32 bitDepth;
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct IS_Painterly_Opts
    {
        public Int32 maxStrokeLen;    // 12
        public Int32 minStrokeLen;    // 4
        public double fCurve;       // .5
        public double threshold;    // 50
        public double blurFactor;   // .95
        public bool bSimplfy;       // FALSE
        public Int32 maxBrushSize;    // 8
        public Int32 brushes;         // 3
        public double opacity;      // FALSE
        public bool roundEnds;      // TRUE
        public bool blurStrokeEdges;   // FALSE
        public Int32 outlineClr;    // RGB(0,0,0)
        public bool drawOutlines;      // FALSE
    }
    
    ////////////////////////////////////////////////////////
    // callback function definition
    public delegate Int32 ISCALLBACKPTR(UInt32 uCurrent, UInt32 uTotal, ref IntPtr uUserData);

    ////////////////////////////////////////////////////////
    // memory alloc callback function definitions
    public delegate Int32 IS3IMGMEM_ALLOC_CBPTR(UInt32 uSize, IntPtr uUserData);
    public delegate Int32 IS3IMGMEM_REALLOC_CBPTR(IntPtr pData, UInt32 uSize, IntPtr uUserData);
    public delegate Int32 IS3IMGMEM_FREE_CBPTR(IntPtr pData, IntPtr uUserData);

    ////////////////////////////////////////////////////////
    // User source / dest function types
    public delegate Int32 is6_SourceOpenFn(IntPtr uUserInfo);
    public delegate UInt32 is6_SourceReadFn(IntPtr pData, UInt32 uDataLen, IntPtr uUserInfo);
    public delegate Int32 is6_SourceWriteFn(IntPtr pData, UInt32 uDataLen, IntPtr uUserInfo);
    public delegate Int32 is6_SourceSeekFn(Int32 uOffset, UInt32 uOrigin, IntPtr uUserInfo);
    public delegate Int32 is6_SourceGetPosFn(IntPtr uUserInfo, ref UInt32 puPos);
    public delegate Int32 is6_SourceGetSizeFn(IntPtr uUserInfo, ref UInt32 puSize);
    public delegate Int32 is6_SourceEOFFn(IntPtr uUserInfo);
    public delegate Int32 is6_SourceCloseFn(IntPtr uUserInfo);

    ////////////////////////////////////////////////////////
    // multi-page TIFF writing callback
    public delegate Int32 is6_TIFFMULTIPAGE_CBPTR(IntPtr pImageArray, IntPtr nWidthArray, IntPtr nHeightArray, IntPtr pPalArray, IntPtr uBitsPerPixelArray, IntPtr uCompressionArrat, IntPtr pDPIArray, IntPtr uData);

    ////////////////////////////////////////////////////////
    // progressive JPEG reading callback
    public delegate Int32 is6_JPG_PROGREAD_CBPTR(IntPtr hImageData, UInt32 uWidth, UInt32 uHeight, UInt32 uBPP, UInt32 uPass, IntPtr uUserData);


    ////////////////////////////////////////////////////////
    // user transform callback function
    public delegate Int32 ISXFORMCALLBACK(double fCurX, double fCurY, ref double pFromX, ref double pFormY, IntPtr uUserData);

    ////////////////////////////////////////////////////////
    // error reporting callback function
    public delegate Int32 ISERRORCALLBACK(UInt32 uErrorCode, [MarshalAs(UnmanagedType.LPStr)] string pErrorText, IntPtr uUserData);




    // now, the functions

    ////////////////////////////////////////////////////////////////////////////////
    //   HISEXIFREADER is6_EXIFCreateReader(HISSRC hSource, UINT32 uFrameIdx, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_EXIFCreateReader")]
    public static extern IntPtr _is6_EXIFCreateReader(IntPtr hSource, UInt32 uFrameIdx, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HISEXIFREADER is6_EXIFCreateReaderFromByteArray(const BYTE * pData, UINT32 uDataLen, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_EXIFCreateReaderFromByteArray")]
    public static extern IntPtr _is6_EXIFCreateReaderFromByteArray(IntPtr pData, UInt32 uDataLen, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_EXIFGetTagData(HISEXIFREADER hEXIFData, UINT32 uTag, UINT32 uFlags, UINT32 *puTagType, HGLOBAL *phData, UINT32 *puLen);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_EXIFGetTagData")]
    public static extern bool _is6_EXIFGetTagData(IntPtr hEXIFData, UInt32 uTag, UInt32 uFlags, ref UInt32 puTagType, ref IntPtr phData, ref UInt32 puLen);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_EXIFGetString(HISEXIFREADER hEXIFReader, UINT32 uTag, UINT32 uFlags, HGLOBAL *phString, UINT32 *puLen);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_EXIFGetString")]
    public static extern bool _is6_EXIFGetString(IntPtr hEXIFReader, UInt32 uTag, UInt32 uFlags, ref IntPtr phString, ref UInt32 puLen);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_EXIFGetTagList(HISEXIFREADER hEXIFReader, HGLOBAL *phString, UINT32 *puLen, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_EXIFGetTagList")]
    public static extern bool _is6_EXIFGetTagList(IntPtr hEXIFReader, ref IntPtr phString, ref UInt32 puLen, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_EXIFGetTagListData(HISEXIFREADER hEXIFData, HGLOBAL *phData, UINT32 *puLen, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_EXIFGetTagListData")]
    public static extern bool _is6_EXIFGetTagListData(IntPtr hEXIFData, ref IntPtr phData, ref UInt32 puLen, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_EXIFGetThumbnail(HISEXIFREADER hEXIFReader, HGLOBAL *phData, UINT32 *puDataLen);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_EXIFGetThumbnail")]
    public static extern bool _is6_EXIFGetThumbnail(IntPtr hEXIFReader, ref IntPtr phData, ref UInt32 puDataLen);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_EXIFGetUserComment(HISEXIFREADER hEXIFReader, HGLOBAL *phData, UINT32 *puDataLen);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_EXIFGetUserComment")]
    public static extern bool _is6_EXIFGetUserComment(IntPtr hEXIFReader, ref IntPtr phData, ref UInt32 puDataLen);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_EXIFGetTagPos(HISEXIFREADER hEXIFReader, UINT32 uTag, UINT32 uFlags, __int32 *puPos, __int32 *puIFDPos, UINT32 *puOutFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_EXIFGetTagPos")]
    public static extern bool _is6_EXIFGetTagPos(IntPtr hEXIFReader, UInt32 uTag, UInt32 uFlags, ref Int32 puPos, ref Int32 puIFDPos, ref UInt32 puOutFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_EXIFDestroyReader(HISEXIFREADER hEXIFReader);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_EXIFDestroyReader")]
    public static extern bool _is6_EXIFDestroyReader(IntPtr hEXIFReader);

    ////////////////////////////////////////////////////////////////////////////////
    //   HISEXIFWRITER is6_EXIFCreateWriter(UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_EXIFCreateWriter")]
    public static extern IntPtr _is6_EXIFCreateWriter(UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_EXIFWriterAddTag(HISEXIFWRITER hEXIFWriter, UINT32 uTagID, UINT32 uTagType, UINT32 uDataCount, const void *pData, UINT32 uIFD, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_EXIFWriterAddTag")]
    public static extern bool _is6_EXIFWriterAddTag(IntPtr hEXIFWriter, UInt32 uTagID, UInt32 uTagType, UInt32 uDataCount, IntPtr pData, UInt32 uIFD, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_EXIFWriteTags(HISEXIFWRITER hEXIFWriter, HGLOBAL *phData, UINT32 *puDataLen, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_EXIFWriteTags")]
    public static extern bool _is6_EXIFWriteTags(IntPtr hEXIFWriter, ref IntPtr phData, ref UInt32 puDataLen, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_EXIFCopyTagsToWriter(HISEXIFWRITER hEXIFWriter, HISEXIFREADER hEXIFReader, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_EXIFCopyTagsToWriter")]
    public static extern bool _is6_EXIFCopyTagsToWriter(IntPtr hEXIFWriter, IntPtr hEXIFReader, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_EXIFSetThumbnailInWriter(HISEXIFWRITER hEXIFWriter, const BYTE *pThumbnailData, UINT32 uDataLen, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_EXIFSetThumbnailInWriter")]
    public static extern bool _is6_EXIFSetThumbnailInWriter(IntPtr hEXIFWriter, IntPtr pThumbnailData, UInt32 uDataLen, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_EXIFDestroyWriter(HISEXIFWRITER hEXIFWriter, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_EXIFDestroyWriter")]
    public static extern bool _is6_EXIFDestroyWriter(IntPtr hEXIFWriter, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetJPGDims(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, UINT32 *puBitDepth, UINT32 *puColorSpace, UINT32 * puFlags, IS4DPIStruct *pDPIStruct, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetJPGDims")]
    public static extern bool _is6_GetJPGDims(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, ref UInt32 puBitDepth, ref UInt32 puColorSpace, ref UInt32 puFlags, ref IS4DPIStruct pDPIStruct, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetPNGDims(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, UINT32 *puBitDepth, UINT32 *puColorType, UINT32 *puInterlaceType, UINT32 * puTransIndex, UINT32 * puTransRed, UINT32 * puTransGreen, UINT32 * puTransBlue, UINT32 * puTransGray, IS4DPIStruct *pDPIStruct, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetPNGDims")]
    public static extern bool _is6_GetPNGDims(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, ref UInt32 puBitDepth, ref UInt32 puColorType, ref UInt32 puInterlaceType, ref UInt32 puTransIndex, ref UInt32 puTransRed, ref UInt32 puTransGreen, ref UInt32 puTransBlue, ref UInt32 puTransGray, ref IS4DPIStruct pDPIStruct, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetPNGPalette(HISSRC hSource, UINT32 *pPalColors, RGBQUAD *pPal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetPNGPalette")]
    public static extern bool _is6_GetPNGPalette(IntPtr hSource, ref UInt32 pPalColors, IntPtr pPal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetTIFFDims(HISSRC hSource, UINT32 uPageIndex, UINT32 *puWidth, UINT32 *puHeight, UINT32 *puBitDepth, IS4DPIStruct *pDPIStruct, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetTIFFDims")]
    public static extern bool _is6_GetTIFFDims(IntPtr hSource, UInt32 uPageIndex, ref UInt32 puWidth, ref UInt32 puHeight, ref UInt32 puBitDepth, ref IS4DPIStruct pDPIStruct, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetBMPDims(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, UINT32 *puBitDepth, IS4DPIStruct *pDPIStruct, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetBMPDims")]
    public static extern bool _is6_GetBMPDims(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, ref UInt32 puBitDepth, ref IS4DPIStruct pDPIStruct, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetBMPPalette(HISSRC hSource, UINT32 *pPalColors, RGBQUAD *pPal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetBMPPalette")]
    public static extern bool _is6_GetBMPPalette(IntPtr hSource, ref UInt32 pPalColors, IntPtr pPal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetPCXDims(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, UINT32 *puBitDepth, IS4DPIStruct* pDPI, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetPCXDims")]
    public static extern bool _is6_GetPCXDims(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, ref UInt32 puBitDepth, ref IS4DPIStruct pDPI, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetPCXPalette(HISSRC hSource, UINT32 *pPalColors, RGBQUAD *pPal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetPCXPalette")]
    public static extern bool _is6_GetPCXPalette(IntPtr hSource, ref UInt32 pPalColors, IntPtr pPal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetTGADims(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, UINT32 *puBitDepth, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetTGADims")]
    public static extern bool _is6_GetTGADims(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, ref UInt32 puBitDepth, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetTGAPalette(HISSRC hSource, UINT32 *pPalColors, RGBQUAD *pPal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetTGAPalette")]
    public static extern bool _is6_GetTGAPalette(IntPtr hSource, ref UInt32 pPalColors, IntPtr pPal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetPAXDims(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, UINT32 *puBitDepth, const char *pPassword, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetPAXDims")]
    public static extern bool _is6_GetPAXDims(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, ref UInt32 puBitDepth,
    [MarshalAs(UnmanagedType.LPStr)]
    string pPassword, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetPAXPalette(HISSRC hSource, const char *pPassword, UINT32 *pPalColors, RGBQUAD *pPal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetPAXPalette")]
    public static extern bool _is6_GetPAXPalette(IntPtr hSource,
    [MarshalAs(UnmanagedType.LPStr)]
    string pPassword, ref UInt32 pPalColors, IntPtr pPal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetPSDDims(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, UINT32 *puBitDepth, UINT32 *puMode, IS4DPIStruct *pDPIStruct, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetPSDDims")]
    public static extern bool _is6_GetPSDDims(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, ref UInt32 puBitDepth, ref UInt32 puMode, ref IS4DPIStruct pDPIStruct, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetPSDPalette(HISSRC hSource, UINT32 *pPalColors, RGBQUAD *pPal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetPSDPalette")]
    public static extern bool _is6_GetPSDPalette(IntPtr hSource, ref UInt32 pPalColors, IntPtr pPal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetTLADims(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, UINT32 *puBitDepth, const char *pPassword, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetTLADims")]
    public static extern bool _is6_GetTLADims(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, ref UInt32 puBitDepth,
    [MarshalAs(UnmanagedType.LPStr)]
    string pPassword, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetTLAPalette(HISSRC hSource, const char *pKey, UINT32 *pPalColors, RGBQUAD *pPal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetTLAPalette")]
    public static extern bool _is6_GetTLAPalette(IntPtr hSource,
    [MarshalAs(UnmanagedType.LPStr)]
    string pKey, ref UInt32 pPalColors, IntPtr pPal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetWBMPDims(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetWBMPDims")]
    public static extern bool _is6_GetWBMPDims(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_GetPCDIndexImageCount(HISSRC hSource, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetPCDIndexImageCount")]
    public static extern UInt32 _is6_GetPCDIndexImageCount(IntPtr hSource, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetGIFDims(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, UINT32 *puBitDepth, __int32 *piBackgdIdx, __int32 *piTransIdx, RGBQUAD *pal, BOOL *pbInterlaced, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetGIFDims")]
    public static extern bool _is6_GetGIFDims(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, ref UInt32 puBitDepth, ref Int32 piBackgdIdx, ref Int32 piTransIdx, IntPtr pal, ref bool pbInterlaced, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetPNMDims(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, UINT32 *puMaxVal, UINT32 *pFormat, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetPNMDims")]
    public static extern bool _is6_GetPNMDims(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, ref UInt32 puMaxVal, ref UInt32 pFormat, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetCALSDims(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, IS4DPIStruct *pDPIStruct, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetCALSDims")]
    public static extern bool _is6_GetCALSDims(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, ref IS4DPIStruct pDPIStruct, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HGLOBAL is6_ReadImage(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, UINT32 uMode, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReadImage")]
    public static extern IntPtr _is6_ReadImage(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, UInt32 uMode, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HBITMAP is6_ReadImageToHBITMAP(HISSRC hSrc, HPALETTE hPal, HDC hDC, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReadImageToHBITMAP")]
    public static extern IntPtr _is6_ReadImageToHBITMAP(IntPtr hSrc, IntPtr hPal, IntPtr hDC, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HGLOBAL is6_ReadBMP(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, UINT32 uBitsPerPixel, RGBQUAD *pPal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReadBMP")]
    public static extern IntPtr _is6_ReadBMP(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, UInt32 uBitsPerPixel, IntPtr pPal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HGLOBAL is6_ReadPCX(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, UINT32 uBitsPerPixel, RGBQUAD *pPal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReadPCX")]
    public static extern IntPtr _is6_ReadPCX(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, UInt32 uBitsPerPixel, IntPtr pPal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HGLOBAL is6_ReadTGA(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, UINT32 uBitsPerPixel, RGBQUAD *pPal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReadTGA")]
    public static extern IntPtr _is6_ReadTGA(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, UInt32 uBitsPerPixel, IntPtr pPal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HGLOBAL is6_ReadPNG(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, UINT32 uBitsPerPixel, RGBQUAD *pPal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReadPNG")]
    public static extern IntPtr _is6_ReadPNG(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, UInt32 uBitsPerPixel, IntPtr pPal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HGLOBAL is6_ReadJPG(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, UINT32 uBitsPerPixel, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReadJPG")]
    public static extern IntPtr _is6_ReadJPG(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, UInt32 uBitsPerPixel, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HGLOBAL is6_ReadMetafile(const char *pFileName, UINT32 *puWidth, UINT32 *puHeight, UINT32 uDefWidth, UINT32 uDefHeight, COLORREF clrBackground, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReadMetafile")]
    public static extern IntPtr _is6_ReadMetafile(
    [MarshalAs(UnmanagedType.LPStr)]
    string pFileName, ref UInt32 puWidth, ref UInt32 puHeight, UInt32 uDefWidth, UInt32 uDefHeight, UInt32 clrBackground, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HGLOBAL is6_ReadMetafileHandle(HENHMETAFILE hEmf, UINT32 *puWidth, UINT32 *puHeight, UINT32 uDefWidth, UINT32 uDefHeight, COLORREF clrBackground, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReadMetafileHandle")]
    public static extern IntPtr _is6_ReadMetafileHandle(IntPtr hEmf, ref UInt32 puWidth, ref UInt32 puHeight, UInt32 uDefWidth, UInt32 uDefHeight, UInt32 clrBackground, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HGLOBAL is6_ReadPAX(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, UINT32 uBitsPerPixel, RGBQUAD *pPal, const char *pPassword, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReadPAX")]
    public static extern IntPtr _is6_ReadPAX(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, UInt32 uBitsPerPixel, IntPtr pPal,
    [MarshalAs(UnmanagedType.LPStr)]
    string pPassword, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HGLOBAL is6_ReadPSD(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, UINT32 uBitsPerPixel, RGBQUAD *pPal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReadPSD")]
    public static extern IntPtr _is6_ReadPSD(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, UInt32 uBitsPerPixel, IntPtr pPal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HGLOBAL is6_ReadTLA(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, const char *pPassword, UINT32 uBytesPerPixel, RGBQUAD *pPal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReadTLA")]
    public static extern IntPtr _is6_ReadTLA(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight,
    [MarshalAs(UnmanagedType.LPStr)]
    string pPassword, UInt32 uBytesPerPixel, IntPtr pPal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HGLOBAL is6_ReadTIFF(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, UINT32 uBitsPerPixel, RGBQUAD *pPal, UINT32 uFrameIndex, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReadTIFF")]
    public static extern IntPtr _is6_ReadTIFF(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, UInt32 uBitsPerPixel, IntPtr pPal, UInt32 uFrameIndex, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_GetTIFFPageCount(HISSRC hSource);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetTIFFPageCount")]
    public static extern UInt32 _is6_GetTIFFPageCount(IntPtr hSource);

    ////////////////////////////////////////////////////////////////////////////////
    //   HGLOBAL is6_ReadWBMP(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, RGBQUAD *pPal, UINT32 uBitsPerPixel, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReadWBMP")]
    public static extern IntPtr _is6_ReadWBMP(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, IntPtr pPal, UInt32 uBitsPerPixel, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HGLOBAL is6_ReadPCD(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, UINT32 uSubImage, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReadPCD")]
    public static extern IntPtr _is6_ReadPCD(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, UInt32 uSubImage, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HGLOBAL is6_ReadPCDIndex(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, UINT32 uIndex, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReadPCDIndex")]
    public static extern IntPtr _is6_ReadPCDIndex(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, UInt32 uIndex, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HGLOBAL is6_ReadGIF(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, __int32 *piTransColor, RGBQUAD *pPal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReadGIF")]
    public static extern IntPtr _is6_ReadGIF(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, ref Int32 piTransColor, IntPtr pPal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ReadMultiFrameGIF(HISSRC hSource, UINT32 *puImageCount, UINT32 *puWidth, UINT32 *puHeight, UINT32 *puLoopCount, UINT32 *puBackGround, __int32 *piTransparency, RGBQUAD *pPal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReadMultiFrameGIF")]
    public static extern bool _is6_ReadMultiFrameGIF(IntPtr hSource, ref UInt32 puImageCount, ref UInt32 puWidth, ref UInt32 puHeight, ref UInt32 puLoopCount, ref UInt32 puBackGround, ref Int32 piTransparency, IntPtr pPal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ClearGIFFrames();
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ClearGIFFrames")]
    public static extern bool _is6_ClearGIFFrames();

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_GetGIFFrameCount();
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetGIFFrameCount")]
    public static extern UInt32 _is6_GetGIFFrameCount();

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetGIFFrame(UINT32 uIndex, HGLOBAL *phImage, UINT32 *pWidth, UINT32 *pHeight, UINT32 *pXpos, UINT32 *pYpos, UINT32 *pTicks, UINT32 *pDisposalMethod, UINT32 *pInputFlag, UINT32 *pPalType, __int32 *pClrTransIndex, BOOL *pbInterlaced, RGBQUAD *pPal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetGIFFrame")]
    public static extern bool _is6_GetGIFFrame(UInt32 uIndex, ref IntPtr phImage, ref UInt32 pWidth, ref UInt32 pHeight, ref UInt32 pXpos, ref UInt32 pYpos, ref UInt32 pTicks, ref UInt32 pDisposalMethod, ref UInt32 pInputFlag, ref UInt32 pPalType, ref Int32 pClrTransIndex, ref bool pbInterlaced, IntPtr pPal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HISGIFANI is6_AnimatedGIFRenderInit(HISSRC hSource, UINT32* uWidth, UINT32 *uHeight, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AnimatedGIFRenderInit")]
    public static extern IntPtr _is6_AnimatedGIFRenderInit(IntPtr hSource, ref UInt32 uWidth, ref UInt32 uHeight, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AnimatedGIFRenderNextFrame(HISGIFANI hGIFAni, BYTE *pOutput, UINT32 * puSleepTicks, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AnimatedGIFRenderNextFrame")]
    public static extern bool _is6_AnimatedGIFRenderNextFrame(IntPtr hGIFAni, IntPtr pOutput, ref UInt32 puSleepTicks, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DestroyAnimatedGIFRender(HISGIFANI hGIFAni);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DestroyAnimatedGIFRender")]
    public static extern bool _is6_DestroyAnimatedGIFRender(IntPtr hGIFAni);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ReadIconFrames(HISSRC hSrc, UINT32 *puCount);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReadIconFrames")]
    public static extern bool _is6_ReadIconFrames(IntPtr hSrc, ref UInt32 puCount);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetIconFrame(UINT32 uIndex, ISIconStruct* pICS);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetIconFrame")]
    public static extern bool _is6_GetIconFrame(UInt32 uIndex, ref ISIconStruct pICS);

    ////////////////////////////////////////////////////////////////////////////////
    //   HGLOBAL is6_ReadPNM(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, UINT32 uBpp, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReadPNM")]
    public static extern IntPtr _is6_ReadPNM(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, UInt32 uBpp, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HGLOBAL is6_ReadCALS(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReadCALS")]
    public static extern IntPtr _is6_ReadCALS(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HDBMP is6_InitReadBMPLines(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, RGBQUAD *pPal);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_InitReadBMPLines")]
    public static extern IntPtr _is6_InitReadBMPLines(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, IntPtr pPal);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ReadNextBMPLine(HDBMP hSingle, BYTE *pRow, UINT32 *puRowIndex);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReadNextBMPLine")]
    public static extern bool _is6_ReadNextBMPLine(IntPtr hSingle, IntPtr pRow, ref UInt32 puRowIndex);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DestroyReadBMPLines(HDBMP hSingle);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DestroyReadBMPLines")]
    public static extern bool _is6_DestroyReadBMPLines(IntPtr hSingle);

    ////////////////////////////////////////////////////////////////////////////////
    //   HDPCX is6_InitReadPCXLines(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, RGBQUAD *pPal);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_InitReadPCXLines")]
    public static extern IntPtr _is6_InitReadPCXLines(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, IntPtr pPal);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ReadNextPCXLine(HDPCX hSingle, BYTE *pRow, UINT32 *puRowIndex);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReadNextPCXLine")]
    public static extern bool _is6_ReadNextPCXLine(IntPtr hSingle, IntPtr pRow, ref UInt32 puRowIndex);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DestroyReadPCXLines(HDPCX hSingle);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DestroyReadPCXLines")]
    public static extern bool _is6_DestroyReadPCXLines(IntPtr hSingle);

    ////////////////////////////////////////////////////////////////////////////////
    //   HDJPG is6_InitReadJPGLines(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, UINT32 uBitsPerPixel, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_InitReadJPGLines")]
    public static extern IntPtr _is6_InitReadJPGLines(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, UInt32 uBitsPerPixel, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ReadNextJPGLine(HDJPG hSingle, BYTE *pRow, UINT32 *puRowIndex);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReadNextJPGLine")]
    public static extern bool _is6_ReadNextJPGLine(IntPtr hSingle, IntPtr pRow, ref UInt32 puRowIndex);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DestroyReadJPGLines(HDJPG hSingle);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DestroyReadJPGLines")]
    public static extern bool _is6_DestroyReadJPGLines(IntPtr hSingle);

    ////////////////////////////////////////////////////////////////////////////////
    //   HDPAX is6_InitReadPAXLines(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, UINT32 uBitsPerPixel, RGBQUAD *pPal, const char *pPassword);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_InitReadPAXLines")]
    public static extern IntPtr _is6_InitReadPAXLines(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, UInt32 uBitsPerPixel, IntPtr pPal,
    [MarshalAs(UnmanagedType.LPStr)]
    string pPassword);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ReadNextPAXLine(HDPAX hSingle, BYTE *pRow, UINT32 *puRowIndex);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReadNextPAXLine")]
    public static extern bool _is6_ReadNextPAXLine(IntPtr hSingle, IntPtr pRow, ref UInt32 puRowIndex);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DestroyReadPAXLines(HDPAX hSingle);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DestroyReadPAXLines")]
    public static extern bool _is6_DestroyReadPAXLines(IntPtr hSingle);

    ////////////////////////////////////////////////////////////////////////////////
    //   HDTLA is6_InitReadTLALines(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, UINT32 uBytesPerPixel, RGBQUAD *pPal, const char *pPassword);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_InitReadTLALines")]
    public static extern IntPtr _is6_InitReadTLALines(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, UInt32 uBytesPerPixel, IntPtr pPal,
    [MarshalAs(UnmanagedType.LPStr)]
    string pPassword);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ReadNextTLALine(HDTLA hSingle, BYTE *pRow, UINT32 *puRowIndex);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReadNextTLALine")]
    public static extern bool _is6_ReadNextTLALine(IntPtr hSingle, IntPtr pRow, ref UInt32 puRowIndex);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DestroyReadTLALines(HDTLA hSingle);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DestroyReadTLALines")]
    public static extern bool _is6_DestroyReadTLALines(IntPtr hSingle);

    ////////////////////////////////////////////////////////////////////////////////
    //   HDPNG is6_InitReadPNGLines(HISSRC hSource, UINT32 *puWidth, UINT32 *puHeight, RGBQUAD *pPal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_InitReadPNGLines")]
    public static extern IntPtr _is6_InitReadPNGLines(IntPtr hSource, ref UInt32 puWidth, ref UInt32 puHeight, IntPtr pPal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ReadNextPNGLine(HDPNG hSingle, BYTE *pRow, UINT32 *puRowIndex);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReadNextPNGLine")]
    public static extern bool _is6_ReadNextPNGLine(IntPtr hSingle, IntPtr pRow, ref UInt32 puRowIndex);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DestroyReadPNGLines(HDPNG hSingle);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DestroyReadPNGLines")]
    public static extern bool _is6_DestroyReadPNGLines(IntPtr hSingle);

    ////////////////////////////////////////////////////////////////////////////////
    //   HISTIFFREADER is6_CreateTIFFReader_TR(HISSRC hSource, UINT32 uFrameIdx, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_CreateTIFFReader_TR")]
    public static extern IntPtr _is6_CreateTIFFReader_TR(IntPtr hSource, UInt32 uFrameIdx, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HGLOBAL is6_ReadTIFF_TR(HISTIFFREADER hReader, UINT32 *pWidth, UINT32 *pHeight, UINT32 uBitsPerPixel, UINT32 uFrameIdx, RGBQUAD *pPal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReadTIFF_TR")]
    public static extern IntPtr _is6_ReadTIFF_TR(IntPtr hReader, ref UInt32 pWidth, ref UInt32 pHeight, UInt32 uBitsPerPixel, UInt32 uFrameIdx, IntPtr pPal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HGLOBAL is6_ReadTIFFTileOrStrip_TR(HISTIFFREADER hReader, UINT32 *pWidth, UINT32 *pHeight, UINT32 uBitsPerPixel, RGBQUAD *pPal, UINT32 xposOrStripIndex, UINT32 ypos, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReadTIFFTileOrStrip_TR")]
    public static extern IntPtr _is6_ReadTIFFTileOrStrip_TR(IntPtr hReader, ref UInt32 pWidth, ref UInt32 pHeight, UInt32 uBitsPerPixel, IntPtr pPal, UInt32 xposOrStripIndex, UInt32 ypos, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_GetTIFFPageCount_TR(HISTIFFREADER hReader);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetTIFFPageCount_TR")]
    public static extern UInt32 _is6_GetTIFFPageCount_TR(IntPtr hReader);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetTIFFTag_TR(HISTIFFREADER hReader, UINT32 uTiffTagID, UINT32 uFlags, ...);
    // Can't translate

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetTIFFTagV_TR(HISTIFFREADER hReader, UINT32 uTiffTagID, UINT32 uFlags, va_list ap);
    // Can't translate

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_SetTIFFPage_TR(HISTIFFREADER hReader, UINT32 uFrameIdx);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SetTIFFPage_TR")]
    public static extern bool _is6_SetTIFFPage_TR(IntPtr hReader, UInt32 uFrameIdx);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DestroyTIFFReader_TR(HISTIFFREADER hReader, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DestroyTIFFReader_TR")]
    public static extern bool _is6_DestroyTIFFReader_TR(IntPtr hReader, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HISTIFFWRITER is6_CreateTIFFWriter_TW(HISDEST hDest, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_CreateTIFFWriter_TW")]
    public static extern IntPtr _is6_CreateTIFFWriter_TW(IntPtr hDest, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_InitializeTIFFWriter_TW(HISTIFFWRITER hWriter, UINT32 uWidth, UINT32 uHeight, UINT32 uBitsPerPixel, const RGBQUAD * pPal, UINT32 uCompMode, const IS4DPIStruct *pDPIStruct, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_InitializeTIFFWriter_TW")]
    public static extern bool _is6_InitializeTIFFWriter_TW(IntPtr hWriter, UInt32 uWidth, UInt32 uHeight, UInt32 uBitsPerPixel, IntPtr pPal, UInt32 uCompMode, ref IS4DPIStruct pDPIStruct, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_WriteTIFF_TW(HISTIFFWRITER hWriter, const BYTE *pImage, UINT32 uRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_WriteTIFF_TW")]
    public static extern UInt32 _is6_WriteTIFF_TW(IntPtr hWriter, IntPtr pImage, UInt32 uRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_SetTIFFTag_TW(HISTIFFWRITER hWriter, UINT32 uTagID, UINT32 uFlags, ...);
    // Can't translate

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_SetTIFFTagV_TW(HISTIFFWRITER hTIFF, UINT32 uTagID, UINT32 uFlags, va_list ap);
    // Can't translate

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_WriteDirectory_TW(HISTIFFWRITER hWriter, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_WriteDirectory_TW")]
    public static extern bool _is6_WriteDirectory_TW(IntPtr hWriter, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DestroyTIFFWriter_TW(HISTIFFWRITER hTIFF, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DestroyTIFFWriter_TW")]
    public static extern bool _is6_DestroyTIFFWriter_TW(IntPtr hTIFF, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HISGEOTIFFREADER is6_GeoTIFFCreateReader(HISTIFFREADER hTIFFReader, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GeoTIFFCreateReader")]
    public static extern IntPtr _is6_GeoTIFFCreateReader(IntPtr hTIFFReader, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GeoTIFFGetTag(HISGEOTIFFREADER hGeoTIFFReader, UINT32 uTagID, HGLOBAL *phData, UINT32 *puDataCount, UINT32 *puDataType, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GeoTIFFGetTag")]
    public static extern bool _is6_GeoTIFFGetTag(IntPtr hGeoTIFFReader, UInt32 uTagID, ref IntPtr phData, ref UInt32 puDataCount, ref UInt32 puDataType, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GeoTIFFTranslateCoordinates(HISGEOTIFFREADER hGeoTIFFReader, double*x, double *y, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GeoTIFFTranslateCoordinates")]
    public static extern bool _is6_GeoTIFFTranslateCoordinates(IntPtr hGeoTIFFReader, ref double x, ref double y, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DestroyGEOTIFFReader(HISGEOTIFFREADER hGeoTIFFReader, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DestroyGEOTIFFReader")]
    public static extern bool _is6_DestroyGEOTIFFReader(IntPtr hGeoTIFFReader, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_WriteBMP(HISDEST hDest, const BYTE *pImg, UINT32 uWidth, __int32 iHeight, UINT32 uBitsPerPixel, UINT32 uInRowStride, UINT32 uColors, const RGBQUAD * pPal, const IS4DPIStruct *pDPIStruct, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_WriteBMP")]
    public static extern UInt32 _is6_WriteBMP(IntPtr hDest, IntPtr pImg, UInt32 uWidth, Int32 iHeight, UInt32 uBitsPerPixel, UInt32 uInRowStride, UInt32 uColors, IntPtr pPal, ref IS4DPIStruct pDPIStruct, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_WriteJPG(HISDEST hDest, const BYTE *pImg, UINT32 uWidth, UINT32 uHeight, UINT32 uBitsPerPixel, UINT32 uRowStride, UINT32 uQuality, const IS4DPIStruct *pDPIStruct, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_WriteJPG")]
    public static extern UInt32 _is6_WriteJPG(IntPtr hDest, IntPtr pImg, UInt32 uWidth, UInt32 uHeight, UInt32 uBitsPerPixel, UInt32 uRowStride, UInt32 uQuality, ref IS4DPIStruct pDPIStruct, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_WriteTIFF(HISDEST hDest, const BYTE *pImg, UINT32 uWidth, UINT32 uHeight, UINT32 uBitsPerPixel, UINT32 uInRowStride, const RGBQUAD *pPal, UINT32 uCompMode, const IS4DPIStruct *pDPIStruct, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_WriteTIFF")]
    public static extern UInt32 _is6_WriteTIFF(IntPtr hDest, IntPtr pImg, UInt32 uWidth, UInt32 uHeight, UInt32 uBitsPerPixel, UInt32 uInRowStride, IntPtr pPal, UInt32 uCompMode, ref IS4DPIStruct pDPIStruct, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_WriteTiffMultiViaCB(HISDEST hDest, is6_TIFFMULTIPAGE_CBPTR pageCallback, IS_CALLBACK_DATA uUserData, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_WriteTiffMultiViaCB")]
    public static extern UInt32 _is6_WriteTiffMultiViaCB(IntPtr hDest, is6_TIFFMULTIPAGE_CBPTR pageCallback, IntPtr uUserData, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_WritePCX(HISDEST hDest, const BYTE *pImg, UINT32 uWidth, UINT32 uHeight, UINT32 uBitsPerPixel, UINT32 uRowStride, const RGBQUAD *pPal, const IS4DPIStruct *pDPIStruct, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_WritePCX")]
    public static extern UInt32 _is6_WritePCX(IntPtr hDest, IntPtr pImg, UInt32 uWidth, UInt32 uHeight, UInt32 uBitsPerPixel, UInt32 uRowStride, IntPtr pPal, ref IS4DPIStruct pDPIStruct, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_WriteTGA(HISDEST hDest, const BYTE *pImg, UINT32 uWidth, UINT32 uHeight, UINT32 uBitsPerPixel, UINT32 uInRowStride, const RGBQUAD *pPal, const IS4DPIStruct *pDPIStruct, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_WriteTGA")]
    public static extern UInt32 _is6_WriteTGA(IntPtr hDest, IntPtr pImg, UInt32 uWidth, UInt32 uHeight, UInt32 uBitsPerPixel, UInt32 uInRowStride, IntPtr pPal, ref IS4DPIStruct pDPIStruct, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_WritePNG(HISDEST hDest, const BYTE *pImg, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, UINT32 uComponentBitDepth, UINT32 uColors, const RGBQUAD * pPal, UINT32 uColorType, double fGammaVal, const IS4DPIStruct *pDPIStruct, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_WritePNG")]
    public static extern UInt32 _is6_WritePNG(IntPtr hDest, IntPtr pImg, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, UInt32 uComponentBitDepth, UInt32 uColors, IntPtr pPal, UInt32 uColorType, double fGammaVal, ref IS4DPIStruct pDPIStruct, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_WritePAX(HISDEST hDest, const BYTE *pImg, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, const char *pPassword, UINT32 uEncType, UINT32 uBitsPerPixel, const RGBQUAD *pPal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_WritePAX")]
    public static extern UInt32 _is6_WritePAX(IntPtr hDest, IntPtr pImg, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride,
    [MarshalAs(UnmanagedType.LPStr)]
    string pPassword, UInt32 uEncType, UInt32 uBitsPerPixel, IntPtr pPal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_WritePSD(HISDEST hDest, const BYTE *pImg, UINT32 uWidth, UINT32 uHeight, UINT32 uBitsPerPixel, UINT32 uRowStride, const RGBQUAD *pPal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_WritePSD")]
    public static extern UInt32 _is6_WritePSD(IntPtr hDest, IntPtr pImg, UInt32 uWidth, UInt32 uHeight, UInt32 uBitsPerPixel, UInt32 uRowStride, IntPtr pPal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_WriteTLA(HISDEST hDest, const BYTE *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uBitsPerPixel, UINT32 uRowStride, UINT32 uStripSize, UINT32 uFilterType, UINT32 uPalColors, const RGBQUAD * pPal, const char *pPassword, BYTE **pDataArray, UINT32 *dataSizeArray, UINT32 uTags, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_WriteTLA")]
    public static extern UInt32 _is6_WriteTLA(IntPtr hDest, IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uBitsPerPixel, UInt32 uRowStride, UInt32 uStripSize, UInt32 uFilterType, UInt32 uPalColors, IntPtr pPal,
    [MarshalAs(UnmanagedType.LPStr)]
    string pPassword, IntPtr pDataArray, ref UInt32 dataSizeArray, UInt32 uTags, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_WriteRGBToMetafile(HISDEST hDest, const BYTE *pImg, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, UINT32 uType, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_WriteRGBToMetafile")]
    public static extern UInt32 _is6_WriteRGBToMetafile(IntPtr hDest, IntPtr pImg, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, UInt32 uType, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_WriteWBMP(HISDEST hDest, const BYTE *pImg, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_WriteWBMP")]
    public static extern UInt32 _is6_WriteWBMP(IntPtr hDest, IntPtr pImg, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_WriteGIF(HISDEST hDest, const BYTE *pImg, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, UINT32 iBackground, __int32 iTransparentIdx, UINT32 iBitsPerPixel, const RGBQUAD *pPal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_WriteGIF")]
    public static extern UInt32 _is6_WriteGIF(IntPtr hDest, IntPtr pImg, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, UInt32 iBackground, Int32 iTransparentIdx, UInt32 iBitsPerPixel, IntPtr pPal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HCGIF is6_InitWriteMultiframedGIF(HISDEST hDest, UINT32 uScreenWidth, UINT32 uScreenHeight, UINT32 uBitsPerPixel, const RGBQUAD *pPal, UINT32 uBackground, __int32 iTransparent, UINT32 uLoopCount, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_InitWriteMultiframedGIF")]
    public static extern IntPtr _is6_InitWriteMultiframedGIF(IntPtr hDest, UInt32 uScreenWidth, UInt32 uScreenHeight, UInt32 uBitsPerPixel, IntPtr pPal, UInt32 uBackground, Int32 iTransparent, UInt32 uLoopCount, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AddGIFFrame(HCGIF hGIS, const BYTE *p8, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, UINT32 LeftOfs, UINT32 TopOfs, UINT32 delayTime, __int32 transIndex, UINT32 uBitsPerPixel, const RGBQUAD *pPal, UINT32 uDisposal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AddGIFFrame")]
    public static extern bool _is6_AddGIFFrame(IntPtr hGIS, IntPtr p8, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, UInt32 LeftOfs, UInt32 TopOfs, UInt32 delayTime, Int32 transIndex, UInt32 uBitsPerPixel, IntPtr pPal, UInt32 uDisposal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DestroyMultiGIF(HCGIF hGIS);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DestroyMultiGIF")]
    public static extern bool _is6_DestroyMultiGIF(IntPtr hGIS);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AddIcon(ISIconStruct* pICS, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AddIcon")]
    public static extern bool _is6_AddIcon(ref ISIconStruct pICS, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_FinishIconWrite(HISDEST hDest, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_FinishIconWrite")]
    public static extern bool _is6_FinishIconWrite(IntPtr hDest, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_WritePNM(HISDEST hDest, const void *pImg, UINT32 uWidth, UINT32 uHeight, UINT32 uBitsPerPixel, UINT32 uRowStride, UINT32 uMaxVal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_WritePNM")]
    public static extern UInt32 _is6_WritePNM(IntPtr hDest, IntPtr pImg, UInt32 uWidth, UInt32 uHeight, UInt32 uBitsPerPixel, UInt32 uRowStride, UInt32 uMaxVal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HCBMP is6_InitWriteBMPLines(HISDEST hDest, UINT32 uWidth, __int32 iHeight, UINT32 uBitsPerPixel, UINT32 uColors, const RGBQUAD * pPal, const IS4DPIStruct *pDPIStruct, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_InitWriteBMPLines")]
    public static extern IntPtr _is6_InitWriteBMPLines(IntPtr hDest, UInt32 uWidth, Int32 iHeight, UInt32 uBitsPerPixel, UInt32 uColors, IntPtr pPal, ref IS4DPIStruct pDPIStruct, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_WriteNextBMPLine(HCBMP hSingle, const BYTE *pRow);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_WriteNextBMPLine")]
    public static extern bool _is6_WriteNextBMPLine(IntPtr hSingle, IntPtr pRow);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DestroyWriteBMPLines(HCBMP hSingle);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DestroyWriteBMPLines")]
    public static extern bool _is6_DestroyWriteBMPLines(IntPtr hSingle);

    ////////////////////////////////////////////////////////////////////////////////
    //   HCPCX is6_InitWritePCXLines(HISDEST hDest, UINT32 uWidth, UINT32 uHeight, UINT32 uBitsPerPixel, const RGBQUAD * pPal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_InitWritePCXLines")]
    public static extern IntPtr _is6_InitWritePCXLines(IntPtr hDest, UInt32 uWidth, UInt32 uHeight, UInt32 uBitsPerPixel, IntPtr pPal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_WriteNextPCXLine(HCPCX hSingle, const BYTE *pRow);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_WriteNextPCXLine")]
    public static extern bool _is6_WriteNextPCXLine(IntPtr hSingle, IntPtr pRow);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DestroyWritePCXLines(HCPCX hSingle);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DestroyWritePCXLines")]
    public static extern bool _is6_DestroyWritePCXLines(IntPtr hSingle);

    ////////////////////////////////////////////////////////////////////////////////
    //   HCTGA is6_InitWriteTGALines(HISDEST hDest, UINT32 uWidth, UINT32 uHeight, UINT32 uBitsPerPixel, const RGBQUAD * pPal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_InitWriteTGALines")]
    public static extern IntPtr _is6_InitWriteTGALines(IntPtr hDest, UInt32 uWidth, UInt32 uHeight, UInt32 uBitsPerPixel, IntPtr pPal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_WriteNextTGALine(HCTGA hSingle, const BYTE *pRow);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_WriteNextTGALine")]
    public static extern bool _is6_WriteNextTGALine(IntPtr hSingle, IntPtr pRow);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DestroyWriteTGALines(HCTGA hSingle);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DestroyWriteTGALines")]
    public static extern bool _is6_DestroyWriteTGALines(IntPtr hSingle);

    ////////////////////////////////////////////////////////////////////////////////
    //   HISTIFFWRITER is6_InitWriteTIFFLines(HISDEST hDest, UINT32 uWidth, UINT32 uHeight, UINT32 uBitsPerPixel, const RGBQUAD * pPal, UINT32 uCompMode, const IS4DPIStruct *pDPIStruct, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_InitWriteTIFFLines")]
    public static extern IntPtr _is6_InitWriteTIFFLines(IntPtr hDest, UInt32 uWidth, UInt32 uHeight, UInt32 uBitsPerPixel, IntPtr pPal, UInt32 uCompMode, ref IS4DPIStruct pDPIStruct, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_WriteNextTIFFLine(HISTIFFWRITER hSingle, const BYTE *pRow);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_WriteNextTIFFLine")]
    public static extern bool _is6_WriteNextTIFFLine(IntPtr hSingle, IntPtr pRow);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DestroyWriteTIFFLines(HISTIFFWRITER hSingle);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DestroyWriteTIFFLines")]
    public static extern bool _is6_DestroyWriteTIFFLines(IntPtr hSingle);

    ////////////////////////////////////////////////////////////////////////////////
    //   HCPNG is6_InitWritePNGLines(HISDEST hDest, UINT32 uWidth, UINT32 uHeight, UINT32 uWidthBytes, UINT32 uBitDepth, UINT32 uColors, const RGBQUAD * pPal, UINT32 uColorType, double fGammaVal, const IS4DPIStruct *pDPIStruct, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_InitWritePNGLines")]
    public static extern IntPtr _is6_InitWritePNGLines(IntPtr hDest, UInt32 uWidth, UInt32 uHeight, UInt32 uWidthBytes, UInt32 uBitDepth, UInt32 uColors, IntPtr pPal, UInt32 uColorType, double fGammaVal, ref IS4DPIStruct pDPIStruct, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_WriteNextPNGLine(HCPNG hSingle, const BYTE *pRow);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_WriteNextPNGLine")]
    public static extern bool _is6_WriteNextPNGLine(IntPtr hSingle, IntPtr pRow);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DestroyWritePNGLines(HCPNG hSingle);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DestroyWritePNGLines")]
    public static extern bool _is6_DestroyWritePNGLines(IntPtr hSingle);

    ////////////////////////////////////////////////////////////////////////////////
    //   HCJPG is6_InitWriteJPGLines(HISDEST hDest, UINT32 uWidth, UINT32 uHeight, UINT32 uQuality, UINT32 uBitsPerPixel, const IS4DPIStruct *pDPIStruct, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_InitWriteJPGLines")]
    public static extern IntPtr _is6_InitWriteJPGLines(IntPtr hDest, UInt32 uWidth, UInt32 uHeight, UInt32 uQuality, UInt32 uBitsPerPixel, ref IS4DPIStruct pDPIStruct, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_WriteNextJPGLine(HCJPG hSingle, const BYTE *pRow);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_WriteNextJPGLine")]
    public static extern bool _is6_WriteNextJPGLine(IntPtr hSingle, IntPtr pRow);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DestroyWriteJPGLines(HCJPG hSingle);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DestroyWriteJPGLines")]
    public static extern bool _is6_DestroyWriteJPGLines(IntPtr hSingle);

    ////////////////////////////////////////////////////////////////////////////////
    //   HCPAX is6_InitWritePAXLines(HISDEST hDest, UINT32 uWidth, UINT32 uHeight, const RGBQUAD * pPal, UINT32 uBitsPerPixel, const char *pPassword, UINT32 uEncType, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_InitWritePAXLines")]
    public static extern IntPtr _is6_InitWritePAXLines(IntPtr hDest, UInt32 uWidth, UInt32 uHeight, IntPtr pPal, UInt32 uBitsPerPixel,
    [MarshalAs(UnmanagedType.LPStr)]
    string pPassword, UInt32 uEncType, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_WriteNextPAXLine(HCPAX hSingle, const BYTE *pRow);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_WriteNextPAXLine")]
    public static extern bool _is6_WriteNextPAXLine(IntPtr hSingle, IntPtr pRow);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DestroyWritePAXLines(HCPAX hSingle);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DestroyWritePAXLines")]
    public static extern bool _is6_DestroyWritePAXLines(IntPtr hSingle);

    ////////////////////////////////////////////////////////////////////////////////
    //   HCTLA is6_InitWriteTLALines(HISDEST hDest, UINT32 uWidth, UINT32 uHeight, const char *pPassword, UINT32 uBitsPerPixel, UINT32 uStripSize, UINT32 uFilterType, UINT32 uPalColors, const RGBQUAD * pPal, BYTE **pDataArray, UINT32 *dataSizeArray, UINT32 uTags, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_InitWriteTLALines")]
    public static extern IntPtr _is6_InitWriteTLALines(IntPtr hDest, UInt32 uWidth, UInt32 uHeight,
    [MarshalAs(UnmanagedType.LPStr)]
    string pPassword, UInt32 uBitsPerPixel, UInt32 uStripSize, UInt32 uFilterType, UInt32 uPalColors, IntPtr pPal, IntPtr pDataArray, ref UInt32 dataSizeArray, UInt32 uTags, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_WriteNextTLALine(HCTLA hSingle, const BYTE *pRow);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_WriteNextTLALine")]
    public static extern bool _is6_WriteNextTLALine(IntPtr hSingle, IntPtr pRow);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DestroyWriteTLALines(HCTLA hSingle);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DestroyWriteTLALines")]
    public static extern bool _is6_DestroyWriteTLALines(IntPtr hSingle);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_GuessFileType(HISSRC hSource);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GuessFileType")]
    public static extern UInt32 _is6_GuessFileType(IntPtr hSource);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_SetFileReadAllocCallbacks(IS3IMGMEM_ALLOC_CBPTR pAlloc, IS3IMGMEM_REALLOC_CBPTR pReAlloc, IS3IMGMEM_FREE_CBPTR pFree, IS_CALLBACK_DATA uUserData);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SetFileReadAllocCallbacks")]
    public static extern void _is6_SetFileReadAllocCallbacks(IS3IMGMEM_ALLOC_CBPTR pAlloc, IS3IMGMEM_REALLOC_CBPTR pReAlloc, IS3IMGMEM_FREE_CBPTR pFree, IntPtr uUserData);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_PNGSetCompressionOptions(__int32 iCompressionLevel, UINT32 uCompressionMemoryLimit, UINT32 uCompressionStrategy, UINT32 uCompressionWindowBits, UINT32 uFilterTypes, UINT32 uMask, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_PNGSetCompressionOptions")]
    public static extern void _is6_PNGSetCompressionOptions(Int32 iCompressionLevel, UInt32 uCompressionMemoryLimit, UInt32 uCompressionStrategy, UInt32 uCompressionWindowBits, UInt32 uFilterTypes, UInt32 uMask, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_PNGSetScreenGamma(double fScreenGamma);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_PNGSetScreenGamma")]
    public static extern void _is6_PNGSetScreenGamma(double fScreenGamma);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_PNGSetDefBackground(UINT32 uIndex, UINT32 uRed, UINT32 uGreen, UINT32 uBlue, UINT32 uGray);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_PNGSetDefBackground")]
    public static extern void _is6_PNGSetDefBackground(UInt32 uIndex, UInt32 uRed, UInt32 uGreen, UInt32 uBlue, UInt32 uGray);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_PNGGetLastBackground(UINT32 * puIndex, UINT32 * puRed, UINT32 * puGreen, UINT32 * puBlue, UINT32 * puGray);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_PNGGetLastBackground")]
    public static extern void _is6_PNGGetLastBackground(ref UInt32 puIndex, ref UInt32 puRed, ref UInt32 puGreen, ref UInt32 puBlue, ref UInt32 puGray);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_PNGSetTransparencyIndex(BOOL bSet, UINT32 uIndex, UINT32 uRed, UINT32 uGreen, UINT32 uBlue, UINT32 uGray);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_PNGSetTransparencyIndex")]
    public static extern void _is6_PNGSetTransparencyIndex(bool bSet, UInt32 uIndex, UInt32 uRed, UInt32 uGreen, UInt32 uBlue, UInt32 uGray);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_PNGReadPNGText(HISSRC hSource, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_PNGReadPNGText")]
    public static extern bool _is6_PNGReadPNGText(IntPtr hSource, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_GetPNGInputTextCount();
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetPNGInputTextCount")]
    public static extern UInt32 _is6_GetPNGInputTextCount();

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetPNGInputText(UINT32 uIndex, HGLOBAL *pKey, HGLOBAL *pText, UINT32 *puCompression);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetPNGInputText")]
    public static extern bool _is6_GetPNGInputText(UInt32 uIndex, ref IntPtr pKey, ref IntPtr pText, ref UInt32 puCompression);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ClearPNGInputText();
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ClearPNGInputText")]
    public static extern bool _is6_ClearPNGInputText();

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AddPNGOutputText(const char *pText, const char *pKey, UINT32 bCompress);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AddPNGOutputText")]
    public static extern bool _is6_AddPNGOutputText(
    [MarshalAs(UnmanagedType.LPStr)]
    string pText,
    [MarshalAs(UnmanagedType.LPStr)]
    string pKey, UInt32 bCompress);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ClearPNGOutputText();
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ClearPNGOutputText")]
    public static extern bool _is6_ClearPNGOutputText();

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DeletePNGText(const char *pText, const char *pKey, BOOL bInput, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DeletePNGText")]
    public static extern bool _is6_DeletePNGText(
    [MarshalAs(UnmanagedType.LPStr)]
    string pText,
    [MarshalAs(UnmanagedType.LPStr)]
    string pKey, bool bInput, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_CopyPNGInputMetadataToOutputMetadata();
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_CopyPNGInputMetadataToOutputMetadata")]
    public static extern void _is6_CopyPNGInputMetadataToOutputMetadata();

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetTIFFBinaryTag(HISSRC hSource, UINT32 uFrameIdx, UINT32 uTiffTagID, HGLOBAL* phData, UINT32 *puDataLen, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetTIFFBinaryTag")]
    public static extern bool _is6_GetTIFFBinaryTag(IntPtr hSource, UInt32 uFrameIdx, UInt32 uTiffTagID, ref IntPtr phData, ref UInt32 puDataLen, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_SetTIFFBinaryTag(UINT32 uTagID, const BYTE *pData, UINT32 uDataLen, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SetTIFFBinaryTag")]
    public static extern void _is6_SetTIFFBinaryTag(UInt32 uTagID, IntPtr pData, UInt32 uDataLen, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_SetTIFFOutputStripSize(int iSize);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SetTIFFOutputStripSize")]
    public static extern void _is6_SetTIFFOutputStripSize(int iSize);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_SetTIFFJPGQuality(int iQuality);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SetTIFFJPGQuality")]
    public static extern void _is6_SetTIFFJPGQuality(int iQuality);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_SetTIFFOutputTileSize(UINT32 uTileX, UINT32 uTileY);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SetTIFFOutputTileSize")]
    public static extern void _is6_SetTIFFOutputTileSize(UInt32 uTileX, UInt32 uTileY);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_SetTIFF4thChannelAlphaHandlingMode(int iAlphaHandlingMode);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SetTIFF4thChannelAlphaHandlingMode")]
    public static extern void _is6_SetTIFF4thChannelAlphaHandlingMode(int iAlphaHandlingMode);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_SetTIFFOrientation(int iOrientation);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SetTIFFOrientation")]
    public static extern void _is6_SetTIFFOrientation(int iOrientation);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetPAXID(HISSRC hSource, BYTE *pID);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetPAXID")]
    public static extern bool _is6_GetPAXID(IntPtr hSource, IntPtr pID);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_GetPAXInputTagCount();
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetPAXInputTagCount")]
    public static extern UInt32 _is6_GetPAXInputTagCount();

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetPAXInputTag(UINT32 uIndex, BYTE *pName, HGLOBAL *phData, UINT32 *puDataLen);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetPAXInputTag")]
    public static extern bool _is6_GetPAXInputTag(UInt32 uIndex, IntPtr pName, ref IntPtr phData, ref UInt32 puDataLen);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AddPAXOutputTag(const char *pName, const BYTE *pData, UINT32 uDataLen);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AddPAXOutputTag")]
    public static extern bool _is6_AddPAXOutputTag(
    [MarshalAs(UnmanagedType.LPStr)]
    string pName, IntPtr pData, UInt32 uDataLen);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_ClearPAXOutputTags();
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ClearPAXOutputTags")]
    public static extern void _is6_ClearPAXOutputTags();

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_SetPAXOutputInfo(const char *pAppName, const char *pAuthor, BYTE *pID);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SetPAXOutputInfo")]
    public static extern bool _is6_SetPAXOutputInfo(
    [MarshalAs(UnmanagedType.LPStr)]
    string pAppName,
    [MarshalAs(UnmanagedType.LPStr)]
    string pAuthor, IntPtr pID);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetPAXInputInfo(char *pAppName, char *pAuthor, BYTE *pID);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetPAXInputInfo")]
    public static extern bool _is6_GetPAXInputInfo(IntPtr pAppName, IntPtr pAuthor, IntPtr pID);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_MakePAXID(const char *pSeedString1, const char *pSeedString2, BYTE *pOutID);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_MakePAXID")]
    public static extern bool _is6_MakePAXID(
    [MarshalAs(UnmanagedType.LPStr)]
    string pSeedString1,
    [MarshalAs(UnmanagedType.LPStr)]
    string pSeedString2, IntPtr pOutID);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_GetTLAInputTagCount();
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetTLAInputTagCount")]
    public static extern UInt32 _is6_GetTLAInputTagCount();

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetTLAInputTag(UINT32 uIndex, HGLOBAL *phData, UINT32 *puDataLen);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetTLAInputTag")]
    public static extern bool _is6_GetTLAInputTag(UInt32 uIndex, ref IntPtr phData, ref UInt32 puDataLen);

    ////////////////////////////////////////////////////////////////////////////////
    //   HGLOBAL is6_GetPSDThumbnail(HISSRC hSource, ISPSDThumbnailInfo* pThumbnailInfo, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetPSDThumbnail")]
    public static extern IntPtr _is6_GetPSDThumbnail(IntPtr hSource, ref ISPSDThumbnailInfo pThumbnailInfo, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_SetPSDOutputResourceBlock(const BYTE *pData, UINT32 uDataCount);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SetPSDOutputResourceBlock")]
    public static extern void _is6_SetPSDOutputResourceBlock(IntPtr pData, UInt32 uDataCount);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetICCProfile(HISSRC hSource, UINT32 uTIFFFrameIdx, HGLOBAL *phICC, UINT32 *puICCLen, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetICCProfile")]
    public static extern bool _is6_GetICCProfile(IntPtr hSource, UInt32 uTIFFFrameIdx, ref IntPtr phICC, ref UInt32 puICCLen, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_SetOutputICCProfile(const BYTE *pProfile, UINT32 uICCLen, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SetOutputICCProfile")]
    public static extern bool _is6_SetOutputICCProfile(IntPtr pProfile, UInt32 uICCLen, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ClearIcons(BOOL bClearOutputIcons);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ClearIcons")]
    public static extern bool _is6_ClearIcons(bool bClearOutputIcons);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_SetJPGProgressiveReadCallback(is6_JPG_PROGREAD_CBPTR pCB, IS_CALLBACK_DATA uUserData);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SetJPGProgressiveReadCallback")]
    public static extern void _is6_SetJPGProgressiveReadCallback(is6_JPG_PROGREAD_CBPTR pCB, IntPtr uUserData);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ReadJPGMarkers(HISSRC hSource, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReadJPGMarkers")]
    public static extern bool _is6_ReadJPGMarkers(IntPtr hSource, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_GetJPGInputTextCount();
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetJPGInputTextCount")]
    public static extern UInt32 _is6_GetJPGInputTextCount();

    ////////////////////////////////////////////////////////////////////////////////
    //   HGLOBAL is6_GetJPGInputText(UINT32 uIndex);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetJPGInputText")]
    public static extern IntPtr _is6_GetJPGInputText(UInt32 uIndex);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ClearJPGInputText();
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ClearJPGInputText")]
    public static extern bool _is6_ClearJPGInputText();

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_GetJPGInputMarkerCount();
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetJPGInputMarkerCount")]
    public static extern UInt32 _is6_GetJPGInputMarkerCount();

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetJPGInputMarkerInfo(UINT32 uIndex, UINT32 *puDataLen, UINT32 *puDataType);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetJPGInputMarkerInfo")]
    public static extern bool _is6_GetJPGInputMarkerInfo(UInt32 uIndex, ref UInt32 puDataLen, ref UInt32 puDataType);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetJPGInputMarker(UINT32 uIndex, HGLOBAL *phData, UINT32 *puDataLen, UINT32 *puDataType);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetJPGInputMarker")]
    public static extern bool _is6_GetJPGInputMarker(UInt32 uIndex, ref IntPtr phData, ref UInt32 puDataLen, ref UInt32 puDataType);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ClearJPGInputMarkers();
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ClearJPGInputMarkers")]
    public static extern bool _is6_ClearJPGInputMarkers();

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AddJPGOutputText(const char *pText);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AddJPGOutputText")]
    public static extern bool _is6_AddJPGOutputText(
    [MarshalAs(UnmanagedType.LPStr)]
    string pText);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ClearJPGOutputText();
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ClearJPGOutputText")]
    public static extern bool _is6_ClearJPGOutputText();

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AddJPGOutputMarker(const BYTE *pData, UINT32 uDataLen, UINT32 uDataType);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AddJPGOutputMarker")]
    public static extern bool _is6_AddJPGOutputMarker(IntPtr pData, UInt32 uDataLen, UInt32 uDataType);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_SetJPGOutputMarker(UINT32 uIdx, const BYTE *pData, UINT32 uDataLen, UINT32 uDataType);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SetJPGOutputMarker")]
    public static extern bool _is6_SetJPGOutputMarker(UInt32 uIdx, IntPtr pData, UInt32 uDataLen, UInt32 uDataType);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_GetJPGOutputMarkerCount();
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetJPGOutputMarkerCount")]
    public static extern UInt32 _is6_GetJPGOutputMarkerCount();

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetJPGOutputMarker(UINT32 uIndex, HGLOBAL *phData, UINT32 *puDataLen, UINT32 *puDataType);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetJPGOutputMarker")]
    public static extern bool _is6_GetJPGOutputMarker(UInt32 uIndex, ref IntPtr phData, ref UInt32 puDataLen, ref UInt32 puDataType);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ReplaceJPGOutputMarker(UINT32 uDataType, const BYTE *pData, UINT32 uDataLen, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReplaceJPGOutputMarker")]
    public static extern bool _is6_ReplaceJPGOutputMarker(UInt32 uDataType, IntPtr pData, UInt32 uDataLen, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_CopyJPGInputMetadataToOutputMetadata();
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_CopyJPGInputMetadataToOutputMetadata")]
    public static extern void _is6_CopyJPGInputMetadataToOutputMetadata();

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ClearJPGOutputMarkers();
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ClearJPGOutputMarkers")]
    public static extern bool _is6_ClearJPGOutputMarkers();

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_SetJPGDCT(UINT32 uDCT);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SetJPGDCT")]
    public static extern void _is6_SetJPGDCT(UInt32 uDCT);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_SetJPGSmoothingFactor(UINT32 uSmoothing);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SetJPGSmoothingFactor")]
    public static extern void _is6_SetJPGSmoothingFactor(UInt32 uSmoothing);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_SetJPGDownsampleFactors(UINT32 *uHFactors, UINT32 *uVFactors);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SetJPGDownsampleFactors")]
    public static extern void _is6_SetJPGDownsampleFactors(IntPtr uHFactors, IntPtr uVFactors);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_SetJPGDCTScaleFactors(UINT32 uNumerator, UINT32 uDenominator);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SetJPGDCTScaleFactors")]
    public static extern void _is6_SetJPGDCTScaleFactors(UInt32 uNumerator, UInt32 uDenominator);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_JPGTransform(HISSRC hSource, HISDEST hDest, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_JPGTransform")]
    public static extern bool _is6_JPGTransform(IntPtr hSource, IntPtr hDest, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_JPGCanDoLosslessTransform(HISSRC hSource, UINT32 uFlag);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_JPGCanDoLosslessTransform")]
    public static extern bool _is6_JPGCanDoLosslessTransform(IntPtr hSource, UInt32 uFlag);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_JPGTransformCrop(HISSRC hSource, HISDEST hDest, const RECT * pCropRect, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_JPGTransformCrop")]
    public static extern bool _is6_JPGTransformCrop(IntPtr hSource, IntPtr hDest, ref RECT pCropRect, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetJPGMCUSize(HISSRC hSource, UINT32 *pMCUX, UINT32 *pMCUY);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetJPGMCUSize")]
    public static extern bool _is6_GetJPGMCUSize(IntPtr hSource, ref UInt32 pMCUX, ref UInt32 pMCUY);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_CopyJPGWithNewMarkers(HISSRC hSource, HISDEST hDest, UINT32 uFlag);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_CopyJPGWithNewMarkers")]
    public static extern bool _is6_CopyJPGWithNewMarkers(IntPtr hSource, IntPtr hDest, UInt32 uFlag);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DrawHBITMAP(HDC hDC, HBITMAP hBmp, __int32 iXPos, __int32 iYPos, UINT32 uOutWidth, UINT32 uOutHeight, HPALETTE hPal);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DrawHBITMAP")]
    public static extern bool _is6_DrawIntPtr(IntPtr hDC, IntPtr hBmp, Int32 iXPos, Int32 iYPos, UInt32 uOutWidth, UInt32 uOutHeight, IntPtr hPal);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DrawHBITMAPCropped(HDC hDC, HBITMAP hBmp, __int32 iXPos, __int32 iYPos, UINT32 uSrcXStart, UINT32 uSrcYStart, UINT32 uOutWidth, UINT32 uOutHeight, HPALETTE hPal);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DrawHBITMAPCropped")]
    public static extern bool _is6_DrawIntPtrCropped(IntPtr hDC, IntPtr hBmp, Int32 iXPos, Int32 iYPos, UInt32 uSrcXStart, UInt32 uSrcYStart, UInt32 uOutWidth, UInt32 uOutHeight, IntPtr hPal);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DrawRGB(HDC hDC, const BYTE *pRGB, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, __int32 iXPos, __int32 iYPos, HPALETTE hPal);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DrawRGB")]
    public static extern bool _is6_DrawRGB(IntPtr hDC, IntPtr pRGB, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, Int32 iXPos, Int32 iYPos, IntPtr hPal);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DrawRGBA(HDC outDC, const BYTE *pRGBA, UINT32 inWidth, UINT32 inHeight, UINT32 uRowStride, __int32 xPos, __int32 yPos, HPALETTE hPal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DrawRGBA")]
    public static extern bool _is6_DrawRGBA(IntPtr outDC, IntPtr pRGBA, UInt32 inWidth, UInt32 inHeight, UInt32 uRowStride, Int32 xPos, Int32 yPos, IntPtr hPal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DrawRGBAScaled(HDC outDC, const BYTE *pRGBA, UINT32 inWidth, UINT32 inHeight, UINT32 uRowStride, __int32 xPos, __int32 yPos, double fScale, HPALETTE hPal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DrawRGBAScaled")]
    public static extern bool _is6_DrawRGBAScaled(IntPtr outDC, IntPtr pRGBA, UInt32 inWidth, UInt32 inHeight, UInt32 uRowStride, Int32 xPos, Int32 yPos, double fScale, IntPtr hPal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_Draw8Bit(HDC hDC, const BYTE *p8Bit, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, const RGBQUAD *pPal, __int32 iXPos, __int32 iYPos, HPALETTE hPal);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_Draw8Bit")]
    public static extern bool _is6_Draw8Bit(IntPtr hDC, IntPtr p8Bit, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, IntPtr pPal, Int32 iXPos, Int32 iYPos, IntPtr hPal);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_Draw1Bit(HDC hDC, const BYTE *p1Bit, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, const RGBQUAD *pPal, __int32 iXPos, __int32 iYPos, HPALETTE hPal);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_Draw1Bit")]
    public static extern bool _is6_Draw1Bit(IntPtr hDC, IntPtr p1Bit, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, IntPtr pPal, Int32 iXPos, Int32 iYPos, IntPtr hPal);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_StretchDrawRGB(HDC hDC, const BYTE *pRGB, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, __int32 iXPos, __int32 iYPos, UINT32 uOutWidth, UINT32 uOutHeight);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_StretchDrawRGB")]
    public static extern bool _is6_StretchDrawRGB(IntPtr hDC, IntPtr pRGB, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, Int32 iXPos, Int32 iYPos, UInt32 uOutWidth, UInt32 uOutHeight);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_StretchDraw8Bit(HDC hDC, const BYTE *p8Bit, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, const RGBQUAD *pPal, __int32 iXPos, __int32 iYPos, UINT32 uOutWidth, UINT32 uOutHeight);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_StretchDraw8Bit")]
    public static extern bool _is6_StretchDraw8Bit(IntPtr hDC, IntPtr p8Bit, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, IntPtr pPal, Int32 iXPos, Int32 iYPos, UInt32 uOutWidth, UInt32 uOutHeight);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_StretchDraw1Bit(HDC hDC, const BYTE *p1Bit, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, const RGBQUAD *pPal, __int32 iXPos, __int32 iYPos, UINT32 uOutWidth, UINT32 uOutHeight);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_StretchDraw1Bit")]
    public static extern bool _is6_StretchDraw1Bit(IntPtr hDC, IntPtr p1Bit, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, IntPtr pPal, Int32 iXPos, Int32 iYPos, UInt32 uOutWidth, UInt32 uOutHeight);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DrawTransparentBitmap(HDC hDC, HBITMAP hBmp, __int32 iXPos, __int32 iYPos, COLORREF clrTransparent);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DrawTransparentBitmap")]
    public static extern bool _is6_DrawTransparentBitmap(IntPtr hDC, IntPtr hBmp, Int32 iXPos, Int32 iYPos, UInt32 clrTransparent);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DrawTransparentRGB(HDC hDC, const BYTE *pRGB, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, __int32 iXPos, __int32 iYPos, COLORREF clrTransparent);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DrawTransparentRGB")]
    public static extern bool _is6_DrawTransparentRGB(IntPtr hDC, IntPtr pRGB, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, Int32 iXPos, Int32 iYPos, UInt32 clrTransparent);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_StretchDrawDIB(HDC hDC, const BITMAPINFOHEADER *pDIB, __int32 iXPos, __int32 iYPos, UINT32 uOutWidth, UINT32 uOutHeight);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_StretchDrawDIB")]
    public static extern bool _is6_StretchDrawDIB(IntPtr hDC, ref BITMAPINFOHEADER pDIB, Int32 iXPos, Int32 iYPos, UInt32 uOutWidth, UInt32 uOutHeight);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_StretchDrawDIBCropped(HDC hDC, const BITMAPINFOHEADER *pDIB, const RECT *pSrcRect, const RECT *pDestRect);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_StretchDrawDIBCropped")]
    public static extern bool _is6_StretchDrawDIBCropped(IntPtr hDC, ref BITMAPINFOHEADER pDIB, ref RECT pSrcRect, ref RECT pDestRect);

    ////////////////////////////////////////////////////////////////////////////////
    //   HBITMAP is6_LoadResourceBitmap(HINSTANCE hInstance, const char *pName, HPALETTE hInPalette);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_LoadResourceBitmap")]
    public static extern IntPtr _is6_LoadResourceBitmap(IntPtr hInstance,
    [MarshalAs(UnmanagedType.LPStr)]
    string pName, IntPtr hInPalette);

    ////////////////////////////////////////////////////////////////////////////////
    //   HBITMAP is6_LoadResourceBitmapW(HINSTANCE hInstance, const wchar_t *pName, HPALETTE hInPalette);
    // Can't translate

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_HBITMAPToRGB(HBITMAP hBmp, HDC hDC, HPALETTE hPal, BYTE *pOutBuf);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_HBITMAPToRGB")]
    public static extern bool _is6_HBITMAPToRGB(IntPtr hBmp, IntPtr hDC, IntPtr hPal, IntPtr pOutBuf);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_HBITMAPToRGBA(HBITMAP hBmp, HDC hDC, HPALETTE hPal, UINT32 uDefAlpha, BYTE *pOutBuf);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_HBITMAPToRGBA")]
    public static extern bool _is6_HBITMAPToRGBA(IntPtr hBmp, IntPtr hDC, IntPtr hPal, UInt32 uDefAlpha, IntPtr pOutBuf);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetHBITMAPDimensions(HBITMAP hBmp, UINT32 *puWidth, UINT32 *puHeight);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetHBITMAPDimensions")]
    public static extern bool _is6_GetHBITMAPDimensions(IntPtr hBmp, ref UInt32 puWidth, ref UInt32 puHeight);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DCToRGB(HDC hDC, UINT32 uXStart, UINT32 uYStart, UINT32 uWidth, UINT32 uHeight, BYTE *pOutBuf);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DCToRGB")]
    public static extern bool _is6_DCToRGB(IntPtr hDC, UInt32 uXStart, UInt32 uYStart, UInt32 uWidth, UInt32 uHeight, IntPtr pOutBuf);

    ////////////////////////////////////////////////////////////////////////////////
    //   HBITMAP is6_RGBToHBITMAP(const BYTE * pRGB, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, HPALETTE hPal, HDC hDC);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_RGBToHBITMAP")]
    public static extern IntPtr _is6_RGBToIntPtr(IntPtr pRGB, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, IntPtr hPal, IntPtr hDC);

    ////////////////////////////////////////////////////////////////////////////////
    //   HBITMAP is6_DIBToHBITMAP(const BITMAPINFOHEADER * pDIB, HPALETTE hPal, HDC hDC);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DIBToHBITMAP")]
    public static extern IntPtr _is6_DIBToIntPtr(ref BITMAPINFOHEADER pDIB, IntPtr hPal, IntPtr hDC);

    ////////////////////////////////////////////////////////////////////////////////
    //   HBITMAP is6_ImageToHBITMAP(const BYTE *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, UINT32 uBpp, const RGBQUAD *pPal, UINT32 uPalColors, const RECT *pClipRect, HPALETTE hPal, HDC hDC, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ImageToHBITMAP")]
    public static extern IntPtr _is6_ImageToHBITMAP(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, UInt32 uBpp, IntPtr pPal, UInt32 uPalColors, ref RECT pClipRect, IntPtr hPal, IntPtr hDC, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HGLOBAL is6_HBITMAPToDIB(HBITMAP hBmp, HPALETTE hPal);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_HBITMAPToDIB")]
    public static extern IntPtr _is6_HBITMAPToDIB(IntPtr hBmp, IntPtr hPal);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DIBWidth(const BITMAPINFOHEADER *pDIB, UINT32 *puWidth);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DIBWidth")]
    public static extern bool _is6_DIBWidth(ref BITMAPINFOHEADER pDIB, ref UInt32 puWidth);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DIBHeight(const BITMAPINFOHEADER *pDIB, __int32 *piWidth);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DIBHeight")]
    public static extern bool _is6_DIBHeight(ref BITMAPINFOHEADER pDIB, ref Int32 piWidth);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DIBBitCount(const BITMAPINFOHEADER *pDIB, UINT32 *puBitCount);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DIBBitCount")]
    public static extern bool _is6_DIBBitCount(ref BITMAPINFOHEADER pDIB, ref UInt32 puBitCount);

    ////////////////////////////////////////////////////////////////////////////////
    //   BYTE* is6_DIBPixelStart(const BITMAPINFOHEADER *pDIB);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DIBPixelStart")]
    public static extern IntPtr _is6_DIBPixelStart(ref BITMAPINFOHEADER pDIB);

    ////////////////////////////////////////////////////////////////////////////////
    //   RGBQUAD* is6_GetDIBPalette(const BITMAPINFOHEADER *pDIB, UINT32 *puColorsUsed);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetDIBPalette")]
    public static extern IntPtr _is6_GetDIBPalette(ref BITMAPINFOHEADER pDIB, ref UInt32 puColorsUsed);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_GetDIBRowStride(UINT32 uWidth, UINT32 uBitDepth);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetDIBRowStride")]
    public static extern UInt32 _is6_GetDIBRowStride(UInt32 uWidth, UInt32 uBitDepth);

    ////////////////////////////////////////////////////////////////////////////////
    //   HPALETTE is6_RGBQUADToHPALETTE(const RGBQUAD *pPal, UINT32 uColors);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_RGBQUADToHPALETTE")]
    public static extern IntPtr _is6_RGBQUADToIntPtr(IntPtr pPal, UInt32 uColors);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DIBToRGB(const BITMAPINFOHEADER * pDIB, BYTE *pOutBuf);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DIBToRGB")]
    public static extern bool _is6_DIBToRGB(ref BITMAPINFOHEADER pDIB, IntPtr pOutBuf);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DIBToRGBA(const BITMAPINFOHEADER * pDIB, UINT32 uDefAlpha, BYTE *pOutBuf);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DIBToRGBA")]
    public static extern bool _is6_DIBToRGBA(ref BITMAPINFOHEADER pDIB, UInt32 uDefAlpha, IntPtr pOutBuf);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DIBPartsToRGB(const BYTE *pDIBBits, const BITMAPINFOHEADER * pBMIH, RGBQUAD *pPalette, BYTE *pOutBuf);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DIBPartsToRGB")]
    public static extern bool _is6_DIBPartsToRGB(IntPtr pDIBBits, ref BITMAPINFOHEADER pBMIH, IntPtr pPalette, IntPtr pOutBuf);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DIBToColormapped(const BITMAPINFOHEADER * pDIB, UINT32 uDesiredBitDepth, UINT32 *uColorsInPal, RGBQUAD *pPal, BYTE *pOutBuf);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DIBToColormapped")]
    public static extern bool _is6_DIBToColormapped(ref BITMAPINFOHEADER pDIB, UInt32 uDesiredBitDepth, ref UInt32 uColorsInPal, IntPtr pPal, IntPtr pOutBuf);

    ////////////////////////////////////////////////////////////////////////////////
    //   HGLOBAL is6_RGBToDIB(const BYTE * pRGB, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, BYTE *pOutBuf, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_RGBToDIB")]
    public static extern IntPtr _is6_RGBToDIB(IntPtr pRGB, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, IntPtr pOutBuf, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HGLOBAL is6_RGBAToDIB(const BYTE * pRGB, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, BYTE *pOutBuf, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_RGBAToDIB")]
    public static extern IntPtr _is6_RGBAToDIB(IntPtr pRGB, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, IntPtr pOutBuf, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HGLOBAL is6_RGB16ToDIB(const BYTE * pRGB, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, BYTE *pOutBuf, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_RGB16ToDIB")]
    public static extern IntPtr _is6_RGB16ToDIB(IntPtr pRGB, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, IntPtr pOutBuf, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HGLOBAL is6_8BitToDIB(const BYTE * p8Bit, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, UINT32 uColors, UINT32 uBPP, const RGBQUAD *pPal, BYTE *pOutBuf, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_8BitToDIB")]
    public static extern IntPtr _is6_8BitToDIB(IntPtr p8Bit, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, UInt32 uColors, UInt32 uBPP, IntPtr pPal, IntPtr pOutBuf, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HGLOBAL is6_1BitToDIB(const BYTE * p1Bit, UINT32 uWidthPix, UINT32 uHeight, UINT32 uRowStride, const RGBQUAD *pPal, BYTE *pOutBuf, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_1BitToDIB")]
    public static extern IntPtr _is6_1BitToDIB(IntPtr p1Bit, UInt32 uWidthPix, UInt32 uHeight, UInt32 uRowStride, IntPtr pPal, IntPtr pOutBuf, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_GetISDIBSize(UINT32 uWidth, UINT32 uHeight, UINT32 uBitsPerPixel, UINT32 uPalColors);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetISDIBSize")]
    public static extern UInt32 _is6_GetISDIBSize(UInt32 uWidth, UInt32 uHeight, UInt32 uBitsPerPixel, UInt32 uPalColors);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_SetHBITMAPCreateMethod(UINT32 uMethod);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SetHBITMAPCreateMethod")]
    public static extern void _is6_SetHBITMAPCreateMethod(UInt32 uMethod);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AdjustImageColorBalance(BYTE *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, __int32 R, __int32 G, __int32 B,__int32 Rshadow, __int32 Gshadow, __int32 Bshadow,__int32 Rhighlight,__int32 Ghighlight,__int32 Bhighlight,__int32 Density,UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AdjustImageColorBalance")]
    public static extern bool _is6_AdjustImageColorBalance(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, Int32 R, Int32 G, Int32 B, Int32 Rshadow, Int32 Gshadow, Int32 Bshadow, Int32 Rhighlight, Int32 Ghighlight, Int32 Bhighlight, Int32 Density, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DuotoneImage(BYTE *pRGB, UINT w, UINT h, UINT32 uBytesPerPixel, UINT32 uRowStride, COLORREF clr, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DuotoneImage")]
    public static extern bool _is6_DuotoneImage(IntPtr pRGB, UInt32 w, UInt32 h, UInt32 uBytesPerPixel, UInt32 uRowStride, UInt32 clr, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_InvertImage(BYTE *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_InvertImage")]
    public static extern bool _is6_InvertImage(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_PosterizeImage(BYTE *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_PosterizeImage")]
    public static extern bool _is6_PosterizeImage(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_HalftoneImage(BYTE *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, UINT32 uMaxDotSize, BOOL bSmoothDots);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_HalftoneImage")]
    public static extern bool _is6_HalftoneImage(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, UInt32 uMaxDotSize, bool bSmoothDots);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_MosaicImage(BYTE *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, UINT32 uSquareSize);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_MosaicImage")]
    public static extern bool _is6_MosaicImage(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, UInt32 uSquareSize);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_SolarizeImage(BYTE *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SolarizeImage")]
    public static extern bool _is6_SolarizeImage(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AdjustTint(BYTE *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, int iTint, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AdjustTint")]
    public static extern bool _is6_AdjustTint(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, int iTint, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_CrackleRGB(const BYTE *pIn, UINT32 w, UINT32 h, UINT32 uInRowStride, BYTE *pOut, UINT32 uOutRowStride, UINT32 mode, UINT32 uDefinition, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_CrackleRGB")]
    public static extern bool _is6_CrackleRGB(IntPtr pIn, UInt32 w, UInt32 h, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, UInt32 mode, UInt32 uDefinition, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GauzyImage(const BYTE *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uInRowStride, BYTE *pOut, UINT32 uOutRowStride, double fBlurAmount, double fSharpAmount, double fClarity, UINT32 uMode);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GauzyImage")]
    public static extern bool _is6_GauzyImage(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, double fBlurAmount, double fSharpAmount, double fClarity, UInt32 uMode);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_Stipple(BYTE *pIn, UINT32 w, UINT32 h, UINT32 uBytesPerPixel, UINT32 uInRowStride, BYTE *pOut, UINT32 uOutRowStride, UINT32 uSize, UINT uFilter, UINT uMode);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_Stipple")]
    public static extern bool _is6_Stipple(IntPtr pIn, UInt32 w, UInt32 h, UInt32 uBytesPerPixel, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, UInt32 uSize, UInt32 uFilter, UInt32 uMode);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_Scribble(BYTE *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pOut, UINT32 uOutRowStride, UINT32 uMode, BOOL bFilterFirst, UINT32 uDark);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_Scribble")]
    public static extern bool _is6_Scribble(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, UInt32 uMode, bool bFilterFirst, UInt32 uDark);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_TintGrayscale(BYTE *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pOut, UINT32 uOutBpp, UINT32 uOutRowStride, COLORREF clrTint, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_TintGrayscale")]
    public static extern bool _is6_TintGrayscale(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutBpp, UInt32 uOutRowStride, UInt32 clrTint, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_Fingerprint(const BYTE *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pOut, UINT32 uOutRowStride, double fDepth, UINT32 uFilterSize, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_Fingerprint")]
    public static extern bool _is6_Fingerprint(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, double fDepth, UInt32 uFilterSize, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_OilPaintRGB(const BYTE *pInRGB, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pOutRGB, UINT32 uOutRowStride, UINT32 uBrushWidth, UINT32 uMaxDensity, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_OilPaintRGB")]
    public static extern bool _is6_OilPaintRGB(IntPtr pInRGB, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOutRGB, UInt32 uOutRowStride, UInt32 uBrushWidth, UInt32 uMaxDensity, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_WatercolorTintRGB(BYTE *pInRGB, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pOutRGB, UINT32 uOutRowStride, double fBlur, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_WatercolorTintRGB")]
    public static extern bool _is6_WatercolorTintRGB(IntPtr pInRGB, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOutRGB, UInt32 uOutRowStride, double fBlur, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_Painterly(const BYTE *pInRGB, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uInRowStride, BYTE *pOutRGB, UINT32 uOutRowStride, IS_Painterly_Opts *pOpts, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_Painterly")]
    public static extern bool _is6_Painterly(IntPtr pInRGB, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInRowStride, IntPtr pOutRGB, UInt32 uOutRowStride, ref IS_Painterly_Opts pOpts, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ASCIIizeGrayscaleImage(const BYTE *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, char *pOutASCII, UINT32 uOutCharsX, UINT32 uOutCharsY, const char *pCharData, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ASCIIizeGrayscaleImage")]
    public static extern bool _is6_ASCIIizeGrayscaleImage(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, IntPtr pOutASCII, UInt32 uOutCharsX, UInt32 uOutCharsY,
    [MarshalAs(UnmanagedType.LPStr)]
    string pCharData, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_SegmentedColorizeRGB(BYTE *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pOutput8, UINT32 uOutRowStride, RGBQUAD *pPal, UINT32 maxColors, UINT32 uFilterType, UINT32 uFilterParam, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SegmentedColorizeRGB")]
    public static extern bool _is6_SegmentedColorizeRGB(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOutput8, UInt32 uOutRowStride, IntPtr pPal, UInt32 maxColors, UInt32 uFilterType, UInt32 uFilterParam, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ReflectImage(BYTE *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uInRowStride, BYTE *pOut, UINT32 uOutRowStride, UINT32 uReflectYPos, UINT32 uReflectHeight, double fReflectionRatioStart, double fReflectionRatioEnd, COLORREF surfaceColor, UINT32 uFadeMode, double fTextureIntensity, UINT32 uTextureScale, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReflectImage")]
    public static extern bool _is6_ReflectImage(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, UInt32 uReflectYPos, UInt32 uReflectHeight, double fReflectionRatioStart, double fReflectionRatioEnd, UInt32 surfaceColor, UInt32 uFadeMode, double fTextureIntensity, UInt32 uTextureScale, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GradientFillImageRadial(BYTE *pOut, UINT32 uWidth, UINT32 uHeight, UINT32 uBpp, UINT32 uRowStride, double fMaxDistance, int iCenterX, int iCenterY, RGBQUAD *clrs, double *fPercentages, UINT32 uNumColors, int iMode, double fPower, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GradientFillImageRadial")]
    public static extern bool _is6_GradientFillImageRadial(IntPtr pOut, UInt32 uWidth, UInt32 uHeight, UInt32 uBpp, UInt32 uRowStride, double fMaxDistance, int iCenterX, int iCenterY, IntPtr clrs, IntPtr fPercentages, UInt32 uNumColors, int iMode, double fPower, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GradientFillImageLinear(BYTE *pOut, UINT32 uWidth, UINT32 uHeight, UINT32 uBpp, UINT32 uRowStride, double fLinePoint1X, double fLinePoint1Y, double fLinePoint2X, double fLinePoint2Y, RGBQUAD *clrs, double *fPercentages, UINT32 uNumColors, int iMode, double fPower, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GradientFillImageLinear")]
    public static extern bool _is6_GradientFillImageLinear(IntPtr pOut, UInt32 uWidth, UInt32 uHeight, UInt32 uBpp, UInt32 uRowStride, double fLinePoint1X, double fLinePoint1Y, double fLinePoint2X, double fLinePoint2Y, IntPtr clrs, IntPtr fPercentages, UInt32 uNumColors, int iMode, double fPower, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_InnerGlowRGBA(BYTE *pRGBA, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, UINT32 uSize, double fOpacity, COLORREF glowClr, const BYTE *pCurveLUT, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_InnerGlowRGBA")]
    public static extern bool _is6_InnerGlowRGBA(IntPtr pRGBA, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, UInt32 uSize, double fOpacity, UInt32 glowClr, IntPtr pCurveLUT, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_OuterGlowRGBA(BYTE *pRGBA, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, UINT32 uSize, double fOpacity, COLORREF glowClr, const BYTE *pCurveLUT, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_OuterGlowRGBA")]
    public static extern bool _is6_OuterGlowRGBA(IntPtr pRGBA, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, UInt32 uSize, double fOpacity, UInt32 glowClr, IntPtr pCurveLUT, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DropShadow(BYTE *pIn, UINT32 inW, UINT32 inH, UINT32 uBpp, UINT32 uInRowStride, HGLOBAL *phOut, UINT32 *pOutW, UINT32 *pOutH, int iOffsetMax, int diffusion, COLORREF clrBackground, COLORREF clrShadow, int iDeg, POINT * pOverlayPos, POINT * pShadowPos, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DropShadow")]
    public static extern bool _is6_DropShadow(IntPtr pIn, UInt32 inW, UInt32 inH, UInt32 uBpp, UInt32 uInRowStride, ref IntPtr phOut, ref UInt32 pOutW, ref UInt32 pOutH, int iOffsetMax, int diffusion, UInt32 clrBackground, UInt32 clrShadow, int iDeg, ref POINT pOverlayPos, ref POINT pShadowPos, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ShadeBevelEdge(BYTE *pRGB, UINT32 inW, UINT32 inH, UINT32 uInRowStride, UINT32 uBevelSize, UINT32 uBpp, UINT32 uFlags, double leftPct, double topPct, double rightPct, double bottomPct, double fBlurPct);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ShadeBevelEdge")]
    public static extern bool _is6_ShadeBevelEdge(IntPtr pRGB, UInt32 inW, UInt32 inH, UInt32 uInRowStride, UInt32 uBevelSize, UInt32 uBpp, UInt32 uFlags, double leftPct, double topPct, double rightPct, double bottomPct, double fBlurPct);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ToneMapping(const void *pInput, UINT32 uWidth, UINT32 uHeight, UINT32 uChannelsPerPixel, UINT32 uInRowStride, BYTE *pOut, UINT32 uOutRowStride, double fLevel, UINT sz, double eps, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ToneMapping")]
    public static extern bool _is6_ToneMapping(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uChannelsPerPixel, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, double fLevel, UInt32 sz, double eps, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_EnhanceDetails(const BYTE *pInput, UINT32 uWidth, UINT32 uHeight, UINT32 uChannelsPerPixel, UINT32 uInRowStride, BYTE *pOut, UINT32 uOutRowStride, UINT32 uFilterSize, double fSigma, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_EnhanceDetails")]
    public static extern bool _is6_EnhanceDetails(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uChannelsPerPixel, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, UInt32 uFilterSize, double fSigma, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AdjustGamma(BYTE *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, double fGamma, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AdjustGamma")]
    public static extern bool _is6_AdjustGamma(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, double fGamma, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AdjustBrightnessContrast(BYTE *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, double fBrightness, double fContrast, double fSplinePower, UINT32 uMode, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AdjustBrightnessContrast")]
    public static extern bool _is6_AdjustBrightnessContrast(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, double fBrightness, double fContrast, double fSplinePower, UInt32 uMode, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ModifyImageSaturation(BYTE *pInput, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, double S);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ModifyImageSaturation")]
    public static extern bool _is6_ModifyImageSaturation(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, double S);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_Vibrance(const void * pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uChannelsPerPixel, UINT32 uRowStride, double fLevel, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_Vibrance")]
    public static extern bool _is6_Vibrance(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uChannelsPerPixel, UInt32 uRowStride, double fLevel, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ApplyLUTsToImage(void *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uChannelsPerPixel, UINT32 uRowStride, const void **pLUTs, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ApplyLUTsToImage")]
    public static extern bool _is6_ApplyLUTsToImage(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uChannelsPerPixel, UInt32 uRowStride, IntPtr pLUTs, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AutoBrightnessRGB(BYTE *pRGB, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, UINT32 uLowThreshold, UINT32 uHighThreshold, UINT32 uMode);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AutoBrightnessRGB")]
    public static extern bool _is6_AutoBrightnessRGB(IntPtr pRGB, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, UInt32 uLowThreshold, UInt32 uHighThreshold, UInt32 uMode);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetBrightnessHistogram(const void *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, UINT32 *pHisto, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetBrightnessHistogram")]
    public static extern bool _is6_GetBrightnessHistogram(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, IntPtr pHisto, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetImageChannelHistograms(const void *pImage, UINT32 nWidth, UINT32 nHeight, UINT32 uChannelsPerPixel, UINT32 uRowStride, UINT32 **pHisto, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetImageChannelHistograms")]
    public static extern bool _is6_GetImageChannelHistograms(IntPtr pImage, UInt32 nWidth, UInt32 nHeight, UInt32 uChannelsPerPixel, UInt32 uRowStride, IntPtr pHisto, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetImageChannelHistogramsDouble(const double *pImage, UINT32 nWidth, UINT32 nHeight, UINT32 uChannelsPerPixel, UINT32 uRowStride, UINT32 uHistoSize, UINT32 **pHisto, double *pfMinVal, double *pfMaxVal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetImageChannelHistogramsDouble")]
    public static extern bool _is6_GetImageChannelHistogramsDouble(IntPtr pImage, UInt32 nWidth, UInt32 nHeight, UInt32 uChannelsPerPixel, UInt32 uRowStride, UInt32 uHistoSize, IntPtr pHisto, IntPtr pfMinVal, IntPtr pfMaxVal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetOneBitHistogram(const BYTE *pImage, UINT32 nWidth, UINT32 nHeight, UINT32 uRowStride, UINT32 *pHisto, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetOneBitHistogram")]
    public static extern bool _is6_GetOneBitHistogram(IntPtr pImage, UInt32 nWidth, UInt32 nHeight, UInt32 uRowStride, IntPtr pHisto, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_BrightnessHistogramStretchImage(BYTE *pRGB, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, double fLowLimit, double fHighLimit, UINT32 uMidPoint, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_BrightnessHistogramStretchImage")]
    public static extern bool _is6_BrightnessHistogramStretchImage(IntPtr pRGB, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, double fLowLimit, double fHighLimit, UInt32 uMidPoint, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_SaturationHistogramStretchImage(BYTE *pRGB, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, double fLowLimit, double fHighLimit, UINT32 uMidPoint, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SaturationHistogramStretchImage")]
    public static extern bool _is6_SaturationHistogramStretchImage(IntPtr pRGB, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, double fLowLimit, double fHighLimit, UInt32 uMidPoint, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_HistogramStretchImage(void *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uChannelsPerPixel, UINT32 uRowStride, double fLowLimit, double fHighLimit, UINT32 uMidPoint, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_HistogramStretchImage")]
    public static extern bool _is6_HistogramStretchImage(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uChannelsPerPixel, UInt32 uRowStride, double fLowLimit, double fHighLimit, UInt32 uMidPoint, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetStretchedHistogramLUT(UINT32 *pHisto, UINT32 uTotalElements, double fLowPercent, double fHiPercent, UINT32 midPoint, BYTE *pLUT, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetStretchedHistogramLUT")]
    public static extern bool _is6_GetStretchedHistogramLUT(IntPtr pHisto, UInt32 uTotalElements, double fLowPercent, double fHiPercent, UInt32 midPoint, IntPtr pLUT, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_BrightnessHistogramEqualizeImage(BYTE *pRGB, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, UINT32 uLoThresh, UINT32 uHiThresh, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_BrightnessHistogramEqualizeImage")]
    public static extern bool _is6_BrightnessHistogramEqualizeImage(IntPtr pRGB, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, UInt32 uLoThresh, UInt32 uHiThresh, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_HistogramEqualizeImage(void *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uChannelsPerPixel, UINT32 uRowStride, UINT32 uLoThresh, UINT32 uHiThresh, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_HistogramEqualizeImage")]
    public static extern bool _is6_HistogramEqualizeImage(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uChannelsPerPixel, UInt32 uRowStride, UInt32 uLoThresh, UInt32 uHiThresh, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_HistogramSpecification(void *pImg, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uRowStride, const UINT32 *pTargetHisto, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_HistogramSpecification")]
    public static extern bool _is6_HistogramSpecification(IntPtr pImg, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uRowStride, IntPtr pTargetHisto, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ContrastMaskImage(BYTE *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uInRowStride, UINT32 uBlendMode, double fSigma, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ContrastMaskImage")]
    public static extern bool _is6_ContrastMaskImage(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uInRowStride, UInt32 uBlendMode, double fSigma, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_InpaintImage(const void * pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uChannelsPerPixel, UINT32 uInRowStride, void * pOut, UINT32 uOutRowStride, const void *pMask, UINT32 uMaskRowStride, int sigma, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_InpaintImage")]
    public static extern bool _is6_InpaintImage(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uChannelsPerPixel, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, IntPtr pMask, UInt32 uMaskRowStride, int sigma, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HGLOBAL is6_FFTAllocGrid(UINT32 uWidth, UINT32 uHeight);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_FFTAllocGrid")]
    public static extern IntPtr _is6_FFTAllocGrid(UInt32 uWidth, UInt32 uHeight);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_FFTTransform(const void *pInput, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, double *grid, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_FFTTransform")]
    public static extern bool _is6_FFTTransform(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, IntPtr grid, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_FFTFilterIntPtrgrid, UINT32 width, UINT32 height, UINT32 uFilterType, const double *params);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_FFTFilter")]
    public static extern bool _is6_FFTFilter(IntPtr grid, UInt32 width, UInt32 height, UInt32 uFilterType, IntPtr pParams);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_FFTTransformInverse(UINT32 uWidth, UINT32 uHeight, double *grid);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_FFTTransformInverse")]
    public static extern bool _is6_FFTTransformInverse(UInt32 uWidth, UInt32 uHeight, IntPtr grid);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_FFTToGrayscale(void * pOut, double *grid, UINT32 width, UINT32 height, UINT32 uRowStride, UINT32 uMode, BOOL bShiftDC, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_FFTToGrayscale")]
    public static extern bool _is6_FFTToGrayscale(IntPtr pOut, IntPtr grid, UInt32 width, UInt32 height, UInt32 uRowStride, UInt32 uMode, bool bShiftDC, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_NextPowerOfTwo(UINT32 val);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_NextPowerOfTwo")]
    public static extern UInt32 _is6_NextPowerOfTwo(UInt32 val);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DetermineImageTranslation(const BYTE *p8A, UINT32 wA, UINT32 hA, UINT32 rsA, const BYTE *p8B, UINT32 wB, UINT32 hB, UINT32 rsB, int *px, int *py, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DetermineImageTranslation")]
    public static extern bool _is6_DetermineImageTranslation(IntPtr p8A, UInt32 wA, UInt32 hA, UInt32 rsA, IntPtr p8B, UInt32 wB, UInt32 hB, UInt32 rsB, ref Int32 px, ref Int32 py, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GaussianBlurImage(const void *pInput, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uInRowStride, void *pOutput, UINT32 uOutRowStride, double fSigmaX, double fSigmaY, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GaussianBlurImage")]
    public static extern bool _is6_GaussianBlurImage(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInRowStride, IntPtr pOutput, UInt32 uOutRowStride, double fSigmaX, double fSigmaY, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_UnsharpMaskImage(const void *pInput, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uInRowStride, void *pOutput, UINT32 uOutRowStride, UINT32 uThreshold, double fAmount, double fSigma, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_UnsharpMaskImage")]
    public static extern bool _is6_UnsharpMaskImage(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInRowStride, IntPtr pOutput, UInt32 uOutRowStride, UInt32 uThreshold, double fAmount, double fSigma, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_Convolve(const void *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uInRowStride, void *pImageOut, UINT32 uOutRowStride, UINT32 uMode, double fK, double *pMatrix, UINT32 nX, UINT32 nY, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_Convolve")]
    public static extern bool _is6_Convolve(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInRowStride, IntPtr pImageOut, UInt32 uOutRowStride, UInt32 uMode, double fK, IntPtr pMatrix, UInt32 nX, UInt32 nY, UInt32 uFlags);
    
    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ApplyLUTAndCrossoverMatrixToRGB(BYTE *pRGB, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, BYTE *pLUT, double *pMatrix);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ApplyLUTAndCrossoverMatrixToRGB")]
    public static extern bool _is6_ApplyLUTAndCrossoverMatrixToRGB(IntPtr pRGB, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, IntPtr pLUT, IntPtr pMatrix);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_CannyEdgeDetector(const BYTE *pIn, UINT32 w, UINT32 h, UINT32 uInRowStride, BYTE *pOut, UINT32 uOutRowStride, double fSigma, double tLow, double tHigh, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_CannyEdgeDetector")]
    public static extern bool _is6_CannyEdgeDetector(IntPtr pIn, UInt32 w, UInt32 h, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, double fSigma, double tLow, double tHigh, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_MotionBlur(const void *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uBpp, UINT32 uInRowStride, void *pOut, UINT32 uOutRowStride, double fAngle, double fSigma, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_MotionBlur")]
    public static extern bool _is6_MotionBlur(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uBpp, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, double fAngle, double fSigma, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_RadialBlur(const void *pIn, UINT32 inW, UINT32 inH, UINT32 bpp, UINT32 uInRowStride, void *pOut, UINT32 uOutRowStride, double fAngle, double quality, POINT * pCenter, UINT32 uFlags) ;
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_RadialBlur")]
    public static extern bool _is6_RadialBlur(IntPtr pIn, UInt32 inW, UInt32 inH, UInt32 bpp, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, double fAngle, double quality, ref POINT pCenter, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ZoomBlur(const void *pIn, UINT32 inW, UINT32 inH, UINT32 bpp, UINT32 uInRowStride, void *pOut, UINT32 uOutRowStride, double amount, POINT *pCenter, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ZoomBlur")]
    public static extern bool _is6_ZoomBlur(IntPtr pIn, UInt32 inW, UInt32 inH, UInt32 bpp, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, double amount, ref POINT pCenter, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_Filter(const void *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uInRowStride, void *pOut, UINT32 uOutRowStride, UINT32 uFilterSize, UINT32 uMode, UINT32 k, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_Filter")]
    public static extern bool _is6_Filter(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, UInt32 uFilterSize, UInt32 uMode, UInt32 k, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_SharpenImage(const void *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uInRowStride, void *pOut, UINT32 uOutRowStride, UINT32 uFilterSize, double fK, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SharpenImage")]
    public static extern bool _is6_SharpenImage(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, UInt32 uFilterSize, double fK, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_BlurImage(const void *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uInRowStride, void *pOut, UINT32 uOutRowStride, UINT32 uFilterSize, double fK, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_BlurImage")]
    public static extern bool _is6_BlurImage(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, UInt32 uFilterSize, double fK, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_MedianFilterImage(const void *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uInRowStride, void *pOut, UINT32 uOutRowStride, UINT32 uFilterSize, double fAmount, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_MedianFilterImage")]
    public static extern bool _is6_MedianFilterImage(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, UInt32 uFilterSize, double fAmount, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ThresholdFilter(void *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uInRowStride, UINT32 uMinVal, UINT32 uMaxVal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ThresholdFilter")]
    public static extern bool _is6_ThresholdFilter(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInRowStride, UInt32 uMinVal, UInt32 uMaxVal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AdaptiveUnsharpMask(const void *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uInRowStride, void *pOut, UINT32 uOutRowStride, UINT32 uThreshold, double fAmount, UINT32 uMode, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AdaptiveUnsharpMask")]
    public static extern bool _is6_AdaptiveUnsharpMask(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, UInt32 uThreshold, double fAmount, UInt32 uMode, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_FindImageMean(const void *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uInRowStride, double *pMean, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_FindImageMean")]
    public static extern bool _is6_FindImageMean(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInRowStride, ref double pMean, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_FindImageStandardDeviation(const void *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uInRowStride, double *pStdDeviation, double *pMean, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_FindImageStandardDeviation")]
    public static extern bool _is6_FindImageStandardDeviation(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInRowStride, ref double pStdDeviation, ref double pMean, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_LocalHistogramEnhancement(const void *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uInRowStride, void *pOut, UINT32 uOutRowStride, UINT32 uFilterSize, double *pMeans, double *pStdDeviations, double k0, double k1, double k2, double k3, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_LocalHistogramEnhancement")]
    public static extern bool _is6_LocalHistogramEnhancement(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, UInt32 uFilterSize, IntPtr pMeans, IntPtr pStdDeviations, double k0, double k1, double k2, double k3, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_MedianFilter1Bit(const BYTE *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pOut, UINT32 uOutRowStride, UINT32 N, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_MedianFilter1Bit")]
    public static extern bool _is6_MedianFilter1Bit(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, UInt32 N, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DustAndScratches(const void *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uInRowStride, void *pOut, UINT32 uOutRowStride, UINT32 uFilterSize, UINT32 uThreshold, double fAmount, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DustAndScratches")]
    public static extern bool _is6_DustAndScratches(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, UInt32 uFilterSize, UInt32 uThreshold, double fAmount, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_BilateralFilterImage(const void *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uInRowStride, void *pOut, UINT32 uRowOutStride, UINT32 uFilterSize, UINT32 uFilterType, double fSigma, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_BilateralFilterImage")]
    public static extern bool _is6_BilateralFilterImage(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInRowStride, IntPtr pOut, UInt32 uRowOutStride, UInt32 uFilterSize, UInt32 uFilterType, double fSigma, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_CrossBilateralFilterImage(const void *pIn1, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, const void *pIn2, void *pOut, UINT32 uOutRowStride, double fSpaceSigma, double fRangeSigma, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_CrossBilateralFilterImage")]
    public static extern bool _is6_CrossBilateralFilterImage(IntPtr pIn1, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pIn2, IntPtr pOut, UInt32 uOutRowStride, double fSpaceSigma, double fRangeSigma, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GuidedFilter(const void *pInImg, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel,UINT32 uInRowStride, const void *pGuideImg, UINT32 uGuideRowStride, void *pOutImg, UINT32 uOutRowStride, UINT32 uRadius, double fDepth, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GuidedFilter")]
    public static extern bool _is6_GuidedFilter(IntPtr pInImg, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInRowStride, IntPtr pGuideImg, UInt32 uGuideRowStride, IntPtr pOutImg, UInt32 uOutRowStride, UInt32 uRadius, double fDepth, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_RetinexImage(const void *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, void *pOut, UINT32 uOutRowStride, UINT32 uMode, double fA, double fB, double fC, double fD, double fGamma, double maxVal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_RetinexImage")]
    public static extern bool _is6_RetinexImage(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, UInt32 uMode, double fA, double fB, double fC, double fD, double fGamma, double maxVal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_SobelFilter(const void *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uInRowStride, void *pOut, UINT32 uOutRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SobelFilter")]
    public static extern bool _is6_SobelFilter(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ApplyWindow(const void *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uInRowStride, UINT32 uWindowType, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ApplyWindow")]
    public static extern bool _is6_ApplyWindow(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInRowStride, UInt32 uWindowType, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_MultiscaleDenoise(const void *pInImg, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uInRowStride, void *pOutImg, UINT32 uOutRowStride, double fThreshold, double fCurve, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_MultiscaleDenoise")]
    public static extern bool _is6_MultiscaleDenoise(IntPtr pInImg, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInRowStride, IntPtr pOutImg, UInt32 uOutRowStride, double fThreshold, double fCurve, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_MultiscaleDecompose(const void *pInImg, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, UINT passes, void **pOutImages, UINT32 uOutRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_MultiscaleDecompose")]
    public static extern bool _is6_MultiscaleDecompose(IntPtr pInImg, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, UInt32 passes, IntPtr pOutImages, UInt32 uOutRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_MultiscaleRecompose(const void **pInImages, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, UINT uImages, void *pOutImg, UINT32 uOutRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_MultiscaleRecompose")]
    public static extern bool _is6_MultiscaleRecompose(IntPtr pInImages, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, UInt32 uImages, IntPtr pOutImg, UInt32 uOutRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_MorphoDilationGray(const BYTE *pInGray, UINT32 w, UINT32 h, UINT32 uInRowStride, const int *mask, int N, BYTE *pOutGray, UINT32 uOutRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_MorphoDilationGray")]
    public static extern bool _is6_MorphoDilationGray(IntPtr pInGray, UInt32 w, UInt32 h, UInt32 uInRowStride, IntPtr mask, Int32 N, IntPtr pOutGray, UInt32 uOutRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_MorphoErosionGray(const BYTE *pInGray, UINT32 w, UINT32 h, UINT32 uInRowStride, const int* mask, int N, BYTE *pOutGray, UINT32 uOutRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_MorphoErosionGray")]
    public static extern bool _is6_MorphoErosionGray(IntPtr pInGray, UInt32 w, UInt32 h, UInt32 uInRowStride, IntPtr mask, Int32 N, IntPtr pOutGray, UInt32 uOutRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_CloseGray(const BYTE *pInGray, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, const int *piMask, int N, BYTE *pOutGray, UINT32 uOutRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_CloseGray")]
    public static extern bool _is6_CloseGray(IntPtr pInGray, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr piMask, Int32 N, IntPtr pOutGray, UInt32 uOutRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_OpenGray(const BYTE *pInGray, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, const int *piMask, int N, BYTE *pOutGray, UINT32 uOutRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_OpenGray")]
    public static extern bool _is6_OpenGray(IntPtr pInGray, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr piMask, Int32 N, IntPtr pOutGray, UInt32 uOutRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_TophatGray(const BYTE *pInGray, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, const int *piMask, int N, BYTE *pOutGray, UINT32 uOutRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_TophatGray")]
    public static extern bool _is6_TophatGray(IntPtr pInGray, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr piMask, Int32 N, IntPtr pOutGray, UInt32 uOutRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_MorphoGradientGray(const BYTE *pInGray, UINT32 w, UINT32 h, UINT32 uInRowStride, const int *pMask, int N, BYTE *pOutGray, UINT32 uOutRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_MorphoGradientGray")]
    public static extern bool _is6_MorphoGradientGray(IntPtr pInGray, UInt32 w, UInt32 h, UInt32 uInRowStride, IntPtr pMask, Int32 N, IntPtr pOutGray, UInt32 uOutRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_MorphoDilation1Bit(const BYTE *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pOut, UINT32 uOutRowStride, const int *mask, UINT32 uFilterSizeX, UINT32 uFilterSizeY, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_MorphoDilation1Bit")]
    public static extern bool _is6_MorphoDilation1Bit(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, IntPtr mask, UInt32 uFilterSizeX, UInt32 uFilterSizeY, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_MorphoErosion1Bit(const BYTE *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pOut, UINT32 uOutRowStride, const int *mask, UINT32 N, UINT32 J, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_MorphoErosion1Bit")]
    public static extern bool _is6_MorphoErosion1Bit(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, IntPtr mask, UInt32 N, UInt32 J, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_MorphoClose1Bit(const BYTE *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pOut, UINT32 uOutRowStride, const int *mask, UINT32 uFilterSizeX, UINT32 uFilterSizeY ,UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_MorphoClose1Bit")]
    public static extern bool _is6_MorphoClose1Bit(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, IntPtr mask, UInt32 uFilterSizeX, UInt32 uFilterSizeY, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_MorphoOpen1Bit(const BYTE *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pOut, UINT32 uOutRowStride, const int *pMask, UINT32 N, UINT32 J, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_MorphoOpen1Bit")]
    public static extern bool _is6_MorphoOpen1Bit(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, IntPtr pMask, UInt32 N, UInt32 J, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_MorphoHitOrMiss1Bit(const BYTE *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pOut, UINT32 uOutRowStride, const int *pMaskA, UINT32 Na, UINT32 Ja, const int *maskB, UINT32 Nb, UINT32 Jb, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_MorphoHitOrMiss1Bit")]
    public static extern bool _is6_MorphoHitOrMiss1Bit(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, IntPtr pMaskA, UInt32 Na, UInt32 Ja, IntPtr maskB, UInt32 Nb, UInt32 Jb, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_MorphoBoundaryExtraction1Bit(const BYTE *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pOut, UINT32 uOutRowStride, const int *pMask, UINT32 N, UINT32 J, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_MorphoBoundaryExtraction1Bit")]
    public static extern bool _is6_MorphoBoundaryExtraction1Bit(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, IntPtr pMask, UInt32 N, UInt32 J, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_MorphoThinning1Bit(const BYTE *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pOut, const int *masksA, UINT32 uElementsInAMask, const int *masksB, UINT32 uElementsInBMask, UINT32 uMaskCount, UINT32 uMaxIterations, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_MorphoThinning1Bit")]
    public static extern bool _is6_MorphoThinning1Bit(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, IntPtr masksA, UInt32 uElementsInAMask, IntPtr masksB, UInt32 uElementsInBMask, UInt32 uMaskCount, UInt32 uMaxIterations, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_InvertBuffer(void * pBuf, UINT32 uLen);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_InvertBuffer")]
    public static extern bool _is6_InvertBuffer(IntPtr pBuf, UInt32 uLen);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_CopyInvertedBuffer(const void *pIn, void *pOut, UINT32 uLen);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_CopyInvertedBuffer")]
    public static extern void _is6_CopyInvertedBuffer(IntPtr pIn, IntPtr pOut, UInt32 uLen);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_IntersectBuffers(const void *pA, const void *pB, void *pOut, UINT32 uLen);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_IntersectBuffers")]
    public static extern bool _is6_IntersectBuffers(IntPtr pA, IntPtr pB, IntPtr pOut, UInt32 uLen);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_IntersectRow1Bit(const void *pA, const void *pB, void *pOut, UINT32 uPix);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_IntersectRow1Bit")]
    public static extern bool _is6_IntersectRow1Bit(IntPtr pA, IntPtr pB, IntPtr pOut, UInt32 uPix);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_UnionBuffers(const void *pA, const void *pB, void *pOut, UINT32 uLen);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_UnionBuffers")]
    public static extern bool _is6_UnionBuffers(IntPtr pA, IntPtr pB, IntPtr pOut, UInt32 uLen);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_XORBuffers(const void *pA, const void *pB, void *pOut, UINT32 uLen);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_XORBuffers")]
    public static extern bool _is6_XORBuffers(IntPtr pA, IntPtr pB, IntPtr pOut, UInt32 uLen);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AddNoise(void *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uInRowStride, UINT32 uMode, double fVariance, double fMean, BOOL bMonochromatic, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AddNoise")]
    public static extern bool _is6_AddNoise(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInRowStride, UInt32 uMode, double fVariance, double fMean, bool bMonochromatic, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GenerateColoredNoise(BYTE *pOut, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, COLORREF clrLow, UINT32 uSize, UINT32 uMode);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GenerateColoredNoise")]
    public static extern bool _is6_GenerateColoredNoise(IntPtr pOut, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, UInt32 clrLow, UInt32 uSize, UInt32 uMode);

    ////////////////////////////////////////////////////////////////////////////////
    //   HISPERLIN is6_InitializePerlinNoiseVolume(UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_InitializePerlinNoiseVolume")]
    public static extern IntPtr _is6_InitializePerlinNoiseVolume(UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetPerlinNoiseSlice(HISPERLIN hPerlin, void *pOut, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, double fScale, double fZOffset, double xStart, double yStart, double radians, double xRotOrig, double yRotOrig, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetPerlinNoiseSlice")]
    public static extern bool _is6_GetPerlinNoiseSlice(IntPtr hPerlin, IntPtr pOut, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, double fScale, double fZOffset, double xStart, double yStart, double radians, double xRotOrig, double yRotOrig, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DestroyPerlinNoiseVolume(HISPERLIN hPerlin);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DestroyPerlinNoiseVolume")]
    public static extern bool _is6_DestroyPerlinNoiseVolume(IntPtr hPerlin);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GenerateHugoNoise(BYTE *pOut, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, int iOctaves, double fPersistence, double fScale);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GenerateHugoNoise")]
    public static extern bool _is6_GenerateHugoNoise(IntPtr pOut, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, int iOctaves, double fPersistence, double fScale);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_OverlayImage(void *pBottom, UINT32 uBottomWidth, UINT32 uBottomHeight, UINT32 uChannelsPerPixel, UINT32 uBottomRowStride, const void *pTop, UINT32 uTopWidth, UINT32 uTopHeight, UINT32 uTopRowStride, __int32 iXPos, __int32 iYPos, double fOpacity, double fK, UINT32 uMode, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_OverlayImage")]
    public static extern bool _is6_OverlayImage(IntPtr pBottom, UInt32 uBottomWidth, UInt32 uBottomHeight, UInt32 uChannelsPerPixel, UInt32 uBottomRowStride, IntPtr pTop, UInt32 uTopWidth, UInt32 uTopHeight, UInt32 uTopRowStride, Int32 iXPos, Int32 iYPos, double fOpacity, double fK, UInt32 uMode, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_Overlay8Bit(BYTE *pImageBottom, UINT32 uWidthBottom, UINT32 uHeightBottom, UINT32 uBottomRowStride, UINT32 uBottomPalColors, const RGBQUAD *pPalBottom, const BYTE *pImageTop, UINT32 uWidthTop, UINT32 uHeightTop, UINT32 uTopRowStride, const RGBQUAD *pPalTop, __int32 iXPos, __int32 iYPos, double fOpacity, UINT32 uTransColorIdx, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_Overlay8Bit")]
    public static extern bool _is6_Overlay8Bit(IntPtr pImageBottom, UInt32 uWidthBottom, UInt32 uHeightBottom, UInt32 uBottomRowStride, UInt32 uBottomPalColors, IntPtr pPalBottom, IntPtr pImageTop, UInt32 uWidthTop, UInt32 uHeightTop, UInt32 uTopRowStride, IntPtr pPalTop, Int32 iXPos, Int32 iYPos, double fOpacity, UInt32 uTransColorIdx, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_OverlayImageColor(BYTE *pBottom, UINT32 uBottomWidth, UINT32 uBottomHeight, UINT32 uBytesPerPixel, UINT32 uBottomRowStride, const BYTE *pTop, UINT32 uTopWidth, UINT32 uTopHeight, UINT32 uTopRowStride, __int32 iXPos, __int32 iYPos, double fOpacity, UINT32 uMode, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_OverlayImageColor")]
    public static extern bool _is6_OverlayImageColor(IntPtr pBottom, UInt32 uBottomWidth, UInt32 uBottomHeight, UInt32 uBytesPerPixel, UInt32 uBottomRowStride, IntPtr pTop, UInt32 uTopWidth, UInt32 uTopHeight, UInt32 uTopRowStride, Int32 iXPos, Int32 iYPos, double fOpacity, UInt32 uMode, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_Overlay8BitOnImage(BYTE *pRGB1, UINT32 uBottomWidth, UINT32 uBottomHeight, UINT32 uBottomBytesPerPixel, UINT32 uBottomRowStride, const BYTE *p8Bit, UINT32 uTopWidth, UINT32 uTopHeight, UINT32 uTopRowStride, const RGBQUAD *pPal, __int32 iXPos, __int32 iYPos, double fOpacity, UINT32 uTransColorIdx, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_Overlay8BitOnImage")]
    public static extern bool _is6_Overlay8BitOnImage(IntPtr pRGB1, UInt32 uBottomWidth, UInt32 uBottomHeight, UInt32 uBottomBytesPerPixel, UInt32 uBottomRowStride, IntPtr p8Bit, UInt32 uTopWidth, UInt32 uTopHeight, UInt32 uTopRowStride, IntPtr pPal, Int32 iXPos, Int32 iYPos, double fOpacity, UInt32 uTransColorIdx, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_OverlayImage8BitAlphaOnRGB(BYTE *pBottomImg, UINT32 uBottomWidth, UINT32 uBottomHeight, UINT32 uBottomRowStride, const BYTE *pTopImg, UINT32 uTopWidth, UINT32 uTopHeight, UINT32 uTopRowStride, const RGBQUAD *pPalTop, __int32 iXPos, __int32 iYPos, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_OverlayImage8BitAlphaOnRGB")]
    public static extern bool _is6_OverlayImage8BitAlphaOnRGB(IntPtr pBottomImg, UInt32 uBottomWidth, UInt32 uBottomHeight, UInt32 uBottomRowStride, IntPtr pTopImg, UInt32 uTopWidth, UInt32 uTopHeight, UInt32 uTopRowStride, IntPtr pPalTop, Int32 iXPos, Int32 iYPos, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_Overlay8BitTransIdxOnRGBA(BYTE *pBottomImg, UINT32 uBottomImageWidth, UINT32 uBottomImageHeight, UINT32 uBottomRowStride, const BYTE *pTopImg, UINT32 uTopImageWidth, UINT32 uTopImageHeight, UINT32 uTopRowStride, const RGBQUAD *pPalTop, __int32 iXPos, __int32 iYPos, UINT32 uTransColorIdx, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_Overlay8BitTransIdxOnRGBA")]
    public static extern bool _is6_Overlay8BitTransIdxOnRGBA(IntPtr pBottomImg, UInt32 uBottomImageWidth, UInt32 uBottomImageHeight, UInt32 uBottomRowStride, IntPtr pTopImg, UInt32 uTopImageWidth, UInt32 uTopImageHeight, UInt32 uTopRowStride, IntPtr pPalTop, Int32 iXPos, Int32 iYPos, UInt32 uTransColorIdx, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_OverlayImage8BitAlpha(BYTE *pBottomImg, UINT32 uBottomWidth, UINT32 uBottomHeight, UINT32 uBottomRowStride, const BYTE *pTopImg, UINT32 uTopWidth, UINT32 uTopHeight, UINT32 uTopRowStride, __int32 iXPos, __int32 iYPos, UINT32 uPalColors, const RGBQUAD *pPal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_OverlayImage8BitAlpha")]
    public static extern bool _is6_OverlayImage8BitAlpha(IntPtr pBottomImg, UInt32 uBottomWidth, UInt32 uBottomHeight, UInt32 uBottomRowStride, IntPtr pTopImg, UInt32 uTopWidth, UInt32 uTopHeight, UInt32 uTopRowStride, Int32 iXPos, Int32 iYPos, UInt32 uPalColors, IntPtr pPal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_Overlay1Bit(BYTE *pImageBottom, UINT32 uWidthBottom, UINT32 uHeightBottom, UINT32 uBottomRowStride, const BYTE *pImageTop, UINT32 uWidthTop, UINT32 uHeightTop, UINT32 uTopRowStride, __int32 iXPos, __int32 iYPos, UINT32 uMode, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_Overlay1Bit")]
    public static extern bool _is6_Overlay1Bit(IntPtr pImageBottom, UInt32 uWidthBottom, UInt32 uHeightBottom, UInt32 uBottomRowStride, IntPtr pImageTop, UInt32 uWidthTop, UInt32 uHeightTop, UInt32 uTopRowStride, Int32 iXPos, Int32 iYPos, UInt32 uMode, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_Overlay1BitMasked(BYTE *pImageBottom, UINT32 uWidthBottom, UINT32 uHeightBottom, UINT32 uBottomRowStride, const BYTE *pImageTop, UINT32 uWidthTop, UINT32 uHeightTop, UINT32 uTopRowStride, const BYTE *pMask, UINT32 uMaskRowStride, __int32 iXPos, __int32 iYPos, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_Overlay1BitMasked")]
    public static extern bool _is6_Overlay1BitMasked(IntPtr pImageBottom, UInt32 uWidthBottom, UInt32 uHeightBottom, UInt32 uBottomRowStride, IntPtr pImageTop, UInt32 uWidthTop, UInt32 uHeightTop, UInt32 uTopRowStride, IntPtr pMask, UInt32 uMaskRowStride, Int32 iXPos, Int32 iYPos, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_OverlayRGBTrans(BYTE *pRGB1, UINT32 uBottomWidth, UINT32 uBottomHeight, UINT32 uBottomRowStride, const BYTE *pRGB2, UINT32 uTopWidth, UINT32 uTopHeight, UINT32 uTopRowStride, __int32 iXPos, __int32 iYPos, double fOpacity, COLORREF clrTrans, UINT32 uTolerance, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_OverlayRGBTrans")]
    public static extern bool _is6_OverlayRGBTrans(IntPtr pRGB1, UInt32 uBottomWidth, UInt32 uBottomHeight, UInt32 uBottomRowStride, IntPtr pRGB2, UInt32 uTopWidth, UInt32 uTopHeight, UInt32 uTopRowStride, Int32 iXPos, Int32 iYPos, double fOpacity, UInt32 clrTrans, UInt32 uTolerance, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_OverlayRGBOnRGBA(BYTE *pRGBA, UINT32 uBottomWidth, UINT32 uBottomHeight, UINT32 uBottomRowStride, const BYTE *pRGB, UINT32 uTopWidth, UINT32 uTopHeight, UINT32 uTopRowStride, __int32 iXPos, __int32 iYPos, double fOpacity, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_OverlayRGBOnRGBA")]
    public static extern bool _is6_OverlayRGBOnRGBA(IntPtr pRGBA, UInt32 uBottomWidth, UInt32 uBottomHeight, UInt32 uBottomRowStride, IntPtr pRGB, UInt32 uTopWidth, UInt32 uTopHeight, UInt32 uTopRowStride, Int32 iXPos, Int32 iYPos, double fOpacity, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AlphaBlendRGB(BYTE *pRGB1, UINT32 uBottomWidth, UINT32 uBottomHeight, UINT32 uBottomRowStride, const BYTE *pRGB2, UINT32 uTopWidth, UINT32 uTopHeight, UINT32 uTopRowStride, const BYTE *pAlphaMask, __int32 iXPos, __int32 iYPos, double fOpacity, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AlphaBlendRGB")]
    public static extern bool _is6_AlphaBlendRGB(IntPtr pRGB1, UInt32 uBottomWidth, UInt32 uBottomHeight, UInt32 uBottomRowStride, IntPtr pRGB2, UInt32 uTopWidth, UInt32 uTopHeight, UInt32 uTopRowStride, IntPtr pAlphaMask, Int32 iXPos, Int32 iYPos, double fOpacity, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AlphaBlendRGBA(BYTE *pImage1, UINT32 uWidth1, UINT32 uHeight1, UINT32 uBottomBPP, UINT32 uBottomRowStride, const BYTE *pRGBA, UINT32 uWidth2, UINT32 uHeight2, UINT32 uTopRowStride, __int32 iXPos, __int32 iYPos, double fOpacity, UINT32 uMode, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AlphaBlendRGBA")]
    public static extern bool _is6_AlphaBlendRGBA(IntPtr pImage1, UInt32 uWidth1, UInt32 uHeight1, UInt32 uBottomBPP, UInt32 uBottomRowStride, IntPtr pRGBA, UInt32 uWidth2, UInt32 uHeight2, UInt32 uTopRowStride, Int32 iXPos, Int32 iYPos, double fOpacity, UInt32 uMode, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AlphaBlendColor(BYTE *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, const BYTE *pAlpha, UINT32 uAlphaWidth, UINT32 uAlphaHeight, UINT32 uAlphaRowStride, COLORREF clrBlend, __int32 iXPos, __int32 iYPos, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AlphaBlendColor")]
    public static extern bool _is6_AlphaBlendColor(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, IntPtr pAlpha, UInt32 uAlphaWidth, UInt32 uAlphaHeight, UInt32 uAlphaRowStride, UInt32 clrBlend, Int32 iXPos, Int32 iYPos, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AlphaBlend8BitGray(BYTE *pImage1, UINT32 uBottomWidth, UINT32 uBottomHeight, UINT32 uBottomRowStride, const BYTE *pImage2, UINT32 uTopWidth, UINT32 uTopHeight, UINT32 uTopRowStride, __int32 iXPos, __int32 iYPos, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AlphaBlend8BitGray")]
    public static extern bool _is6_AlphaBlend8BitGray(IntPtr pImage1, UInt32 uBottomWidth, UInt32 uBottomHeight, UInt32 uBottomRowStride, IntPtr pImage2, UInt32 uTopWidth, UInt32 uTopHeight, UInt32 uTopRowStride, Int32 iXPos, Int32 iYPos, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ChromaKeyOverlayRGB(BYTE *pBG, UINT32 uWidthBG, UINT32 uHeightBG, UINT32 uRowStrideBG, const BYTE *pFG, UINT32 uWidthFG, UINT32 uHeightFG, UINT32 uRowStrideFG, __int32 iXPos, __int32 iYPos, COLORREF clrKey, double fAngle, UINT32 uNoise, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ChromaKeyOverlayRGB")]
    public static extern bool _is6_ChromaKeyOverlayRGB(IntPtr pBG, UInt32 uWidthBG, UInt32 uHeightBG, UInt32 uRowStrideBG, IntPtr pFG, UInt32 uWidthFG, UInt32 uHeightFG, UInt32 uRowStrideFG, Int32 iXPos, Int32 iYPos, UInt32 clrKey, double fAngle, UInt32 uNoise, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ChromaKeyGetMask(const BYTE *pRGB, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pOut, UINT32 uOutRowStride, COLORREF clrKey, double fAngle, UINT32 uNoise, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ChromaKeyGetMask")]
    public static extern bool _is6_ChromaKeyGetMask(IntPtr pRGB, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, UInt32 clrKey, double fAngle, UInt32 uNoise, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_OverlayDIBOnDIB(BITMAPINFOHEADER *pDIBBottom, const BITMAPINFOHEADER *pDIBTop, __int32 iXPos, __int32 iYPos, UINT32 uFlags1, UINT32 uFlags2, double fK);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_OverlayDIBOnDIB")]
    public static extern bool _is6_OverlayDIBOnDIB(ref BITMAPINFOHEADER pDIBBottom, ref BITMAPINFOHEADER pDIBTop, Int32 iXPos, Int32 iYPos, UInt32 uFlags1, UInt32 uFlags2, double fK);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ImageToGrayScale(void *pInput, UINT32 uWidth, UINT32 uHeight, UINT32 uChannelsPerPixel, UINT32 uRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ImageToGrayScale")]
    public static extern bool _is6_ImageToGrayScale(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uChannelsPerPixel, UInt32 uRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ImageToGrayScaleSingle(const void *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uInRowStride, void *pOutput, UINT32 uOutRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ImageToGrayScaleSingle")]
    public static extern bool _is6_ImageToGrayScaleSingle(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uInRowStride, IntPtr pOutput, UInt32 uOutRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ImageToGrayScaleWeighted(void *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uChannelsPerPixel, UINT32 uRowStride, double rw, double gw, double bw, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ImageToGrayScaleWeighted")]
    public static extern bool _is6_ImageToGrayScaleWeighted(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uChannelsPerPixel, UInt32 uRowStride, double rw, double gw, double bw, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ImageToGrayScaleSingleWeighted(const void *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uInRowStride, void *pOutput, UINT32 uOutRowStride, double rw, double gw, double bw, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ImageToGrayScaleSingleWeighted")]
    public static extern bool _is6_ImageToGrayScaleSingleWeighted(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uInRowStride, IntPtr pOutput, UInt32 uOutRowStride, double rw, double gw, double bw, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_RGBToBGR(void *pRGB, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_RGBToBGR")]
    public static extern bool _is6_RGBToBGR(IntPtr pRGB, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_RGBAToBGRA(void *pRGBA, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_RGBAToBGRA")]
    public static extern bool _is6_RGBAToBGRA(IntPtr pRGBA, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_RGBToRGBA(const BYTE *pRGB, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE* pRGBAOut, UINT32 uOutRowStride, UINT32 uFillAlpha);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_RGBToRGBA")]
    public static extern bool _is6_RGBToRGBA(IntPtr pRGB, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pRGBAOut, UInt32 uOutRowStride, UInt32 uFillAlpha);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_SplitImage(const void *pInput, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uInRowStride, void **pOutPlanes, UINT32 uOutRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SplitImage")]
    public static extern bool _is6_SplitImage(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInRowStride, IntPtr pOutPlanes, UInt32 uOutRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_CopyImageChannel(const void *pInput, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uInRowStride, void *pOut, UINT32 uOutRowStride, UINT32 uChannelIdx, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_CopyImageChannel")]
    public static extern bool _is6_CopyImageChannel(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, UInt32 uChannelIdx, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_CombineImageChannels(const void **pInputPlanes, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uInRowStride, void *pOutput, UINT32 uOutRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_CombineImageChannels")]
    public static extern bool _is6_CombineImageChannels(IntPtr pInputPlanes, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInRowStride, IntPtr pOutput, UInt32 uOutRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_SetImageChannel(const void *pSingleChannel, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, void *pOut, UINT32 uComponentsPerPixel, UINT32 uOutRowStride, UINT32 uChannelIdx, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SetImageChannel")]
    public static extern bool _is6_SetImageChannel(IntPtr pSingleChannel, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uComponentsPerPixel, UInt32 uOutRowStride, UInt32 uChannelIdx, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ShuffleImageChannels(const void *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uInRowStride, void *pOut, UINT32 uOutRowStride, BYTE *pPositions, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ShuffleImageChannels")]
    public static extern bool _is6_ShuffleImageChannels(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, IntPtr pPositions, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_SplitRGBAToRGBPlusA(const void *pRGBA, UINT32 uWidth, UINT32 uHeight, UINT32 uRGBARowStride, void *pRGB, UINT32 uRGBRowStride, void *pAlpha, UINT32 uARowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SplitRGBAToRGBPlusA")]
    public static extern bool _is6_SplitRGBAToRGBPlusA(IntPtr pRGBA, UInt32 uWidth, UInt32 uHeight, UInt32 uRGBARowStride, IntPtr pRGB, UInt32 uRGBRowStride, IntPtr pAlpha, UInt32 uARowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ReorderChannels(void *pInput, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uInRowStride, void *pOutput, UINT32 uOutRowStride, void *pOrderArray, UINT32 uOrderArraySize, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ReorderChannels")]
    public static extern bool _is6_ReorderChannels(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInRowStride, IntPtr pOutput, UInt32 uOutRowStride, IntPtr pOrderArray, UInt32 uOrderArraySize, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_BlendSolidColor(BYTE *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, COLORREF clrBlend, double fAmount, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_BlendSolidColor")]
    public static extern bool _is6_BlendSolidColor(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, UInt32 clrBlend, double fAmount, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AlphaBlendSolidColor(BYTE *pRGBA, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, COLORREF clrBlend, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AlphaBlendSolidColor")]
    public static extern bool _is6_AlphaBlendSolidColor(IntPtr pRGBA, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, UInt32 clrBlend, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GrayscaleTo1Bit(const BYTE *pImg8, UINT32 w, UINT32 h, UINT32 uInRowStride, BYTE *pImg1, UINT32 uOutRowStride, UINT32 uMode, UINT32 uParam, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GrayscaleTo1Bit")]
    public static extern bool _is6_GrayscaleTo1Bit(IntPtr pImg8, UInt32 w, UInt32 h, UInt32 uInRowStride, IntPtr pImg1, UInt32 uOutRowStride, UInt32 uMode, UInt32 uParam, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   int is6_GetGrayscaleTo1BitThreshold(const BYTE *pImg8, UINT32 w, UINT32 h, UINT32 uInRowStride, UINT32 uMode, UINT32 uParam1, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetGrayscaleTo1BitThreshold")]
    public static extern int _is6_GetGrayscaleTo1BitThreshold(IntPtr pImg8, UInt32 w, UInt32 h, UInt32 uInRowStride, UInt32 uMode, UInt32 uParam1, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_Pack8BitBuffer(const BYTE *pInput, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pOutput, UINT32 uBPP, BOOL bPadRows, UINT32 uOutRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_Pack8BitBuffer")]
    public static extern bool _is6_Pack8BitBuffer(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOutput, UInt32 uBPP, bool bPadRows, UInt32 uOutRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_UnpackBufferTo8Bit(const BYTE *pInput, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, UINT32 uInBPP, BYTE *pOut8Bit, UINT32 uOutRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_UnpackBufferTo8Bit")]
    public static extern bool _is6_UnpackBufferTo8Bit(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, UInt32 uInBPP, IntPtr pOut8Bit, UInt32 uOutRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ShiftImageChannels(const BYTE *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uInRowStride, BYTE *pOutImage, UINT32 uOutRowStride, __int32 iXOffset, __int32 iYOffset, UINT32 uBackGround, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ShiftImageChannels")]
    public static extern bool _is6_ShiftImageChannels(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uInRowStride, IntPtr pOutImage, UInt32 uOutRowStride, Int32 iXOffset, Int32 iYOffset, UInt32 uBackGround, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_CopyBuffer(const BYTE *pInputBuf, UINT32 uInWidthBytes, UINT32 uHeight, UINT32 uOutWidthBytes, BYTE *pOutputBuf);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_CopyBuffer")]
    public static extern bool _is6_CopyBuffer(IntPtr pInputBuf, UInt32 uInWidthBytes, UInt32 uHeight, UInt32 uOutWidthBytes, IntPtr pOutputBuf);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_8BitToRGB(const BYTE *p8Bit, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pRGB, UINT32 uOutRowStride, UINT32 uColors, const RGBQUAD *pPal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_8BitToRGB")]
    public static extern bool _is6_8BitToRGB(IntPtr p8Bit, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pRGB, UInt32 uOutRowStride, UInt32 uColors, IntPtr pPal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_8BitToRGBA(const BYTE *p8Bit, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pRGBA, UINT32 uOutRowStride, UINT32 uColors, const RGBQUAD *pPal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_8BitToRGBA")]
    public static extern bool _is6_8BitToRGBA(IntPtr p8Bit, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pRGBA, UInt32 uOutRowStride, UInt32 uColors, IntPtr pPal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_CombineRGBAndAToRGBA(const void *pRGB, UINT32 uWidth, UINT32 uHeight, UINT32 uRGBRowStride, const void *pAlpha, UINT32 uARowStride, void *pRGBA, UINT32 uRGBARowStride, UINT32 uFillAlpha, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_CombineRGBAndAToRGBA")]
    public static extern bool _is6_CombineRGBAndAToRGBA(IntPtr pRGB, UInt32 uWidth, UInt32 uHeight, UInt32 uRGBRowStride, IntPtr pAlpha, UInt32 uARowStride, IntPtr pRGBA, UInt32 uRGBARowStride, UInt32 uFillAlpha, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_CropImage(const BYTE *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pOut, UINT32 uOutRowStride, const RECT * pCropRect, UINT32 uBytesPerPixel);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_CropImage")]
    public static extern bool _is6_CropImage(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, ref RECT pCropRect, UInt32 uBytesPerPixel);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_Crop1Bit(const BYTE *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pOut, UINT32 uOutRowStride, const RECT * pCropRect);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_Crop1Bit")]
    public static extern bool _is6_Crop1Bit(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, ref RECT pCropRect);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_VerticalFlipImage(BYTE * pBuffer, UINT32 uRowStride, UINT32 uHeight);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_VerticalFlipImage")]
    public static extern bool _is6_VerticalFlipImage(IntPtr pBuffer, UInt32 uRowStride, UInt32 uHeight);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_HorizontalFlipImage(BYTE *pImg, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_HorizontalFlipImage")]
    public static extern bool _is6_HorizontalFlipImage(IntPtr pImg, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_FlipHorizontal1Bit(BYTE *pImg, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_FlipHorizontal1Bit")]
    public static extern bool _is6_FlipHorizontal1Bit(IntPtr pImg, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_FillSolidRect(BYTE *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, const RECT * pFillRect, UINT32 uColorSpec, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_FillSolidRect")]
    public static extern bool _is6_FillSolidRect(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, ref RECT pFillRect, UInt32 uColorSpec, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_FillSolidRect1Bit(BYTE *p1Bit, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, const RECT * pFillRect, UINT32 uIdxFill);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_FillSolidRect1Bit")]
    public static extern bool _is6_FillSolidRect1Bit(IntPtr p1Bit, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, ref RECT pFillRect, UInt32 uIdxFill);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_FillSolidRectSingleChannel(BYTE *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, const RECT * pFillRect, BYTE uColorSpec, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_FillSolidRectSingleChannel")]
    public static extern bool _is6_FillSolidRectSingleChannel(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, ref RECT pFillRect, byte uColorSpec, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_FillTransparentRectOnImage(BYTE *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, const RECT *pFillRect, COLORREF clrBlend, double fOpacity, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_FillTransparentRectOnImage")]
    public static extern bool _is6_FillTransparentRectOnImage(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, ref RECT pFillRect, UInt32 clrBlend, double fOpacity, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_FloodFillImage(BYTE *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, const POINT * pptStart, COLORREF clrFill, UINT32 uFillMode, UINT32 uTolerance, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_FloodFillImage")]
    public static extern bool _is6_FloodFillImage(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, ref POINT pptStart, UInt32 clrFill, UInt32 uFillMode, UInt32 uTolerance, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetColorMatchMaskFromImage(const BYTE *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uInRowStride, BYTE *p8BitMask, UINT32 uOutRowStride, const POINT * pptCenter, COLORREF clr, UINT32 uFillMode, UINT32 uClrTolerance, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetColorMatchMaskFromImage")]
    public static extern bool _is6_GetColorMatchMaskFromImage(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uInRowStride, IntPtr p8BitMask, UInt32 uOutRowStride, ref POINT pptCenter, UInt32 clr, UInt32 uFillMode, UInt32 uClrTolerance, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetHSVColorMatchMaskFromImageIntPtrpHSV, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *p8BitMask, UINT32 uOutRowStride, UINT32 uStartX, UINT32 uStartY, double h, double s, double vOrL, UINT32 uFillMode, double fHTolerance, double fSTolerance, double fVOrLTolerance, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetHSVColorMatchMaskFromImage")]
    public static extern bool _is6_GetHSVColorMatchMaskFromImage(IntPtr pHSV, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr p8BitMask, UInt32 uOutRowStride, UInt32 uStartX, UInt32 uStartY, double h, double s, double vOrL, UInt32 uFillMode, double fHTolerance, double fSTolerance, double fVOrLTolerance, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_PolygonFillImage(BYTE *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uInRowStride, XYdouble *pPoints, UINT32 uNumPoints, BYTE *pOverImage, UINT32 uOverW, UINT32 uOverH, UINT32 uOverRowStride, UINT32 uClrSpec, double fOpacity, RGBQUAD *pPal, UINT32 uPalColors, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_PolygonFillImage")]
    public static extern bool _is6_PolygonFillImage(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uInRowStride, IntPtr pPoints, UInt32 uNumPoints, IntPtr pOverImage, UInt32 uOverW, UInt32 uOverH, UInt32 uOverRowStride, UInt32 uClrSpec, double fOpacity, IntPtr pPal, UInt32 uPalColors, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_PolygonFillImage_16(ISUINT16 *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uInRowStride, XYdouble *pPoints, UINT32 uNumPoints, ISRGBA16 *pClrSpec, double fOpacity, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_PolygonFillImage_16")]
    public static extern bool _is6_PolygonFillImage_16(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInRowStride, IntPtr pPoints, UInt32 uNumPoints, IntPtr pClrSpec, double fOpacity, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetPolygonScanlineArray(XYdouble *pInPoints, UINT32 uNumInPoints, HGLOBAL *puRowArray, HGLOBAL *puDoubleLeftXArray, HGLOBAL *puDoubleRightXArray, UINT32 *puNumRows, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetPolygonScanlineArray")]
    public static extern bool _is6_GetPolygonScanlineArray(IntPtr pInPoints, UInt32 uNumInPoints, ref IntPtr puRowArray, ref IntPtr puDoubleLeftXArray, ref IntPtr puDoubleRightXArray, ref UInt32 puNumRows, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_PolygonFill1Bit(BYTE *p1Bit, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, XYdouble *pPoints, UINT32 uNumPoints, UINT32 uColor, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_PolygonFill1Bit")]
    public static extern bool _is6_PolygonFill1Bit(IntPtr p1Bit, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, IntPtr pPoints, UInt32 uNumPoints, UInt32 uColor, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DrawEllipseOnImage(BYTE *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, UINT32 uColorSpec, const POINT * pptCenter, UINT32 uHorizRadius, UINT32 uVertRadius, BOOL bFill, double fOpacity, RGBQUAD *pPal, UINT32 uPalColors, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DrawEllipseOnImage")]
    public static extern bool _is6_DrawEllipseOnImage(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, UInt32 uColorSpec, ref POINT pptCenter, UInt32 uHorizRadius, UInt32 uVertRadius, bool bFill, double fOpacity, IntPtr pPal, UInt32 uPalColors, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DrawEllipseOn1Bit(BYTE *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, UINT32 uColor, const POINT * pptCenter, UINT32 uHorizRadius, UINT32 uVertRadius, BOOL bFill, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DrawEllipseOn1Bit")]
    public static extern bool _is6_DrawEllipseOn1Bit(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, UInt32 uColor, ref POINT pptCenter, UInt32 uHorizRadius, UInt32 uVertRadius, bool bFill, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DrawLineOnImage(BYTE *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, UINT32 uColorSpec, const POINT * pptStart, const POINT * pptEnd, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DrawLineOnImage")]
    public static extern bool _is6_DrawLineOnImage(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, UInt32 uColorSpec, ref POINT pptStart, ref POINT pptEnd, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DrawThickLineOnImage(BYTE *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, UINT32 uColorSpec, RGBQUAD *pal, UINT32 uPalColors, double fOpacity, const XYdouble * pxyStart, const XYdouble * pxyEnd, double fLineWidth, UINT32 endStyle0, UINT32 endStyle1, UINT32 arrowLength, UINT32 arrowWidth, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DrawThickLineOnImage")]
    public static extern bool _is6_DrawThickLineOnImage(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, UInt32 uColorSpec, IntPtr pal, UInt32 uPalColors, double fOpacity, ref XYdouble pxyStart, ref XYdouble pxyEnd, double fLineWidth, UInt32 endStyle0, UInt32 endStyle1, UInt32 arrowLength, UInt32 arrowWidth, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DrawLineOn1Bit(BYTE *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, UINT32 uColor, const POINT * pptStart, const POINT * pptEnd, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DrawLineOn1Bit")]
    public static extern bool _is6_DrawLineOn1Bit(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, UInt32 uColor, ref POINT pptStart, ref POINT pptEnd, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_CountImageColors(const BYTE *pRGB, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_CountImageColors")]
    public static extern UInt32 _is6_CountImageColors(IntPtr pRGB, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_GetFirstNColorsInRGB(const BYTE *pRGB, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, UINT32 uColors, RGBQUAD *pPal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetFirstNColorsInRGB")]
    public static extern UInt32 _is6_GetFirstNColorsInRGB(IntPtr pRGB, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, UInt32 uColors, IntPtr pPal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   COLORREF is6_FindFirstUnusedRGBColor(const BYTE *pRGB, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_FindFirstUnusedRGBColor")]
    public static extern UInt32 _is6_FindFirstUnusedRGBColor(IntPtr pRGB, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_FindColorsUsedIn8BitImage(const BYTE *p8Bit, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, UINT32 *puColors);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_FindColorsUsedIn8BitImage")]
    public static extern bool _is6_FindColorsUsedIn8BitImage(IntPtr p8Bit, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, IntPtr puColors);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ColorReplaceImage(BYTE *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, COLORREF clrOld, COLORREF clrNew, UINT32 uTolerance, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ColorReplaceImage")]
    public static extern bool _is6_ColorReplaceImage(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, UInt32 clrOld, UInt32 clrNew, UInt32 uTolerance, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ColorReplaceImageRangeSpecified(BYTE *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, BYTE *pTargetArray, BYTE *pNewValArray, BYTE *pToleranceArray, BYTE bChannelMask, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ColorReplaceImageRangeSpecified")]
    public static extern bool _is6_ColorReplaceImageRangeSpecified(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, IntPtr pTargetArray, IntPtr pNewValArray, IntPtr pToleranceArray, byte bChannelMask, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetBorder(const BYTE *pImg, UINT32 uWidth, UINT32 uHeight, UINT32 uBitsPerPixel, UINT32 uRowStride, RGBQUAD *pPal, UINT32 uTolerance, UINT32 uColorSpec, RECT *pImageRect, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetBorder")]
    public static extern bool _is6_GetBorder(IntPtr pImg, UInt32 uWidth, UInt32 uHeight, UInt32 uBitsPerPixel, UInt32 uRowStride, IntPtr pPal, UInt32 uTolerance, UInt32 uColorSpec, ref RECT pImageRect, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_Create8BitMaskFromColor(const BYTE *pRGB, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uInRowStride, BYTE *pMask, UINT32 uOutRowStride, COLORREF clrMatch, UINT32 uTolerance, UINT32 uOutputLevel, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_Create8BitMaskFromColor")]
    public static extern bool _is6_Create8BitMaskFromColor(IntPtr pRGB, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uInRowStride, IntPtr pMask, UInt32 uOutRowStride, UInt32 clrMatch, UInt32 uTolerance, UInt32 uOutputLevel, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_Create1BitMaskFromColor(const BYTE *pInput8, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *p1Mask, UINT32 uOutRowStride, BYTE colorMatch, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_Create1BitMaskFromColor")]
    public static extern bool _is6_Create1BitMaskFromColor(IntPtr pInput8, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr p1Mask, UInt32 uOutRowStride, byte colorMatch, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_SetColorFrom1BitMask(const BYTE *p1mask, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pOutput8, UINT32 uOutRowStride, BYTE colorSet, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SetColorFrom1BitMask")]
    public static extern bool _is6_SetColorFrom1BitMask(IntPtr p1mask, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOutput8, UInt32 uOutRowStride, byte colorSet, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_QuantizeRGBTo8Bit(const BYTE *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *p8Bit, UINT32 uOutRowStride, UINT32 uColors, RGBQUAD *pPal, UINT32 uDitherStyle, UINT32 uDitherErrorMax, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_QuantizeRGBTo8Bit")]
    public static extern bool _is6_QuantizeRGBTo8Bit(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr p8Bit, UInt32 uOutRowStride, UInt32 uColors, IntPtr pPal, UInt32 uDitherStyle, UInt32 uDitherErrorMax, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_RGBTo8BitBestFit(const BYTE *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *p8Bit, UINT32 uOutRowStride, UINT32 uColors, RGBQUAD *pPal, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_RGBTo8BitBestFit")]
    public static extern bool _is6_RGBTo8BitBestFit(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr p8Bit, UInt32 uOutRowStride, UInt32 uColors, IntPtr pPal, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_RGBTo8BitDithered(const BYTE *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *p8Bit, UINT32 uOutRowStride, UINT32 uColors, RGBQUAD *pal, UINT32 uDitherStyle, UINT32 uDitherErrorMax, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_RGBTo8BitDithered")]
    public static extern bool _is6_RGBTo8BitDithered(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr p8Bit, UInt32 uOutRowStride, UInt32 uColors, IntPtr pal, UInt32 uDitherStyle, UInt32 uDitherErrorMax, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_Get8BitPaletteFromRGB(const BYTE *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, UINT32 uColors, RGBQUAD *pPal, UINT32 *puColorsFound, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_Get8BitPaletteFromRGB")]
    public static extern bool _is6_Get8BitPaletteFromRGB(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, UInt32 uColors, IntPtr pPal, ref UInt32 puColorsFound, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_QuantizeRGBATo8Bit(const BYTE *pRGBA, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pOut8, UINT32 uOutRowStride, UINT32 uColors, RGBQUAD *pal, BOOL bFSDither, UINT32 *puColorsUsed, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_QuantizeRGBATo8Bit")]
    public static extern bool _is6_QuantizeRGBATo8Bit(IntPtr pRGBA, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut8, UInt32 uOutRowStride, UInt32 uColors, IntPtr pal, bool bFSDither, ref UInt32 puColorsUsed, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_RGBTo1Bit(const BYTE *pRGB, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *p1Bit, UINT32 uOutRowStride, UINT32 uK, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_RGBTo1Bit")]
    public static extern bool _is6_RGBTo1Bit(IntPtr pRGB, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr p1Bit, UInt32 uOutRowStride, UInt32 uK, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_PolygonWarpImage(BYTE *pInput, UINT32 uInWidth, UINT32 uInHeight, UINT32 uInRowStride, BYTE *pOutput, UINT32 uOutWidth, UINT32 uOutHeight, UINT32 uOutRowStride, const ISQuadrilateral *inQuad, const ISQuadrilateral *outQuad, UINT32 uBitsPerPixel, RGBQUAD *pPal, UINT32 uPalColors, UINT32 uMode, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_PolygonWarpImage")]
    public static extern bool _is6_PolygonWarpImage(IntPtr pInput, UInt32 uInWidth, UInt32 uInHeight, UInt32 uInRowStride, IntPtr pOutput, UInt32 uOutWidth, UInt32 uOutHeight, UInt32 uOutRowStride, ref ISQuadrilateral inQuad, ref ISQuadrilateral outQuad, UInt32 uBitsPerPixel, IntPtr pPal, UInt32 uPalColors, UInt32 uMode, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_PolygonWarpGetPoint(const ISQuadrilateral *inQuad, const ISQuadrilateral *outQuad, const XYdouble * inPt, XYdouble * outPt, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_PolygonWarpGetPoint")]
    public static extern bool _is6_PolygonWarpGetPoint(ref ISQuadrilateral inQuad, ref ISQuadrilateral outQuad, ref XYdouble inPt, ref XYdouble outPt, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_PolygonIsConvex(const POINT * pPoints, UINT32 uPoints);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_PolygonIsConvex")]
    public static extern bool _is6_PolygonIsConvex(IntPtr pPoints, UInt32 uPoints);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetConvexHull(const POINT *pInPoints, UINT32 uNumInPoints, HGLOBAL *phOutPoints, UINT32 *puNumHullPoints);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetConvexHull")]
    public static extern bool _is6_GetConvexHull(IntPtr pInPoints, UInt32 uNumInPoints, ref IntPtr phOutPoints, ref UInt32 puNumHullPoints);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetConvexHullXYdouble(const XYdouble *pInPoints, UINT32 uNumInPoints, HGLOBAL *phOutPoints, UINT32 *puNumHullPoints);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetConvexHullXYdouble")]
    public static extern bool _is6_GetConvexHullXYdouble(IntPtr pInPoints, UInt32 uNumInPoints, ref IntPtr phOutPoints, ref UInt32 puNumHullPoints);

    ////////////////////////////////////////////////////////////////////////////////
    //   HISCOLORMATCH is6_CreateColorMatcher(const RGBQUAD *pPal, UINT32 uPalColors);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_CreateColorMatcher")]
    public static extern IntPtr _is6_CreateColorMatcher(IntPtr pPal, UInt32 uPalColors);

    ////////////////////////////////////////////////////////////////////////////////
    //   __int32 is6_FindClosestColor(HISCOLORMATCH hISCM, BYTE r, BYTE g, BYTE b);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_FindClosestColor")]
    public static extern Int32 _is6_FindClosestColor(IntPtr hISCM, byte r, byte g, byte b);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DestroyColorMatcher(HISCOLORMATCH hISCM);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DestroyColorMatcher")]
    public static extern bool _is6_DestroyColorMatcher(IntPtr hISCM);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ColorCompare(COLORREF x, COLORREF y, UINT32 uTolerance);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ColorCompare")]
    public static extern bool _is6_ColorCompare(UInt32 x, UInt32 y, UInt32 uTolerance);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_SwapPaletteEntriesIn8Bit(BYTE *p8, UINT32 uWidth, UINT32 uHeight, RGBQUAD *pPal, BYTE idx1, BYTE idx2);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SwapPaletteEntriesIn8Bit")]
    public static extern bool _is6_SwapPaletteEntriesIn8Bit(IntPtr p8, UInt32 uWidth, UInt32 uHeight, IntPtr pPal, byte idx1, byte idx2);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DoubleArrayOffsetIntPtrpDouble, UINT32 uWidth, UINT32 uHeight, UINT32 uChannels, UINT32 uRowStride, double *pAdd, double *pMul, double *pMin, double *pMax);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DoubleArrayOffset")]
    public static extern bool _is6_DoubleArrayOffset(IntPtr pDouble, UInt32 uWidth, UInt32 uHeight, UInt32 uChannels, UInt32 uRowStride, IntPtr pAdd, IntPtr pMul, IntPtr pMin, IntPtr pMax);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_MakeRectFadeMask(BYTE *p8BitMask, UINT32 uWidth, UINT32 uHeight, double fFadeWidthRatio);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_MakeRectFadeMask")]
    public static extern bool _is6_MakeRectFadeMask(IntPtr p8BitMask, UInt32 uWidth, UInt32 uHeight, double fFadeWidthRatio);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_RGB24ToRGB16(const BYTE *pRGB24, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pRGB16, UINT32 uOutRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_RGB24ToRGB16")]
    public static extern bool _is6_RGB24ToRGB16(IntPtr pRGB24, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pRGB16, UInt32 uOutRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DespeckleImage(BYTE *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DespeckleImage")]
    public static extern bool _is6_DespeckleImage(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_FindNormalizedDifference(const BYTE *p1, const BYTE *p2, UINT32 uWidth, UINT32 uHeight, BYTE *pOutput, double dMin, double dMax, double dThreshold);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_FindNormalizedDifference")]
    public static extern bool _is6_FindNormalizedDifference(IntPtr p1, IntPtr p2, UInt32 uWidth, UInt32 uHeight, IntPtr pOutput, double dMin, double dMax, double dThreshold);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_NormalizedDifferenceImage(const BYTE *pImage1, const BYTE *pImage2, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, BYTE *pImageOut, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_NormalizedDifferenceImage")]
    public static extern bool _is6_NormalizedDifferenceImage(IntPtr pImage1, IntPtr pImage2, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, IntPtr pImageOut, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_NormalizeImage(void *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uRowStride, double fLow, double fHigh, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_NormalizeImage")]
    public static extern bool _is6_NormalizeImage(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uRowStride, double fLow, double fHigh, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_EmbossRGB(const BYTE *pInBump8, UINT32 uWidth, UINT32 uHeight, UINT32 uBumpRowStride, double azimuth, double elevation, UINT32 uWidth45, const BYTE *texture, UINT32 uTextureRowStride, BYTE *pOutRGB, UINT32 uOutRowStride, const BYTE *pMask8, UINT32 uMaskRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_EmbossRGB")]
    public static extern bool _is6_EmbossRGB(IntPtr pInBump8, UInt32 uWidth, UInt32 uHeight, UInt32 uBumpRowStride, double azimuth, double elevation, UInt32 uWidth45, IntPtr texture, UInt32 uTextureRowStride, IntPtr pOutRGB, UInt32 uOutRowStride, IntPtr pMask8, UInt32 uMaskRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ApplyRedEyeFilter(BYTE *pRGB, UINT32 uWidth, UINT32 uHeight, const RECT * pRect, UINT32 uSatLevel, UINT32 uColorRange);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ApplyRedEyeFilter")]
    public static extern bool _is6_ApplyRedEyeFilter(IntPtr pRGB, UInt32 uWidth, UInt32 uHeight, ref RECT pRect, UInt32 uSatLevel, UInt32 uColorRange);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_PushImage(const BYTE *pInBuf, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, BYTE *pOutBuf, RGBQUAD *pal, UINT32 uNumColors, const POINT * pptFrom, const POINT * pptTo, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_PushImage")]
    public static extern bool _is6_PushImage(IntPtr pInBuf, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, IntPtr pOutBuf, IntPtr pal, UInt32 uNumColors, ref POINT pptFrom, ref POINT pptTo, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DivideAndFill(const BYTE *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uInRowStride, BYTE * pOut, UINT32 uOutRowStride, UINT32 uOutlineMode, UINT32 uJitterMode, UINT32 uFillMode, UINT32 uMinSize, UINT32 uThreshold, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DivideAndFill")]
    public static extern bool _is6_DivideAndFill(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, UInt32 uOutlineMode, UInt32 uJitterMode, UInt32 uFillMode, UInt32 uMinSize, UInt32 uThreshold, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_Deinterlace(BYTE *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_Deinterlace")]
    public static extern bool _is6_Deinterlace(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DeinterlaceCollapse(const BYTE *pMem, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uRowStride, BYTE *pOut, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DeinterlaceCollapse")]
    public static extern bool _is6_DeinterlaceCollapse(IntPtr pMem, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uRowStride, IntPtr pOut, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_FindDeskewAngleOneBit(const BYTE *p1Bit, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, double *pRho, UINT32 uFactor, UINT32 uLimitAngle, UINT32 uPixelLimit, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_FindDeskewAngleOneBit")]
    public static extern bool _is6_FindDeskewAngleOneBit(IntPtr p1Bit, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride, ref double pRho, UInt32 uFactor, UInt32 uLimitAngle, UInt32 uPixelLimit, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_Convert8bpcTo16bpc(const BYTE *pImageIn, UINT32 uWidth, UINT32 uHeight, UINT32 uChannelsPerPixel, UINT32 uInRowStride, ISUINT16 *pImageOut, UINT32 uOutRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_Convert8bpcTo16bpc")]
    public static extern bool _is6_Convert8bpcTo16bpc(IntPtr pImageIn, UInt32 uWidth, UInt32 uHeight, UInt32 uChannelsPerPixel, UInt32 uInRowStride, IntPtr pImageOut, UInt32 uOutRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_Convert16bpcTo8bpc(const ISUINT16 *pImageIn, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uInBitsUsed, UINT32 uInRowStride, BYTE *pImageOut, UINT32 uOutRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_Convert16bpcTo8bpc")]
    public static extern bool _is6_Convert16bpcTo8bpc(IntPtr pImageIn, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInBitsUsed, UInt32 uInRowStride, IntPtr pImageOut, UInt32 uOutRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_IntegerToFloatingPoint(const void *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uInRowStride, void *pOut, UINT32 uOutRowStride, double fScale, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_IntegerToFloatingPoint")]
    public static extern bool _is6_IntegerToFloatingPoint(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, double fScale, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_FloatingPointToInteger(const void *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uInRowStride, void *pOut, UINT32 uOutRowStride, double fScale, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_FloatingPointToInteger")]
    public static extern bool _is6_FloatingPointToInteger(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, double fScale, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_SwapByteOrderIn16bpcImage(ISUINT16 *pImageIn, UINT32 uWidth, UINT32 uHeight, UINT32 uChannelsPerPixel, UINT32 uInRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SwapByteOrderIn16bpcImage")]
    public static extern bool _is6_SwapByteOrderIn16bpcImage(IntPtr pImageIn, UInt32 uWidth, UInt32 uHeight, UInt32 uChannelsPerPixel, UInt32 uInRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ShiftImageSubPixel(const BYTE *pInImage, UINT32 uInWidth, UINT32 uInHeight, UINT32 uChannelsPerPixel, UINT32 uInRowStride, BYTE *pOutImage, UINT32 uOutRowStride, double fOffset, UINT32 uEdgeBlendClr, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ShiftImageSubPixel")]
    public static extern bool _is6_ShiftImageSubPixel(IntPtr pInImage, UInt32 uInWidth, UInt32 uInHeight, UInt32 uChannelsPerPixel, UInt32 uInRowStride, IntPtr pOutImage, UInt32 uOutRowStride, double fOffset, UInt32 uEdgeBlendClr, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_Get3DSplinePoints(UINT32 uOutPoints, UINT32 uInPoints, UINT32 uDegree, double *inX, double *inY, double *inZ, double *outX, double *outY, double *outZ);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_Get3DSplinePoints")]
    public static extern bool _is6_Get3DSplinePoints(UInt32 uOutPoints, UInt32 uInPoints, UInt32 uDegree, IntPtr inX, IntPtr inY, IntPtr inZ, IntPtr outX, IntPtr outY, IntPtr outZ);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_SimpleWhitePointCorrection(void *pInput, UINT32 uWidth, UINT32 uHeight, UINT32 uChannelsPerPixel, UINT32 uRowStride, int wr, int wg, int wb, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SimpleWhitePointCorrection")]
    public static extern bool _is6_SimpleWhitePointCorrection(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uChannelsPerPixel, UInt32 uRowStride, int wr, int wg, int wb, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_RGBToXYZ(void *pInput, UINT32 uWidth, UINT32 uHeight, UINT32 uInCPP, UINT32 uInRowStride, double *pOut, UINT32 uOutRowStride, double *pM, UINT32 uCompanding, double fGamma, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_RGBToXYZ")]
    public static extern bool _is6_RGBToXYZ(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uInCPP, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, IntPtr pM, UInt32 uCompanding, double fGamma, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_XYZToRGBIntPtrpInput, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, void *pOut, UINT32 uOutCPP, UINT32 uOutRowStride, double *pM, UINT32 uCompanding, double fGamma, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_XYZToRGB")]
    public static extern bool _is6_XYZToRGB(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutCPP, UInt32 uOutRowStride, IntPtr pM, UInt32 uCompanding, double fGamma, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_XYZToLabIntPtrpInput, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, double *pOut, UINT32 uOutRowStride, double *pXYZ_WhitePoint, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_XYZToLab")]
    public static extern bool _is6_XYZToLab(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, IntPtr pXYZ_WhitePoint, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_LabToXYZIntPtrpInput, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, double *pOut, UINT32 uOutRowStride, double *pXYZ_WhitePoint, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_LabToXYZ")]
    public static extern bool _is6_LabToXYZ(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, IntPtr pXYZ_WhitePoint, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_XYZToLuvIntPtrpInput, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, double *pOut, UINT32 uOutRowStride, double *pXYZ_WhitePoint, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_XYZToLuv")]
    public static extern bool _is6_XYZToLuv(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, IntPtr pXYZ_WhitePoint, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_LuvToXYZIntPtrpInput, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, double *pOut, UINT32 uOutRowStride, double *pXYZ_WhitePoint, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_LuvToXYZ")]
    public static extern bool _is6_LuvToXYZ(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, IntPtr pXYZ_WhitePoint, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_RGBToYCC(const BYTE *pInput, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, void *pOut, UINT32 uOutRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_RGBToYCC")]
    public static extern bool _is6_RGBToYCC(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_YCCToRGB(const void *pInput, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pOut, UINT32 uOutRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_YCCToRGB")]
    public static extern bool _is6_YCCToRGB(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_LabToLCH(const double *pInput, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, double *pOut, UINT32 uOutRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_LabToLCH")]
    public static extern bool _is6_LabToLCH(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_LCHToLab(const double *pInput, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, double *pOut, UINT32 uOutRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_LCHToLab")]
    public static extern bool _is6_LCHToLab(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_LuvToLCH(const double *pInput, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, double *pOut, UINT32 uOutRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_LuvToLCH")]
    public static extern bool _is6_LuvToLCH(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_LCHToLuv(const double *pInput, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, double *pOut, UINT32 uOutRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_LCHToLuv")]
    public static extern bool _is6_LCHToLuv(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_RGBToLab(const void *pInput, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, double *pOut, UINT32 uOutRowStride, double *pXYZ_WhitePoint, double *pM, UINT32 uCompanding, double fGamma, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_RGBToLab")]
    public static extern bool _is6_RGBToLab(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, IntPtr pXYZ_WhitePoint, IntPtr pM, UInt32 uCompanding, double fGamma, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_LabToRGB(const double *pInput, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, void *pOut, UINT32 uOutRowStride, double *pXYZ_WhitePoint, double *pM, UINT32 uCompanding, double fGamma, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_LabToRGB")]
    public static extern bool _is6_LabToRGB(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, IntPtr pXYZ_WhitePoint, IntPtr pM, UInt32 uCompanding, double fGamma, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_RGBToLuv(const void *pInput, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, double *pOut, UINT32 uOutRowStride, double *pXYZ_WhitePoint, double *pM, UINT32 uCompanding, double fGamma, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_RGBToLuv")]
    public static extern bool _is6_RGBToLuv(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, IntPtr pXYZ_WhitePoint, IntPtr pM, UInt32 uCompanding, double fGamma, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_LuvToRGB(const double *pInput, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, void *pOut, UINT32 uOutRowStride, double *pXYZ_WhitePoint, double *pM, UINT32 uCompanding, double fGamma, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_LuvToRGB")]
    public static extern bool _is6_LuvToRGB(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, IntPtr pXYZ_WhitePoint, IntPtr pM, UInt32 uCompanding, double fGamma, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_RGBToLCH(const void *pInput, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, double *pOut, UINT32 uOutRowStride, double *pXYZ_WhitePoint, double *pM, UINT32 uCompanding, double fGamma, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_RGBToLCH")]
    public static extern bool _is6_RGBToLCH(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, IntPtr pXYZ_WhitePoint, IntPtr pM, UInt32 uCompanding, double fGamma, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_LCHToRGB(const double *pInput, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, void *pOut, UINT32 uOutRowStride, double *pXYZ_WhitePoint, double *pM, UINT32 uCompanding, double fGamma, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_LCHToRGB")]
    public static extern bool _is6_LCHToRGB(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, IntPtr pXYZ_WhitePoint, IntPtr pM, UInt32 uCompanding, double fGamma, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_RGBToHSL(const BYTE *pInput, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, void *pOut, UINT32 uOutRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_RGBToHSL")]
    public static extern bool _is6_RGBToHSL(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_HSLToRGB(const void *pInput, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pOutput, UINT32 uOutRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_HSLToRGB")]
    public static extern bool _is6_HSLToRGB(IntPtr pInput, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOutput, UInt32 uOutRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   double is6_CompareColorsDeltaE(double A1, double A2, double A3, double B1, double B2, double B3, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_CompareColorsDeltaE")]
    public static extern double _is6_CompareColorsDeltaE(double A1, double A2, double A3, double B1, double B2, double B3, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ResizeImage(const void * pImgSrc, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, void *pImgDest, UINT32 uOutWidth, UINT32 uOutHeight, UINT32 uOutRowStride, UINT32 uComponentsPerPixel, UINT32 uMode, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ResizeImage")]
    public static extern bool _is6_ResizeImage(IntPtr pImgSrc, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pImgDest, UInt32 uOutWidth, UInt32 uOutHeight, UInt32 uOutRowStride, UInt32 uComponentsPerPixel, UInt32 uMode, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ResizeDIB(const BITMAPINFOHEADER *pInDIB, UINT32 uOutW, UINT32 uOutH, HGLOBAL *phOutDIB, UINT32 uMethod, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ResizeDIB")]
    public static extern bool _is6_ResizeDIB(ref BITMAPINFOHEADER pInDIB, UInt32 uOutW, UInt32 uOutH, ref IntPtr phOutDIB, UInt32 uMethod, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ResizeImage8To24(const BYTE * pImgSrc, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pImgDest, UINT32 uOutWidth, UINT32 uOutHeight, UINT32 uOutRowStride, const RGBQUAD *pPal, UINT32 uMode, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ResizeImage8To24")]
    public static extern bool _is6_ResizeImage8To24(IntPtr pImgSrc, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pImgDest, UInt32 uOutWidth, UInt32 uOutHeight, UInt32 uOutRowStride, IntPtr pPal, UInt32 uMode, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ResizeImage1To8Gray(const BYTE * pImgSrc, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pImgDest, UINT32 uOutWidth, UINT32 uOutHeight, UINT32 uOutRowStride, UINT32 uMode, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ResizeImage1To8Gray")]
    public static extern bool _is6_ResizeImage1To8Gray(IntPtr pImgSrc, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pImgDest, UInt32 uOutWidth, UInt32 uOutHeight, UInt32 uOutRowStride, UInt32 uMode, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ResizeImage8(const BYTE * pImgSrc, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pImgDest, UINT32 uOutWidth, UINT32 uOutHeight, UINT32 uOutRowStride, const RGBQUAD *pPal, UINT32 uPalColors, UINT32 uMode, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ResizeImage8")]
    public static extern bool _is6_ResizeImage8(IntPtr pImgSrc, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pImgDest, UInt32 uOutWidth, UInt32 uOutHeight, UInt32 uOutRowStride, IntPtr pPal, UInt32 uPalColors, UInt32 uMode, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ResizeImage1(const BYTE * pImgSrc, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pImgDest, UINT32 uOutWidth, UINT32 uOutHeight, UINT32 uOutRowStride, UINT32 uCutOff, UINT32 uMode, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ResizeImage1")]
    public static extern bool _is6_ResizeImage1(IntPtr pImgSrc, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pImgDest, UInt32 uOutWidth, UInt32 uOutHeight, UInt32 uOutRowStride, UInt32 uCutOff, UInt32 uMode, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ResizeImageMasked(const BYTE * pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uSrcRowStride, BYTE * pImageOut, UINT32 uOutWidth, UINT32 uOutHeight, UINT32 uOutRowStride, COLORREF clrMask, UINT32 uBytesPerPixel, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ResizeImageMasked")]
    public static extern bool _is6_ResizeImageMasked(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uSrcRowStride, IntPtr pImageOut, UInt32 uOutWidth, UInt32 uOutHeight, UInt32 uOutRowStride, UInt32 clrMask, UInt32 uBytesPerPixel, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_Resize8Masked(const BYTE * pIn, UINT32 uSrcWidthPix, UINT32 uSrcHeight, UINT32 uInRowStride, BYTE * pOut, UINT32 uDestWidthPix, UINT32 uDestHeight, UINT32 uOutRowStride, const RGBQUAD *pPal, UINT32 uColors, BYTE maskIdx);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_Resize8Masked")]
    public static extern bool _is6_Resize8Masked(IntPtr pIn, UInt32 uSrcWidthPix, UInt32 uSrcHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uDestWidthPix, UInt32 uDestHeight, UInt32 uOutRowStride, IntPtr pPal, UInt32 uColors, byte maskIdx);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_SeamCarve(const BYTE *pInRGB, UINT32 inW, UINT32 inH, UINT32 uBPP, UINT32 uInRowStride, const BYTE *pMask8, UINT32 uMaskRowStride, BYTE *pOutRGB, UINT32 uOutRowStride, int iSeams, ISUINT16 newSeamWeight, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SeamCarve")]
    public static extern bool _is6_SeamCarve(IntPtr pInRGB, UInt32 inW, UInt32 inH, UInt32 uBPP, UInt32 uInRowStride, IntPtr pMask8, UInt32 uMaskRowStride, IntPtr pOutRGB, UInt32 uOutRowStride, int iSeams, Int16 newSeamWeight, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_RotateImage(const void *inBuf, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel, UINT32 uInRowStride, void *pOut, UINT32 uOutRowStride, RGBQUAD *pPal, UINT32 uPalColors, double radians, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_RotateImage")]
    public static extern bool _is6_RotateImage(IntPtr inBuf, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, IntPtr pPal, UInt32 uPalColors, double radians, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_RotateOneBitImage(BYTE *inBuf, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pOut, UINT32 uOutRowStride, double radians, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_RotateOneBitImage")]
    public static extern bool _is6_RotateOneBitImage(IntPtr inBuf, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, double radians, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_GetRotatedBufComponents(double radians, UINT32 uWidth, UINT32 uHeight, UINT32 uComponentsPerPixel);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetRotatedBufComponents")]
    public static extern UInt32 _is6_GetRotatedBufComponents(double radians, UInt32 uWidth, UInt32 uHeight, UInt32 uComponentsPerPixel);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetRotatedPixelSize(double radians, UINT32 uWidth, UINT32 uHeight, UINT32 *pWidth, UINT32 *pHeight);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetRotatedPixelSize")]
    public static extern bool _is6_GetRotatedPixelSize(double radians, UInt32 uWidth, UInt32 uHeight, ref UInt32 pWidth, ref UInt32 pHeight);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_QuickRotateImageInPlace(void *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uRotate, UINT32 uChannels, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_QuickRotateImageInPlace")]
    public static extern bool _is6_QuickRotateImageInPlace(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uRotate, UInt32 uChannels, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_QuickRotateImage(const void *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, void *pOutput, UINT32 uOutRowStride, UINT32 uRotate, UINT32 uChannelsPerPixel, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_QuickRotateImage")]
    public static extern bool _is6_QuickRotateImage(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOutput, UInt32 uOutRowStride, UInt32 uRotate, UInt32 uChannelsPerPixel, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_QuickRotate1Bit(BYTE *pInBuf, UINT32 nInWidth, UINT32 nInHeight, UINT32 uInRowStride, BYTE *pOutBuf, UINT32 uOutRowStride, UINT32 uRotate);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_QuickRotate1Bit")]
    public static extern bool _is6_QuickRotate1Bit(IntPtr pInBuf, UInt32 nInWidth, UInt32 nInHeight, UInt32 uInRowStride, IntPtr pOutBuf, UInt32 uOutRowStride, UInt32 uRotate);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ShearImageX(BYTE *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uInRowStride, BYTE *pOut, __int32 xOffset, UINT32 uOutRowStride, COLORREF clrBack, BOOL bFast, RGBQUAD *pPal, UINT32 uPalColors);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ShearImageX")]
    public static extern bool _is6_ShearImageX(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uInRowStride, IntPtr pOut, Int32 xOffset, UInt32 uOutRowStride, UInt32 clrBack, bool bFast, IntPtr pPal, UInt32 uPalColors);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ShearImageY(BYTE *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uInRowStride, BYTE *pOut, __int32 yOffset, UINT32 uOutRowStride, COLORREF clrBack, BOOL bFast, RGBQUAD *pPal, UINT32 uPalColors);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ShearImageY")]
    public static extern bool _is6_ShearImageY(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uInRowStride, IntPtr pOut, Int32 yOffset, UInt32 uOutRowStride, UInt32 clrBack, bool bFast, IntPtr pPal, UInt32 uPalColors);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ShearOneBitX(BYTE *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pOut, __int32 xOffset, UINT32 uOutRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ShearOneBitX")]
    public static extern bool _is6_ShearOneBitX(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, Int32 xOffset, UInt32 uOutRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ShearOneBitY(BYTE *pImage, UINT32 uWidth, UINT32 uHeight, UINT32 uInRowStride, BYTE *pOut, __int32 yOffset, UINT32 uOutRowStride, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ShearOneBitY")]
    public static extern bool _is6_ShearOneBitY(IntPtr pImage, UInt32 uWidth, UInt32 uHeight, UInt32 uInRowStride, IntPtr pOut, Int32 yOffset, UInt32 uOutRowStride, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DrawTextOnRGB(BYTE *pRGB, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, const char *pText, const char *pFontName, UINT32 uFontPixels, const RECT * pTextRect, UINT32 uDrawFlags, UINT32 uFlags, COLORREF clrText);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DrawTextOnRGB")]
    public static extern bool _is6_DrawTextOnRGB(IntPtr pRGB, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride,
    [MarshalAs(UnmanagedType.LPStr)]
    string pText,
    [MarshalAs(UnmanagedType.LPStr)]
    string pFontName, UInt32 uFontPixels, ref RECT pTextRect, UInt32 uDrawFlags, UInt32 uFlags, UInt32 clrText);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DrawTextOnRGB2(BYTE *pRGB, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, const char *pText, const LOGFONT *pLogFont, const RECT *textRect, UINT32 uDrawFlags, UINT32 uFlags, COLORREF clrText);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DrawTextOnRGB2")]
    public static extern bool _is6_DrawTextOnRGB2(IntPtr pRGB, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride,
    [MarshalAs(UnmanagedType.LPStr)]
    string pText, ref LOGFONT pLogFont, ref RECT textRect, UInt32 uDrawFlags, UInt32 uFlags, UInt32 clrText);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DrawTextOnRGBA(BYTE *pRGBA, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, const char *pText, const char *pFontName, UINT32 uFontPixels, const RECT * pTextRect, UINT32 uDrawFlags, UINT32 uFlags, COLORREF clrText);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DrawTextOnRGBA")]
    public static extern bool _is6_DrawTextOnRGBA(IntPtr pRGBA, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride,
    [MarshalAs(UnmanagedType.LPStr)]
    string pText,
    [MarshalAs(UnmanagedType.LPStr)]
    string pFontName, UInt32 uFontPixels, ref RECT pTextRect, UInt32 uDrawFlags, UInt32 uFlags, UInt32 clrText);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DrawTextOnRGBA2(BYTE *pRGBA, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, const char *pText, const LOGFONT *pLogFont, const RECT *textRect, UINT32 uDrawFlags, UINT32 uFlags, COLORREF clrText);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DrawTextOnRGBA2")]
    public static extern bool _is6_DrawTextOnRGBA2(IntPtr pRGBA, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride,
    [MarshalAs(UnmanagedType.LPStr)]
    string pText, ref LOGFONT pLogFont, ref RECT textRect, UInt32 uDrawFlags, UInt32 uFlags, UInt32 clrText);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DrawTextOn8Bit(BYTE *p8Bit, UINT32 width, UINT32 height, UINT32 uRowStride, const char *drawText, const char *fontName, UINT32 uFontPixels, const RECT *pTextRect, UINT32 uDrawFlags, UINT32 uFlags, UINT32 uTextColorIndex, RGBQUAD *pPal, UINT32 uPalColors);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DrawTextOn8Bit")]
    public static extern bool _is6_DrawTextOn8Bit(IntPtr p8Bit, UInt32 width, UInt32 height, UInt32 uRowStride,
    [MarshalAs(UnmanagedType.LPStr)]
    string drawText,
    [MarshalAs(UnmanagedType.LPStr)]
    string fontName, UInt32 uFontPixels, ref RECT pTextRect, UInt32 uDrawFlags, UInt32 uFlags, UInt32 uTextColorIndex, IntPtr pPal, UInt32 uPalColors);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DrawTextOn8Bit2(BYTE *p8Bit, UINT32 width, UINT32 height, UINT32 uRowStride, const char *drawText, const LOGFONT *pLogFont, const RECT *pTextRect, UINT32 uDrawFlags, UINT32 uFlags, UINT32 uTextColorIndex, RGBQUAD *pPal, UINT32 uPalColors);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DrawTextOn8Bit2")]
    public static extern bool _is6_DrawTextOn8Bit2(IntPtr p8Bit, UInt32 width, UInt32 height, UInt32 uRowStride,
    [MarshalAs(UnmanagedType.LPStr)]
    string drawText, ref LOGFONT pLogFont, ref RECT pTextRect, UInt32 uDrawFlags, UInt32 uFlags, UInt32 uTextColorIndex, IntPtr pPal, UInt32 uPalColors);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DrawTextOn1Bit(BYTE *p1Bit, UINT32 width, UINT32 height, UINT32 uRowStride, const char *drawText, const char *fontName, UINT32 uFontPixels, const RECT *pTextRect, UINT32 uDrawFlags, UINT32 uFlags, UINT32 uTextBit);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DrawTextOn1Bit")]
    public static extern bool _is6_DrawTextOn1Bit(IntPtr p1Bit, UInt32 width, UInt32 height, UInt32 uRowStride,
    [MarshalAs(UnmanagedType.LPStr)]
    string drawText,
    [MarshalAs(UnmanagedType.LPStr)]
    string fontName, UInt32 uFontPixels, ref RECT pTextRect, UInt32 uDrawFlags, UInt32 uFlags, UInt32 uTextBit);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DrawTextOn1Bit2(BYTE *p1Bit, UINT32 width, UINT32 height, UINT32 uRowStride, const char *drawText, const LOGFONT *pLogFont, const RECT *pTextRect, UINT32 uDrawFlags, UINT32 uFlags, UINT32 uTextBit);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DrawTextOn1Bit2")]
    public static extern bool _is6_DrawTextOn1Bit2(IntPtr p1Bit, UInt32 width, UInt32 height, UInt32 uRowStride,
    [MarshalAs(UnmanagedType.LPStr)]
    string drawText, ref LOGFONT pLogFont, ref RECT pTextRect, UInt32 uDrawFlags, UInt32 uFlags, UInt32 uTextBit);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetTextLineSize(const char *drawText, const char *fontName, UINT32 fontPixels, const RECT* pTextRect, UINT32 uDrawFlags, UINT32 uFlags, UINT32 *pWidth, UINT32 *pHeight);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetTextLineSize")]
    public static extern bool _is6_GetTextLineSize(
    [MarshalAs(UnmanagedType.LPStr)]
    string drawText,
    [MarshalAs(UnmanagedType.LPStr)]
    string fontName, UInt32 fontPixels, ref RECT pTextRect, UInt32 uDrawFlags, UInt32 uFlags, ref UInt32 pWidth, ref UInt32 pHeight);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetTextLineSize2(const char *drawText, const LOGFONT *pLogFont, const RECT *pTextRect, UINT32 uDrawFlags, UINT32 uFlags, UINT32 *pWidth, UINT32 *pHeight);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetTextLineSize2")]
    public static extern bool _is6_GetTextLineSize2(
    [MarshalAs(UnmanagedType.LPStr)]
    string drawText, ref LOGFONT pLogFont, ref RECT pTextRect, UInt32 uDrawFlags, UInt32 uFlags, ref UInt32 pWidth, ref UInt32 pHeight);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DrawSmoothTextOnRGB(BYTE *pRGB, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, const char *pText, const char *pFontName, UINT32 uFontHeight, UINT32 uSmoothingFactor, const RECT *pTextRect, UINT32 uDrawFlags, UINT32 uFlags, COLORREF textColor);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DrawSmoothTextOnRGB")]
    public static extern bool _is6_DrawSmoothTextOnRGB(IntPtr pRGB, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride,
    [MarshalAs(UnmanagedType.LPStr)]
    string pText,
    [MarshalAs(UnmanagedType.LPStr)]
    string pFontName, UInt32 uFontHeight, UInt32 uSmoothingFactor, ref RECT pTextRect, UInt32 uDrawFlags, UInt32 uFlags, UInt32 textColor);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DrawSmoothTextOnRGB2(BYTE *pRGB, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, const char *pText, const LOGFONT *pLogFont, UINT32 uSmoothingFactor, const RECT *pTextRect, UINT32 uDrawFlags, UINT32 uFlags, COLORREF textColor);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DrawSmoothTextOnRGB2")]
    public static extern bool _is6_DrawSmoothTextOnRGB2(IntPtr pRGB, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride,
    [MarshalAs(UnmanagedType.LPStr)]
    string pText, ref LOGFONT pLogFont, UInt32 uSmoothingFactor, ref RECT pTextRect, UInt32 uDrawFlags, UInt32 uFlags, UInt32 textColor);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DrawSmoothTextOnRGBA(BYTE *pRGB, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, const char *pText, const char *pFontName, UINT32 uFontHeight, UINT32 uSmoothingFactor, const RECT *pTextRect, UINT32 uDrawFlags, UINT32 uFlags, COLORREF textColor);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DrawSmoothTextOnRGBA")]
    public static extern bool _is6_DrawSmoothTextOnRGBA(IntPtr pRGB, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride,
    [MarshalAs(UnmanagedType.LPStr)]
    string pText,
    [MarshalAs(UnmanagedType.LPStr)]
    string pFontName, UInt32 uFontHeight, UInt32 uSmoothingFactor, ref RECT pTextRect, UInt32 uDrawFlags, UInt32 uFlags, UInt32 textColor);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DrawSmoothTextOnRGBA2(BYTE *pRGB, UINT32 uWidth, UINT32 uHeight, UINT32 uRowStride, const char *pText, const LOGFONT *pLogFont, UINT32 uSmoothingFactor, const RECT *pTextRect, UINT32 uDrawFlags, UINT32 uFlags, COLORREF textColor);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DrawSmoothTextOnRGBA2")]
    public static extern bool _is6_DrawSmoothTextOnRGBA2(IntPtr pRGB, UInt32 uWidth, UInt32 uHeight, UInt32 uRowStride,
    [MarshalAs(UnmanagedType.LPStr)]
    string pText, ref LOGFONT pLogFont, UInt32 uSmoothingFactor, ref RECT pTextRect, UInt32 uDrawFlags, UInt32 uFlags, UInt32 textColor);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_SetTextTransparency(double fTransparency);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SetTextTransparency")]
    public static extern void _is6_SetTextTransparency(double fTransparency);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AddSpinTransform(UINT32 uWidth, UINT32 uHeight, double fMaxRadius, double fMaxAngleOffsetDeg, int iOffsetX, int iOffsetY);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AddSpinTransform")]
    public static extern bool _is6_AddSpinTransform(UInt32 uWidth, UInt32 uHeight, double fMaxRadius, double fMaxAngleOffsetDeg, int iOffsetX, int iOffsetY);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AddSpinWaveTransform(UINT32 uWidth, UINT32 uHeight, double fMaxRadius, double fMaxAngleOffsetDeg, double fPeriods, int iOffsetX, int iOffsetY);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AddSpinWaveTransform")]
    public static extern bool _is6_AddSpinWaveTransform(UInt32 uWidth, UInt32 uHeight, double fMaxRadius, double fMaxAngleOffsetDeg, double fPeriods, int iOffsetX, int iOffsetY);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AddEllipticalTransform(UINT32 uWidth, UINT32 uHeight, double fRadiusX, double fRadiusY, int iXoffset, int iYOffset, UINT32 uMode);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AddEllipticalTransform")]
    public static extern bool _is6_AddEllipticalTransform(UInt32 uWidth, UInt32 uHeight, double fRadiusX, double fRadiusY, int iXoffset, int iYOffset, UInt32 uMode);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AddLensTransform(UINT32 uWidth, UINT32 uHeight, double fMaxRadius, int iOffsetX, int iOffsetY);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AddLensTransform")]
    public static extern bool _is6_AddLensTransform(UInt32 uWidth, UInt32 uHeight, double fMaxRadius, int iOffsetX, int iOffsetY);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AddPinchTransform(UINT32 uWidth, UINT32 uHeight, double fMaxRadius, double fAmount, int iOffsetX, int iOffsetY);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AddPinchTransform")]
    public static extern bool _is6_AddPinchTransform(UInt32 uWidth, UInt32 uHeight, double fMaxRadius, double fAmount, int iOffsetX, int iOffsetY);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AddRippleTransform(UINT32 uWidth, UINT32 uHeight, double fMaxRadius, double fAmount, double fPeriods, double fOffsetX, double fOffsetY, int iDampenStyle);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AddRippleTransform")]
    public static extern bool _is6_AddRippleTransform(UInt32 uWidth, UInt32 uHeight, double fMaxRadius, double fAmount, double fPeriods, double fOffsetX, double fOffsetY, int iDampenStyle);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AddOffsetTransform(UINT32 uWidth, UINT32 uHeight, double xOffset, double yOffset, int iStyle);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AddOffsetTransform")]
    public static extern bool _is6_AddOffsetTransform(UInt32 uWidth, UInt32 uHeight, double xOffset, double yOffset, int iStyle);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AddRandomTransform(UINT32 uWidth, UINT32 uHeight, double fAmount);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AddRandomTransform")]
    public static extern bool _is6_AddRandomTransform(UInt32 uWidth, UInt32 uHeight, double fAmount);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AddLineSliceTransform(UINT32 uWidth, UINT32 uHeight, int iOffset1, int iOffset2, int eStyle);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AddLineSliceTransform")]
    public static extern bool _is6_AddLineSliceTransform(UInt32 uWidth, UInt32 uHeight, int iOffset1, int iOffset2, int eStyle);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AddZigZagTransform(UINT32 uWidth, UINT32 uHeight, double fMaxOffsetPercent, int iPeriods, int eStyle);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AddZigZagTransform")]
    public static extern bool _is6_AddZigZagTransform(UInt32 uWidth, UInt32 uHeight, double fMaxOffsetPercent, int iPeriods, int eStyle);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AddWaveTransform(UINT32 uWidth, UINT32 uHeight, double fMaxOffsetPercent, double fPeriods, int iStyle);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AddWaveTransform")]
    public static extern bool _is6_AddWaveTransform(UInt32 uWidth, UInt32 uHeight, double fMaxOffsetPercent, double fPeriods, int iStyle);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AddWowTransform(UINT32 uWidth, UINT32 uHeight, double fMaxRadius, int eStyle);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AddWowTransform")]
    public static extern bool _is6_AddWowTransform(UInt32 uWidth, UInt32 uHeight, double fMaxRadius, int eStyle);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AddMarbleTransform(UINT32 uWidth, UINT32 uHeight, double fAmount, double fXScale, double fYScale);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AddMarbleTransform")]
    public static extern bool _is6_AddMarbleTransform(UInt32 uWidth, UInt32 uHeight, double fAmount, double fXScale, double fYScale);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AddPerlinDisplacementTransform(UINT32 uWidth, UINT32 uHeight, double fAmount, double fXScale, double fYScale);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AddPerlinDisplacementTransform")]
    public static extern bool _is6_AddPerlinDisplacementTransform(UInt32 uWidth, UInt32 uHeight, double fAmount, double fXScale, double fYScale);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AddBumpMapDisplacementTransform(UINT32 uWidth, UINT32 uHeight, double fAmount, BYTE *pBMBuf, UINT uBMWidth, UINT uBMHeight);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AddBumpMapDisplacementTransform")]
    public static extern bool _is6_AddBumpMapDisplacementTransform(UInt32 uWidth, UInt32 uHeight, double fAmount, IntPtr pBMBuf, UInt32 uBMWidth, UInt32 uBMHeight);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AddPolygonTransform(UINT32 uWidth, UINT32 uHeight, POINT *pPoints, UINT32 uNumPoints, UINT32 uMode);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AddPolygonTransform")]
    public static extern bool _is6_AddPolygonTransform(UInt32 uWidth, UInt32 uHeight, IntPtr pPoints, UInt32 uNumPoints, UInt32 uMode);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AddGlassBlockTransform(UINT32 uWidth, UINT32 uHeight, UINT32 uBlockWidth, UINT32 uBlockHeight, UINT32 uBevelSize, UINT32 uBevelOffset, BOOL bSmoothBevels, double fBlockMagnification, double fDistortionFrequency, double fDistortionIntensity);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AddGlassBlockTransform")]
    public static extern bool _is6_AddGlassBlockTransform(UInt32 uWidth, UInt32 uHeight, UInt32 uBlockWidth, UInt32 uBlockHeight, UInt32 uBevelSize, UInt32 uBevelOffset, bool bSmoothBevels, double fBlockMagnification, double fDistortionFrequency, double fDistortionIntensity);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AddUserTransform(UINT32 uWidth, UINT32 uHeight, ISXFORMCALLBACK pCallbackFn, IS_CALLBACK_DATA uUserData);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AddUserTransform")]
    public static extern bool _is6_AddUserTransform(UInt32 uWidth, UInt32 uHeight, ISXFORMCALLBACK pCallbackFn, IntPtr uUserData);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_TransformProcess(const void *pIn, UINT32 uWidth, UINT32 uHeight, UINT32 uBytesPerPixel, UINT32 uInRowStride, void *pOut, UINT32 uOutRowStride, UINT32 uMode, const void* backColors, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_TransformProcess")]
    public static extern bool _is6_TransformProcess(IntPtr pIn, UInt32 uWidth, UInt32 uHeight, UInt32 uBytesPerPixel, UInt32 uInRowStride, IntPtr pOut, UInt32 uOutRowStride, UInt32 uMode, IntPtr backColors, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetTransformDimensions(UINT32 uWidth, UINT32 uHeight, double *fMinX, double *fMinY, double *fMaxX, double *fMaxY);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetTransformDimensions")]
    public static extern bool _is6_GetTransformDimensions(UInt32 uWidth, UInt32 uHeight, ref double fMinX, ref double fMinY, ref double fMaxX, ref double fMaxY);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_ClearAllTransforms();
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ClearAllTransforms")]
    public static extern void _is6_ClearAllTransforms();

    ////////////////////////////////////////////////////////////////////////////////
    //   HISIPTC is6_IPTCInitialize(HISSRC hSrc, UINT32 uFrameIdx, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_IPTCInitialize")]
    public static extern IntPtr _is6_IPTCInitialize(IntPtr hSrc, UInt32 uFrameIdx, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HISIPTC is6_IPTCInitializeFromByteArray(const BYTE *pData, UINT32 uDataLength, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_IPTCInitializeFromByteArray")]
    public static extern IntPtr _is6_IPTCInitializeFromByteArray(IntPtr pData, UInt32 uDataLength, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_IPTCGetTag(HISIPTC hIPTC, UINT32 uSection, UINT32 uTagID, UINT32 uIndex, HGLOBAL *phData, UINT32 *puLen);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_IPTCGetTag")]
    public static extern bool _is6_IPTCGetTag(IntPtr hIPTC, UInt32 uSection, UInt32 uTagID, UInt32 uIndex, ref IntPtr phData, ref UInt32 puLen);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_IPTCGetTagList(HISIPTC hIPTC, HGLOBAL *phString, UINT32 *puLen, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_IPTCGetTagList")]
    public static extern bool _is6_IPTCGetTagList(IntPtr hIPTC, ref IntPtr phString, ref UInt32 puLen, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_IPTCRelease(HISIPTC hIPTC);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_IPTCRelease")]
    public static extern bool _is6_IPTCRelease(IntPtr hIPTC);

    ////////////////////////////////////////////////////////////////////////////////
    //   HISIPTCW is6_IPTCWriteInit();
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_IPTCWriteInit")]
    public static extern IntPtr _is6_IPTCWriteInit();

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_IPTCWriteAddTagData(HISIPTCW hIPTC, UINT32 uSection, UINT32 uID, const BYTE *pData, UINT32 uDataLen);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_IPTCWriteAddTagData")]
    public static extern bool _is6_IPTCWriteAddTagData(IntPtr hIPTC, UInt32 uSection, UInt32 uID, IntPtr pData, UInt32 uDataLen);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_IPTCWriteRemoveTag(HISIPTCW hIPTC, UINT32 uSection, UINT32 uID);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_IPTCWriteRemoveTag")]
    public static extern bool _is6_IPTCWriteRemoveTag(IntPtr hIPTC, UInt32 uSection, UInt32 uID);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_IPTCExport(HISIPTCW hIPTC, HGLOBAL *hOut, UINT32 *uSize, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_IPTCExport")]
    public static extern bool _is6_IPTCExport(IntPtr hIPTC, ref IntPtr hOut, ref UInt32 uSize, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_IPTCWriteDestroy(HISIPTCW hIPTC);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_IPTCWriteDestroy")]
    public static extern bool _is6_IPTCWriteDestroy(IntPtr hIPTC);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_IPTCCopyTagsFromInputToOutput(HISIPTCW hIPTCW, HISIPTC hIPTCR, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_IPTCCopyTagsFromInputToOutput")]
    public static extern bool _is6_IPTCCopyTagsFromInputToOutput(IntPtr hIPTCW, IntPtr hIPTCR, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_GetImgSourceVersion(char *buf);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetImgSourceVersion")]
    public static extern void _is6_GetImgSourceVersion(IntPtr buf);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_Initialize(const char *pKey);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_Initialize")]
    public static extern void _is6_Initialize(
    [MarshalAs(UnmanagedType.LPStr)]
    string pKey);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_InitializeEx(const char *pKey, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_InitializeEx")]
    public static extern void _is6_InitializeEx(
    [MarshalAs(UnmanagedType.LPStr)]
    string pKey, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_Exit();
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_Exit")]
    public static extern void _is6_Exit();

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ThreadHasTLS();
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ThreadHasTLS")]
    public static extern bool _is6_ThreadHasTLS();

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_GetLastError();
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetLastError")]
    public static extern UInt32 _is6_GetLastError();

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_SetLastError(int error, const char *pCallerFunctionName);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SetLastError")]
    public static extern void _is6_SetLastError(int error,
    [MarshalAs(UnmanagedType.LPStr)]
    string pCallerFunctionName);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_GetErrorList(HGLOBAL *hOutData, UINT32 *puLen, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetErrorList")]
    public static extern void _is6_GetErrorList(ref IntPtr hOutData, ref UInt32 puLen, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_SetCallback(ISCALLBACKPTR pCallback, IS_CALLBACK_DATA uUserData);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SetCallback")]
    public static extern void _is6_SetCallback(ISCALLBACKPTR pCallback, IntPtr uUserData);

    ////////////////////////////////////////////////////////////////////////////////
    //   ISCALLBACKPTR is6_GetCallback(IS_CALLBACK_DATA *puUserData);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetCallback")]
    public static extern ISCALLBACKPTR _is6_GetCallback(ref IntPtr puUserData);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_SetErrorCallback(ISERRORCALLBACK pCallback, IS_CALLBACK_DATA userData);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SetErrorCallback")]
    public static extern void _is6_SetErrorCallback(ISERRORCALLBACK pCallback, IntPtr userData);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_ThreadExit();
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ThreadExit")]
    public static extern void _is6_ThreadExit();

    ////////////////////////////////////////////////////////////////////////////////
    //   HISEXTHK is6_GetExtHook(UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetExtHook")]
    public static extern IntPtr _is6_GetExtHook(UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_SetDebugMessageLevel(UINT32 uLevel);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SetDebugMessageLevel")]
    public static extern void _is6_SetDebugMessageLevel(UInt32 uLevel);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_SwapLong(UINT32 *pLong);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SwapLong")]
    public static extern void _is6_SwapLong(ref UInt32 pLong);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_SwapShort(ISUINT16 *pShort);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SwapShort")]
    public static extern void _is6_SwapShort(ref Int16 pShort);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetSIMDSupport(UINT32 uLevel);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetSIMDSupport")]
    public static extern bool _is6_GetSIMDSupport(UInt32 uLevel);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_DisableSIMDSupport(UINT32 uLevel);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DisableSIMDSupport")]
    public static extern void _is6_DisableSIMDSupport(UInt32 uLevel);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_EnableSIMDFunctions(BOOL bUseSIMD);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_EnableSIMDFunctions")]
    public static extern void _is6_EnableSIMDFunctions(bool bUseSIMD);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_SetWorkerThreadCount(UINT32 n);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SetWorkerThreadCount")]
    public static extern void _is6_SetWorkerThreadCount(UInt32 n);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_SetWorkerThreadCallbackFrequency(UINT32 ms);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SetWorkerThreadCallbackFrequency")]
    public static extern void _is6_SetWorkerThreadCallbackFrequency(UInt32 ms);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_SetWorkerThreadTimeout(UINT32 ms);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SetWorkerThreadTimeout")]
    public static extern void _is6_SetWorkerThreadTimeout(UInt32 ms);

    ////////////////////////////////////////////////////////////////////////////////
    //   void is6_SetWorkerThreadPoolSize(UINT32 n);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_SetWorkerThreadPoolSize")]
    public static extern void _is6_SetWorkerThreadPoolSize(UInt32 n);

    ////////////////////////////////////////////////////////////////////////////////
    //   HISPSDRM is6_InitializePSDResourceManager(UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_InitializePSDResourceManager")]
    public static extern IntPtr _is6_InitializePSDResourceManager(UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_DestroyPSDResourceManager(HISPSDRM hPSDMgr);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_DestroyPSDResourceManager")]
    public static extern bool _is6_DestroyPSDResourceManager(IntPtr hPSDMgr);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_FillPSDResourceManagerFromSource(HISPSDRM hPSDMgr, HISSRC hSource, UINT32 uTiffFrameIdx, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_FillPSDResourceManagerFromSource")]
    public static extern bool _is6_FillPSDResourceManagerFromSource(IntPtr hPSDMgr, IntPtr hSource, UInt32 uTiffFrameIdx, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_FillPSDResourceManagerFromByteArray(HISPSDRM hPSDMgr, const BYTE *pData, UINT32 uDataLen, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_FillPSDResourceManagerFromByteArray")]
    public static extern bool _is6_FillPSDResourceManagerFromByteArray(IntPtr hPSDMgr, IntPtr pData, UInt32 uDataLen, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetPSDResourceList(HISPSDRM hPSDMgr, HGLOBAL *pU16Items, UINT32 *puItemCount, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetPSDResourceList")]
    public static extern bool _is6_GetPSDResourceList(IntPtr hPSDMgr, ref IntPtr pU16Items, ref UInt32 puItemCount, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetPSDResource(HISPSDRM hPSDMgr, ISUINT16 resID, HGLOBAL *phData, UINT32 *puDataLen, HGLOBAL *phDesc, UINT32 *puDescLen, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetPSDResource")]
    public static extern bool _is6_GetPSDResource(IntPtr hPSDMgr, Int16 resID, ref IntPtr phData, ref UInt32 puDataLen, ref IntPtr phDesc, ref UInt32 puDescLen, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_RemovePSDResource(HISPSDRM hPSDMgr, ISUINT16 resID, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_RemovePSDResource")]
    public static extern bool _is6_RemovePSDResource(IntPtr hPSDMgr, Int16 resID, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_AddPSDResource(HISPSDRM hPSDMgr, ISUINT16 resID, const BYTE *pData, UINT32 uDataLen, const char *pDescription, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_AddPSDResource")]
    public static extern bool _is6_AddPSDResource(IntPtr hPSDMgr, Int16 resID, IntPtr pData, UInt32 uDataLen,
    [MarshalAs(UnmanagedType.LPStr)]
    string pDescription, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_CopyPSDResourceManager(HISPSDRM hPSDMgrSrc, HISPSDRM hPSDMgrDest, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_CopyPSDResourceManager")]
    public static extern bool _is6_CopyPSDResourceManager(IntPtr hPSDMgrSrc, IntPtr hPSDMgrDest, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ExportPSDResourceBlock(HISPSDRM hPSDMgr, HGLOBAL *phData, UINT32 *puDataLen, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ExportPSDResourceBlock")]
    public static extern bool _is6_ExportPSDResourceBlock(IntPtr hPSDMgr, ref IntPtr phData, ref UInt32 puDataLen, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_ExaminePhotoshopResources(const BYTE *pPhotoshopData, const UINT32 uPSLength, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ExaminePhotoshopResources")]
    public static extern bool _is6_ExaminePhotoshopResources(IntPtr pPhotoshopData, UInt32 uPSLength, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_CopyPSDWithNewResources(HISSRC hSource, HISDEST hDest, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_CopyPSDWithNewResources")]
    public static extern bool _is6_CopyPSDWithNewResources(IntPtr hSource, IntPtr hDest, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   HISSRC is6_OpenFileSource(const char * pFileName);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_OpenFileSource")]
    public static extern IntPtr _is6_OpenFileSource(
    [MarshalAs(UnmanagedType.LPStr)]
    string  pFileName);

    ////////////////////////////////////////////////////////////////////////////////
    //   HISSRC is6_OpenFileSourceW(const wchar_t * pFileNameW);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_OpenFileSourceW")]
    public static extern IntPtr _is6_OpenFileSourceW(IntPtr pFileNameW);

    ////////////////////////////////////////////////////////////////////////////////
    //   HISSRC is6_OpenHandleSource(HANDLE handle);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_OpenHandleSource")]
    public static extern IntPtr _is6_OpenHandleSource(IntPtr handle);

    ////////////////////////////////////////////////////////////////////////////////
    //   HISSRC is6_OpenMemorySource(const BYTE *pInBuf, const UINT32 uBufLen);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_OpenMemorySource")]
    public static extern IntPtr _is6_OpenMemorySource(IntPtr pInBuf, UInt32 uBufLen);

    ////////////////////////////////////////////////////////////////////////////////
    //   HISSRC is6_OpenUserSource(const is6_SourceOpenFn pOpenFn, const is6_SourceReadFn pReadFn, const is6_SourceSeekFn pSeekFn, const is6_SourceGetPosFn pPosFn, const is6_SourceGetSizeFn pSizeFn, const is6_SourceEOFFn pEOFFn, const is6_SourceCloseFn pCloseFn, const IS_CALLBACK_DATA uUserInfo);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_OpenUserSource")]
    public static extern IntPtr _is6_OpenUserSource(is6_SourceOpenFn pOpenFn, is6_SourceReadFn pReadFn, is6_SourceSeekFn pSeekFn, is6_SourceGetPosFn pPosFn, is6_SourceGetSizeFn pSizeFn, is6_SourceEOFFn pEOFFn, is6_SourceCloseFn pCloseFn, IntPtr uUserInfo);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_CloseSource(HISSRC hSource);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_CloseSource")]
    public static extern UInt32 _is6_CloseSource(IntPtr hSource);

    ////////////////////////////////////////////////////////////////////////////////
    //   HISDEST is6_OpenFileDest(const char *pFileName, BOOL bAppend);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_OpenFileDest")]
    public static extern IntPtr _is6_OpenFileDest(
    [MarshalAs(UnmanagedType.LPStr)]
    string pFileName, bool bAppend);

    ////////////////////////////////////////////////////////////////////////////////
    //   HISDEST is6_OpenFileDestW(const wchar_t *pFileName, BOOL bAppend);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_OpenFileDestW")]
    public static extern IntPtr _is6_OpenFileDestW(IntPtr pFileName, bool bAppend);

    ////////////////////////////////////////////////////////////////////////////////
    //   HISDEST is6_OpenHandleDest(HANDLE handle, BOOL bAppend);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_OpenHandleDest")]
    public static extern IntPtr _is6_OpenHandleDest(IntPtr handle, bool bAppend);

    ////////////////////////////////////////////////////////////////////////////////
    //   HISDEST is6_OpenMemoryDest(BYTE *pOutBuf, const UINT32 uBufLen, BOOL bAppend);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_OpenMemoryDest")]
    public static extern IntPtr _is6_OpenMemoryDest(IntPtr pOutBuf, UInt32 uBufLen, bool bAppend);

    ////////////////////////////////////////////////////////////////////////////////
    //   HISDEST is6_OpenDynamicMemoryDest(BOOL bAppend);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_OpenDynamicMemoryDest")]
    public static extern IntPtr _is6_OpenDynamicMemoryDest(bool bAppend);

    ////////////////////////////////////////////////////////////////////////////////
    //   HISDEST is6_OpenUserDest(const is6_SourceOpenFn pOpenFn, const is6_SourceWriteFn pWriteFn, const is6_SourceReadFn pReadFn, const is6_SourceSeekFn pSeekFn, const is6_SourceGetPosFn pPosFn, const is6_SourceGetSizeFn pSizeFn, const is6_SourceEOFFn pEOFFn, const is6_SourceCloseFn pCloseFn, BOOL bAppend, const IS_CALLBACK_DATA uUserInfo);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_OpenUserDest")]
    public static extern IntPtr _is6_OpenUserDest(is6_SourceOpenFn pOpenFn, is6_SourceWriteFn pWriteFn, is6_SourceReadFn pReadFn, is6_SourceSeekFn pSeekFn, is6_SourceGetPosFn pPosFn, is6_SourceGetSizeFn pSizeFn, is6_SourceEOFFn pEOFFn, is6_SourceCloseFn pCloseFn, bool bAppend, IntPtr uUserInfo);

    ////////////////////////////////////////////////////////////////////////////////
    //   HISDEST is6_OpenNullDest(UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_OpenNullDest")]
    public static extern IntPtr _is6_OpenNullDest(UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_CloseDest(HISDEST hDest);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_CloseDest")]
    public static extern UInt32 _is6_CloseDest(IntPtr hDest);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_Read(HANDLE hSource, BYTE * pData, const UINT32 uDataLen);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_Read")]
    public static extern UInt32 _is6_Read(IntPtr hSource, IntPtr pData, UInt32 uDataLen);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_Write(HANDLE hSource, const BYTE * pData, const UINT32 uDataLen);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_Write")]
    public static extern bool _is6_Write(IntPtr hSource, IntPtr pData, UInt32 uDataLen);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_Seek(HANDLE hMgr, __int32 uOffset, UINT32 uOrigin);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_Seek")]
    public static extern bool _is6_Seek(IntPtr hMgr, Int32 uOffset, UInt32 uOrigin);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetPos(HANDLE hMgr, UINT32 *puPos);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetPos")]
    public static extern bool _is6_GetPos(IntPtr hMgr, ref UInt32 puPos);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_GetSize(HANDLE hMgr, UINT32 *puSize);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_GetSize")]
    public static extern bool _is6_GetSize(IntPtr hMgr, ref UInt32 puSize);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_EOF(HANDLE hMgr);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_EOF")]
    public static extern bool _is6_EOF(IntPtr hMgr);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_IsValidManager(HANDLE hMgr);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_IsValidManager")]
    public static extern bool _is6_IsValidManager(IntPtr hMgr);

    ////////////////////////////////////////////////////////////////////////////////
    //   BOOL is6_IsValidManagerNoErr(HANDLE hMgr);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_IsValidManagerNoErr")]
    public static extern bool _is6_IsValidManagerNoErr(IntPtr hMgr);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_ZDeflateBuffer(const BYTE *pIn, UINT32 uInLen, BYTE *pOut, UINT32 uOutLen, UINT32 uLevel, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ZDeflateBuffer")]
    public static extern UInt32 _is6_ZDeflateBuffer(IntPtr pIn, UInt32 uInLen, IntPtr pOut, UInt32 uOutLen, UInt32 uLevel, UInt32 uFlags);

    ////////////////////////////////////////////////////////////////////////////////
    //   UINT32 is6_ZInflateBuffer(const BYTE *pIn, UINT32 uInLen, BYTE *pOut, UINT32 uOutLen, UINT32 uFlags);
    [DllImport("ImgSource60.dll", EntryPoint = "_is6_ZInflateBuffer")]
    public static extern UInt32 _is6_ZInflateBuffer(IntPtr pIn, UInt32 uInLen, IntPtr pOut, UInt32 uOutLen, UInt32 uFlags);
}
