/*
 * Decompiled with CFR 0.152.
 */
package org.freeinternals.classfile.core;

import java.io.IOException;
import org.freeinternals.classfile.core.PosDataInputStream;
import org.freeinternals.classfile.core.U2ClassComponent;

public class AccessFlags
extends U2ClassComponent {
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SUPER = 32;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;

    AccessFlags(PosDataInputStream posDis) throws IOException {
        super(posDis);
    }

    public String getModifiers() {
        StringBuilder sb = new StringBuilder(25);
        Boolean isFirstModifier = true;
        if ((this.value.value & 1) > 0) {
            sb.append("public ");
            isFirstModifier = false;
        }
        if ((this.value.value & 0x10) > 0) {
            if (!isFirstModifier.booleanValue()) {
                sb.append(' ');
            }
            sb.append("final ");
            isFirstModifier = false;
        }
        if ((this.value.value & 0x20) > 0) {
            if (!isFirstModifier.booleanValue()) {
                sb.append(' ');
            }
            sb.append("super ");
            isFirstModifier = false;
        }
        if ((this.value.value & 0x200) > 0) {
            if (!isFirstModifier.booleanValue()) {
                sb.append(' ');
            }
            sb.append("interface ");
            isFirstModifier = false;
        }
        if ((this.value.value & 0x400) > 0) {
            if (!isFirstModifier.booleanValue()) {
                sb.append(' ');
            }
            sb.append("abstract ");
            isFirstModifier = false;
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(25);
        sb.append(String.format("%04X  (", this.value.value));
        if ((this.value.value & 1) > 0) {
            sb.append("public ");
        }
        if ((this.value.value & 0x10) > 0) {
            sb.append("final ");
        }
        if ((this.value.value & 0x20) > 0) {
            sb.append("super ");
        }
        if ((this.value.value & 0x200) > 0) {
            sb.append("interface ");
        }
        if ((this.value.value & 0x400) > 0) {
            sb.append("abstract ");
        }
        sb.append(")");
        return sb.toString();
    }
}

