/*
 * Decompiled with CFR 0.152.
 */
package org.freeinternals.classfile.core;

import java.io.IOException;
import org.freeinternals.classfile.core.AbstractCPInfo;
import org.freeinternals.classfile.core.AttributeInfo;
import org.freeinternals.classfile.core.ClassComponent;
import org.freeinternals.classfile.core.ClassFormatException;
import org.freeinternals.classfile.core.PosDataInputStream;
import org.freeinternals.classfile.core.u2;
import org.freeinternals.classfile.core.u4;

public class AttributeCode
extends AttributeInfo {
    private final transient u2 max_stack = new u2();
    private final transient u2 max_locals;
    private final transient u4 code_length;
    private final transient byte[] code;
    private final transient u2 exception_table_length;
    private transient ExceptionTable[] exceptionTable;
    private final transient u2 attributes_count;
    private transient AttributeInfo[] attributes;

    AttributeCode(u2 nameIndex, String type, PosDataInputStream posDataInputStream, AbstractCPInfo[] cp) throws IOException, ClassFormatException {
        super(nameIndex, type, posDataInputStream);
        int i;
        this.max_stack.value = posDataInputStream.readUnsignedShort();
        this.max_locals = new u2();
        this.max_locals.value = posDataInputStream.readUnsignedShort();
        this.code_length = new u4();
        this.code_length.value = posDataInputStream.readInt();
        this.code = new byte[this.code_length.value];
        posDataInputStream.read(this.code);
        this.exception_table_length = new u2();
        this.exception_table_length.value = posDataInputStream.readUnsignedShort();
        if (this.exception_table_length.value > 0) {
            this.exceptionTable = new ExceptionTable[this.exception_table_length.value];
            for (i = 0; i < this.exception_table_length.value; ++i) {
                this.exceptionTable[i] = new ExceptionTable(posDataInputStream);
            }
        }
        this.attributes_count = new u2();
        this.attributes_count.value = posDataInputStream.readUnsignedShort();
        int attrCount = this.attributes_count.value;
        if (attrCount > 0) {
            this.attributes = new AttributeInfo[attrCount];
            for (i = 0; i < attrCount; ++i) {
                this.attributes[i] = AttributeInfo.parse(posDataInputStream, cp);
            }
        }
        super.checkSize(posDataInputStream.getPos());
    }

    public int getMaxStack() {
        return this.max_stack.value;
    }

    public int getMaxLocals() {
        return this.max_locals.value;
    }

    public int getCodeLength() {
        return this.code_length.value;
    }

    public byte[] getCode() {
        return this.code;
    }

    public int getExceptionTableLength() {
        return this.exception_table_length.value;
    }

    public ExceptionTable getExceptionTable(int index) {
        ExceptionTable et = null;
        if (this.exceptionTable != null) {
            et = this.exceptionTable[index];
        }
        return et;
    }

    public int getAttributeCount() {
        return this.attributes_count.value;
    }

    public AttributeInfo getAttribute(int index) {
        return this.attributes[index];
    }

    public final class ExceptionTable
    extends ClassComponent {
        private final transient u2 start_pc;
        private final transient u2 end_pc;
        private final transient u2 handler_pc;
        private final transient u2 catch_type;

        private ExceptionTable(PosDataInputStream posDataInputStream) throws IOException {
            this.startPos = posDataInputStream.getPos();
            this.length = 8;
            this.start_pc = new u2();
            this.start_pc.value = posDataInputStream.readUnsignedShort();
            this.end_pc = new u2();
            this.end_pc.value = posDataInputStream.readUnsignedShort();
            this.handler_pc = new u2();
            this.handler_pc.value = posDataInputStream.readUnsignedShort();
            this.catch_type = new u2();
            this.catch_type.value = posDataInputStream.readUnsignedShort();
        }

        public int getStartPc() {
            return this.start_pc.value;
        }

        public int getEndPc() {
            return this.end_pc.value;
        }

        public int getHandlerPc() {
            return this.handler_pc.value;
        }

        public int getCatchType() {
            return this.catch_type.value;
        }
    }
}

