/*
 * Decompiled with CFR 0.152.
 */
package org.freeinternals.classfile.core;

import java.io.IOException;
import org.freeinternals.classfile.core.AttributeInfo;
import org.freeinternals.classfile.core.ClassFormatException;
import org.freeinternals.classfile.core.PosDataInputStream;
import org.freeinternals.classfile.core.u2;

public class AttributeConstantValue
extends AttributeInfo {
    private final transient u2 constantvalue_index;

    AttributeConstantValue(u2 nameIndex, String type, PosDataInputStream posDataInputStream) throws IOException, ClassFormatException {
        super(nameIndex, type, posDataInputStream);
        if (this.attribute_length.value != 2) {
            throw new ClassFormatException(String.format("The attribute_length of AttributeConstantValue is not 2, it is %d.", this.attribute_length.value));
        }
        this.constantvalue_index = new u2();
        this.constantvalue_index.value = posDataInputStream.readUnsignedShort();
        super.checkSize(posDataInputStream.getPos());
    }

    public int getConstantValueIndex() {
        return this.constantvalue_index.value;
    }
}

