/*
 * Decompiled with CFR 0.152.
 */
package org.freeinternals.classfile.core;

import java.io.IOException;
import org.freeinternals.classfile.core.AttributeInfo;
import org.freeinternals.classfile.core.ClassFormatException;
import org.freeinternals.classfile.core.PosDataInputStream;
import org.freeinternals.classfile.core.u2;

public class AttributeExceptions
extends AttributeInfo {
    private final transient u2 number_of_exceptions = new u2();
    private transient u2[] exception_index_table;

    AttributeExceptions(u2 nameIndex, String type, PosDataInputStream posDataInputStream) throws IOException, ClassFormatException {
        super(nameIndex, type, posDataInputStream);
        int excpCount = this.number_of_exceptions.value = posDataInputStream.readUnsignedShort();
        if (excpCount > 0) {
            this.exception_index_table = new u2[excpCount];
            for (int i = 0; i < excpCount; ++i) {
                this.exception_index_table[i] = new u2();
                this.exception_index_table[i].value = posDataInputStream.readUnsignedShort();
            }
        }
        super.checkSize(posDataInputStream.getPos());
    }

    public int getNumberOfExceptions() {
        return this.number_of_exceptions.value;
    }

    public int getExceptionIndexTableItem(int index) {
        int i = this.exception_index_table == null ? -1 : this.exception_index_table[index].value;
        return i;
    }
}

