/*
 * Decompiled with CFR 0.152.
 */
package org.freeinternals.classfile.core;

import java.io.IOException;
import org.freeinternals.classfile.core.AbstractCPInfo;
import org.freeinternals.classfile.core.AttributeCode;
import org.freeinternals.classfile.core.AttributeConstantValue;
import org.freeinternals.classfile.core.AttributeDeprecated;
import org.freeinternals.classfile.core.AttributeExceptions;
import org.freeinternals.classfile.core.AttributeExtended;
import org.freeinternals.classfile.core.AttributeInnerClasses;
import org.freeinternals.classfile.core.AttributeLineNumberTable;
import org.freeinternals.classfile.core.AttributeLocalVariableTable;
import org.freeinternals.classfile.core.AttributeSourceFile;
import org.freeinternals.classfile.core.AttributeSynthetic;
import org.freeinternals.classfile.core.ClassComponent;
import org.freeinternals.classfile.core.ClassFormatException;
import org.freeinternals.classfile.core.ConstantUtf8Info;
import org.freeinternals.classfile.core.PosDataInputStream;
import org.freeinternals.classfile.core.u2;
import org.freeinternals.classfile.core.u4;

public class AttributeInfo
extends ClassComponent {
    public static final String TypeConstantValue = "ConstantValue";
    public static final String TypeCode = "Code";
    public static final String TypeExceptions = "Exceptions";
    public static final String TypeInnerClasses = "InnerClasses";
    public static final String TypeSynthetic = "Synthetic";
    public static final String TypeSourceFile = "SourceFile";
    public static final String TypeLineNumberTable = "LineNumberTable";
    public static final String TypeLocalVariableTable = "LocalVariableTable";
    public static final String TypeDeprecated = "Deprecated";
    public static final String Extended = "[Extended Attr.] ";
    private transient String type;
    transient u2 attribute_name_index;
    transient u4 attribute_length;

    AttributeInfo() {
    }

    AttributeInfo(u2 nameIndex, String type, PosDataInputStream posDataInputStream) throws IOException, ClassFormatException {
        this.startPos = posDataInputStream.getPos() - 2;
        this.type = type;
        this.attribute_name_index = new u2();
        this.attribute_name_index.value = nameIndex.value;
        this.attribute_length = new u4();
        this.attribute_length.value = posDataInputStream.readInt();
        this.length = this.attribute_length.value + 6;
    }

    static AttributeInfo parse(PosDataInputStream posDataInputStream, AbstractCPInfo[] cp) throws IOException, ClassFormatException {
        AttributeInfo attr = new AttributeInfo();
        u2 attrNameIndex = new u2();
        attrNameIndex.value = posDataInputStream.readUnsignedShort();
        if (1 == cp[attrNameIndex.value].tag.value) {
            String type = ((ConstantUtf8Info)cp[attrNameIndex.value]).getValue();
            attr = TypeConstantValue.equals(type) ? new AttributeConstantValue(attrNameIndex, type, posDataInputStream) : (TypeCode.equals(type) ? new AttributeCode(attrNameIndex, type, posDataInputStream, cp) : (TypeExceptions.equals(type) ? new AttributeExceptions(attrNameIndex, type, posDataInputStream) : (TypeInnerClasses.equals(type) ? new AttributeInnerClasses(attrNameIndex, type, posDataInputStream) : (TypeSynthetic.equals(type) ? new AttributeSynthetic(attrNameIndex, type, posDataInputStream) : (TypeSourceFile.equals(type) ? new AttributeSourceFile(attrNameIndex, type, posDataInputStream) : (TypeLineNumberTable.equals(type) ? new AttributeLineNumberTable(attrNameIndex, type, posDataInputStream) : (TypeLocalVariableTable.equals(type) ? new AttributeLocalVariableTable(attrNameIndex, type, posDataInputStream) : (TypeDeprecated.equals(type) ? new AttributeDeprecated(attrNameIndex, type, posDataInputStream) : new AttributeExtended(attrNameIndex, Extended + type, posDataInputStream)))))))));
        } else {
            throw new ClassFormatException(String.format("Attribute name_index is not CONSTANT_Utf8. Constant index = %d, type = %d.", attrNameIndex.value, cp[attrNameIndex.value].tag.value));
        }
        return attr;
    }

    protected void checkSize(int endPos) throws ClassFormatException {
        if (this.startPos + this.length != endPos) {
            throw new ClassFormatException(String.format("Attribute analysis failed. type='%s', startPos=%d, length=%d, endPos=%d", this.getName(), this.startPos, this.length, endPos));
        }
    }

    public String getName() {
        return this.type != null ? this.type : "";
    }

    public int getNameIndex() {
        return this.attribute_name_index.value;
    }

    public int getAttributeLength() {
        return this.attribute_length.value;
    }
}

