/*
 * Decompiled with CFR 0.152.
 */
package org.freeinternals.classfile.core;

import java.io.IOException;
import org.freeinternals.classfile.core.AttributeInfo;
import org.freeinternals.classfile.core.ClassComponent;
import org.freeinternals.classfile.core.ClassFormatException;
import org.freeinternals.classfile.core.PosDataInputStream;
import org.freeinternals.classfile.core.u2;

public class AttributeInnerClasses
extends AttributeInfo {
    private final transient u2 number_of_classes = new u2();
    private transient Class[] classes;

    AttributeInnerClasses(u2 nameIndex, String type, PosDataInputStream posDataInputStream) throws IOException, ClassFormatException {
        super(nameIndex, type, posDataInputStream);
        this.number_of_classes.value = posDataInputStream.readUnsignedShort();
        if (this.number_of_classes.value > 0) {
            this.classes = new Class[this.number_of_classes.value];
            for (int i = 0; i < this.number_of_classes.value; ++i) {
                this.classes[i] = new Class(posDataInputStream);
            }
        }
        super.checkSize(posDataInputStream.getPos());
    }

    public int getNumberOfClasses() {
        return this.number_of_classes.value;
    }

    public Class getClass(int index) {
        Class cls = null;
        if (this.classes != null) {
            cls = this.classes[index];
        }
        return cls;
    }

    public final class Class
    extends ClassComponent {
        private final transient u2 inner_class_info_index;
        private final transient u2 outer_class_info_index;
        private final transient u2 inner_name_index;
        private final transient u2 inner_class_access_flags;

        private Class(PosDataInputStream posDataInputStream) throws IOException {
            this.startPos = posDataInputStream.getPos();
            this.length = 8;
            this.inner_class_info_index = new u2();
            this.inner_class_info_index.value = posDataInputStream.readUnsignedShort();
            this.outer_class_info_index = new u2();
            this.outer_class_info_index.value = posDataInputStream.readUnsignedShort();
            this.inner_name_index = new u2();
            this.inner_name_index.value = posDataInputStream.readUnsignedShort();
            this.inner_class_access_flags = new u2();
            this.inner_class_access_flags.value = posDataInputStream.readUnsignedShort();
        }

        public int getInnerClassInfoIndex() {
            return this.inner_class_info_index.value;
        }

        public int getOuterClassInfoIndex() {
            return this.outer_class_info_index.value;
        }

        public int getInnerNameIndex() {
            return this.inner_name_index.value;
        }

        public int getInnerClassAccessFlags() {
            return this.inner_class_access_flags.value;
        }
    }
}

