/*
 * Decompiled with CFR 0.152.
 */
package org.freeinternals.classfile.core;

import java.io.IOException;
import org.freeinternals.classfile.core.AttributeInfo;
import org.freeinternals.classfile.core.ClassComponent;
import org.freeinternals.classfile.core.ClassFormatException;
import org.freeinternals.classfile.core.PosDataInputStream;
import org.freeinternals.classfile.core.u2;

public class AttributeLineNumberTable
extends AttributeInfo {
    private final transient u2 line_number_table_length = new u2();
    private transient LineNumberTable[] lineNumberTable;

    AttributeLineNumberTable(u2 nameIndex, String type, PosDataInputStream posDataInputStream) throws IOException, ClassFormatException {
        super(nameIndex, type, posDataInputStream);
        this.line_number_table_length.value = posDataInputStream.readUnsignedShort();
        if (this.line_number_table_length.value > 0) {
            this.lineNumberTable = new LineNumberTable[this.line_number_table_length.value];
            for (int i = 0; i < this.line_number_table_length.value; ++i) {
                this.lineNumberTable[i] = new LineNumberTable(posDataInputStream);
            }
        }
        super.checkSize(posDataInputStream.getPos());
    }

    public int getLineNumberTableLength() {
        return this.line_number_table_length.value;
    }

    public LineNumberTable getLineNumberTable(int index) {
        LineNumberTable lnt = null;
        if (this.lineNumberTable != null) {
            lnt = this.lineNumberTable[index];
        }
        return lnt;
    }

    public final class LineNumberTable
    extends ClassComponent {
        private final transient u2 start_pc;
        private final transient u2 line_number;

        private LineNumberTable(PosDataInputStream posDataInputStream) throws IOException {
            this.startPos = posDataInputStream.getPos();
            this.length = 4;
            this.start_pc = new u2();
            this.start_pc.value = posDataInputStream.readUnsignedShort();
            this.line_number = new u2();
            this.line_number.value = posDataInputStream.readUnsignedShort();
        }

        public int getStartPc() {
            return this.start_pc.value;
        }

        public int getLineNumber() {
            return this.line_number.value;
        }
    }
}

