/*
 * Decompiled with CFR 0.152.
 */
package org.freeinternals.classfile.core;

import java.io.IOException;
import org.freeinternals.classfile.core.AttributeInfo;
import org.freeinternals.classfile.core.ClassComponent;
import org.freeinternals.classfile.core.ClassFormatException;
import org.freeinternals.classfile.core.PosDataInputStream;
import org.freeinternals.classfile.core.u2;

public class AttributeLocalVariableTable
extends AttributeInfo {
    private final transient u2 local_variable_table_length = new u2();
    private transient LocalVariableTable[] localVariableTable;

    AttributeLocalVariableTable(u2 nameIndex, String type, PosDataInputStream posDataInputStream) throws IOException, ClassFormatException {
        super(nameIndex, type, posDataInputStream);
        this.local_variable_table_length.value = posDataInputStream.readUnsignedShort();
        if (this.local_variable_table_length.value > 0) {
            this.localVariableTable = new LocalVariableTable[this.local_variable_table_length.value];
            for (int i = 0; i < this.local_variable_table_length.value; ++i) {
                this.localVariableTable[i] = new LocalVariableTable(posDataInputStream);
            }
        }
        super.checkSize(posDataInputStream.getPos());
    }

    public int getLocalVariableTalbeLength() {
        return this.local_variable_table_length.value;
    }

    public LocalVariableTable getLocalVariableTable(int index) {
        LocalVariableTable lvt = null;
        if (this.localVariableTable != null) {
            lvt = this.localVariableTable[index];
        }
        return lvt;
    }

    public final class LocalVariableTable
    extends ClassComponent {
        private final transient u2 start_pc;
        private final transient u2 length_lvt;
        private final transient u2 name_index;
        private final transient u2 descriptor_index;
        private final transient u2 index;

        private LocalVariableTable(PosDataInputStream posDataInputStream) throws IOException {
            this.startPos = posDataInputStream.getPos();
            this.length = 10;
            this.start_pc = new u2();
            this.start_pc.value = posDataInputStream.readUnsignedShort();
            this.length_lvt = new u2();
            this.length_lvt.value = posDataInputStream.readUnsignedShort();
            this.name_index = new u2();
            this.name_index.value = posDataInputStream.readUnsignedShort();
            this.descriptor_index = new u2();
            this.descriptor_index.value = posDataInputStream.readUnsignedShort();
            this.index = new u2();
            this.index.value = posDataInputStream.readUnsignedShort();
        }

        public int getStartPc() {
            return this.start_pc.value;
        }

        public int getCodeLength() {
            return this.length_lvt.value;
        }

        public int getNameIndex() {
            return this.name_index.value;
        }

        public int getDescriptorIndex() {
            return this.descriptor_index.value;
        }

        public int getIndex() {
            return this.index.value;
        }
    }
}

