/*
 * Decompiled with CFR 0.152.
 */
package org.freeinternals.classfile.core;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.freeinternals.classfile.core.AbstractCPInfo;
import org.freeinternals.classfile.core.AccessFlags;
import org.freeinternals.classfile.core.AttributeCount;
import org.freeinternals.classfile.core.AttributeInfo;
import org.freeinternals.classfile.core.CPCount;
import org.freeinternals.classfile.core.ClassFormatException;
import org.freeinternals.classfile.core.ConstantClassInfo;
import org.freeinternals.classfile.core.ConstantDoubleInfo;
import org.freeinternals.classfile.core.ConstantFieldrefInfo;
import org.freeinternals.classfile.core.ConstantFloatInfo;
import org.freeinternals.classfile.core.ConstantIntegerInfo;
import org.freeinternals.classfile.core.ConstantInterfaceMethodrefInfo;
import org.freeinternals.classfile.core.ConstantLongInfo;
import org.freeinternals.classfile.core.ConstantMethodrefInfo;
import org.freeinternals.classfile.core.ConstantNameAndTypeInfo;
import org.freeinternals.classfile.core.ConstantStringInfo;
import org.freeinternals.classfile.core.ConstantUtf8Info;
import org.freeinternals.classfile.core.FieldCount;
import org.freeinternals.classfile.core.FieldInfo;
import org.freeinternals.classfile.core.Interface;
import org.freeinternals.classfile.core.InterfaceCount;
import org.freeinternals.classfile.core.MajorVersion;
import org.freeinternals.classfile.core.MethodCount;
import org.freeinternals.classfile.core.MethodInfo;
import org.freeinternals.classfile.core.MinorVersion;
import org.freeinternals.classfile.core.PosByteArrayInputStream;
import org.freeinternals.classfile.core.PosDataInputStream;
import org.freeinternals.classfile.core.SignatureConvertor;
import org.freeinternals.classfile.core.SignatureException;
import org.freeinternals.classfile.core.SuperClass;
import org.freeinternals.classfile.core.ThisClass;
import org.freeinternals.classfile.core.u4;

public class ClassFile {
    private byte[] classByteArray;
    private PosDataInputStream posDataInputStream;
    public static final int MAGIC = -889275714;
    private u4 magic;
    private MinorVersion minor_version;
    private MajorVersion major_version;
    private CPCount constant_pool_count;
    private AbstractCPInfo[] constant_pool;
    private AccessFlags access_flags;
    private ThisClass this_class;
    private SuperClass super_class;
    private InterfaceCount interfaces_count;
    private Interface[] interfaces;
    private FieldCount fields_count;
    private FieldInfo[] fields;
    private MethodCount methods_count;
    private MethodInfo[] methods;
    private AttributeCount attributes_count;
    private AttributeInfo[] attributes;

    public ClassFile(byte[] classByteArray) throws IOException, ClassFormatException {
        this.classByteArray = (byte[])classByteArray.clone();
        Parser parser = new Parser();
        parser.parse();
        this.analysisDeclarations();
    }

    private void analysisDeclarations() throws ClassFormatException {
        if (this.fields_count.getValue() > 0) {
            String type = null;
            for (FieldInfo field : this.fields) {
                try {
                    type = SignatureConvertor.signature2Type(this.getConstantUtf8Value(field.getDescriptorIndex()));
                }
                catch (SignatureException se) {
                    type = "[Unexpected signature type]: " + this.getConstantUtf8Value(field.getDescriptorIndex());
                }
                field.setDeclaration(String.format("%s %s %s", field.getModifiers(), type, this.getConstantUtf8Value(field.getNameIndex())));
            }
        }
        if (this.methods_count.getValue() > 0) {
            String mtdReturnType = null;
            String mtdParameters = null;
            for (MethodInfo method : this.methods) {
                try {
                    mtdReturnType = SignatureConvertor.parseMethodReturnType(this.getConstantUtf8Value(method.getDescriptorIndex()));
                }
                catch (SignatureException se) {
                    mtdReturnType = String.format("[Unexpected method return type: %s]", this.getConstantUtf8Value(method.getDescriptorIndex()));
                }
                try {
                    mtdParameters = SignatureConvertor.parseMethodParameters(this.getConstantUtf8Value(method.getDescriptorIndex()));
                }
                catch (SignatureException se) {
                    mtdParameters = String.format("[Unexpected method parameters: %s]", this.getConstantUtf8Value(method.getDescriptorIndex()));
                }
                method.setDeclaration(String.format("%s %s %s %s", method.getModifiers(), mtdReturnType, this.getConstantUtf8Value(method.getNameIndex()), mtdParameters));
            }
        }
    }

    private String getConstantUtf8Value(int cpIndex) throws ClassFormatException {
        String returnValue = null;
        if (cpIndex == 0 || cpIndex >= this.constant_pool_count.value.value) {
            throw new ClassFormatException(String.format("Constant Pool index is out of range. CP index cannot be zero, and should be less than CP count (=%d). CP index = %d.", this.constant_pool_count.value.value, cpIndex));
        }
        if (this.constant_pool[cpIndex].tag.value != 1) {
            throw new ClassFormatException(String.format("Unexpected constant pool type: Utf8(%d) expected, but it is '%d'.", (short)1, this.constant_pool[cpIndex].tag.value));
        }
        ConstantUtf8Info utf8Info = (ConstantUtf8Info)this.constant_pool[cpIndex];
        returnValue = utf8Info.getValue();
        return returnValue;
    }

    public byte[] getClassByteArray() {
        return this.classByteArray;
    }

    public byte[] getClassByteArray(int startIndex, int length) {
        if (startIndex < 0 || length < 1) {
            throw new IllegalArgumentException("startIndex or length is not valid. startIndex = " + startIndex + ", length = " + length);
        }
        if (startIndex + length - 1 > this.classByteArray.length) {
            throw new ArrayIndexOutOfBoundsException("The last item index is bigger than class byte array size.");
        }
        byte[] data = new byte[length];
        for (int i = 0; i < length; ++i) {
            data[i] = this.classByteArray[startIndex + i];
        }
        return data;
    }

    public int getByteArraySize() {
        return this.classByteArray.length;
    }

    public MinorVersion getMinorVersion() {
        return this.minor_version;
    }

    public MajorVersion getMajorVersion() {
        return this.major_version;
    }

    public CPCount getCPCount() {
        return this.constant_pool_count;
    }

    public AbstractCPInfo[] getConstantPool() {
        return this.constant_pool;
    }

    public String getCPDescription(int index) {
        if (index >= this.constant_pool_count.getValue()) {
            return null;
        }
        if (index == 0) {
            return null;
        }
        return new CPDescr().getCPDescr(index);
    }

    public AccessFlags getAccessFlags() {
        return this.access_flags;
    }

    public ThisClass getThisClass() {
        return this.this_class;
    }

    public SuperClass getSuperClass() {
        return this.super_class;
    }

    public InterfaceCount getInterfacesCount() {
        return this.interfaces_count;
    }

    public Interface[] getInterfaces() {
        return this.interfaces;
    }

    public FieldCount getFieldCount() {
        return this.fields_count;
    }

    public FieldInfo[] getFields() {
        return this.fields;
    }

    public MethodCount getMethodCount() {
        return this.methods_count;
    }

    public MethodInfo[] getMethods() {
        return this.methods;
    }

    public AttributeCount getAttributeCount() {
        return this.attributes_count;
    }

    public AttributeInfo[] getAttributes() {
        return this.attributes;
    }

    static /* synthetic */ AbstractCPInfo[] access$602(ClassFile x0, AbstractCPInfo[] x1) {
        x0.constant_pool = x1;
        return x1;
    }

    static /* synthetic */ Interface[] access$1102(ClassFile x0, Interface[] x1) {
        x0.interfaces = x1;
        return x1;
    }

    static /* synthetic */ FieldInfo[] access$1302(ClassFile x0, FieldInfo[] x1) {
        x0.fields = x1;
        return x1;
    }

    static /* synthetic */ MethodInfo[] access$1502(ClassFile x0, MethodInfo[] x1) {
        x0.methods = x1;
        return x1;
    }

    static /* synthetic */ AttributeInfo[] access$1702(ClassFile x0, AttributeInfo[] x1) {
        x0.attributes = x1;
        return x1;
    }

    private class CPDescr {
        CPDescr() {
        }

        public String getCPDescr(int index) {
            StringBuilder sb = new StringBuilder(40);
            switch (ClassFile.this.constant_pool[index].getTag()) {
                case 1: {
                    sb.append("Utf8: ");
                    sb.append(this.getDescr_Utf8((ConstantUtf8Info)ClassFile.this.constant_pool[index]));
                    break;
                }
                case 3: {
                    sb.append("Integer: ");
                    sb.append(this.getDescr_Integer((ConstantIntegerInfo)ClassFile.this.constant_pool[index]));
                    break;
                }
                case 4: {
                    sb.append("Float: ");
                    sb.append(this.getDescr_Float((ConstantFloatInfo)ClassFile.this.constant_pool[index]));
                    break;
                }
                case 5: {
                    sb.append("Long: ");
                    sb.append(this.getDescr_Long((ConstantLongInfo)ClassFile.this.constant_pool[index]));
                    break;
                }
                case 6: {
                    sb.append("Double: ");
                    sb.append(this.getDescr_Double((ConstantDoubleInfo)ClassFile.this.constant_pool[index]));
                    break;
                }
                case 7: {
                    sb.append("Class: ");
                    sb.append(this.getDescr_Class((ConstantClassInfo)ClassFile.this.constant_pool[index]));
                    break;
                }
                case 8: {
                    sb.append("String: ");
                    sb.append(this.getDescr_String((ConstantStringInfo)ClassFile.this.constant_pool[index]));
                    break;
                }
                case 9: {
                    sb.append("Fieldref: ");
                    sb.append(this.getDescr_Fieldref((ConstantFieldrefInfo)ClassFile.this.constant_pool[index]));
                    break;
                }
                case 10: {
                    sb.append("Methodref: ");
                    sb.append(this.getDescr_Methodref((ConstantMethodrefInfo)ClassFile.this.constant_pool[index]));
                    break;
                }
                case 11: {
                    sb.append("InterfaceMethodref: ");
                    sb.append(this.getDescr_InterfaceMethodref((ConstantInterfaceMethodrefInfo)ClassFile.this.constant_pool[index]));
                    break;
                }
                case 12: {
                    sb.append("NameAndType: ");
                    sb.append(this.getDescr_NameAndType((ConstantNameAndTypeInfo)ClassFile.this.constant_pool[index], Descr_NameAndType.RAW));
                    break;
                }
                default: {
                    sb.append("!!! Un-supported CP type.");
                }
            }
            return sb.toString();
        }

        private String getDescr_Utf8(ConstantUtf8Info info) {
            return info.getValue();
        }

        private String getDescr_Integer(ConstantIntegerInfo info) {
            return String.valueOf(info.getValue());
        }

        private String getDescr_Float(ConstantFloatInfo info) {
            return String.valueOf(info.getValue());
        }

        private String getDescr_Long(ConstantLongInfo info) {
            return String.valueOf(info.getValue());
        }

        private String getDescr_Double(ConstantDoubleInfo info) {
            return String.valueOf(info.getValue());
        }

        private String getDescr_Class(ConstantClassInfo info) {
            return SignatureConvertor.parseClassSignature(this.getDescr_Utf8((ConstantUtf8Info)ClassFile.this.constant_pool[info.getNameIndex()]));
        }

        private String getDescr_String(ConstantStringInfo info) {
            return SignatureConvertor.parseClassSignature(this.getDescr_Utf8((ConstantUtf8Info)ClassFile.this.constant_pool[info.getStringIndex()]));
        }

        private String getDescr_Fieldref(ConstantFieldrefInfo info) {
            return this.getDescr_ref(info.getClassIndex(), info.getNameAndTypeIndex(), Descr_NameAndType.FIELD);
        }

        private String getDescr_Methodref(ConstantMethodrefInfo info) {
            return this.getDescr_ref(info.getClassIndex(), info.getNameAndTypeIndex(), Descr_NameAndType.METHOD);
        }

        private String getDescr_InterfaceMethodref(ConstantInterfaceMethodrefInfo info) {
            return this.getDescr_ref(info.getClassIndex(), info.getNameAndTypeIndex(), Descr_NameAndType.METHOD);
        }

        private String getDescr_ref(int classindex, int natindex, Descr_NameAndType type) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getDescr_Class((ConstantClassInfo)ClassFile.this.constant_pool[classindex]));
            sb.append(".");
            sb.append(this.getDescr_NameAndType((ConstantNameAndTypeInfo)ClassFile.this.constant_pool[natindex], type));
            return sb.toString();
        }

        private String getDescr_NameAndType(ConstantNameAndTypeInfo info, Descr_NameAndType format) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getDescr_Utf8((ConstantUtf8Info)ClassFile.this.constant_pool[info.getNameIndex()]));
            sb.append(", ");
            String type = this.getDescr_Utf8((ConstantUtf8Info)ClassFile.this.constant_pool[info.getDescriptorIndex()]);
            switch (format) {
                case RAW: {
                    sb.append(type);
                    break;
                }
                case FIELD: {
                    try {
                        sb.append("type = ");
                        sb.append(SignatureConvertor.signature2Type(type));
                    }
                    catch (SignatureException ex) {
                        Logger.getLogger(ClassFile.class.getName()).log(Level.SEVERE, null, ex);
                        sb.append(type);
                        sb.append(" !!! Un-recognized type");
                    }
                    break;
                }
                case METHOD: {
                    StringBuilder sb_mtd = new StringBuilder();
                    try {
                        sb_mtd.append("parameter = ");
                        sb_mtd.append(SignatureConvertor.parseMethodParameters(type));
                        sb_mtd.append(", returns = ");
                        sb_mtd.append(SignatureConvertor.parseMethodReturnType(type));
                        sb.append((CharSequence)sb_mtd);
                    }
                    catch (SignatureException ex) {
                        Logger.getLogger(ClassFile.class.getName()).log(Level.SEVERE, null, ex);
                        sb.append(type);
                        sb.append(" !!! Un-recognized type");
                    }
                    break;
                }
            }
            return sb.toString();
        }
    }

    private static enum Descr_NameAndType {
        RAW(1),
        FIELD(2),
        METHOD(3);

        private final int enum_value;

        private Descr_NameAndType(int value) {
            this.enum_value = value;
        }

        public int value() {
            return this.enum_value;
        }
    }

    private class Parser {
        Parser() {
        }

        public void parse() throws IOException, ClassFormatException {
            PosByteArrayInputStream posByteArrayInputStream = new PosByteArrayInputStream(ClassFile.this.classByteArray);
            ClassFile.this.posDataInputStream = new PosDataInputStream(posByteArrayInputStream);
            ClassFile.this.magic = new u4(ClassFile.this.posDataInputStream.readInt());
            if (((ClassFile)ClassFile.this).magic.value != -889275714) {
                throw new ClassFormatException("The magic number of the byte array is not 0xCAFEBABE");
            }
            this.parseClassFileVersion();
            this.parseConstantPool();
            this.parseClassDeclaration();
            this.parseFields();
            this.parseMethods();
            this.parseAttributes();
        }

        private void parseClassFileVersion() throws IOException, ClassFormatException {
            ClassFile.this.minor_version = new MinorVersion(ClassFile.this.posDataInputStream);
            ClassFile.this.major_version = new MajorVersion(ClassFile.this.posDataInputStream);
        }

        private void parseConstantPool() throws IOException, ClassFormatException {
            ClassFile.this.constant_pool_count = new CPCount(ClassFile.this.posDataInputStream);
            int cp_count = ClassFile.this.constant_pool_count.getValue();
            ClassFile.access$602(ClassFile.this, new AbstractCPInfo[cp_count]);
            block13: for (int i = 1; i < cp_count; ++i) {
                short tag = (short)ClassFile.this.posDataInputStream.readUnsignedByte();
                switch (tag) {
                    case 1: {
                        ((ClassFile)ClassFile.this).constant_pool[i] = new ConstantUtf8Info(ClassFile.this.posDataInputStream);
                        continue block13;
                    }
                    case 3: {
                        ((ClassFile)ClassFile.this).constant_pool[i] = new ConstantIntegerInfo(ClassFile.this.posDataInputStream);
                        continue block13;
                    }
                    case 4: {
                        ((ClassFile)ClassFile.this).constant_pool[i] = new ConstantFloatInfo(ClassFile.this.posDataInputStream);
                        continue block13;
                    }
                    case 5: {
                        ((ClassFile)ClassFile.this).constant_pool[i] = new ConstantLongInfo(ClassFile.this.posDataInputStream);
                        ++i;
                        continue block13;
                    }
                    case 6: {
                        ((ClassFile)ClassFile.this).constant_pool[i] = new ConstantDoubleInfo(ClassFile.this.posDataInputStream);
                        ++i;
                        continue block13;
                    }
                    case 7: {
                        ((ClassFile)ClassFile.this).constant_pool[i] = new ConstantClassInfo(ClassFile.this.posDataInputStream);
                        continue block13;
                    }
                    case 8: {
                        ((ClassFile)ClassFile.this).constant_pool[i] = new ConstantStringInfo(ClassFile.this.posDataInputStream);
                        continue block13;
                    }
                    case 9: {
                        ((ClassFile)ClassFile.this).constant_pool[i] = new ConstantFieldrefInfo(ClassFile.this.posDataInputStream);
                        continue block13;
                    }
                    case 10: {
                        ((ClassFile)ClassFile.this).constant_pool[i] = new ConstantMethodrefInfo(ClassFile.this.posDataInputStream);
                        continue block13;
                    }
                    case 11: {
                        ((ClassFile)ClassFile.this).constant_pool[i] = new ConstantInterfaceMethodrefInfo(ClassFile.this.posDataInputStream);
                        continue block13;
                    }
                    case 12: {
                        ((ClassFile)ClassFile.this).constant_pool[i] = new ConstantNameAndTypeInfo(ClassFile.this.posDataInputStream);
                        continue block13;
                    }
                    default: {
                        throw new ClassFormatException(String.format("Unreconizable constant pool type found. Constant pool tag: [%d]; class file offset: [%d].", tag, ClassFile.this.posDataInputStream.getPos() - 1));
                    }
                }
            }
        }

        private void parseClassDeclaration() throws IOException, ClassFormatException {
            ClassFile.this.access_flags = new AccessFlags(ClassFile.this.posDataInputStream);
            ClassFile.this.this_class = new ThisClass(ClassFile.this.posDataInputStream);
            ClassFile.this.super_class = new SuperClass(ClassFile.this.posDataInputStream);
            ClassFile.this.interfaces_count = new InterfaceCount(ClassFile.this.posDataInputStream);
            if (ClassFile.this.interfaces_count.getValue() > 0) {
                ClassFile.access$1102(ClassFile.this, new Interface[ClassFile.this.interfaces_count.getValue()]);
                for (int i = 0; i < ClassFile.this.interfaces_count.getValue(); ++i) {
                    ((ClassFile)ClassFile.this).interfaces[i] = new Interface(ClassFile.this.posDataInputStream);
                }
            }
        }

        private void parseFields() throws IOException, ClassFormatException {
            ClassFile.this.fields_count = new FieldCount(ClassFile.this.posDataInputStream);
            int fieldCount = ClassFile.this.fields_count.getValue();
            if (fieldCount > 0) {
                ClassFile.access$1302(ClassFile.this, new FieldInfo[fieldCount]);
                for (int i = 0; i < fieldCount; ++i) {
                    ((ClassFile)ClassFile.this).fields[i] = new FieldInfo(ClassFile.this.posDataInputStream, ClassFile.this.constant_pool);
                }
            }
        }

        private void parseMethods() throws IOException, ClassFormatException {
            ClassFile.this.methods_count = new MethodCount(ClassFile.this.posDataInputStream);
            int methodCount = ClassFile.this.methods_count.getValue();
            if (methodCount > 0) {
                ClassFile.access$1502(ClassFile.this, new MethodInfo[methodCount]);
                for (int i = 0; i < methodCount; ++i) {
                    ((ClassFile)ClassFile.this).methods[i] = new MethodInfo(ClassFile.this.posDataInputStream, ClassFile.this.constant_pool);
                }
            }
        }

        private void parseAttributes() throws IOException, ClassFormatException {
            ClassFile.this.attributes_count = new AttributeCount(ClassFile.this.posDataInputStream);
            int attributeCount = ClassFile.this.attributes_count.getValue();
            if (attributeCount > 0) {
                ClassFile.access$1702(ClassFile.this, new AttributeInfo[attributeCount]);
                for (int i = 0; i < attributeCount; ++i) {
                    ((ClassFile)ClassFile.this).attributes[i] = AttributeInfo.parse(ClassFile.this.posDataInputStream, ClassFile.this.constant_pool);
                }
            }
        }
    }
}

