/*
 * Decompiled with CFR 0.152.
 */
package org.freeinternals.classfile.core;

import java.io.IOException;
import org.freeinternals.classfile.core.AbstractCPInfo;
import org.freeinternals.classfile.core.PosDataInputStream;
import org.freeinternals.classfile.core.u2;

public class ConstantClassInfo
extends AbstractCPInfo {
    private final u2 name_index;

    ConstantClassInfo(PosDataInputStream posDataInputStream) throws IOException {
        this.tag.value = (short)7;
        this.startPos = posDataInputStream.getPos() - 1;
        this.length = 3;
        this.name_index = new u2();
        this.name_index.value = posDataInputStream.readUnsignedShort();
    }

    @Override
    public String getName() {
        return "Class";
    }

    @Override
    public String getDescription() {
        return String.format("ConstantClassInfo: Start Position: [%d], length: [%d], value: name_index = [%d].", this.startPos, this.length, this.name_index.value);
    }

    public int getNameIndex() {
        return this.name_index.value;
    }
}

