/*
 * Decompiled with CFR 0.152.
 */
package org.freeinternals.classfile.core;

import java.io.IOException;
import org.freeinternals.classfile.core.AbstractCPInfo;
import org.freeinternals.classfile.core.PosDataInputStream;

public class ConstantFloatInfo
extends AbstractCPInfo {
    private final Float floatValue;

    ConstantFloatInfo(PosDataInputStream posDataInputStream) throws IOException {
        this.tag.value = (short)4;
        this.startPos = posDataInputStream.getPos() - 1;
        this.length = 5;
        this.floatValue = Float.valueOf(posDataInputStream.readFloat());
    }

    @Override
    public String getName() {
        return "Float";
    }

    @Override
    public String getDescription() {
        return String.format("ConstantFloatInfo: Start Position: [%d], length: [%d], value: [%f].", this.startPos, this.length, this.floatValue);
    }

    public float getValue() {
        return this.floatValue.floatValue();
    }
}

