/*
 * Decompiled with CFR 0.152.
 */
package org.freeinternals.classfile.core;

import java.io.IOException;
import org.freeinternals.classfile.core.AbstractCPInfo;
import org.freeinternals.classfile.core.PosDataInputStream;
import org.freeinternals.classfile.core.u2;

public class ConstantNameAndTypeInfo
extends AbstractCPInfo {
    private final u2 name_index;
    private final u2 descriptor_index;

    ConstantNameAndTypeInfo(PosDataInputStream posDataInputStream) throws IOException {
        this.tag.value = (short)12;
        this.startPos = posDataInputStream.getPos() - 1;
        this.length = 5;
        this.name_index = new u2();
        this.name_index.value = posDataInputStream.readUnsignedShort();
        this.descriptor_index = new u2();
        this.descriptor_index.value = posDataInputStream.readUnsignedShort();
    }

    @Override
    public String getName() {
        return "NameAndType";
    }

    @Override
    public String getDescription() {
        return String.format("ConstantNameAndTypeInfo: Start Position: [%d], length: [%d], value: name_index=[%d], descriptor_index=[%d].", this.startPos, this.length, this.name_index.value, this.descriptor_index.value);
    }

    public int getNameIndex() {
        return this.name_index.value;
    }

    public int getDescriptorIndex() {
        return this.descriptor_index.value;
    }
}

