/*
 * Decompiled with CFR 0.152.
 */
package org.freeinternals.classfile.core;

import java.io.IOException;
import org.freeinternals.classfile.core.AbstractCPInfo;
import org.freeinternals.classfile.core.PosDataInputStream;
import org.freeinternals.classfile.core.u2;

public class ConstantStringInfo
extends AbstractCPInfo {
    private final u2 string_index;

    ConstantStringInfo(PosDataInputStream posDataInputStream) throws IOException {
        this.tag.value = (short)8;
        this.startPos = posDataInputStream.getPos() - 1;
        this.length = 3;
        this.string_index = new u2();
        this.string_index.value = posDataInputStream.readUnsignedShort();
    }

    @Override
    public String getName() {
        return "String";
    }

    @Override
    public String getDescription() {
        return String.format("ConstantStringInfo: Start Position: [%d], length: [%d], value: string_index=[%d].", this.startPos, this.length, this.string_index.value);
    }

    public int getStringIndex() {
        return this.string_index.value;
    }
}

