/*
 * Decompiled with CFR 0.152.
 */
package org.freeinternals.classfile.core;

import java.io.IOException;
import org.freeinternals.classfile.core.AbstractCPInfo;
import org.freeinternals.classfile.core.ClassFormatException;
import org.freeinternals.classfile.core.PosDataInputStream;
import org.freeinternals.classfile.core.u2;

public class ConstantUtf8Info
extends AbstractCPInfo {
    private final u2 length_utf8;
    private final byte[] bytes;

    ConstantUtf8Info(PosDataInputStream posDataInputStream) throws IOException, ClassFormatException {
        this.tag.value = 1;
        this.startPos = posDataInputStream.getPos() - 1;
        this.length_utf8 = new u2();
        this.length_utf8.value = posDataInputStream.readUnsignedShort();
        this.bytes = new byte[this.length_utf8.value];
        int bytesRead = posDataInputStream.read(this.bytes);
        if (bytesRead != this.length_utf8.value) {
            throw new ClassFormatException("Read bytes for CONSTANT_Utf8 error.");
        }
        this.length = this.length_utf8.value + 1 + 2;
    }

    @Override
    public String getName() {
        return "Utf8";
    }

    @Override
    public String getDescription() {
        return String.format("ConstantUtf8Info: Start Position: [%d], length: [%d], value: [%s].", this.startPos, this.length, this.getValue());
    }

    public int getBytesLength() {
        return this.length_utf8.value;
    }

    public String getValue() {
        return new String(this.bytes);
    }
}

