/*
 * Decompiled with CFR 0.152.
 */
package org.freeinternals.classfile.core;

import java.io.IOException;
import org.freeinternals.classfile.core.AbstractCPInfo;
import org.freeinternals.classfile.core.AttributeInfo;
import org.freeinternals.classfile.core.ClassComponent;
import org.freeinternals.classfile.core.ClassFormatException;
import org.freeinternals.classfile.core.PosDataInputStream;
import org.freeinternals.classfile.core.u2;

public class FieldInfo
extends ClassComponent {
    private u2 access_flags;
    private u2 name_index;
    private u2 descriptor_index;
    private u2 attributes_count;
    private AttributeInfo[] attributes;
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_VOLATILE = 64;
    public static final int ACC_TRANSIENT = 128;
    private String declaration;

    FieldInfo() {
    }

    FieldInfo(PosDataInputStream posDataInputStream, AbstractCPInfo[] cp) throws IOException, ClassFormatException {
        this.startPos = posDataInputStream.getPos();
        this.length = -1;
        this.access_flags = new u2();
        this.access_flags.value = posDataInputStream.readUnsignedShort();
        this.name_index = new u2();
        this.name_index.value = posDataInputStream.readUnsignedShort();
        this.descriptor_index = new u2();
        this.descriptor_index.value = posDataInputStream.readUnsignedShort();
        this.attributes_count = new u2();
        int attrCount = this.attributes_count.value = posDataInputStream.readUnsignedShort();
        if (attrCount > 0) {
            this.attributes = new AttributeInfo[attrCount];
            for (int i = 0; i < attrCount; ++i) {
                this.attributes[i] = AttributeInfo.parse(posDataInputStream, cp);
            }
        }
        this.calculateLength();
    }

    private void calculateLength() {
        this.length = 8;
        for (int i = 0; i < this.attributes_count.value; ++i) {
            this.length += this.attributes[i].getLength();
        }
    }

    public int getAccessFlags() {
        return this.access_flags.value;
    }

    public int getNameIndex() {
        return this.name_index.value;
    }

    public int getDescriptorIndex() {
        return this.descriptor_index.value;
    }

    public int getAttributesCount() {
        return this.attributes_count.value;
    }

    public AttributeInfo getAttribute(int index) {
        AttributeInfo info = null;
        if (this.attributes != null) {
            info = this.attributes[index];
        }
        return info;
    }

    public String getModifiers() {
        StringBuilder sb = new StringBuilder(20);
        Boolean isTheFirstModifier = true;
        if ((this.access_flags.value & 1) > 0) {
            sb.append("public");
            isTheFirstModifier = false;
        } else if ((this.access_flags.value & 2) > 0) {
            sb.append("private");
            isTheFirstModifier = false;
        } else if ((this.access_flags.value & 4) > 0) {
            sb.append("protected");
            isTheFirstModifier = false;
        }
        if ((this.access_flags.value & 8) > 0) {
            if (!isTheFirstModifier.booleanValue()) {
                sb.append(' ');
            }
            sb.append("static");
            isTheFirstModifier = false;
        }
        if ((this.access_flags.value & 0x10) > 0) {
            if (!isTheFirstModifier.booleanValue()) {
                sb.append(' ');
            }
            sb.append("final");
            isTheFirstModifier = false;
        } else if ((this.access_flags.value & 0x40) > 0) {
            if (!isTheFirstModifier.booleanValue()) {
                sb.append(' ');
            }
            sb.append("volatile");
            isTheFirstModifier = false;
        }
        if ((this.access_flags.value & 0x80) > 0) {
            if (!isTheFirstModifier.booleanValue()) {
                sb.append(' ');
            }
            sb.append("transient");
            isTheFirstModifier = false;
        }
        return sb.toString();
    }

    final void setDeclaration(String declaration) {
        this.declaration = declaration;
    }

    public String getDeclaration() {
        return this.declaration;
    }
}

