/*
 * Decompiled with CFR 0.152.
 */
package org.freeinternals.classfile.core;

import java.io.IOException;
import org.freeinternals.classfile.core.ClassFile;
import org.freeinternals.classfile.core.PosByteArrayInputStream;
import org.freeinternals.classfile.core.PosDataInputStream;

public final class Opcode {
    private static final String FORMAT_SD = "%s %d";
    private static final String FORMAT_SDS = "%s %d [%s]";
    private static final int op_nop = 0;
    private static final int op_aconst_null = 1;
    private static final int op_iconst_m1 = 2;
    private static final int op_iconst_0 = 3;
    private static final int op_iconst_1 = 4;
    private static final int op_iconst_2 = 5;
    private static final int op_iconst_3 = 6;
    private static final int op_iconst_4 = 7;
    private static final int op_iconst_5 = 8;
    private static final int op_lconst_0 = 9;
    private static final int op_lconst_1 = 10;
    private static final int op_fconst_0 = 11;
    private static final int op_fconst_1 = 12;
    private static final int op_fconst_2 = 13;
    private static final int op_dconst_0 = 14;
    private static final int op_dconst_1 = 15;
    private static final int op_bipush = 16;
    private static final int op_sipush = 17;
    private static final int op_ldc = 18;
    private static final int op_ldc_w = 19;
    private static final int op_ldc2_w = 20;
    private static final int op_iload = 21;
    private static final int op_lload = 22;
    private static final int op_fload = 23;
    private static final int op_dload = 24;
    private static final int op_aload = 25;
    private static final int op_iload_0 = 26;
    private static final int op_iload_1 = 27;
    private static final int op_iload_2 = 28;
    private static final int op_iload_3 = 29;
    private static final int op_lload_0 = 30;
    private static final int op_lload_1 = 31;
    private static final int op_lload_2 = 32;
    private static final int op_lload_3 = 33;
    private static final int op_fload_0 = 34;
    private static final int op_fload_1 = 35;
    private static final int op_fload_2 = 36;
    private static final int op_fload_3 = 37;
    private static final int op_dload_0 = 38;
    private static final int op_dload_1 = 39;
    private static final int op_dload_2 = 40;
    private static final int op_dload_3 = 41;
    private static final int op_aload_0 = 42;
    private static final int op_aload_1 = 43;
    private static final int op_aload_2 = 44;
    private static final int op_aload_3 = 45;
    private static final int op_iaload = 46;
    private static final int op_laload = 47;
    private static final int op_faload = 48;
    private static final int op_daload = 49;
    private static final int op_aaload = 50;
    private static final int op_baload = 51;
    private static final int op_caload = 52;
    private static final int op_saload = 53;
    private static final int op_istore = 54;
    private static final int op_lstore = 55;
    private static final int op_fstore = 56;
    private static final int op_dstore = 57;
    private static final int op_astore = 58;
    private static final int op_istore_0 = 59;
    private static final int op_istore_1 = 60;
    private static final int op_istore_2 = 61;
    private static final int op_istore_3 = 62;
    private static final int op_lstore_0 = 63;
    private static final int op_lstore_1 = 64;
    private static final int op_lstore_2 = 65;
    private static final int op_lstore_3 = 66;
    private static final int op_fstore_0 = 67;
    private static final int op_fstore_1 = 68;
    private static final int op_fstore_2 = 69;
    private static final int op_fstore_3 = 70;
    private static final int op_dstore_0 = 71;
    private static final int op_dstore_1 = 72;
    private static final int op_dstore_2 = 73;
    private static final int op_dstore_3 = 74;
    private static final int op_astore_0 = 75;
    private static final int op_astore_1 = 76;
    private static final int op_astore_2 = 77;
    private static final int op_astore_3 = 78;
    private static final int op_iastore = 79;
    private static final int op_lastore = 80;
    private static final int op_fastore = 81;
    private static final int op_dastore = 82;
    private static final int op_aastore = 83;
    private static final int op_bastore = 84;
    private static final int op_castore = 85;
    private static final int op_sastore = 86;
    private static final int op_pop = 87;
    private static final int op_pop2 = 88;
    private static final int op_dup = 89;
    private static final int op_dup_x1 = 90;
    private static final int op_dup_x2 = 91;
    private static final int op_dup2 = 92;
    private static final int op_dup2_x1 = 93;
    private static final int op_dup2_x2 = 94;
    private static final int op_swap = 95;
    private static final int op_iadd = 96;
    private static final int op_ladd = 97;
    private static final int op_fadd = 98;
    private static final int op_dadd = 99;
    private static final int op_isub = 100;
    private static final int op_lsub = 101;
    private static final int op_fsub = 102;
    private static final int op_dsub = 103;
    private static final int op_imul = 104;
    private static final int op_lmul = 105;
    private static final int op_fmul = 106;
    private static final int op_dmul = 107;
    private static final int op_idiv = 108;
    private static final int op_ldiv = 109;
    private static final int op_fdiv = 110;
    private static final int op_ddiv = 111;
    private static final int op_irem = 112;
    private static final int op_lrem = 113;
    private static final int op_frem = 114;
    private static final int op_drem = 115;
    private static final int op_ineg = 116;
    private static final int op_lneg = 117;
    private static final int op_fneg = 118;
    private static final int op_dneg = 119;
    private static final int op_ishl = 120;
    private static final int op_lshl = 121;
    private static final int op_ishr = 122;
    private static final int op_lshr = 123;
    private static final int op_iushr = 124;
    private static final int op_lushr = 125;
    private static final int op_iand = 126;
    private static final int op_land = 127;
    private static final int op_ior = 128;
    private static final int op_lor = 129;
    private static final int op_ixor = 130;
    private static final int op_lxor = 131;
    private static final int op_iinc = 132;
    private static final int op_i2l = 133;
    private static final int op_i2f = 134;
    private static final int op_i2d = 135;
    private static final int op_l2i = 136;
    private static final int op_l2f = 137;
    private static final int op_l2d = 138;
    private static final int op_f2i = 139;
    private static final int op_f2l = 140;
    private static final int op_f2d = 141;
    private static final int op_d2i = 142;
    private static final int op_d2l = 143;
    private static final int op_d2f = 144;
    private static final int op_i2b = 145;
    private static final int op_i2c = 146;
    private static final int op_i2s = 147;
    private static final int op_lcmp = 148;
    private static final int op_fcmpl = 149;
    private static final int op_fcmpg = 150;
    private static final int op_dcmpl = 151;
    private static final int op_dcmpg = 152;
    private static final int op_ifeq = 153;
    private static final int op_ifne = 154;
    private static final int op_iflt = 155;
    private static final int op_ifge = 156;
    private static final int op_ifgt = 157;
    private static final int op_ifle = 158;
    private static final int op_if_icmpeq = 159;
    private static final int op_if_icmpne = 160;
    private static final int op_if_icmplt = 161;
    private static final int op_if_icmpge = 162;
    private static final int op_if_icmpgt = 163;
    private static final int op_if_icmple = 164;
    private static final int op_if_acmpeq = 165;
    private static final int op_if_acmpne = 166;
    private static final int op_goto = 167;
    private static final int op_jsr = 168;
    private static final int op_ret = 169;
    private static final int op_tableswitch = 170;
    private static final int op_lookupswitch = 171;
    private static final int op_ireturn = 172;
    private static final int op_lreturn = 173;
    private static final int op_freturn = 174;
    private static final int op_dreturn = 175;
    private static final int op_areturn = 176;
    private static final int op_return = 177;
    private static final int op_getstatic = 178;
    private static final int op_putstatic = 179;
    private static final int op_getfield = 180;
    private static final int op_putfield = 181;
    private static final int op_invokevirtual = 182;
    private static final int op_invokespecial = 183;
    private static final int op_invokestatic = 184;
    private static final int op_invokeinterface = 185;
    private static final int op_new = 187;
    private static final int op_newarray = 188;
    private static final int op_anewarray = 189;
    private static final int op_arraylength = 190;
    private static final int op_athrow = 191;
    private static final int op_checkcast = 192;
    private static final int op_instanceof = 193;
    private static final int op_monitorenter = 194;
    private static final int op_monitorexit = 195;
    private static final int op_wide = 196;
    private static final int op_multianewarray = 197;
    private static final int op_ifnull = 198;
    private static final int op_ifnonnull = 199;
    private static final int op_goto_w = 200;
    private static final int op_jsr_w = 201;
    private static final String name_nop = "nop";
    private static final String name_aconst_null = "aconst_null";
    private static final String name_iconst_m1 = "iconst_m1";
    private static final String name_iconst_0 = "iconst_0";
    private static final String name_iconst_1 = "iconst_1";
    private static final String name_iconst_2 = "iconst_2";
    private static final String name_iconst_3 = "iconst_3";
    private static final String name_iconst_4 = "iconst_4";
    private static final String name_iconst_5 = "iconst_5";
    private static final String name_lconst_0 = "lconst_0";
    private static final String name_lconst_1 = "lconst_1";
    private static final String name_fconst_0 = "fconst_0";
    private static final String name_fconst_1 = "fconst_1";
    private static final String name_fconst_2 = "fconst_2";
    private static final String name_dconst_0 = "dconst_0";
    private static final String name_dconst_1 = "dconst_1";
    private static final String name_bipush = "bipush";
    private static final String name_sipush = "sipush";
    private static final String name_ldc = "ldc";
    private static final String name_ldc_w = "ldc_w";
    private static final String name_ldc2_w = "ldc2_w";
    private static final String name_iload = "iload";
    private static final String name_lload = "lload";
    private static final String name_fload = "fload";
    private static final String name_dload = "dload";
    private static final String name_aload = "aload";
    private static final String name_iload_0 = "iload_0";
    private static final String name_iload_1 = "iload_1";
    private static final String name_iload_2 = "iload_2";
    private static final String name_iload_3 = "iload_3";
    private static final String name_lload_0 = "lload_0";
    private static final String name_lload_1 = "lload_1";
    private static final String name_lload_2 = "lload_2";
    private static final String name_lload_3 = "lload_3";
    private static final String name_fload_0 = "fload_0";
    private static final String name_fload_1 = "fload_1";
    private static final String name_fload_2 = "fload_2";
    private static final String name_fload_3 = "fload_3";
    private static final String name_dload_0 = "dload_0";
    private static final String name_dload_1 = "dload_1";
    private static final String name_dload_2 = "dload_2";
    private static final String name_dload_3 = "dload_3";
    private static final String name_aload_0 = "aload_0";
    private static final String name_aload_1 = "aload_1";
    private static final String name_aload_2 = "aload_2";
    private static final String name_aload_3 = "aload_3";
    private static final String name_iaload = "iaload";
    private static final String name_laload = "laload";
    private static final String name_faload = "faload";
    private static final String name_daload = "daload";
    private static final String name_aaload = "aaload";
    private static final String name_baload = "baload";
    private static final String name_caload = "caload";
    private static final String name_saload = "saload";
    private static final String name_istore = "istore";
    private static final String name_lstore = "lstore";
    private static final String name_fstore = "fstore";
    private static final String name_dstore = "dstore";
    private static final String name_astore = "astore";
    private static final String name_istore_0 = "istore_0";
    private static final String name_istore_1 = "istore_1";
    private static final String name_istore_2 = "istore_2";
    private static final String name_istore_3 = "istore_3";
    private static final String name_lstore_0 = "lstore_0";
    private static final String name_lstore_1 = "lstore_1";
    private static final String name_lstore_2 = "lstore_2";
    private static final String name_lstore_3 = "lstore_3";
    private static final String name_fstore_0 = "fstore_0";
    private static final String name_fstore_1 = "fstore_1";
    private static final String name_fstore_2 = "fstore_2";
    private static final String name_fstore_3 = "fstore_3";
    private static final String name_dstore_0 = "dstore_0";
    private static final String name_dstore_1 = "dstore_1";
    private static final String name_dstore_2 = "dstore_2";
    private static final String name_dstore_3 = "dstore_3";
    private static final String name_astore_0 = "astore_0";
    private static final String name_astore_1 = "astore_1";
    private static final String name_astore_2 = "astore_2";
    private static final String name_astore_3 = "astore_3";
    private static final String name_iastore = "iastore";
    private static final String name_lastore = "lastore";
    private static final String name_fastore = "fastore";
    private static final String name_dastore = "dastore";
    private static final String name_aastore = "aastore";
    private static final String name_bastore = "bastore";
    private static final String name_castore = "castore";
    private static final String name_sastore = "sastore";
    private static final String name_pop = "pop";
    private static final String name_pop2 = "pop2";
    private static final String name_dup = "dup";
    private static final String name_dup_x1 = "dup_x1";
    private static final String name_dup_x2 = "dup_x2";
    private static final String name_dup2 = "dup2";
    private static final String name_dup2_x1 = "dup2_x1";
    private static final String name_dup2_x2 = "dup2_x2";
    private static final String name_swap = "swap";
    private static final String name_iadd = "iadd";
    private static final String name_ladd = "ladd";
    private static final String name_fadd = "fadd";
    private static final String name_dadd = "dadd";
    private static final String name_isub = "isub";
    private static final String name_lsub = "lsub";
    private static final String name_fsub = "fsub";
    private static final String name_dsub = "dsub";
    private static final String name_imul = "imul";
    private static final String name_lmul = "lmul";
    private static final String name_fmul = "fmul";
    private static final String name_dmul = "dmul";
    private static final String name_idiv = "idiv";
    private static final String name_ldiv = "ldiv";
    private static final String name_fdiv = "fdiv";
    private static final String name_ddiv = "ddiv";
    private static final String name_irem = "irem";
    private static final String name_lrem = "lrem";
    private static final String name_frem = "frem";
    private static final String name_drem = "drem";
    private static final String name_ineg = "ineg";
    private static final String name_lneg = "lneg";
    private static final String name_fneg = "fneg";
    private static final String name_dneg = "dneg";
    private static final String name_ishl = "ishl";
    private static final String name_lshl = "lshl";
    private static final String name_ishr = "ishr";
    private static final String name_lshr = "lshr";
    private static final String name_iushr = "iushr";
    private static final String name_lushr = "lushr";
    private static final String name_iand = "iand";
    private static final String name_land = "land";
    private static final String name_ior = "ior";
    private static final String name_lor = "lor";
    private static final String name_ixor = "ixor";
    private static final String name_lxor = "lxor";
    private static final String name_iinc = "iinc";
    private static final String name_i2l = "i2l";
    private static final String name_i2f = "i2f";
    private static final String name_i2d = "i2d";
    private static final String name_l2i = "l2i";
    private static final String name_l2f = "l2f";
    private static final String name_l2d = "l2d";
    private static final String name_f2i = "f2i";
    private static final String name_f2l = "f2l";
    private static final String name_f2d = "f2d";
    private static final String name_d2i = "d2i";
    private static final String name_d2l = "d2l";
    private static final String name_d2f = "d2f";
    private static final String name_i2b = "i2b";
    private static final String name_i2c = "i2c";
    private static final String name_i2s = "i2s";
    private static final String name_lcmp = "lcmp";
    private static final String name_fcmpl = "fcmpl";
    private static final String name_fcmpg = "fcmpg";
    private static final String name_dcmpl = "dcmpl";
    private static final String name_dcmpg = "dcmpg";
    private static final String name_ifeq = "ifeq";
    private static final String name_ifne = "ifne";
    private static final String name_iflt = "iflt";
    private static final String name_ifge = "ifge";
    private static final String name_ifgt = "ifgt";
    private static final String name_ifle = "ifle";
    private static final String name_if_icmpeq = "if_icmpeq";
    private static final String name_if_icmpne = "if_icmpne";
    private static final String name_if_icmplt = "if_icmplt";
    private static final String name_if_icmpge = "if_icmpge";
    private static final String name_if_icmpgt = "if_icmpgt";
    private static final String name_if_icmple = "if_icmple";
    private static final String name_if_acmpeq = "if_acmpeq";
    private static final String name_if_acmpne = "if_acmpne";
    private static final String name_goto = "goto";
    private static final String name_jsr = "jsr";
    private static final String name_ret = "ret";
    private static final String name_tableswitch = "tableswitch";
    private static final String name_lookupswitch = "lookupswitch";
    private static final String name_ireturn = "ireturn";
    private static final String name_lreturn = "lreturn";
    private static final String name_freturn = "freturn";
    private static final String name_dreturn = "dreturn";
    private static final String name_areturn = "areturn";
    private static final String name_return = "return";
    private static final String name_getstatic = "getstatic";
    private static final String name_putstatic = "putstatic";
    private static final String name_getfield = "getfield";
    private static final String name_putfield = "putfield";
    private static final String name_invokevirtual = "invokevirtual";
    private static final String name_invokespecial = "invokespecial";
    private static final String name_invokestatic = "invokestatic";
    private static final String name_invokeinterface = "invokeinterface";
    private static final String name_new = "name_new";
    private static final String name_newarray = "newarray";
    private static final String name_anewarray = "anewarray";
    private static final String name_arraylength = "arraylength";
    private static final String name_athrow = "athrow";
    private static final String name_checkcast = "checkcast";
    private static final String name_instanceof = "instanceof";
    private static final String name_monitorenter = "monitorenter";
    private static final String name_monitorexit = "monitorexit";
    private static final String name_wide = "wide";
    private static final String name_wide_iload = "wide iload";
    private static final String name_wide_lload = "wide lload";
    private static final String name_wide_fload = "wide fload";
    private static final String name_wide_dload = "wide dload";
    private static final String name_wide_aload = "wide aload";
    private static final String name_wide_istore = "wide istore";
    private static final String name_wide_lstore = "wide lstore";
    private static final String name_wide_fstore = "wide fstore";
    private static final String name_wide_dstore = "wide dstore";
    private static final String name_wide_astore = "wide astore";
    private static final String name_wide_iinc = "wide iinc";
    private static final String name_wide_ret = "wide ret";
    private static final String name_multianewarray = "multianewarray";
    private static final String name_ifnull = "ifnull";
    private static final String name_ifnonnull = "ifnonnull";
    private static final String name_goto_w = "goto_w";
    private static final String name_jsr_w = "jsr_w";
    private static final int op_breakpoint = 202;
    private static final int op_impdep1 = 254;
    private static final int op_impdep2 = 255;
    private static final String name_breakpoint = "breakpoint";
    private static final String name_impdep1 = "impdep1";
    private static final String name_impdep2 = "impdep2";

    private Opcode() {
    }

    public static String parseCode(byte[] code, ClassFile classFile) {
        if (code == null || code.length < 1) {
            return null;
        }
        PosByteArrayInputStream pbais = new PosByteArrayInputStream(code);
        PosDataInputStream pdis = new PosDataInputStream(pbais);
        StringBuilder sb = new StringBuilder(code.length * 10);
        while (pdis.getPos() < code.length) {
            try {
                sb.append(Opcode.parseOpcode(pdis, classFile));
                sb.append('\n');
            }
            catch (IOException ioe) {
                break;
            }
        }
        return sb.toString();
    }

    private static String parseOpcode(PosDataInputStream pdis, ClassFile classFile) throws IOException {
        int curPos = pdis.getPos();
        int opcode = pdis.read();
        int byteValue = 0;
        byte byteValue2 = 0;
        int shortValue = 0;
        int intValue = 0;
        String opcodeText = null;
        switch (opcode) {
            case 0: {
                opcodeText = name_nop;
                break;
            }
            case 1: {
                opcodeText = name_aconst_null;
                break;
            }
            case 2: {
                opcodeText = name_iconst_m1;
                break;
            }
            case 3: {
                opcodeText = name_iconst_0;
                break;
            }
            case 4: {
                opcodeText = name_iconst_1;
                break;
            }
            case 5: {
                opcodeText = name_iconst_2;
                break;
            }
            case 6: {
                opcodeText = name_iconst_3;
                break;
            }
            case 7: {
                opcodeText = name_iconst_4;
                break;
            }
            case 8: {
                opcodeText = name_iconst_5;
                break;
            }
            case 9: {
                opcodeText = name_lconst_0;
                break;
            }
            case 10: {
                opcodeText = name_lconst_1;
                break;
            }
            case 11: {
                opcodeText = name_fconst_0;
                break;
            }
            case 12: {
                opcodeText = name_fconst_1;
                break;
            }
            case 13: {
                opcodeText = name_fconst_2;
                break;
            }
            case 14: {
                opcodeText = name_dconst_0;
                break;
            }
            case 15: {
                opcodeText = name_dconst_1;
                break;
            }
            case 16: {
                byteValue = pdis.readUnsignedByte();
                opcodeText = String.format(FORMAT_SD, name_bipush, byteValue);
                break;
            }
            case 17: {
                shortValue = pdis.readUnsignedShort();
                opcodeText = String.format(FORMAT_SD, 17, shortValue);
                break;
            }
            case 18: {
                byteValue = pdis.readUnsignedByte();
                opcodeText = String.format(FORMAT_SDS, name_ldc, byteValue, classFile.getCPDescription(byteValue));
                break;
            }
            case 19: {
                shortValue = pdis.readUnsignedShort();
                opcodeText = String.format(FORMAT_SDS, name_ldc_w, shortValue, classFile.getCPDescription(shortValue));
                break;
            }
            case 20: {
                shortValue = pdis.readUnsignedShort();
                opcodeText = String.format(FORMAT_SDS, name_ldc2_w, shortValue, classFile.getCPDescription(shortValue));
                break;
            }
            case 21: {
                byteValue = pdis.readUnsignedByte();
                opcodeText = String.format(FORMAT_SD, name_iload, byteValue);
                break;
            }
            case 22: {
                byteValue = pdis.readUnsignedByte();
                opcodeText = String.format(FORMAT_SD, name_lload, byteValue);
                break;
            }
            case 23: {
                byteValue = pdis.readUnsignedByte();
                opcodeText = String.format(FORMAT_SD, name_fload, byteValue);
                break;
            }
            case 24: {
                byteValue = pdis.readUnsignedByte();
                opcodeText = String.format(FORMAT_SD, name_dload, byteValue);
                break;
            }
            case 25: {
                byteValue = pdis.readUnsignedByte();
                opcodeText = String.format(FORMAT_SD, name_aload, byteValue);
                break;
            }
            case 26: {
                opcodeText = name_iload_0;
                break;
            }
            case 27: {
                opcodeText = name_iload_1;
                break;
            }
            case 28: {
                opcodeText = name_iload_2;
                break;
            }
            case 29: {
                opcodeText = name_iload_3;
                break;
            }
            case 30: {
                opcodeText = name_lload_0;
                break;
            }
            case 31: {
                opcodeText = name_lload_1;
                break;
            }
            case 32: {
                opcodeText = name_lload_2;
                break;
            }
            case 33: {
                opcodeText = name_lload_3;
                break;
            }
            case 34: {
                opcodeText = name_fload_0;
                break;
            }
            case 35: {
                opcodeText = name_fload_1;
                break;
            }
            case 36: {
                opcodeText = name_fload_2;
                break;
            }
            case 37: {
                opcodeText = name_fload_3;
                break;
            }
            case 38: {
                opcodeText = name_dload_0;
                break;
            }
            case 39: {
                opcodeText = name_dload_1;
                break;
            }
            case 40: {
                opcodeText = name_dload_2;
                break;
            }
            case 41: {
                opcodeText = name_dload_3;
                break;
            }
            case 42: {
                opcodeText = name_aload_0;
                break;
            }
            case 43: {
                opcodeText = name_aload_1;
                break;
            }
            case 44: {
                opcodeText = name_aload_2;
                break;
            }
            case 45: {
                opcodeText = name_aload_3;
                break;
            }
            case 46: {
                opcodeText = name_iaload;
                break;
            }
            case 47: {
                opcodeText = name_laload;
                break;
            }
            case 48: {
                opcodeText = name_faload;
                break;
            }
            case 49: {
                opcodeText = name_daload;
                break;
            }
            case 50: {
                opcodeText = name_aaload;
                break;
            }
            case 51: {
                opcodeText = name_baload;
                break;
            }
            case 52: {
                opcodeText = name_caload;
                break;
            }
            case 53: {
                opcodeText = name_saload;
                break;
            }
            case 54: {
                byteValue = pdis.readUnsignedByte();
                opcodeText = String.format(FORMAT_SD, name_istore, byteValue);
                break;
            }
            case 55: {
                byteValue = pdis.readUnsignedByte();
                opcodeText = String.format(FORMAT_SD, name_lstore, byteValue);
                break;
            }
            case 56: {
                byteValue = pdis.readUnsignedByte();
                opcodeText = String.format(FORMAT_SD, name_fstore, byteValue);
                break;
            }
            case 57: {
                byteValue = pdis.readUnsignedByte();
                opcodeText = String.format(FORMAT_SD, name_dstore, byteValue);
                break;
            }
            case 58: {
                byteValue = pdis.readUnsignedByte();
                opcodeText = String.format(FORMAT_SD, name_dstore, byteValue);
                break;
            }
            case 59: {
                opcodeText = name_istore_0;
                break;
            }
            case 60: {
                opcodeText = name_istore_1;
                break;
            }
            case 61: {
                opcodeText = name_istore_2;
                break;
            }
            case 62: {
                opcodeText = name_istore_3;
                break;
            }
            case 63: {
                opcodeText = name_lstore_0;
                break;
            }
            case 64: {
                opcodeText = name_lstore_1;
                break;
            }
            case 65: {
                opcodeText = name_lstore_2;
                break;
            }
            case 66: {
                opcodeText = name_lstore_3;
                break;
            }
            case 67: {
                opcodeText = name_fstore_0;
                break;
            }
            case 68: {
                opcodeText = name_fstore_1;
                break;
            }
            case 69: {
                opcodeText = name_fstore_2;
                break;
            }
            case 70: {
                opcodeText = name_fstore_3;
                break;
            }
            case 71: {
                opcodeText = name_dstore_0;
                break;
            }
            case 72: {
                opcodeText = name_dstore_1;
                break;
            }
            case 73: {
                opcodeText = name_dstore_2;
                break;
            }
            case 74: {
                opcodeText = name_dstore_3;
                break;
            }
            case 75: {
                opcodeText = name_astore_0;
                break;
            }
            case 76: {
                opcodeText = name_astore_1;
                break;
            }
            case 77: {
                opcodeText = name_astore_2;
                break;
            }
            case 78: {
                opcodeText = name_astore_3;
                break;
            }
            case 79: {
                opcodeText = name_iastore;
                break;
            }
            case 80: {
                opcodeText = name_lastore;
                break;
            }
            case 81: {
                opcodeText = name_fastore;
                break;
            }
            case 82: {
                opcodeText = name_dastore;
                break;
            }
            case 83: {
                opcodeText = name_aastore;
                break;
            }
            case 84: {
                opcodeText = name_bastore;
                break;
            }
            case 85: {
                opcodeText = name_castore;
                break;
            }
            case 86: {
                opcodeText = name_sastore;
                break;
            }
            case 87: {
                opcodeText = name_pop;
                break;
            }
            case 88: {
                opcodeText = name_pop2;
                break;
            }
            case 89: {
                opcodeText = name_dup;
                break;
            }
            case 90: {
                opcodeText = name_dup_x1;
                break;
            }
            case 91: {
                opcodeText = name_dup_x2;
                break;
            }
            case 92: {
                opcodeText = name_dup2;
                break;
            }
            case 93: {
                opcodeText = name_dup2_x1;
                break;
            }
            case 94: {
                opcodeText = name_dup2_x2;
                break;
            }
            case 95: {
                opcodeText = name_swap;
                break;
            }
            case 96: {
                opcodeText = name_iadd;
                break;
            }
            case 97: {
                opcodeText = name_ladd;
                break;
            }
            case 98: {
                opcodeText = name_fadd;
                break;
            }
            case 99: {
                opcodeText = name_dadd;
                break;
            }
            case 100: {
                opcodeText = name_isub;
                break;
            }
            case 101: {
                opcodeText = name_lsub;
                break;
            }
            case 102: {
                opcodeText = name_fsub;
                break;
            }
            case 103: {
                opcodeText = name_dsub;
                break;
            }
            case 104: {
                opcodeText = name_imul;
                break;
            }
            case 105: {
                opcodeText = name_lmul;
                break;
            }
            case 106: {
                opcodeText = name_fmul;
                break;
            }
            case 107: {
                opcodeText = name_dmul;
                break;
            }
            case 108: {
                opcodeText = name_idiv;
                break;
            }
            case 109: {
                opcodeText = name_ldiv;
                break;
            }
            case 110: {
                opcodeText = name_fdiv;
                break;
            }
            case 111: {
                opcodeText = name_ddiv;
                break;
            }
            case 112: {
                opcodeText = name_irem;
                break;
            }
            case 113: {
                opcodeText = name_lrem;
                break;
            }
            case 114: {
                opcodeText = name_frem;
                break;
            }
            case 115: {
                opcodeText = name_drem;
                break;
            }
            case 116: {
                opcodeText = name_ineg;
                break;
            }
            case 117: {
                opcodeText = name_lneg;
                break;
            }
            case 118: {
                opcodeText = name_fneg;
                break;
            }
            case 119: {
                opcodeText = name_dneg;
                break;
            }
            case 120: {
                opcodeText = name_ishl;
                break;
            }
            case 121: {
                opcodeText = name_lshl;
                break;
            }
            case 122: {
                opcodeText = name_ishr;
                break;
            }
            case 123: {
                opcodeText = name_lshr;
                break;
            }
            case 124: {
                opcodeText = name_iushr;
                break;
            }
            case 125: {
                opcodeText = name_lushr;
                break;
            }
            case 126: {
                opcodeText = name_iand;
                break;
            }
            case 127: {
                opcodeText = name_land;
                break;
            }
            case 128: {
                opcodeText = name_ior;
                break;
            }
            case 129: {
                opcodeText = name_lor;
                break;
            }
            case 130: {
                opcodeText = name_ixor;
                break;
            }
            case 131: {
                opcodeText = name_lxor;
                break;
            }
            case 132: {
                byteValue = pdis.readUnsignedByte();
                byteValue2 = pdis.readByte();
                opcodeText = String.format("%s %d %d        ; index const", name_iinc, byteValue, (int)byteValue2);
                break;
            }
            case 133: {
                opcodeText = name_i2l;
                break;
            }
            case 134: {
                opcodeText = name_i2f;
                break;
            }
            case 135: {
                opcodeText = name_i2d;
                break;
            }
            case 136: {
                opcodeText = name_l2i;
                break;
            }
            case 137: {
                opcodeText = name_l2f;
                break;
            }
            case 138: {
                opcodeText = name_l2d;
                break;
            }
            case 139: {
                opcodeText = name_f2i;
                break;
            }
            case 140: {
                opcodeText = name_f2l;
                break;
            }
            case 141: {
                opcodeText = name_f2d;
                break;
            }
            case 142: {
                opcodeText = name_d2i;
                break;
            }
            case 143: {
                opcodeText = name_d2l;
                break;
            }
            case 144: {
                opcodeText = name_d2f;
                break;
            }
            case 145: {
                opcodeText = name_i2b;
                break;
            }
            case 146: {
                opcodeText = name_i2c;
                break;
            }
            case 147: {
                opcodeText = name_i2s;
                break;
            }
            case 148: {
                opcodeText = name_lcmp;
                break;
            }
            case 149: {
                opcodeText = name_fcmpl;
                break;
            }
            case 150: {
                opcodeText = name_fcmpg;
                break;
            }
            case 151: {
                opcodeText = name_dcmpl;
                break;
            }
            case 152: {
                opcodeText = name_dcmpg;
                break;
            }
            case 153: {
                shortValue = pdis.readShort();
                opcodeText = String.format(FORMAT_SD, name_ifeq, shortValue);
                break;
            }
            case 154: {
                shortValue = pdis.readShort();
                opcodeText = String.format(FORMAT_SD, name_ifne, shortValue);
                break;
            }
            case 155: {
                shortValue = pdis.readShort();
                opcodeText = String.format(FORMAT_SD, name_iflt, shortValue);
                break;
            }
            case 156: {
                shortValue = pdis.readShort();
                opcodeText = String.format(FORMAT_SD, name_ifge, shortValue);
                break;
            }
            case 157: {
                shortValue = pdis.readShort();
                opcodeText = String.format(FORMAT_SD, name_ifgt, shortValue);
                break;
            }
            case 158: {
                shortValue = pdis.readShort();
                opcodeText = String.format(FORMAT_SD, name_ifle, shortValue);
                break;
            }
            case 159: {
                shortValue = pdis.readShort();
                opcodeText = String.format(FORMAT_SD, name_if_icmpeq, shortValue);
                break;
            }
            case 160: {
                shortValue = pdis.readShort();
                opcodeText = String.format(FORMAT_SD, name_if_icmpne, shortValue);
                break;
            }
            case 161: {
                shortValue = pdis.readShort();
                opcodeText = String.format(FORMAT_SD, name_if_icmplt, shortValue);
                break;
            }
            case 162: {
                shortValue = pdis.readShort();
                opcodeText = String.format(FORMAT_SD, name_if_icmpge, shortValue);
                break;
            }
            case 163: {
                shortValue = pdis.readShort();
                opcodeText = String.format(FORMAT_SD, name_if_icmpgt, shortValue);
                break;
            }
            case 164: {
                shortValue = pdis.readShort();
                opcodeText = String.format(FORMAT_SD, name_if_icmple, shortValue);
                break;
            }
            case 165: {
                shortValue = pdis.readShort();
                opcodeText = String.format(FORMAT_SD, name_if_acmpeq, shortValue);
                break;
            }
            case 166: {
                shortValue = pdis.readShort();
                opcodeText = String.format(FORMAT_SD, name_if_acmpne, shortValue);
                break;
            }
            case 167: {
                shortValue = pdis.readShort();
                opcodeText = String.format(FORMAT_SD, name_goto, shortValue);
                break;
            }
            case 168: {
                shortValue = pdis.readShort();
                opcodeText = String.format(FORMAT_SD, name_jsr, shortValue);
                break;
            }
            case 169: {
                byteValue = pdis.readUnsignedByte();
                opcodeText = String.format(FORMAT_SD, name_ret, byteValue);
                break;
            }
            case 170: {
                pdis.skipBytes(3);
                opcodeText = Opcode.getOpcodeTableSwitchText(pdis, 8);
                break;
            }
            case 171: {
                pdis.skipBytes(3);
                opcodeText = Opcode.getOpcodeLookupSwitchText(pdis, 8);
                break;
            }
            case 172: {
                opcodeText = name_ireturn;
                break;
            }
            case 173: {
                opcodeText = name_lreturn;
                break;
            }
            case 174: {
                opcodeText = name_freturn;
                break;
            }
            case 175: {
                opcodeText = name_dreturn;
                break;
            }
            case 176: {
                opcodeText = name_areturn;
                break;
            }
            case 177: {
                opcodeText = name_return;
                break;
            }
            case 178: {
                shortValue = pdis.readUnsignedShort();
                opcodeText = String.format(FORMAT_SDS, name_getstatic, shortValue, classFile.getCPDescription(shortValue));
                break;
            }
            case 179: {
                shortValue = pdis.readUnsignedShort();
                opcodeText = String.format(FORMAT_SDS, name_putstatic, shortValue, classFile.getCPDescription(shortValue));
                break;
            }
            case 180: {
                shortValue = pdis.readUnsignedShort();
                opcodeText = String.format(FORMAT_SDS, name_getfield, shortValue, classFile.getCPDescription(shortValue));
                break;
            }
            case 181: {
                shortValue = pdis.readUnsignedShort();
                opcodeText = String.format(FORMAT_SDS, name_putfield, shortValue, classFile.getCPDescription(shortValue));
                break;
            }
            case 182: {
                shortValue = pdis.readUnsignedShort();
                opcodeText = String.format(FORMAT_SDS, name_invokevirtual, shortValue, classFile.getCPDescription(shortValue));
                break;
            }
            case 183: {
                shortValue = pdis.readUnsignedShort();
                opcodeText = String.format(FORMAT_SDS, name_invokespecial, shortValue, classFile.getCPDescription(shortValue));
                break;
            }
            case 184: {
                shortValue = pdis.readUnsignedShort();
                opcodeText = String.format(FORMAT_SDS, name_invokestatic, shortValue, classFile.getCPDescription(shortValue));
                break;
            }
            case 185: {
                shortValue = pdis.readUnsignedShort();
                byteValue = pdis.readUnsignedByte();
                pdis.skipBytes(1);
                opcodeText = String.format("%s interface=%d [%s], nargs=%d", name_invokeinterface, shortValue, classFile.getCPDescription(shortValue), byteValue);
                break;
            }
            case 187: {
                shortValue = pdis.readUnsignedShort();
                opcodeText = String.format(FORMAT_SDS, name_new, shortValue, classFile.getCPDescription(shortValue));
                break;
            }
            case 188: {
                byteValue = pdis.readUnsignedByte();
                opcodeText = String.format("%s %s", name_newarray, Opcode.getOpcodeNewarrayAtype(byteValue));
                break;
            }
            case 189: {
                shortValue = pdis.readUnsignedShort();
                opcodeText = String.format(FORMAT_SDS, name_anewarray, shortValue, classFile.getCPDescription(shortValue));
                break;
            }
            case 190: {
                opcodeText = name_arraylength;
                break;
            }
            case 191: {
                opcodeText = name_athrow;
                break;
            }
            case 192: {
                shortValue = pdis.readUnsignedShort();
                opcodeText = String.format(FORMAT_SDS, name_checkcast, shortValue, classFile.getCPDescription(shortValue));
                break;
            }
            case 193: {
                shortValue = pdis.readUnsignedShort();
                opcodeText = String.format(FORMAT_SDS, name_instanceof, shortValue, classFile.getCPDescription(shortValue));
                break;
            }
            case 194: {
                opcodeText = name_monitorenter;
                break;
            }
            case 195: {
                opcodeText = name_monitorexit;
                break;
            }
            case 196: {
                opcodeText = Opcode.getOpcodeWideText(pdis);
                break;
            }
            case 197: {
                shortValue = pdis.readUnsignedShort();
                byteValue = pdis.readUnsignedByte();
                opcodeText = String.format("%s index=%d [%s] dimensions=%d", name_instanceof, shortValue, classFile.getCPDescription(shortValue), byteValue);
                break;
            }
            case 198: {
                shortValue = pdis.readUnsignedShort();
                opcodeText = String.format(FORMAT_SD, name_ifnull, shortValue);
                break;
            }
            case 199: {
                shortValue = pdis.readUnsignedShort();
                opcodeText = String.format(FORMAT_SD, name_ifnonnull, shortValue);
                break;
            }
            case 200: {
                intValue = pdis.readInt();
                opcodeText = String.format(FORMAT_SD, name_goto_w, intValue);
                break;
            }
            case 201: {
                intValue = pdis.readInt();
                opcodeText = String.format(FORMAT_SD, name_jsr_w, intValue);
                break;
            }
            case 202: {
                opcodeText = "[Reserved] - breakpoint";
                break;
            }
            case 254: {
                opcodeText = "[Reserved] - impdep1";
                break;
            }
            case 255: {
                opcodeText = "[Reserved] - impdep2";
                break;
            }
            default: {
                opcodeText = "[Unknown opcode]";
            }
        }
        return String.format("opcode [%02X] - %04d: %s", opcode, curPos, opcodeText);
    }

    private static String getOpcodeNewarrayAtype(int type) {
        String value;
        switch (type) {
            case 4: {
                value = "T_BOOLEAN";
                break;
            }
            case 5: {
                value = "T_CHAR";
                break;
            }
            case 6: {
                value = "T_FLOAT";
                break;
            }
            case 7: {
                value = "T_DOUBLE";
                break;
            }
            case 8: {
                value = "T_BYTE";
                break;
            }
            case 9: {
                value = "T_SHORT";
                break;
            }
            case 10: {
                value = "T_INT";
                break;
            }
            case 11: {
                value = "T_LONG";
                break;
            }
            default: {
                value = "[ERROR: Unknown type]";
            }
        }
        return value;
    }

    private static String getOpcodeLookupSwitchText(PosDataInputStream pdis, int spaceLength) throws IOException {
        int i;
        String space;
        if (spaceLength < 1) {
            space = "";
        } else {
            StringBuilder sbSpace = new StringBuilder(spaceLength);
            for (i = 0; i < spaceLength; ++i) {
                sbSpace.appendCodePoint(32);
            }
            space = sbSpace.toString();
        }
        int defaultJump = pdis.readInt();
        StringBuilder sb = new StringBuilder(200);
        sb.append(name_lookupswitch);
        sb.append(String.format(": default=%d", defaultJump));
        int pairCount = pdis.readInt();
        int caseValue = 0;
        int offsetValue = 0;
        for (i = 0; i < pairCount; ++i) {
            caseValue = pdis.readInt();
            offsetValue = pdis.readInt();
            sb.append(String.format("\n%scase %d: %d", space, caseValue, offsetValue));
        }
        return sb.toString();
    }

    private static String getOpcodeTableSwitchText(PosDataInputStream pdis, int spaceLength) throws IOException {
        int i;
        String space;
        if (spaceLength < 1) {
            space = "";
        } else {
            StringBuilder sbSpace = new StringBuilder(spaceLength);
            for (i = 0; i < spaceLength; ++i) {
                sbSpace.appendCodePoint(32);
            }
            space = sbSpace.toString();
        }
        int defaultJump = pdis.readInt();
        int valueLow = pdis.readInt();
        int valueHigh = pdis.readInt();
        int tableLength = valueHigh - valueLow + 1;
        StringBuilder sb = new StringBuilder(200);
        sb.append(name_tableswitch);
        sb.append(String.format(" %d to %d: default=%d", valueLow, valueHigh, defaultJump));
        for (i = 0; i < tableLength; ++i) {
            int offsetValue = pdis.readInt();
            sb.append(String.format("\n%s%d", space, offsetValue));
        }
        return sb.toString();
    }

    private static String getOpcodeWideText(PosDataInputStream pdis) throws IOException {
        int opcode = pdis.readUnsignedByte();
        String opcodeText = null;
        switch (opcode) {
            case 21: {
                int shortValue = pdis.readUnsignedShort();
                opcodeText = String.format(FORMAT_SD, name_wide_iload, shortValue);
                break;
            }
            case 22: {
                int shortValue = pdis.readUnsignedShort();
                opcodeText = String.format(FORMAT_SD, name_wide_lload, shortValue);
                break;
            }
            case 23: {
                int shortValue = pdis.readUnsignedShort();
                opcodeText = String.format(FORMAT_SD, name_wide_fload, shortValue);
                break;
            }
            case 24: {
                int shortValue = pdis.readUnsignedShort();
                opcodeText = String.format(FORMAT_SD, name_wide_dload, shortValue);
                break;
            }
            case 25: {
                int shortValue = pdis.readUnsignedShort();
                opcodeText = String.format(FORMAT_SD, name_wide_aload, shortValue);
                break;
            }
            case 54: {
                int shortValue = pdis.readUnsignedShort();
                opcodeText = String.format(FORMAT_SD, name_wide_istore, shortValue);
                break;
            }
            case 55: {
                int shortValue = pdis.readUnsignedShort();
                opcodeText = String.format(FORMAT_SD, name_wide_lstore, shortValue);
                break;
            }
            case 56: {
                int shortValue = pdis.readUnsignedShort();
                opcodeText = String.format(FORMAT_SD, name_wide_fstore, shortValue);
                break;
            }
            case 57: {
                int shortValue = pdis.readUnsignedShort();
                opcodeText = String.format(FORMAT_SD, name_wide_dstore, shortValue);
                break;
            }
            case 58: {
                int shortValue = pdis.readUnsignedShort();
                opcodeText = String.format(FORMAT_SD, name_wide_astore, shortValue);
                break;
            }
            case 132: {
                int shortValue = pdis.readUnsignedShort();
                int shortValue2 = pdis.readUnsignedShort();
                opcodeText = String.format("%s %d %d", name_wide_iinc, shortValue, shortValue2);
                break;
            }
            case 169: {
                int shortValue = pdis.readUnsignedShort();
                opcodeText = String.format(FORMAT_SD, name_wide_ret, shortValue);
                break;
            }
            default: {
                opcodeText = String.format("%s [Unknown opcode]", name_wide);
            }
        }
        return opcodeText;
    }
}

