/*
 * Decompiled with CFR 0.152.
 */
package org.freeinternals.classfile.core;

import org.freeinternals.classfile.core.SignatureException;

final class SignatureConvertor {
    private SignatureConvertor() {
    }

    protected static String parseMethodReturnType(String signature) throws SignatureException {
        if (signature == null) {
            throw new IllegalArgumentException("'signature' should not be null.");
        }
        if (signature.length() < 3) {
            throw new IllegalArgumentException("'signature' should be more than 2 characters.");
        }
        int bracketEnd = signature.indexOf(41);
        if (bracketEnd == -1) {
            throw new IllegalArgumentException(String.format("There is no ')' in the method signature: %s", signature));
        }
        String returnValue = null;
        String returnType = signature.substring(bracketEnd + 1);
        returnValue = "V".equals(returnType) ? "void" : SignatureConvertor.signature2Type(returnType);
        return returnValue;
    }

    protected static String parseMethodParameters(String signature) throws SignatureException {
        if (signature == null) {
            throw new IllegalArgumentException("'signature' should not be null.");
        }
        if (signature.length() < 3) {
            throw new IllegalArgumentException("'signature' should be more than 2 characters.");
        }
        int bracketEnd = signature.indexOf(41);
        if (signature.charAt(0) != '(' || bracketEnd == -1) {
            throw new IllegalArgumentException(String.format("There is no '(' or ')' in the method signature: %s", signature));
        }
        StringBuilder sbResult = new StringBuilder(signature.length() + signature.length());
        sbResult.append('(');
        StringBuilder sbParameter = new StringBuilder(sbResult.capacity());
        int commaIndex = 0;
        String rawParameters = signature.substring(1, bracketEnd + 1);
        int parametersCounter = 0;
        while (rawParameters.charAt(0) != ')') {
            if (rawParameters.charAt(0) == '[') {
                sbParameter.append("[]");
                rawParameters = rawParameters.substring(1);
                continue;
            }
            if (SignatureConvertor.isPrimitiveTypes(rawParameters.charAt(0)).booleanValue()) {
                sbParameter = sbParameter.insert(0, SignatureConvertor.extractPrimitiveTypes(rawParameters.charAt(0)));
                sbResult.append((CharSequence)sbParameter);
                ++parametersCounter;
                sbParameter = sbParameter.delete(0, sbParameter.capacity());
                rawParameters = rawParameters.substring(1);
            } else if (rawParameters.charAt(0) == 'L') {
                commaIndex = rawParameters.indexOf(59);
                sbParameter = sbParameter.insert(0, SignatureConvertor.extractClassFullSignature(rawParameters.substring(0, commaIndex + 1)));
                sbResult.append((CharSequence)sbParameter);
                ++parametersCounter;
                sbParameter = sbParameter.delete(0, sbParameter.capacity());
                rawParameters = rawParameters.substring(commaIndex + 1);
            }
            sbResult.append(", ");
        }
        if (parametersCounter > 0) {
            sbResult.delete(sbResult.length() - 2, sbResult.length());
        }
        sbResult.append(')');
        return sbResult.toString();
    }

    protected static String signature2Type(String signature) throws SignatureException {
        if (signature == null || signature.isEmpty()) {
            throw new IllegalArgumentException("'signature' should not be null or empty.");
        }
        StringBuilder sb = new StringBuilder(signature.length());
        String sig = signature;
        int arrayCount = 0;
        while (sig.charAt(0) == '[') {
            ++arrayCount;
            sig = sig.substring(1);
        }
        sb.append(SignatureConvertor.rawSignature2Type(sig));
        while (arrayCount > 0) {
            sb.append("[]");
            --arrayCount;
        }
        return sb.toString();
    }

    private static String rawSignature2Type(String signature) throws IllegalArgumentException, SignatureException {
        if (signature == null) {
            throw new IllegalArgumentException("'signature' should not be null.");
        }
        String returnValue = null;
        int signatureLength = signature.length();
        switch (signatureLength) {
            case 0: 
            case 2: {
                throw new SignatureException(String.format("Sinagure length cannot be 0, or 2. Current 'signature' length=%d.", signatureLength));
            }
            case 1: {
                returnValue = SignatureConvertor.extractPrimitiveTypes(signature.charAt(0));
                break;
            }
            default: {
                returnValue = SignatureConvertor.extractClassFullSignature(signature);
            }
        }
        return returnValue;
    }

    private static String extractPrimitiveTypes(char typeSignature) {
        String javaType = null;
        switch (typeSignature) {
            case 'B': {
                javaType = "byte";
                break;
            }
            case 'C': {
                javaType = "char";
                break;
            }
            case 'D': {
                javaType = "double";
                break;
            }
            case 'F': {
                javaType = "float";
                break;
            }
            case 'I': {
                javaType = "int";
                break;
            }
            case 'J': {
                javaType = "long";
                break;
            }
            case 'S': {
                javaType = "short";
                break;
            }
            case 'Z': {
                javaType = "boolean ";
                break;
            }
            default: {
                javaType = "[ERROR: unknown primitive type]";
            }
        }
        return javaType;
    }

    private static Boolean isPrimitiveTypes(char typeSignature) {
        Boolean returnValue = false;
        switch (typeSignature) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                returnValue = true;
                break;
            }
            default: {
                returnValue = false;
            }
        }
        return returnValue;
    }

    private static String extractClassFullSignature(String classSignature) throws IllegalArgumentException, SignatureException {
        if (classSignature == null) {
            throw new IllegalArgumentException("'ClassSignature' should not be null.");
        }
        int length = classSignature.length();
        if (length < 3) {
            throw new SignatureException(String.format("Fully-qualified class sinagure length cannot be less than 2. Current length=%d.", length));
        }
        if (classSignature.charAt(0) != 'L' || classSignature.charAt(length - 1) != ';') {
            throw new SignatureException(String.format("Fully-qualified class sinagure format is not 'L-xxx-;'. it is '%s'.", classSignature));
        }
        String returnValue = null;
        returnValue = classSignature.substring(1, length - 1);
        return returnValue.replace('/', '.');
    }

    protected static String parseClassSignature(String classSignature) throws IllegalArgumentException {
        if (classSignature == null) {
            throw new IllegalArgumentException("'ClassSignature' should not be null.");
        }
        return classSignature.replace('/', '.');
    }
}

