/*
 * Decompiled with CFR 0.152.
 */
package org.freeinternals.classfile.ui;

import java.awt.Dimension;
import java.awt.event.MouseListener;
import javax.swing.JTextArea;
import org.freeinternals.classfile.ui.JBinaryViewer;

class JRowViewer
extends JTextArea {
    private static final long serialVersionUID = 4876543219876500000L;
    protected static final int width = 75;

    public JRowViewer() {
        this.setFont(JBinaryViewer.font);
        this.setAlignmentX(0.0f);
        this.setMinimumSize(new Dimension(270, Short.MAX_VALUE));
        this.setMaximumSize(new Dimension(270, Short.MAX_VALUE));
        this.setEditable(false);
        this.filterMouseEvents();
    }

    protected void setData(int rowCount, int rowItemMax) {
        int rowStartValue = 0;
        this.removeAll();
        for (int i = 0; i < rowCount; ++i) {
            this.append(String.format("%08Xh\n", rowStartValue));
            rowStartValue += rowItemMax;
        }
        Dimension d = new Dimension(75, rowCount * 20);
        this.setMinimumSize(d);
        this.setMaximumSize(d);
    }

    private void filterMouseEvents() {
        MouseListener[] allMl = this.getMouseListeners();
        if (allMl != null) {
            for (int i = 0; i < allMl.length; ++i) {
                this.removeMouseListener(allMl[i]);
            }
        }
    }
}

