/*
 * Decompiled with CFR 0.152.
 */
package org.freeinternals.classfile.ui;

import java.awt.Font;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.freeinternals.classfile.core.ClassFile;
import org.freeinternals.classfile.core.ClassFormatException;
import org.freeinternals.classfile.core.Opcode;
import org.freeinternals.classfile.ui.JBinaryViewer;
import org.freeinternals.classfile.ui.JTreeClassFile;
import org.freeinternals.classfile.ui.JTreeNodeClassComponent;
import org.freeinternals.classfile.ui.Tool;
import org.freeinternals.common.ui.JPanelForTree;

public class JSplitPaneClassFile
extends JSplitPane {
    private static final long serialVersionUID = 4876543219876500000L;
    private ClassFile classFile;
    private JBinaryViewer binaryViewer = null;
    private JScrollPane binaryViewerView = null;
    private JTextArea opcode = null;

    public JSplitPaneClassFile(byte[] byteArray) {
        try {
            this.classFile = new ClassFile((byte[])byteArray.clone());
        }
        catch (IOException ex) {
            Logger.getLogger(JSplitPaneClassFile.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ClassFormatException ex) {
            Logger.getLogger(JSplitPaneClassFile.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.createAndShowGUI();
    }

    private void createAndShowGUI() {
        JTreeClassFile jTreeClassFile = new JTreeClassFile(this.classFile);
        jTreeClassFile.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                JSplitPaneClassFile.this.jTreeClassFileSelectionChanged(evt);
            }
        });
        JPanelForTree panel = new JPanelForTree(jTreeClassFile);
        JTabbedPane tabbedPane = new JTabbedPane();
        this.binaryViewer = new JBinaryViewer();
        this.binaryViewer.setData(this.classFile.getClassByteArray());
        this.binaryViewerView = new JScrollPane(this.binaryViewer);
        this.binaryViewerView.getVerticalScrollBar().setValue(0);
        tabbedPane.add("Class File", this.binaryViewerView);
        this.opcode = new JTextArea();
        this.opcode.setFont(new Font("DialogInput", 0, 14));
        this.opcode.setEditable(false);
        tabbedPane.add("Opcode", new JScrollPane(this.opcode));
        this.setOrientation(1);
        this.setDividerSize(5);
        this.setDividerLocation(280);
        this.setLeftComponent(panel);
        this.setRightComponent(tabbedPane);
        this.binaryViewerView.getVerticalScrollBar().setValue(0);
    }

    private void jTreeClassFileSelectionChanged(TreeSelectionEvent evt) {
        DefaultMutableTreeNode objDmtn;
        Object obj = evt.getPath().getLastPathComponent();
        if (obj instanceof DefaultMutableTreeNode && (obj = (objDmtn = (DefaultMutableTreeNode)obj).getUserObject()) instanceof JTreeNodeClassComponent) {
            JTreeNodeClassComponent objTncc = (JTreeNodeClassComponent)obj;
            this.binaryViewer.setSelection(objTncc.getStartPos(), objTncc.getLength());
            this.opcode.setText(null);
            if (objTncc.getText().equals("code")) {
                byte[] data = this.classFile.getClassByteArray(objTncc.getStartPos(), objTncc.getLength());
                this.opcode.append(Tool.getByteDataHexView(data));
                this.opcode.append("\n");
                this.opcode.append(Opcode.parseCode(data, this.classFile));
            }
        }
    }
}

