/*
 * Decompiled with CFR 0.152.
 */
package org.freeinternals.classfile.ui;

import javax.swing.tree.DefaultMutableTreeNode;
import org.freeinternals.classfile.core.AttributeCode;
import org.freeinternals.classfile.core.AttributeConstantValue;
import org.freeinternals.classfile.core.AttributeDeprecated;
import org.freeinternals.classfile.core.AttributeExceptions;
import org.freeinternals.classfile.core.AttributeExtended;
import org.freeinternals.classfile.core.AttributeInfo;
import org.freeinternals.classfile.core.AttributeInnerClasses;
import org.freeinternals.classfile.core.AttributeLineNumberTable;
import org.freeinternals.classfile.core.AttributeLocalVariableTable;
import org.freeinternals.classfile.core.AttributeSourceFile;
import org.freeinternals.classfile.core.AttributeSynthetic;
import org.freeinternals.classfile.ui.InvalidTreeNodeException;
import org.freeinternals.classfile.ui.JTreeNodeClassComponent;

class JTreeAttribute {
    private JTreeAttribute() {
    }

    public static void generateTreeNode(DefaultMutableTreeNode rootNode, AttributeInfo attribute_info) throws InvalidTreeNodeException {
        if (attribute_info == null) {
            return;
        }
        int startPos = attribute_info.getStartPos();
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos, 2, "attribute_name_index: " + attribute_info.getNameIndex() + ", name=" + attribute_info.getName())));
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 2, 4, "attribute_length: " + attribute_info.getAttributeLength())));
        String type = attribute_info.getName();
        if ("ConstantValue".equals(type)) {
            JTreeAttribute.generateTreeNode(rootNode, (AttributeConstantValue)attribute_info);
        } else if ("Code".equals(type)) {
            JTreeAttribute.generateTreeNode(rootNode, (AttributeCode)attribute_info);
        } else if ("Exceptions".equals(type)) {
            JTreeAttribute.generateTreeNode(rootNode, (AttributeExceptions)attribute_info);
        } else if ("InnerClasses".equals(type)) {
            JTreeAttribute.generateTreeNode(rootNode, (AttributeInnerClasses)attribute_info);
        } else if ("Synthetic".equals(type)) {
            JTreeAttribute.generateTreeNode(rootNode, (AttributeSynthetic)attribute_info);
        } else if ("SourceFile".equals(type)) {
            JTreeAttribute.generateTreeNode(rootNode, (AttributeSourceFile)attribute_info);
        } else if ("LineNumberTable".equals(type)) {
            JTreeAttribute.generateTreeNode(rootNode, (AttributeLineNumberTable)attribute_info);
        } else if ("LocalVariableTable".equals(type)) {
            JTreeAttribute.generateTreeNode(rootNode, (AttributeLocalVariableTable)attribute_info);
        } else if ("Deprecated".equals(type)) {
            JTreeAttribute.generateTreeNode(rootNode, (AttributeDeprecated)attribute_info);
        } else {
            JTreeAttribute.generateTreeNode(rootNode, (AttributeExtended)attribute_info);
        }
    }

    private static void generateTreeNode(DefaultMutableTreeNode rootNode, AttributeConstantValue constantValue) throws InvalidTreeNodeException {
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(constantValue.getStartPos() + 6, 2, "constantvalue_index: " + constantValue.getConstantValueIndex())));
    }

    private static void generateTreeNode(DefaultMutableTreeNode rootNode, AttributeCode code) throws InvalidTreeNodeException {
        int i;
        int startPos = code.getStartPos();
        int codeLength = code.getCodeLength();
        int exceptionTableLength = code.getExceptionTableLength();
        int attrCount = code.getAttributeCount();
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 6, 2, "max_stack: " + code.getMaxStack())));
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 8, 2, "max_locals: " + code.getMaxLocals())));
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 10, 4, "code_length: " + code.getCodeLength())));
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 14, codeLength, "code")));
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 14 + codeLength, 2, "exception_table_length: " + exceptionTableLength)));
        if (exceptionTableLength > 0) {
            AttributeCode.ExceptionTable lastEt = code.getExceptionTable(exceptionTableLength - 1);
            DefaultMutableTreeNode treeNodeExceptionTable = new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 14 + codeLength + 1, lastEt.getStartPos() + lastEt.getLength() - (startPos + 14 + codeLength + 1), "exception_table"));
            for (i = 0; i < exceptionTableLength; ++i) {
                AttributeCode.ExceptionTable et = code.getExceptionTable(i);
                DefaultMutableTreeNode treeNodeExceptionTableItem = new DefaultMutableTreeNode(new JTreeNodeClassComponent(et.getStartPc(), et.getLength(), String.format("[%d]", i)));
                ExceptionTable.generateTreeNode(treeNodeExceptionTableItem, et);
                treeNodeExceptionTable.add(treeNodeExceptionTableItem);
                treeNodeExceptionTableItem = null;
            }
            rootNode.add(treeNodeExceptionTable);
        }
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 14 + codeLength + 2 + exceptionTableLength * 8, 2, "attributes_count: " + attrCount)));
        if (attrCount > 0) {
            DefaultMutableTreeNode treeNodeAttribute = new DefaultMutableTreeNode(new JTreeNodeClassComponent(0, 0, "attributes"));
            for (i = 0; i < attrCount; ++i) {
                DefaultMutableTreeNode treeNodeAttributeItem = new DefaultMutableTreeNode(new JTreeNodeClassComponent(0, 0, String.format("[attribute %d]", i)));
                JTreeAttribute.generateTreeNode(treeNodeAttributeItem, code.getAttribute(i));
                treeNodeAttribute.add(treeNodeAttributeItem);
                treeNodeAttributeItem = null;
            }
            rootNode.add(treeNodeAttribute);
        }
    }

    private static void generateTreeNode(DefaultMutableTreeNode rootNode, AttributeExceptions exceptions) throws InvalidTreeNodeException {
        int startPos = exceptions.getStartPos();
        int numOfExceptions = exceptions.getNumberOfExceptions();
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 6, 2, "number_of_exceptions: " + numOfExceptions)));
        if (numOfExceptions > 0) {
            DefaultMutableTreeNode treeNodeExceptions = new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 8, numOfExceptions * 2, "exceptions"));
            for (int i = 0; i < numOfExceptions; ++i) {
                treeNodeExceptions.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 10 + i * 2, 2, String.format("exception_index_table[%d]: cp_index=%d", i, exceptions.getExceptionIndexTableItem(i)))));
            }
            rootNode.add(treeNodeExceptions);
        }
    }

    private static void generateTreeNode(DefaultMutableTreeNode rootNode, AttributeInnerClasses innerClasses) throws InvalidTreeNodeException {
        int startPos = innerClasses.getStartPos();
        int numOfClasses = innerClasses.getNumberOfClasses();
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 6, 2, "number_of_classes: " + numOfClasses)));
        if (numOfClasses > 0) {
            DefaultMutableTreeNode treeNodeInnerClass = new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 8, innerClasses.getClass(numOfClasses - 1).getStartPos() + innerClasses.getClass(numOfClasses - 1).getLength() - (startPos + 8), "classes"));
            for (int i = 0; i < numOfClasses; ++i) {
                AttributeInnerClasses.Class cls = innerClasses.getClass(i);
                DefaultMutableTreeNode treeNodeInnerClassItem = new DefaultMutableTreeNode(new JTreeNodeClassComponent(cls.getStartPos(), cls.getLength(), String.format("class %d", i + 1)));
                Class.generateTreeNode(treeNodeInnerClassItem, cls);
                treeNodeInnerClass.add(treeNodeInnerClassItem);
                treeNodeInnerClassItem = null;
            }
            rootNode.add(treeNodeInnerClass);
        }
    }

    private static void generateTreeNode(DefaultMutableTreeNode rootNode, AttributeSynthetic synthetic) throws InvalidTreeNodeException {
    }

    private static void generateTreeNode(DefaultMutableTreeNode rootNode, AttributeSourceFile sourceFile) throws InvalidTreeNodeException {
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(sourceFile.getStartPos() + 6, 2, "sourcefile_index: " + sourceFile.getSourcefileIndex())));
    }

    private static void generateTreeNode(DefaultMutableTreeNode rootNode, AttributeLineNumberTable lineNumberTable) throws InvalidTreeNodeException {
        int startPos = lineNumberTable.getStartPos();
        int length = lineNumberTable.getLineNumberTableLength();
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 6, 2, "line_number_table_length: " + length)));
        if (length > 0) {
            DefaultMutableTreeNode treeNodeLnt = new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 8, length * 4, "line_number_table"));
            for (int i = 0; i < length; ++i) {
                AttributeLineNumberTable.LineNumberTable lnt = lineNumberTable.getLineNumberTable(i);
                DefaultMutableTreeNode treeNodeLntItem = new DefaultMutableTreeNode(new JTreeNodeClassComponent(lnt.getStartPos(), lnt.getLength(), String.format("[row %d]", i)));
                LineNumberTable.generateTreeNode(treeNodeLntItem, lnt);
                treeNodeLnt.add(treeNodeLntItem);
                treeNodeLntItem = null;
            }
            rootNode.add(treeNodeLnt);
        }
    }

    private static void generateTreeNode(DefaultMutableTreeNode rootNode, AttributeLocalVariableTable localVariableTable) throws InvalidTreeNodeException {
        int startPos = localVariableTable.getStartPos();
        int length = localVariableTable.getLocalVariableTalbeLength();
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 6, 2, "local_variable_table_length: " + length)));
        if (length > 0) {
            DefaultMutableTreeNode treeNodeLvt = new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 8, length * 4, "local_variable_table"));
            for (int i = 0; i < length; ++i) {
                AttributeLocalVariableTable.LocalVariableTable lvt = localVariableTable.getLocalVariableTable(i);
                DefaultMutableTreeNode treeNodeLvtItem = new DefaultMutableTreeNode(new JTreeNodeClassComponent(lvt.getStartPos(), lvt.getLength(), String.format("[%05d]", i)));
                LocalVariableTable.generateTreeNode(treeNodeLvtItem, lvt);
                treeNodeLvt.add(treeNodeLvtItem);
                treeNodeLvtItem = null;
            }
            rootNode.add(treeNodeLvt);
        }
    }

    private static void generateTreeNode(DefaultMutableTreeNode rootNode, AttributeDeprecated deprecated) throws InvalidTreeNodeException {
    }

    private static void generateTreeNode(DefaultMutableTreeNode rootNode, AttributeExtended unknown) throws InvalidTreeNodeException {
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(unknown.getStartPos() + 6, unknown.getAttributeLength(), "raw data")));
    }

    private static final class LocalVariableTable {
        LocalVariableTable() {
        }

        private static void generateTreeNode(DefaultMutableTreeNode rootNode, AttributeLocalVariableTable.LocalVariableTable lvt) throws InvalidTreeNodeException {
            if (lvt == null) {
                return;
            }
            int startPos = lvt.getStartPos();
            rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos, 2, "start_pc: " + lvt.getStartPc())));
            rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 2, 2, "length: " + lvt.getLength())));
            rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 4, 2, "name_index: " + lvt.getNameIndex())));
            rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 6, 2, "descriptor_index: " + lvt.getNameIndex())));
            rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 8, 2, "index: " + lvt.getIndex())));
        }
    }

    private static final class LineNumberTable {
        LineNumberTable() {
        }

        private static void generateTreeNode(DefaultMutableTreeNode rootNode, AttributeLineNumberTable.LineNumberTable lnt) throws InvalidTreeNodeException {
            if (lnt == null) {
                return;
            }
            int startPos = lnt.getStartPos();
            rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos, 2, "start_pc: " + lnt.getStartPc())));
            rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 2, 2, "line_number: " + lnt.getLineNumber())));
        }
    }

    private static final class Class {
        Class() {
        }

        private static void generateTreeNode(DefaultMutableTreeNode rootNode, AttributeInnerClasses.Class cls) throws InvalidTreeNodeException {
            int startPos = cls.getStartPos();
            rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos, 2, "inner_class_info_index: " + cls.getInnerClassInfoIndex())));
            rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 2, 2, "outer_class_info_index: " + cls.getOuterClassInfoIndex())));
            rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 4, 2, "inner_name_index: " + cls.getInnerNameIndex())));
            rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 6, 2, "inner_class_access_flags: " + cls.getInnerClassAccessFlags())));
        }
    }

    private static final class ExceptionTable {
        ExceptionTable() {
        }

        private static void generateTreeNode(DefaultMutableTreeNode rootNode, AttributeCode.ExceptionTable et) throws InvalidTreeNodeException {
            if (et == null) {
                return;
            }
            int startPos = et.getStartPos();
            rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos, 2, "start_pc: " + et.getStartPc())));
            rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 2, 2, "end_pc: " + et.getEndPc())));
            rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 4, 2, "handler_pc: " + et.getHandlerPc())));
            rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 6, 2, "catch_type: " + et.getCatchType())));
        }
    }
}

