/*
 * Decompiled with CFR 0.152.
 */
package org.freeinternals.classfile.ui;

import javax.swing.tree.DefaultMutableTreeNode;
import org.freeinternals.classfile.core.AbstractCPInfo;
import org.freeinternals.classfile.core.ConstantClassInfo;
import org.freeinternals.classfile.core.ConstantDoubleInfo;
import org.freeinternals.classfile.core.ConstantFieldrefInfo;
import org.freeinternals.classfile.core.ConstantFloatInfo;
import org.freeinternals.classfile.core.ConstantIntegerInfo;
import org.freeinternals.classfile.core.ConstantInterfaceMethodrefInfo;
import org.freeinternals.classfile.core.ConstantLongInfo;
import org.freeinternals.classfile.core.ConstantMethodrefInfo;
import org.freeinternals.classfile.core.ConstantNameAndTypeInfo;
import org.freeinternals.classfile.core.ConstantStringInfo;
import org.freeinternals.classfile.core.ConstantUtf8Info;
import org.freeinternals.classfile.ui.InvalidTreeNodeException;
import org.freeinternals.classfile.ui.JTreeNodeClassComponent;

final class JTreeCPInfo {
    private JTreeCPInfo() {
    }

    public static void generateTreeNode(DefaultMutableTreeNode rootNode, AbstractCPInfo cp_info) throws InvalidTreeNodeException {
        if (cp_info == null) {
            return;
        }
        short tag = cp_info.getTag();
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(cp_info.getStartPos(), 1, "tag: " + tag)));
        switch (tag) {
            case 1: {
                JTreeCPInfo.generateTreeNode(rootNode, (ConstantUtf8Info)cp_info);
                break;
            }
            case 3: {
                JTreeCPInfo.generateTreeNode(rootNode, (ConstantIntegerInfo)cp_info);
                break;
            }
            case 4: {
                JTreeCPInfo.generateTreeNode(rootNode, (ConstantFloatInfo)cp_info);
                break;
            }
            case 5: {
                JTreeCPInfo.generateTreeNode(rootNode, (ConstantLongInfo)cp_info);
                break;
            }
            case 6: {
                JTreeCPInfo.generateTreeNode(rootNode, (ConstantDoubleInfo)cp_info);
                break;
            }
            case 7: {
                JTreeCPInfo.generateTreeNode(rootNode, (ConstantClassInfo)cp_info);
                break;
            }
            case 8: {
                JTreeCPInfo.generateTreeNode(rootNode, (ConstantStringInfo)cp_info);
                break;
            }
            case 9: {
                JTreeCPInfo.generateTreeNode(rootNode, (ConstantFieldrefInfo)cp_info);
                break;
            }
            case 10: {
                JTreeCPInfo.generateTreeNode(rootNode, (ConstantMethodrefInfo)cp_info);
                break;
            }
            case 11: {
                JTreeCPInfo.generateTreeNode(rootNode, (ConstantInterfaceMethodrefInfo)cp_info);
                break;
            }
            case 12: {
                JTreeCPInfo.generateTreeNode(rootNode, (ConstantNameAndTypeInfo)cp_info);
                break;
            }
        }
    }

    private static void generateTreeNode(DefaultMutableTreeNode rootNode, ConstantUtf8Info utf8Info) throws InvalidTreeNodeException {
        int startPos = utf8Info.getStartPos();
        int bytesLength = utf8Info.getBytesLength();
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 1, 2, "length: " + bytesLength)));
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 3, bytesLength, "bytes: " + utf8Info.getValue())));
    }

    private static void generateTreeNode(DefaultMutableTreeNode rootNode, ConstantIntegerInfo integerInfo) throws InvalidTreeNodeException {
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(integerInfo.getStartPos() + 1, 4, "bytes: " + integerInfo.getValue())));
    }

    private static void generateTreeNode(DefaultMutableTreeNode rootNode, ConstantFloatInfo floatInfo) throws InvalidTreeNodeException {
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(floatInfo.getStartPos() + 1, 4, "bytes: " + floatInfo.getValue())));
    }

    private static void generateTreeNode(DefaultMutableTreeNode rootNode, ConstantLongInfo longInfo) throws InvalidTreeNodeException {
        int startPos = longInfo.getStartPos();
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 1, 4, "high_bytes")));
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 5, 4, "low_bytes")));
    }

    private static void generateTreeNode(DefaultMutableTreeNode rootNode, ConstantDoubleInfo doubleInfo) throws InvalidTreeNodeException {
        int startPos = doubleInfo.getStartPos();
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 1, 4, "high_bytes")));
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 5, 4, "low_bytes")));
    }

    private static void generateTreeNode(DefaultMutableTreeNode rootNode, ConstantClassInfo classInfo) throws InvalidTreeNodeException {
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(classInfo.getStartPos() + 1, 2, "name_index: " + classInfo.getNameIndex())));
    }

    private static void generateTreeNode(DefaultMutableTreeNode rootNode, ConstantStringInfo stringInfo) throws InvalidTreeNodeException {
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(stringInfo.getStartPos() + 1, 2, "string_index: " + stringInfo.getStringIndex())));
    }

    private static void generateTreeNode(DefaultMutableTreeNode rootNode, ConstantFieldrefInfo fieldrefInfo) throws InvalidTreeNodeException {
        int startPos = fieldrefInfo.getStartPos();
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 1, 2, "class_index: " + fieldrefInfo.getClassIndex())));
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 3, 2, "name_and_type_index: " + fieldrefInfo.getNameAndTypeIndex())));
    }

    private static void generateTreeNode(DefaultMutableTreeNode rootNode, ConstantMethodrefInfo methodrefInfo) throws InvalidTreeNodeException {
        int startPos = methodrefInfo.getStartPos();
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 1, 2, "class_index: " + methodrefInfo.getClassIndex())));
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 3, 2, "name_and_type_index: " + methodrefInfo.getNameAndTypeIndex())));
    }

    private static void generateTreeNode(DefaultMutableTreeNode rootNode, ConstantInterfaceMethodrefInfo interfaceMethodrefInfo) throws InvalidTreeNodeException {
        int startPos = interfaceMethodrefInfo.getStartPos();
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 1, 2, "class_index: " + interfaceMethodrefInfo.getClassIndex())));
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 3, 2, "name_and_type_index: " + interfaceMethodrefInfo.getNameAndTypeIndex())));
    }

    private static void generateTreeNode(DefaultMutableTreeNode rootNode, ConstantNameAndTypeInfo nameAndTypeInfo) throws InvalidTreeNodeException {
        int startPos = nameAndTypeInfo.getStartPos();
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 1, 2, "name_index: " + nameAndTypeInfo.getNameIndex())));
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 3, 2, "descriptor_index: " + nameAndTypeInfo.getDescriptorIndex())));
    }
}

