/*
 * Decompiled with CFR 0.152.
 */
package org.freeinternals.classfile.ui;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.freeinternals.classfile.core.AbstractCPInfo;
import org.freeinternals.classfile.core.AttributeInfo;
import org.freeinternals.classfile.core.ClassFile;
import org.freeinternals.classfile.core.FieldInfo;
import org.freeinternals.classfile.core.Interface;
import org.freeinternals.classfile.core.MethodInfo;
import org.freeinternals.classfile.ui.InvalidTreeNodeException;
import org.freeinternals.classfile.ui.JTreeAttribute;
import org.freeinternals.classfile.ui.JTreeCPInfo;
import org.freeinternals.classfile.ui.JTreeField;
import org.freeinternals.classfile.ui.JTreeMethod;
import org.freeinternals.classfile.ui.JTreeNodeClassComponent;

public class JTreeClassFile
extends JTree {
    private static final long serialVersionUID = 4876543219876500000L;
    private static int STARTPOS_constant_pool = 10;
    private final ClassFile classFile;
    DefaultMutableTreeNode root = null;

    public JTreeClassFile(ClassFile classFile) {
        this.classFile = classFile;
        this.generateTreeNodes();
        this.setModel(new DefaultTreeModel(this.root));
    }

    private void generateTreeNodes() {
        try {
            this.root = new DefaultMutableTreeNode(new JTreeNodeClassComponent(0, this.classFile.getByteArraySize(), "Class File"));
            DefaultMutableTreeNode magic = new DefaultMutableTreeNode(new JTreeNodeClassComponent(0, 4, "magic"));
            this.root.add(magic);
            this.generateTreeNodeClsssFileVersion();
            this.generateConstantPool();
            this.generateClassDeclaration();
            this.generateFields();
            this.generateMethods();
            this.generateAttributes();
        }
        catch (InvalidTreeNodeException itne) {
            Logger.getLogger(JTreeClassFile.class.getName()).log(Level.SEVERE, null, itne);
        }
    }

    private void generateTreeNodeClsssFileVersion() throws InvalidTreeNodeException {
        DefaultMutableTreeNode minor_version = new DefaultMutableTreeNode(new JTreeNodeClassComponent(this.classFile.getMinorVersion().getStartPos(), this.classFile.getMinorVersion().getLength(), "minor_version: " + this.classFile.getMinorVersion().getValue()));
        this.root.add(minor_version);
        DefaultMutableTreeNode major_version = new DefaultMutableTreeNode(new JTreeNodeClassComponent(this.classFile.getMajorVersion().getStartPos(), this.classFile.getMajorVersion().getLength(), "major_version: " + this.classFile.getMajorVersion().getValue()));
        this.root.add(major_version);
    }

    private void generateConstantPool() throws InvalidTreeNodeException {
        int cpCount = this.classFile.getCPCount().getValue();
        DefaultMutableTreeNode constant_pool_count = new DefaultMutableTreeNode(new JTreeNodeClassComponent(this.classFile.getCPCount().getStartPos(), this.classFile.getCPCount().getLength(), "constant_pool_count: " + cpCount));
        this.root.add(constant_pool_count);
        AbstractCPInfo[] cp = this.classFile.getConstantPool();
        DefaultMutableTreeNode constant_pool = new DefaultMutableTreeNode(new JTreeNodeClassComponent(STARTPOS_constant_pool, cp[cpCount - 1].getStartPos() + cp[cpCount - 1].getLength() - STARTPOS_constant_pool, "constant_pool"));
        this.root.add(constant_pool);
        for (int i = 1; i < cpCount; ++i) {
            DefaultMutableTreeNode cp_info;
            if (cp[i] != null) {
                cp_info = new DefaultMutableTreeNode(new JTreeNodeClassComponent(cp[i].getStartPos(), cp[i].getLength(), i + ". " + cp[i].getName()));
                JTreeCPInfo.generateTreeNode(cp_info, cp[i]);
            } else {
                cp_info = new DefaultMutableTreeNode(new JTreeNodeClassComponent(0, 0, i + ". [Empty Item]"));
            }
            constant_pool.add(cp_info);
            cp_info = null;
        }
    }

    private void generateClassDeclaration() throws InvalidTreeNodeException {
        StringBuilder sb = new StringBuilder();
        DefaultMutableTreeNode access_flags = new DefaultMutableTreeNode(new JTreeNodeClassComponent(this.classFile.getAccessFlags().getStartPos(), this.classFile.getAccessFlags().getLength(), "access_flags: " + this.classFile.getAccessFlags().getModifiers()));
        this.root.add(access_flags);
        sb.append("this_class: ");
        sb.append(this.classFile.getThisClass().getValue());
        sb.append(String.format(" - [%s]", this.classFile.getCPDescription(this.classFile.getThisClass().getValue())));
        DefaultMutableTreeNode this_class = new DefaultMutableTreeNode(new JTreeNodeClassComponent(this.classFile.getThisClass().getStartPos(), this.classFile.getThisClass().getLength(), sb.toString()));
        this.root.add(this_class);
        sb.setLength(0);
        sb.append("super_class: ");
        sb.append(this.classFile.getSuperClass().getValue());
        sb.append(String.format(" - [%s]", this.classFile.getCPDescription(this.classFile.getSuperClass().getValue())));
        DefaultMutableTreeNode super_class = new DefaultMutableTreeNode(new JTreeNodeClassComponent(this.classFile.getSuperClass().getStartPos(), this.classFile.getSuperClass().getLength(), sb.toString()));
        this.root.add(super_class);
        int interfaceCount = this.classFile.getInterfacesCount().getValue();
        DefaultMutableTreeNode interfaces_count = new DefaultMutableTreeNode(new JTreeNodeClassComponent(this.classFile.getInterfacesCount().getStartPos(), this.classFile.getInterfacesCount().getLength(), "interfaces_count: " + interfaceCount));
        this.root.add(interfaces_count);
        if (interfaceCount > 0) {
            Interface[] interfaces = this.classFile.getInterfaces();
            DefaultMutableTreeNode interfacesNode = new DefaultMutableTreeNode(new JTreeNodeClassComponent(interfaces[0].getStartPos(), interfaces[interfaceCount - 1].getStartPos() + interfaces[interfaceCount - 1].getLength() - interfaces[0].getStartPos(), "interfaces"));
            this.root.add(interfacesNode);
            for (int i = 0; i < interfaceCount; ++i) {
                sb.setLength(0);
                sb.append(i);
                sb.append(". ");
                sb.append(interfaces[i].getValue());
                sb.append(String.format(" - [%s]", this.classFile.getCPDescription(interfaces[i].getValue())));
                DefaultMutableTreeNode interfaceNode = new DefaultMutableTreeNode(new JTreeNodeClassComponent(interfaces[i].getStartPos(), interfaces[i].getLength(), sb.toString()));
                interfacesNode.add(interfaceNode);
                interfaceNode = null;
            }
        }
    }

    private void generateFields() throws InvalidTreeNodeException {
        int fieldCount = this.classFile.getFieldCount().getValue();
        DefaultMutableTreeNode fields_count = new DefaultMutableTreeNode(new JTreeNodeClassComponent(this.classFile.getFieldCount().getStartPos(), this.classFile.getFieldCount().getLength(), "fields_count: " + fieldCount));
        this.root.add(fields_count);
        if (fieldCount > 0) {
            FieldInfo[] fields = this.classFile.getFields();
            DefaultMutableTreeNode fieldsNode = new DefaultMutableTreeNode(new JTreeNodeClassComponent(fields[0].getStartPos(), fields[fieldCount - 1].getStartPos() + fields[fieldCount - 1].getLength() - fields[0].getStartPos(), "fields"));
            this.root.add(fieldsNode);
            for (int i = 0; i < fieldCount; ++i) {
                DefaultMutableTreeNode fieldNode = new DefaultMutableTreeNode(new JTreeNodeClassComponent(fields[i].getStartPos(), fields[i].getLength(), String.format("field %d: %s", i + 1, fields[i].getDeclaration())));
                JTreeField.generateTreeNode(fieldNode, fields[i]);
                fieldsNode.add(fieldNode);
                fieldNode = null;
            }
        }
    }

    private void generateMethods() throws InvalidTreeNodeException {
        int methodCount = this.classFile.getMethodCount().getValue();
        DefaultMutableTreeNode methods_count = new DefaultMutableTreeNode(new JTreeNodeClassComponent(this.classFile.getMethodCount().getStartPos(), this.classFile.getMethodCount().getLength(), "methods_count: " + methodCount));
        this.root.add(methods_count);
        if (methodCount > 0) {
            MethodInfo[] methods = this.classFile.getMethods();
            DefaultMutableTreeNode methodsNode = new DefaultMutableTreeNode(new JTreeNodeClassComponent(methods[0].getStartPos(), methods[methodCount - 1].getStartPos() + methods[methodCount - 1].getLength() - methods[0].getStartPos(), "methods"));
            this.root.add(methodsNode);
            for (int i = 0; i < methodCount; ++i) {
                DefaultMutableTreeNode methodNode = new DefaultMutableTreeNode(new JTreeNodeClassComponent(methods[i].getStartPos(), methods[i].getLength(), String.format("method %d: %s", i + 1, methods[i].getDeclaration())));
                JTreeMethod.generateTreeNode(methodNode, methods[i]);
                methodsNode.add(methodNode);
                methodNode = null;
            }
        }
    }

    private void generateAttributes() throws InvalidTreeNodeException {
        int attrCount = this.classFile.getAttributeCount().getValue();
        DefaultMutableTreeNode attrs_count = new DefaultMutableTreeNode(new JTreeNodeClassComponent(this.classFile.getAttributeCount().getStartPos(), this.classFile.getAttributeCount().getLength(), "attributes_count: " + attrCount));
        this.root.add(attrs_count);
        if (attrCount > 0) {
            AttributeInfo[] attrs = this.classFile.getAttributes();
            DefaultMutableTreeNode attrsNode = new DefaultMutableTreeNode(new JTreeNodeClassComponent(attrs[0].getStartPos(), attrs[attrCount - 1].getStartPos() + attrs[attrCount - 1].getLength() - attrs[0].getStartPos(), "attributes"));
            this.root.add(attrsNode);
            for (int i = 0; i < attrCount; ++i) {
                DefaultMutableTreeNode attrNode = new DefaultMutableTreeNode(new JTreeNodeClassComponent(attrs[i].getStartPos(), attrs[i].getLength(), i + ". " + attrs[i].getName()));
                JTreeAttribute.generateTreeNode(attrNode, attrs[i]);
                attrsNode.add(attrNode);
                attrNode = null;
            }
        }
    }
}

