/*
 * Decompiled with CFR 0.152.
 */
package org.freeinternals.classfile.ui;

import javax.swing.tree.DefaultMutableTreeNode;
import org.freeinternals.classfile.core.AttributeInfo;
import org.freeinternals.classfile.core.MethodInfo;
import org.freeinternals.classfile.ui.InvalidTreeNodeException;
import org.freeinternals.classfile.ui.JTreeAttribute;
import org.freeinternals.classfile.ui.JTreeNodeClassComponent;

final class JTreeMethod {
    private JTreeMethod() {
    }

    public static void generateTreeNode(DefaultMutableTreeNode rootNode, MethodInfo method_info) throws InvalidTreeNodeException {
        if (method_info == null) {
            return;
        }
        int startPos = method_info.getStartPos();
        int attributesCount = method_info.getAttributesCount();
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos, 2, "access_flags: " + method_info.getAccessFlags() + ", " + method_info.getModifiers())));
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 2, 2, "name_index: " + method_info.getNameIndex())));
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 4, 2, "descriptor_index: " + method_info.getDescriptorIndex())));
        rootNode.add(new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 6, 2, "attributes_count: " + attributesCount)));
        if (attributesCount > 0) {
            AttributeInfo lastAttr = method_info.getAttribute(attributesCount - 1);
            DefaultMutableTreeNode treeNodeAttr = new DefaultMutableTreeNode(new JTreeNodeClassComponent(startPos + 8, lastAttr.getStartPos() + lastAttr.getLength() - startPos - 8, "attributes"));
            for (int i = 0; i < attributesCount; ++i) {
                AttributeInfo attr = method_info.getAttribute(i);
                DefaultMutableTreeNode treeNodeAttrItem = new DefaultMutableTreeNode(new JTreeNodeClassComponent(attr.getStartPos(), attr.getLength(), String.format("%d. %s", i + 1, attr.getName())));
                JTreeAttribute.generateTreeNode(treeNodeAttrItem, attr);
                treeNodeAttr.add(treeNodeAttrItem);
                treeNodeAttrItem = null;
            }
            rootNode.add(treeNodeAttr);
        }
    }
}

