/*
 * Decompiled with CFR 0.152.
 */
package org.freeinternals.classfile.ui;

import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.freeinternals.classfile.ui.JTreeNodeZipFile;

public class JTreeZipFile
extends JTree {
    private static final long serialVersionUID = 4876543219876500000L;
    private final ZipFile zipFile;
    private DefaultMutableTreeNode root = null;

    public JTreeZipFile(ZipFile zipFile) {
        if (zipFile == null) {
            throw new IllegalArgumentException("zipFile cannot be null.");
        }
        this.zipFile = zipFile;
        this.generateTreeNodes();
        this.setModel(new DefaultTreeModel(this.root));
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    private void generateTreeNodes() {
        this.root = new DefaultMutableTreeNode(this.zipFile.getName());
        Enumeration<? extends ZipEntry> zipEntries = this.zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            this.addTreeNode(zipEntries.nextElement());
        }
    }

    private void addTreeNode(ZipEntry ze) {
        boolean isFolder = false;
        String nodePath = ze.getName();
        if (nodePath == null || nodePath.isEmpty()) {
            return;
        }
        if (nodePath.endsWith("/")) {
            isFolder = true;
            if ((nodePath = nodePath.substring(0, nodePath.length() - 1)).isEmpty()) {
                return;
            }
        }
        String[] nodePaths = nodePath.split("/");
        DefaultMutableTreeNode node = this.root;
        for (int i = 0; i < nodePaths.length; ++i) {
            node = i + 1 == nodePaths.length ? this.addTreeNode(node, nodePaths[i], isFolder, ze) : this.addTreeNode(node, nodePaths[i], isFolder, null);
        }
    }

    private DefaultMutableTreeNode addTreeNode(DefaultMutableTreeNode parent, String childText, boolean isFolder, ZipEntry ze) {
        if (parent == null) {
            throw new IllegalArgumentException("parent node cannot be null.");
        }
        if (childText == null || childText.isEmpty()) {
            throw new IllegalArgumentException("child node text cannot be null or empty.");
        }
        DefaultMutableTreeNode child = null;
        if (parent.isLeaf()) {
            child = new DefaultMutableTreeNode(new JTreeNodeZipFile(childText, ze));
            parent.add(child);
        } else {
            int childCount = parent.getChildCount();
            TreeNode childTreeNode = null;
            for (int i = 0; i < childCount; ++i) {
                childTreeNode = parent.getChildAt(i);
                if (!childText.equals(childTreeNode.toString()) || !(childTreeNode instanceof DefaultMutableTreeNode)) continue;
                child = (DefaultMutableTreeNode)childTreeNode;
            }
            if (child == null) {
                child = new DefaultMutableTreeNode(new JTreeNodeZipFile(childText, ze));
                parent.add(child);
            }
        }
        return child;
    }
}

