/*
 * Decompiled with CFR 0.152.
 */
package org.freeinternals.common.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class JPanelForTree
extends JPanel {
    private static final long serialVersionUID = 4876543219876500000L;
    private final JTree tree;
    private JToolBar toolbar;
    private JButton buttonExpand;
    private JButton buttonCollapse;

    public JPanelForTree(JTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException("[tree] cannot be null.");
        }
        this.tree = tree;
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                JPanelForTree.this.tree_SelectionChanged(evt);
            }
        });
        this.createToolbar();
        this.layoutComponents();
    }

    private void layoutComponents() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.toolbar);
        Component glue = Box.createGlue();
        glue.setMaximumSize(new Dimension(Short.MAX_VALUE, this.toolbar.getHeight()));
        panel.add(glue);
        this.add(panel);
        this.add(new JScrollPane(this.tree));
    }

    private void createToolbar() {
        this.toolbar = new JToolBar();
        this.toolbar.setRollover(true);
        JButton buttonExpandAll = new JButton("Expand All");
        buttonExpandAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPanelForTree.this.toolbar_ExpandAll();
            }
        });
        this.toolbar.add(buttonExpandAll);
        JButton buttonCollapseAll = new JButton("Collapse All");
        buttonCollapseAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPanelForTree.this.toolbar_CollapseAll();
            }
        });
        this.toolbar.add(buttonCollapseAll);
        this.buttonExpand = new JButton("Expand");
        this.buttonExpand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPanelForTree.this.toolbar_Expand();
            }
        });
        this.toolbar.add(this.buttonExpand);
        this.buttonCollapse = new JButton("Collapse");
        this.buttonCollapse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPanelForTree.this.toolbar_Collapse();
            }
        });
        this.toolbar.add(this.buttonCollapse);
    }

    private void toolbar_ExpandAll() {
        if (this.tree == null) {
            return;
        }
        int old = 0;
        int now = 0;
        do {
            old = this.tree.getRowCount();
            for (int i = 0; i < old; ++i) {
                this.tree.expandRow(i);
            }
        } while ((now = this.tree.getRowCount()) > old);
    }

    private void toolbar_CollapseAll() {
        if (this.tree == null) {
            return;
        }
        this.tree.collapseRow(0);
    }

    private void toolbar_Expand() {
        if (this.tree == null) {
            return;
        }
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        this.tree.expandPath(treePath);
    }

    private void toolbar_Collapse() {
        if (this.tree == null) {
            return;
        }
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        this.tree.collapsePath(treePath);
    }

    private void tree_SelectionChanged(TreeSelectionEvent e) {
        TreePath path = e.getPath();
        if (path == null) {
            return;
        }
    }
}

