/*
 * Decompiled with CFR 0.152.
 */
package com.gt;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JavaDependencyFinder
implements Runnable {
    private Hashtable m_jarsHash = new Hashtable();

    public JavaDependencyFinder(String[] stringArray) {
        if (stringArray.length == 1 && stringArray[0].startsWith("deps=")) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[0].substring(5), ",");
            while (stringTokenizer.hasMoreTokens()) {
                File file = new File(stringTokenizer.nextToken());
                if (file.exists() && file.isDirectory()) {
                    this.addAllJars(file);
                    continue;
                }
                System.err.println(file.getName() + " :: Cannot find this folder.");
            }
        } else {
            System.err.println("Usage: java -jar jdf.jar deps=<comma separated list of folders having all the jars/zips you'd like to include in your search>");
            System.exit(1);
        }
    }

    private void addAllJars(File file) {
        block6: {
            block5: {
                if (!file.isDirectory()) break block5;
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    this.addAllJars(fileArray[i]);
                }
                break block6;
            }
            if (!file.getName().toLowerCase().endsWith(".jar") && !file.getName().toLowerCase().endsWith(".zip")) break block6;
            try {
                JarFile jarFile = new JarFile(file);
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement().getName();
                    if (!string.endsWith(".class")) continue;
                    string = string.substring(0, string.indexOf("."));
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
                    String string2 = "";
                    while (stringTokenizer.hasMoreTokens()) {
                        string2 = string2 + stringTokenizer.nextToken() + ".";
                    }
                    string2 = string2.substring(0, string2.length() - 1);
                    this.m_jarsHash.put(string2, file.getCanonicalPath());
                }
                jarFile.close();
            }
            catch (IOException iOException) {
                System.err.println(file.getName() + " :: " + iOException.getMessage());
            }
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("Initializing Dependy finder...");
        JavaDependencyFinder javaDependencyFinder = new JavaDependencyFinder(stringArray);
        System.out.println("Ready. [Press CTRL+C to break]");
        new Thread(javaDependencyFinder).start();
    }

    public void run() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.out.print("\nEnter class to find: ");
        while (true) {
            try {
                while (true) {
                    String string;
                    if ((string = bufferedReader.readLine()) == null) {
                        continue;
                    }
                    String string2 = (String)this.m_jarsHash.get(string);
                    if (string2 != null) {
                        System.out.println("Found in jar: " + string2);
                    } else {
                        System.out.println("Class not found!");
                    }
                    System.out.print("\nEnter class to find: ");
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                continue;
            }
            break;
        }
    }
}

