/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.ElementIterator;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class LinksCollectEngine {
    private int maxurls = 2000;
    private int maxdomains = 100;
    private int index = 0;
    private String Initialwebpage = null;
    private int downloadedsize = 0;
    private long interval = 0L;
    private long start_time = 0L;
    private ArrayList linkpool;
    private Map<String, Integer> domainpool;
    private volatile boolean saveflag = false;
    private ipaddrmatch ipmatch = new ipaddrmatch();

    LinksCollectEngine() {
    }

    LinksCollectEngine(int max_urls, int max_domains, String Initial_webpage) {
        this.linkpool = new ArrayList();
        this.domainpool = new HashMap<String, Integer>();
        this.maxurls = max_urls;
        this.maxdomains = max_domains;
        this.Initialwebpage = Initial_webpage;
        this.insertlinks(this.Initialwebpage);
    }

    public String nexturl() {
        if (this.linkpool.size() < this.maxurls && this.domainpool.size() < this.maxdomains && this.index < this.linkpool.size() && !this.saveflag) {
            return this.linkpool.get(this.index++).toString();
        }
        return null;
    }

    public void parselinks(String baseurlstr) {
        if (baseurlstr.endsWith(".pdf")) {
            return;
        }
        URL baseurl = null;
        try {
            baseurl = new URL(baseurlstr);
        }
        catch (MalformedURLException e) {
            return;
        }
        String data = this.urldownload(baseurlstr);
        if (data == null || data.isEmpty()) {
            return;
        }
        this.downloadedsize += data.length();
        StringReader r = new StringReader(data);
        HTMLEditorKit htmlkit = new HTMLEditorKit();
        HTMLDocument htmldoc = new HTMLDocument();
        htmldoc.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        try {
            htmlkit.read(r, (Document)htmldoc, 0);
            ElementIterator docit = new ElementIterator(htmldoc);
            AbstractDocument.AbstractElement e = (AbstractDocument.AbstractElement)docit.next();
            while (e != null) {
                SimpleAttributeSet simple;
                Object href;
                Object o = e.getAttribute(HTML.Tag.A);
                if (o != null && (href = (simple = (SimpleAttributeSet)o).getAttribute(HTML.Attribute.HREF)) != null) {
                    if (this.domainpool.size() >= this.maxdomains || this.linkpool.size() >= this.maxurls) {
                        return;
                    }
                    URL url = new URL(baseurl, href.toString());
                    this.insertlinks(url.toString().trim());
                    this.insertdomain(url.getHost().trim());
                }
                e = (AbstractDocument.AbstractElement)docit.next();
                if (!this.saveflag) continue;
                break;
            }
        }
        catch (MalformedURLException e1) {
        }
        catch (Exception e) {
            System.err.println("engine parse html error");
        }
    }

    private void insertdomain(String d) {
        if (d.length() <= 0) {
            return;
        }
        if (d.equalsIgnoreCase("localhost")) {
            return;
        }
        if (d.equalsIgnoreCase("http")) {
            return;
        }
        if (this.ipmatch.validate(d)) {
            return;
        }
        if (this.domainpool.containsKey(d)) {
            int count = this.domainpool.get(d) + 1;
            this.domainpool.put(d, count);
        } else {
            try {
                InetAddress a = InetAddress.getByName(d);
                String name = a.getHostName();
                if (name == null || name.trim().length() <= 0) {
                    return;
                }
            }
            catch (IOException ex1) {
                return;
            }
            if (d.length() > 0) {
                this.domainpool.put(d, 1);
            }
        }
    }

    private void insertlinks(String l) {
        if (l.length() <= 0) {
            return;
        }
        if (l.startsWith("mailto:")) {
            return;
        }
        if (!this.linkpool.contains(l)) {
            boolean bl = this.linkpool.add(l);
        }
    }

    private String urldownload(String urlstr) {
        URL url = null;
        StringBuilder buf = new StringBuilder();
        try {
            url = new URL(urlstr);
        }
        catch (MalformedURLException e) {
            System.err.println(urlstr + " is illegal");
            return null;
        }
        try {
            String line = null;
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3000);
            BufferedReader bufreader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = bufreader.readLine()) != null) {
                buf.append(line);
                buf.append(System.getProperty("line.separator"));
            }
            bufreader.close();
        }
        catch (Exception e) {
            System.err.println("Reading/connecting " + urlstr + " is timeout");
            return null;
        }
        return buf.toString();
    }

    public void printresult() {
        Iterator<Map.Entry<String, Integer>> it = this.domainpool.entrySet().iterator();
        int max = 0;
        String name = null;
        while (it.hasNext()) {
            Map.Entry<String, Integer> e = it.next();
            int value = e.getValue();
            if (max >= value) continue;
            max = value;
            name = e.getKey();
        }
        System.out.println("the number of domains=" + this.domainpool.size() + "\nthe domain having the max links=" + max + "\n this domain is " + name + "\nthe downloaded data size is " + this.downloadedsize + "=" + this.downloadedsize / 1024 + "KB");
        System.out.println("the time is " + (double)this.interval / 1.0E9 + " seconds");
    }

    public void save(String defaultbackupfile) {
        this.interval += System.nanoTime() - this.start_time;
        try {
            FileOutputStream fos = new FileOutputStream(new File(defaultbackupfile));
            ObjectOutputStream out = new ObjectOutputStream(fos);
            out.writeObject(this.Initialwebpage);
            out.writeObject(this.domainpool);
            out.writeObject(String.valueOf(this.downloadedsize));
            out.writeObject(this.linkpool);
            out.writeObject(String.valueOf(this.index));
            out.writeObject(String.valueOf(this.maxdomains));
            out.writeObject(String.valueOf(this.maxurls));
            out.writeObject(String.valueOf(this.interval));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean restore(String defaultbackupfile) {
        try {
            FileInputStream fis = new FileInputStream(new File(defaultbackupfile));
            ObjectInputStream in = new ObjectInputStream(fis);
            this.Initialwebpage = (String)in.readObject();
            this.domainpool = (Map)in.readObject();
            this.downloadedsize = Integer.valueOf((String)in.readObject());
            this.linkpool = (ArrayList)in.readObject();
            this.index = Integer.valueOf((String)in.readObject());
            this.maxdomains = Integer.valueOf((String)in.readObject());
            this.maxurls = Integer.valueOf((String)in.readObject());
            this.interval = Long.valueOf((String)in.readObject());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void docollecting() {
        String urlnext;
        this.start_time = System.nanoTime();
        while ((urlnext = this.nexturl()) != null) {
            this.parselinks(urlnext);
        }
        this.interval += System.nanoTime() - this.start_time;
    }

    public String printresulttostring() {
        Iterator<Map.Entry<String, Integer>> it = this.domainpool.entrySet().iterator();
        int max = 0;
        String name = null;
        while (it.hasNext()) {
            Map.Entry<String, Integer> e = it.next();
            int value = e.getValue();
            if (max >= value) continue;
            max = value;
            name = e.getKey();
        }
        String res = "The number of non-duplicate links =" + this.linkpool.size() + "\nThe downloaded data size is " + this.downloadedsize + "=" + this.downloadedsize / 1024 + "KB" + "\nThe time is " + (double)this.interval / 1.0E9 + " seconds" + "\nThe domain having the max links=" + max + "\n is " + name;
        return res;
    }

    public int numlinks() {
        return this.linkpool.size();
    }

    public int numdomains() {
        return this.domainpool.size();
    }

    public int downloadeddata() {
        return this.downloadedsize;
    }

    public void setstarttime() {
        this.start_time = System.nanoTime();
    }

    public void setintervaltime() {
        this.interval += System.nanoTime() - this.start_time;
    }

    public String getalldomains() {
        Iterator<Map.Entry<String, Integer>> it = this.domainpool.entrySet().iterator();
        int num = 0;
        String alldomains = "";
        while (it.hasNext()) {
            Map.Entry<String, Integer> e = it.next();
            alldomains = alldomains + String.valueOf(++num) + " " + e.getKey().toString() + " " + ((Object)e.getValue()).toString() + "\n";
        }
        return alldomains;
    }

    public void setsaveflag() {
        this.saveflag = true;
    }

    public int getmaxnumdomains() {
        return this.maxdomains;
    }

    public int getmaxnumlinks() {
        return this.maxurls;
    }
}

