/*
 * Decompiled with CFR 0.152.
 */
package com.schwebke.awt.tools.display;

import com.schwebke.awt.tools.display.Bar;
import com.schwebke.awt.tools.display.HMoveTo;
import com.schwebke.awt.tools.display.NewLine;
import com.schwebke.awt.tools.display.Text;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class Display
extends JPanel {
    private static final RenderingHints rh = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    protected Dimension size;
    protected List content;
    protected double lineHeight;
    protected int baseIndent;

    public Display(Dimension size) {
        this.size = size;
        this.content = new ArrayList();
        this.lineHeight = 1.2;
        this.baseIndent = 5;
    }

    public Display(Dimension size, int baseIndent) {
        this.size = size;
        this.content = new ArrayList();
        this.lineHeight = 1.2;
        this.baseIndent = baseIndent;
    }

    public List getContent() {
        return this.content;
    }

    public void setContent(List content) {
        this.content = content;
    }

    @Override
    public void paint(Graphics gAwt) {
        Graphics2D g = (Graphics2D)gAwt;
        g.addRenderingHints(rh);
        int x = this.baseIndent;
        int y = 1;
        ArrayList line = new ArrayList();
        for (Object item : this.content) {
            if (item instanceof NewLine) {
                int vSkip = ((NewLine)item).getVSkip();
                x = this.baseIndent;
                y = (int)((double)y + this.lineHeight * (double)this.getSize(line).height);
                this.paintLine(g, line, x, y);
                y += vSkip;
                line = new ArrayList();
                continue;
            }
            line.add(item);
        }
        y = (int)((double)y + this.lineHeight * (double)this.getSize(line).height);
        this.paintLine(g, line, x, y);
    }

    protected void paintLine(Graphics g, List line, int x, int y) {
        for (Object item : line) {
            if (item instanceof Text) {
                Text t = (Text)item;
                g.setColor(t.getColor());
                g.setFont(t.getFont());
                g.drawString(t.getText(), x, y);
                x += this.getSize((Text)t).width;
            }
            if (item instanceof Bar) {
                Bar b = (Bar)item;
                g.setColor(b.getBorder());
                g.drawRect(x, y - b.getHeight(), b.getWidth(), b.getHeight());
                g.setColor(b.getBackground());
                g.fillRect(x + 1, y - b.getHeight() + 1, b.getWidth() - 1, b.getHeight() - 1);
                g.setColor(b.getFill());
                g.fillRect(x + 1, y - b.getHeight() + 1, (int)((double)(b.getWidth() - 1) * b.getRatio()), b.getHeight() - 1);
                x += b.getWidth() + b.getSpace();
            }
            if (!(item instanceof HMoveTo)) continue;
            x = ((HMoveTo)item).getHPos() + this.baseIndent;
        }
    }

    protected Dimension getSize(Text t) {
        FontMetrics fm = this.getFontMetrics(t.getFont());
        return new Dimension(fm.stringWidth(t.text), fm.getHeight());
    }

    protected Dimension getSize(List line) {
        int height = 0;
        int width = 0;
        for (Object item : line) {
            Dimension size = null;
            if (item instanceof Text) {
                size = this.getSize((Text)item);
            }
            if (size == null) continue;
            if (size.height > height) {
                height = size.height;
            }
            width += size.width;
        }
        return new Dimension(width, height);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.size;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.size;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.size;
    }

    static {
        rh.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
    }
}

