/*
 * Decompiled with CFR 0.152.
 */
package com.schwebke.jbeam;

import com.schwebke.jbeam.JBeam;
import com.schwebke.jbeam.model.EBBeam;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.PropertyResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DlgEBBeam
extends JDialog
implements ActionListener {
    private EBBeam beam;
    private JCheckBox hNi;
    private JCheckBox hVi;
    private JCheckBox hMi;
    private JCheckBox hNk;
    private JCheckBox hVk;
    private JCheckBox hMk;
    private JTextField EI;
    private JTextField EA;
    private JTextField m;
    private JTextField vi;
    private JTextField vk;
    private JTextField ni;
    private JTextField nk;
    private JTextField label;
    private boolean OK;

    public DlgEBBeam(Frame parent, EBBeam beam) {
        super(parent, "EB Beam", true);
        try {
            PropertyResourceBundle locale = new PropertyResourceBundle(JBeam.getResourceAsStream("locale.txt"));
            this.beam = beam;
            Container dlg = this.getContentPane();
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(2, 2, 2, 2);
            dlg.setLayout(gb);
            c.fill = 1;
            c.gridwidth = 0;
            c.weightx = 1.0;
            this.hNi = new JCheckBox("Ni " + locale.getString("DlgEBBeamHinge"), beam.getHinge(0));
            this.hVi = new JCheckBox("Vi " + locale.getString("DlgEBBeamHinge"), beam.getHinge(1));
            this.hMi = new JCheckBox("Mi " + locale.getString("DlgEBBeamHinge"), beam.getHinge(2));
            this.hNk = new JCheckBox("Nk " + locale.getString("DlgEBBeamHinge"), beam.getHinge(3));
            this.hVk = new JCheckBox("Vk " + locale.getString("DlgEBBeamHinge"), beam.getHinge(4));
            this.hMk = new JCheckBox("Mk " + locale.getString("DlgEBBeamHinge"), beam.getHinge(5));
            gb.setConstraints(this.hNi, c);
            dlg.add(this.hNi);
            gb.setConstraints(this.hVi, c);
            dlg.add(this.hVi);
            gb.setConstraints(this.hMi, c);
            dlg.add(this.hMi);
            gb.setConstraints(this.hNk, c);
            dlg.add(this.hNk);
            gb.setConstraints(this.hVk, c);
            dlg.add(this.hVk);
            gb.setConstraints(this.hMk, c);
            dlg.add(this.hMk);
            this.EI = new JTextField(String.valueOf(beam.getEI()));
            this.EA = new JTextField(String.valueOf(beam.getEA()));
            this.m = new JTextField(String.valueOf(beam.getM()));
            this.vi = new JTextField(String.valueOf(beam.getVi()));
            this.vk = new JTextField(String.valueOf(beam.getVk()));
            this.ni = new JTextField(String.valueOf(beam.getNi()));
            this.nk = new JTextField(String.valueOf(beam.getNk()));
            this.label = new JTextField(beam.getLabel());
            JLabel l = new JLabel(locale.getString("DlgEBBeamEI"));
            c.weightx = 0.2;
            c.gridwidth = -1;
            gb.setConstraints(l, c);
            dlg.add(l);
            c.weightx = 1.0;
            c.gridwidth = 0;
            gb.setConstraints(this.EI, c);
            dlg.add(this.EI);
            l = new JLabel(locale.getString("DlgEBBeamEA"));
            c.weightx = 0.2;
            c.gridwidth = -1;
            gb.setConstraints(l, c);
            dlg.add(l);
            c.weightx = 1.0;
            c.gridwidth = 0;
            gb.setConstraints(this.EA, c);
            dlg.add(this.EA);
            l = new JLabel(locale.getString("DlgM"));
            c.weightx = 0.2;
            c.gridwidth = -1;
            gb.setConstraints(l, c);
            dlg.add(l);
            c.weightx = 1.0;
            c.gridwidth = 0;
            gb.setConstraints(this.m, c);
            dlg.add(this.m);
            l = new JLabel("vi");
            c.weightx = 0.2;
            c.gridwidth = -1;
            gb.setConstraints(l, c);
            dlg.add(l);
            c.weightx = 1.0;
            c.gridwidth = 0;
            gb.setConstraints(this.vi, c);
            dlg.add(this.vi);
            l = new JLabel("vk");
            c.weightx = 0.2;
            c.gridwidth = -1;
            gb.setConstraints(l, c);
            dlg.add(l);
            c.weightx = 1.0;
            c.gridwidth = 0;
            gb.setConstraints(this.vk, c);
            dlg.add(this.vk);
            l = new JLabel("ni");
            c.weightx = 0.2;
            c.gridwidth = -1;
            gb.setConstraints(l, c);
            dlg.add(l);
            c.weightx = 1.0;
            c.gridwidth = 0;
            gb.setConstraints(this.ni, c);
            dlg.add(this.ni);
            l = new JLabel("nk");
            c.weightx = 0.2;
            c.gridwidth = -1;
            gb.setConstraints(l, c);
            dlg.add(l);
            c.weightx = 1.0;
            c.gridwidth = 0;
            gb.setConstraints(this.nk, c);
            dlg.add(this.nk);
            l = new JLabel(locale.getString("DlgLabel"));
            c.weightx = 0.2;
            c.gridwidth = -1;
            gb.setConstraints(l, c);
            dlg.add(l);
            c.weightx = 1.0;
            c.gridwidth = 0;
            gb.setConstraints(this.label, c);
            dlg.add(this.label);
            JPanel bbar = new JPanel();
            JButton button = new JButton(locale.getString("DlgOK"));
            button.addActionListener(this);
            bbar.add(button);
            button = new JButton(locale.getString("DlgCancel"));
            button.addActionListener(this);
            bbar.add(button);
            gb.setConstraints(bbar, c);
            dlg.add(bbar);
            if (parent != null) {
                this.setLocation(parent.getLocation().x + 100, parent.getLocation().y + 100);
            } else {
                this.setLocation(300, 200);
            }
            this.setResizable(false);
            this.pack();
            this.setVisible(true);
        }
        catch (Exception e) {
            System.out.println("DlgEBBeam build error: " + e.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        boolean canClose = true;
        this.OK = false;
        if (event.getActionCommand().equals("OK")) {
            this.OK = true;
            this.beam.setHinge(0, this.hNi.isSelected());
            this.beam.setHinge(1, this.hVi.isSelected());
            this.beam.setHinge(2, this.hMi.isSelected());
            this.beam.setHinge(3, this.hNk.isSelected());
            this.beam.setHinge(4, this.hVk.isSelected());
            this.beam.setHinge(5, this.hMk.isSelected());
            this.beam.setLabel(this.label.getText());
            try {
                this.beam.setEI(new Double(this.EI.getText()));
                this.beam.setEA(new Double(this.EA.getText()));
                this.beam.setM(new Double(this.m.getText()));
                this.beam.setVi(new Double(this.vi.getText()));
                this.beam.setVk(new Double(this.vk.getText()));
                this.beam.setNi(new Double(this.ni.getText()));
                this.beam.setNk(new Double(this.nk.getText()));
            }
            catch (NumberFormatException e) {
                canClose = false;
                JOptionPane.showMessageDialog(null, "Please enter a valid number", "Number Format Error", 0);
            }
        }
        if (canClose) {
            this.setVisible(false);
            this.dispose();
        }
    }

    public boolean getOK() {
        return this.OK;
    }
}

