/*
 * Decompiled with CFR 0.152.
 */
package com.schwebke.jbeam;

import com.schwebke.jbeam.JBeam;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.PropertyResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DlgGrid
extends JDialog
implements ActionListener {
    private JBeam controller;
    private JTextField vGrid;
    private JTextField sGrid;
    private JTextField checkR;

    public DlgGrid(Frame parent, JBeam controller) {
        super(parent, "Grid", true);
        this.controller = controller;
        try {
            PropertyResourceBundle locale = new PropertyResourceBundle(JBeam.getResourceAsStream("locale.txt"));
            Container dlg = this.getContentPane();
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(2, 2, 2, 2);
            c.fill = 1;
            dlg.setLayout(gb);
            this.vGrid = new JTextField(String.valueOf(controller.view.getGrid()));
            JLabel l = new JLabel(locale.getString("DlgGridVisibleGrid"));
            c.weightx = 0.2;
            c.gridwidth = -1;
            gb.setConstraints(l, c);
            dlg.add(l);
            c.weightx = 1.0;
            c.gridwidth = 0;
            gb.setConstraints(this.vGrid, c);
            dlg.add(this.vGrid);
            this.sGrid = new JTextField(String.valueOf(controller.grid));
            l = new JLabel(locale.getString("DlgGridSnapGrid"));
            c.weightx = 0.2;
            c.gridwidth = -1;
            gb.setConstraints(l, c);
            dlg.add(l);
            c.weightx = 1.0;
            c.gridwidth = 0;
            gb.setConstraints(this.sGrid, c);
            dlg.add(this.sGrid);
            this.checkR = new JTextField(String.valueOf(controller.checkR));
            l = new JLabel(locale.getString("DlgGridCheckRadius"));
            c.weightx = 0.2;
            c.gridwidth = -1;
            gb.setConstraints(l, c);
            dlg.add(l);
            c.weightx = 1.0;
            c.gridwidth = 0;
            gb.setConstraints(this.checkR, c);
            dlg.add(this.checkR);
            JPanel bbar = new JPanel();
            JButton button = new JButton(locale.getString("DlgOK"));
            button.addActionListener(this);
            bbar.add(button);
            button = new JButton(locale.getString("DlgCancel"));
            button.addActionListener(this);
            bbar.add(button);
            gb.setConstraints(bbar, c);
            dlg.add(bbar);
            if (parent != null) {
                this.setLocation(parent.getLocation().x + 100, parent.getLocation().y + 100);
            } else {
                this.setLocation(300, 200);
            }
            this.setResizable(false);
            this.pack();
            this.setVisible(true);
        }
        catch (Exception e) {
            System.out.println("DlgGrid build error: " + e.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        boolean canClose = true;
        if (event.getActionCommand().equals("OK")) {
            try {
                this.controller.grid = new Double(this.sGrid.getText());
                this.controller.view.setGrid(new Double(this.vGrid.getText()));
                this.controller.checkR = new Integer(this.checkR.getText());
                if (this.controller.checkR < 0) {
                    throw new NumberFormatException();
                }
                if (this.controller.grid < 0.0) {
                    throw new NumberFormatException();
                }
                if (this.controller.view.getGrid() < 0.0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                canClose = false;
                JOptionPane.showMessageDialog(null, "Please enter a valid number", "Number Format Error", 0);
            }
        }
        if (canClose) {
            this.setVisible(false);
            this.dispose();
        }
    }
}

