/*
 * Decompiled with CFR 0.152.
 */
package com.schwebke.jbeam;

import com.schwebke.awt.tools.display.Display;
import com.schwebke.awt.tools.display.HMoveTo;
import com.schwebke.awt.tools.display.NewLine;
import com.schwebke.awt.tools.display.Text;
import com.schwebke.jbeam.JBeam;
import com.schwebke.jbeam.model.EBBeam;
import com.schwebke.jbeam.model.EBSBeam;
import com.schwebke.jbeam.model.Model;
import com.schwebke.jbeam.model.Node;
import com.schwebke.jbeam.model.Truss;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.PropertyResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class DlgInfo
extends JDialog
implements ActionListener {
    public DlgInfo(JBeam jbeam, JFrame parent, Model model, Object obj) {
        super(parent, "Info", true);
        try {
            Text t;
            PropertyResourceBundle locale = new PropertyResourceBundle(JBeam.getResourceAsStream("locale.txt"));
            Container content = this.getContentPane();
            content.setLayout(new BorderLayout());
            Display display = new Display(new Dimension(300, 400));
            List info = display.getContent();
            Font ues = new Font("SansSerif", 1, 14);
            Font sues = new Font("SansSerif", 0, 12);
            HMoveTo tab1 = new HMoveTo(90);
            if (obj instanceof Node) {
                Node node = (Node)obj;
                t = new Text(locale.getString("DlgInfoNode"));
                t.setFont(ues);
                info.add(t);
                if (!node.getLabel().equals("")) {
                    t.setText(t.getText() + " " + node.getLabel());
                }
                if (model.getValidCalculation()) {
                    if (!(node.getCX() && node.getCZ() && node.getCR())) {
                        info.add(new NewLine(4));
                        t = new Text(locale.getString("DlgInfoDisplacements"));
                        info.add(t);
                        t.setFont(sues);
                        if (!node.getCX()) {
                            info.add(new NewLine());
                            info.add(new Text("dX"));
                            info.add(tab1);
                            info.add(new Text(jbeam.format(node.getDX())));
                        }
                        if (!node.getCZ()) {
                            info.add(new NewLine());
                            info.add(new Text("dZ"));
                            info.add(tab1);
                            info.add(new Text(jbeam.format(node.getDZ())));
                        }
                        if (!node.getCR()) {
                            info.add(new NewLine());
                            info.add(new Text("dR"));
                            info.add(tab1);
                            info.add(new Text(jbeam.format(node.getDR())));
                        }
                    }
                    if (node.getCX() || node.getCZ() || node.getCR()) {
                        info.add(new NewLine(4));
                        t = new Text(locale.getString("DlgInfoSupportReactions"));
                        info.add(t);
                        t.setFont(sues);
                        if (node.getCX()) {
                            info.add(new NewLine());
                            info.add(new Text("Fx"));
                            info.add(tab1);
                            info.add(new Text(jbeam.format(node.getRFx())));
                        }
                        if (node.getCZ()) {
                            info.add(new NewLine());
                            info.add(new Text("Fz"));
                            info.add(tab1);
                            info.add(new Text(jbeam.format(node.getRFz())));
                        }
                        if (node.getCR()) {
                            info.add(new NewLine());
                            info.add(new Text("M"));
                            info.add(tab1);
                            info.add(new Text(jbeam.format(node.getRM())));
                        }
                    }
                } else {
                    info.add(new NewLine());
                    info.add(new Text(locale.getString("DlgInfoNoResults")));
                }
            }
            if (obj instanceof Truss) {
                Truss truss = (Truss)obj;
                t = new Text(locale.getString("DlgInfoTruss"));
                t.setFont(ues);
                info.add(t);
                if (model.getValidCalculation()) {
                    info.add(new NewLine(4));
                    t = new Text(locale.getString("DlgInfoNormalForces"));
                    info.add(t);
                    t.setFont(sues);
                    info.add(new NewLine());
                    info.add(new Text("N1"));
                    info.add(tab1);
                    info.add(new Text(jbeam.format(truss.N(0.0))));
                    info.add(new NewLine());
                    info.add(new Text("N2"));
                    info.add(tab1);
                    info.add(new Text(jbeam.format(truss.N(1.0))));
                } else {
                    info.add(new NewLine());
                    info.add(new Text(locale.getString("DlgInfoNoResults")));
                }
            }
            if (obj instanceof EBBeam) {
                EBBeam beam = (EBBeam)obj;
                EBSBeam beams = null;
                Text t2 = new Text(locale.getString("DlgInfoEBBeam"));
                if (obj instanceof EBSBeam) {
                    t2 = new Text(locale.getString("DlgInfoEBSBeam"));
                    beams = (EBSBeam)obj;
                }
                t2.setFont(ues);
                info.add(t2);
                if (model.getValidCalculation()) {
                    info.add(new NewLine(4));
                    t2 = new Text(locale.getString("DlgInfoDisplacements"));
                    info.add(t2);
                    t2.setFont(sues);
                    info.add(new NewLine());
                    info.add(new Text("dX1"));
                    info.add(tab1);
                    info.add(new Text(jbeam.format(beam.getV(0))));
                    info.add(new NewLine());
                    info.add(new Text("dZ1"));
                    info.add(tab1);
                    info.add(new Text(jbeam.format(beam.getV(1))));
                    info.add(new NewLine());
                    info.add(new Text("dR1"));
                    info.add(tab1);
                    info.add(new Text(jbeam.format(beam.getV(2))));
                    info.add(new NewLine());
                    info.add(new Text("dX2"));
                    info.add(tab1);
                    info.add(new Text(jbeam.format(beam.getV(3))));
                    info.add(new NewLine());
                    info.add(new Text("dZ2"));
                    info.add(tab1);
                    info.add(new Text(jbeam.format(beam.getV(4))));
                    info.add(new NewLine());
                    info.add(new Text("dR2"));
                    info.add(tab1);
                    info.add(new Text(jbeam.format(beam.getV(5))));
                    if (beams != null) {
                        double fMaxDis = beams.fDisplaceMax();
                        double maxDis = beams.displace(fMaxDis);
                        double fMinDis = beams.fDisplaceMin();
                        double minDis = beams.displace(fMinDis);
                        info.add(new NewLine());
                        info.add(new Text(locale.getString("DlgInfoMaxDisplace")));
                        info.add(tab1);
                        info.add(new Text(jbeam.format(maxDis) + " " + locale.getString("DlgInfoAt") + " " + jbeam.format(fMaxDis * beam.getL())));
                        info.add(new NewLine());
                        info.add(new Text(locale.getString("DlgInfoMinDisplace")));
                        info.add(tab1);
                        info.add(new Text(jbeam.format(minDis) + " " + locale.getString("DlgInfoAt") + " " + jbeam.format(fMinDis * beam.getL())));
                    }
                    info.add(new NewLine(4));
                    t2 = new Text(locale.getString("DlgInfoMoments"));
                    info.add(t2);
                    t2.setFont(sues);
                    info.add(new NewLine());
                    info.add(new Text("M1"));
                    info.add(tab1);
                    info.add(new Text(jbeam.format(beam.M(0.0))));
                    info.add(new NewLine());
                    info.add(new Text("M2"));
                    info.add(tab1);
                    info.add(new Text(jbeam.format(beam.M(1.0))));
                    double fMinM = beam.fMinM();
                    double fMaxM = beam.fMaxM();
                    info.add(new NewLine());
                    info.add(new Text("Mmin"));
                    info.add(tab1);
                    info.add(new Text(jbeam.format(beam.M(fMinM)) + " " + locale.getString("DlgInfoAt") + " " + jbeam.format(fMinM * beam.getL())));
                    info.add(new NewLine());
                    info.add(new Text("Mmax"));
                    info.add(tab1);
                    info.add(new Text(jbeam.format(beam.M(fMaxM)) + " " + locale.getString("DlgInfoAt") + " " + jbeam.format(fMaxM * beam.getL())));
                    info.add(new NewLine(4));
                    t2 = new Text(locale.getString("DlgInfoShearForces"));
                    info.add(t2);
                    t2.setFont(sues);
                    info.add(new NewLine());
                    info.add(new Text("V1"));
                    info.add(tab1);
                    info.add(new Text(jbeam.format(beam.V(0.0))));
                    info.add(new NewLine());
                    info.add(new Text("V2"));
                    info.add(tab1);
                    info.add(new Text(jbeam.format(beam.V(1.0))));
                    double fMinV = beam.fMinV();
                    double fMaxV = beam.fMaxV();
                    info.add(new NewLine());
                    info.add(new Text("Vmin"));
                    info.add(tab1);
                    info.add(new Text(jbeam.format(beam.V(fMinV)) + " " + locale.getString("DlgInfoAt") + " " + jbeam.format(fMinV * beam.getL())));
                    info.add(new NewLine());
                    info.add(new Text("Vmax"));
                    info.add(tab1);
                    info.add(new Text(jbeam.format(beam.V(fMaxV)) + " " + locale.getString("DlgInfoAt") + " " + jbeam.format(fMaxV * beam.getL())));
                    info.add(new NewLine(4));
                    t2 = new Text(locale.getString("DlgInfoNormalForces"));
                    info.add(t2);
                    t2.setFont(sues);
                    info.add(new NewLine());
                    info.add(new Text("N1"));
                    info.add(tab1);
                    info.add(new Text(jbeam.format(beam.N(0.0))));
                    info.add(new NewLine());
                    info.add(new Text("N2"));
                    info.add(tab1);
                    info.add(new Text(jbeam.format(beam.N(1.0))));
                } else {
                    info.add(new NewLine());
                    info.add(new Text(locale.getString("DlgInfoNoResults")));
                }
            }
            content.add((Component)display, "Center");
            JPanel bbar = new JPanel();
            bbar.setLayout(new GridLayout(0, 1));
            JButton button = new JButton(locale.getString("DlgOK"));
            button.addActionListener(this);
            bbar.add(button);
            content.add((Component)bbar, "South");
            if (parent != null) {
                this.setLocation(parent.getLocation().x + 100, parent.getLocation().y + 100);
            } else {
                this.setLocation(300, 200);
            }
            this.setResizable(false);
            this.pack();
            this.setSize(350, this.getSize().height);
            this.setVisible(true);
        }
        catch (Exception e) {
            System.out.println("DlgInfo build error: " + e.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        boolean canClose = true;
        if (event.getActionCommand().equals("OK")) {
            // empty if block
        }
        if (canClose) {
            this.setVisible(false);
            this.dispose();
        }
    }
}

