/*
 * Decompiled with CFR 0.152.
 */
package com.schwebke.jbeam;

import com.schwebke.jbeam.JBeam;
import com.schwebke.jbeam.model.Node;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.PropertyResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DlgNode
extends JDialog
implements ActionListener {
    private Node node;
    private JCheckBox cX;
    private JCheckBox cZ;
    private JCheckBox cR;
    private JTextField x;
    private JTextField z;
    private JTextField Fx;
    private JTextField Fz;
    private JTextField M;
    private JTextField label;
    private boolean OK;

    public DlgNode(Frame parent, Node node) {
        super(parent, "Edit Node", true);
        try {
            PropertyResourceBundle locale = new PropertyResourceBundle(JBeam.getResourceAsStream("locale.txt"));
            this.node = node;
            Container dlg = this.getContentPane();
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(2, 2, 2, 2);
            dlg.setLayout(gb);
            c.fill = 1;
            c.gridwidth = 0;
            c.weightx = 1.0;
            this.cX = new JCheckBox(locale.getString("DlgNodeCX"), node.getCX());
            this.cZ = new JCheckBox(locale.getString("DlgNodeCZ"), node.getCZ());
            this.cR = new JCheckBox(locale.getString("DlgNodeCR"), node.getCR());
            gb.setConstraints(this.cX, c);
            dlg.add(this.cX);
            gb.setConstraints(this.cZ, c);
            dlg.add(this.cZ);
            gb.setConstraints(this.cR, c);
            dlg.add(this.cR);
            this.x = new JTextField(String.valueOf(node.getX()));
            this.z = new JTextField(String.valueOf(node.getZ()));
            this.Fx = new JTextField(String.valueOf(node.getFx()));
            this.Fz = new JTextField(String.valueOf(node.getFz()));
            this.M = new JTextField(String.valueOf(node.getM()));
            this.label = new JTextField(node.getLabel());
            JLabel l = new JLabel("X");
            c.weightx = 0.2;
            c.gridwidth = -1;
            gb.setConstraints(l, c);
            dlg.add(l);
            c.weightx = 1.0;
            c.gridwidth = 0;
            gb.setConstraints(this.x, c);
            dlg.add(this.x);
            l = new JLabel("Z");
            c.weightx = 0.2;
            c.gridwidth = -1;
            gb.setConstraints(l, c);
            dlg.add(l);
            c.weightx = 1.0;
            c.gridwidth = 0;
            gb.setConstraints(this.z, c);
            dlg.add(this.z);
            l = new JLabel(locale.getString("DlgNodeForceX"));
            c.weightx = 0.2;
            c.gridwidth = -1;
            gb.setConstraints(l, c);
            dlg.add(l);
            c.weightx = 1.0;
            c.gridwidth = 0;
            gb.setConstraints(this.Fx, c);
            dlg.add(this.Fx);
            l = new JLabel(locale.getString("DlgNodeForceZ"));
            c.weightx = 0.2;
            c.gridwidth = -1;
            gb.setConstraints(l, c);
            dlg.add(l);
            c.weightx = 1.0;
            c.gridwidth = 0;
            gb.setConstraints(this.Fz, c);
            dlg.add(this.Fz);
            l = new JLabel(locale.getString("DlgNodeMoment"));
            c.weightx = 0.2;
            c.gridwidth = -1;
            gb.setConstraints(l, c);
            dlg.add(l);
            c.weightx = 1.0;
            c.gridwidth = 0;
            gb.setConstraints(this.M, c);
            dlg.add(this.M);
            l = new JLabel(locale.getString("DlgLabel"));
            c.weightx = 0.2;
            c.gridwidth = -1;
            gb.setConstraints(l, c);
            dlg.add(l);
            c.weightx = 1.0;
            c.gridwidth = 0;
            gb.setConstraints(this.label, c);
            dlg.add(this.label);
            JPanel bbar = new JPanel();
            JButton button = new JButton(locale.getString("DlgOK"));
            button.addActionListener(this);
            bbar.add(button);
            button = new JButton(locale.getString("DlgCancel"));
            button.addActionListener(this);
            bbar.add(button);
            gb.setConstraints(bbar, c);
            dlg.add(bbar);
            if (parent != null) {
                this.setLocation(parent.getLocation().x + 100, parent.getLocation().y + 100);
            } else {
                this.setLocation(300, 200);
            }
            this.setResizable(false);
            this.pack();
            this.setVisible(true);
        }
        catch (Exception e) {
            System.out.println("DlgNode build error: " + e.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        boolean canClose = true;
        this.OK = false;
        if (event.getActionCommand().equals("OK")) {
            this.OK = true;
            this.node.setCX(this.cX.isSelected());
            this.node.setCZ(this.cZ.isSelected());
            this.node.setCR(this.cR.isSelected());
            this.node.setLabel(this.label.getText());
            try {
                this.node.setX(new Double(this.x.getText()));
                this.node.setZ(new Double(this.z.getText()));
                this.node.setFx(new Double(this.Fx.getText()));
                this.node.setFz(new Double(this.Fz.getText()));
                this.node.setM(new Double(this.M.getText()));
            }
            catch (NumberFormatException e) {
                canClose = false;
                JOptionPane.showMessageDialog(null, "Please enter a valid number", "Number Format Error", 0);
            }
        }
        if (canClose) {
            this.setVisible(false);
            this.dispose();
        }
    }

    public boolean getOK() {
        return this.OK;
    }
}

