/*
 * Decompiled with CFR 0.152.
 */
package com.schwebke.jbeam;

import com.schwebke.jbeam.JBeam;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.PropertyResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DlgSectionalVals
extends JDialog
implements ActionListener {
    private JBeam controller;
    private JTextField EA;
    private JTextField EI;
    private JTextField GAs;
    private JTextField m;

    public DlgSectionalVals(Frame parent, JBeam controller) {
        super(parent, "Sectional vals", true);
        try {
            PropertyResourceBundle locale = new PropertyResourceBundle(JBeam.getResourceAsStream("locale.txt"));
            this.controller = controller;
            Container dlg = this.getContentPane();
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(2, 2, 2, 2);
            c.fill = 1;
            dlg.setLayout(gb);
            this.EA = new JTextField(String.valueOf(controller.EA));
            JLabel l = new JLabel(locale.getString("DlgSecValsDefaultEA"));
            c.weightx = 0.2;
            c.gridwidth = -1;
            gb.setConstraints(l, c);
            dlg.add(l);
            c.weightx = 1.0;
            c.gridwidth = 0;
            gb.setConstraints(this.EA, c);
            dlg.add(this.EA);
            this.EI = new JTextField(String.valueOf(controller.EI));
            l = new JLabel(locale.getString("DlgSecValsDefaultEI"));
            c.weightx = 0.2;
            c.gridwidth = -1;
            gb.setConstraints(l, c);
            dlg.add(l);
            c.weightx = 1.0;
            c.gridwidth = 0;
            gb.setConstraints(this.EI, c);
            dlg.add(this.EI);
            this.GAs = new JTextField(String.valueOf(controller.GAs));
            l = new JLabel(locale.getString("DlgSecValsDefaultGAs"));
            c.weightx = 0.2;
            c.gridwidth = -1;
            gb.setConstraints(l, c);
            dlg.add(l);
            c.weightx = 1.0;
            c.gridwidth = 0;
            gb.setConstraints(this.GAs, c);
            dlg.add(this.GAs);
            this.m = new JTextField(String.valueOf(controller.m));
            l = new JLabel(locale.getString("DlgSecValsDefaultM"));
            c.weightx = 0.2;
            c.gridwidth = -1;
            gb.setConstraints(l, c);
            dlg.add(l);
            c.weightx = 1.0;
            c.gridwidth = 0;
            gb.setConstraints(this.m, c);
            dlg.add(this.m);
            JPanel bbar = new JPanel();
            JButton button = new JButton(locale.getString("DlgOK"));
            button.addActionListener(this);
            bbar.add(button);
            button = new JButton(locale.getString("DlgCancel"));
            button.addActionListener(this);
            bbar.add(button);
            gb.setConstraints(bbar, c);
            dlg.add(bbar);
            if (parent != null) {
                this.setLocation(parent.getLocation().x + 100, parent.getLocation().y + 100);
            } else {
                this.setLocation(300, 200);
            }
            this.setResizable(false);
            this.pack();
            this.setVisible(true);
        }
        catch (Exception e) {
            System.out.println("DlgSectionalVals build error: " + e.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        boolean canClose = true;
        if (event.getActionCommand().equals("OK")) {
            try {
                this.controller.EA = new Double(this.EA.getText());
                this.controller.EI = new Double(this.EI.getText());
                this.controller.GAs = new Double(this.GAs.getText());
                this.controller.m = new Double(this.m.getText());
            }
            catch (NumberFormatException e) {
                canClose = false;
                JOptionPane.showMessageDialog(null, "Please enter a valid number", "Number Format Error", 0);
            }
        }
        if (canClose) {
            this.setVisible(false);
            this.dispose();
        }
    }
}

