/*
 * Decompiled with CFR 0.152.
 */
package com.schwebke.jbeam;

import com.schwebke.jbeam.JBeam;
import com.schwebke.jbeam.model.Truss;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.PropertyResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DlgTruss
extends JDialog
implements ActionListener {
    private Truss truss;
    private JTextField EA;
    private JTextField m;
    private JTextField label;
    private boolean OK;

    public DlgTruss(Frame parent, Truss truss) {
        super(parent, "Edit Truss", true);
        try {
            PropertyResourceBundle locale = new PropertyResourceBundle(JBeam.getResourceAsStream("locale.txt"));
            this.truss = truss;
            Container dlg = this.getContentPane();
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(2, 2, 2, 2);
            c.fill = 1;
            dlg.setLayout(gb);
            this.EA = new JTextField(String.valueOf(truss.getEA()));
            this.m = new JTextField(String.valueOf(truss.getM()));
            this.label = new JTextField(truss.getLabel());
            JLabel l = new JLabel(locale.getString("DlgTrussEA"));
            c.weightx = 0.2;
            c.gridwidth = -1;
            gb.setConstraints(l, c);
            dlg.add(l);
            c.weightx = 1.0;
            c.gridwidth = 0;
            gb.setConstraints(this.EA, c);
            dlg.add(this.EA);
            l = new JLabel(locale.getString("DlgM"));
            c.weightx = 0.2;
            c.gridwidth = -1;
            gb.setConstraints(l, c);
            dlg.add(l);
            c.weightx = 1.0;
            c.gridwidth = 0;
            gb.setConstraints(this.m, c);
            dlg.add(this.m);
            l = new JLabel(locale.getString("DlgLabel"));
            c.weightx = 0.2;
            c.gridwidth = -1;
            gb.setConstraints(l, c);
            dlg.add(l);
            c.weightx = 1.0;
            c.gridwidth = 0;
            gb.setConstraints(this.label, c);
            dlg.add(this.label);
            JPanel bbar = new JPanel();
            JButton button = new JButton(locale.getString("DlgOK"));
            button.addActionListener(this);
            bbar.add(button);
            button = new JButton(locale.getString("DlgCancel"));
            button.addActionListener(this);
            bbar.add(button);
            gb.setConstraints(bbar, c);
            dlg.add(bbar);
            if (parent != null) {
                this.setLocation(parent.getLocation().x + 100, parent.getLocation().y + 100);
            } else {
                this.setLocation(300, 200);
            }
            this.setResizable(false);
            this.pack();
            this.setVisible(true);
        }
        catch (Exception e) {
            System.out.println("DlgEBBeam build error: " + e.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        boolean canClose = true;
        this.OK = false;
        if (event.getActionCommand().equals("OK")) {
            this.OK = true;
            this.truss.setLabel(this.label.getText());
            try {
                this.truss.setEA(new Double(this.EA.getText()));
                this.truss.setM(new Double(this.m.getText()));
            }
            catch (NumberFormatException e) {
                canClose = false;
                JOptionPane.showMessageDialog(null, "Please enter a valid number", "Number Format Error", 0);
            }
        }
        if (canClose) {
            this.setVisible(false);
            this.dispose();
        }
    }

    public boolean getOK() {
        return this.OK;
    }
}

